/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.ivoice;

import com.bliss.core.AudioMixer;
import com.bliss.core.LoadInputStream;
import com.bliss.core.Processor;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.ivoice.MicroSequencer;
import java.io.IOException;

public class LPC12
extends Processor {
    private static final int[] qtbl = new int[]{0, 511, 510, 509, 508, 507, 506, 505, 504, 503, 502, 501, 500, 499, 498, 497, 496, 495, 494, 493, 492, 491, 490, 489, 488, 487, 486, 485, 484, 483, 482, 481, 479, 477, 475, 473, 471, 469, 467, 465, 463, 461, 459, 457, 455, 453, 451, 449, 447, 445, 443, 441, 439, 437, 435, 433, 431, 429, 427, 425, 421, 417, 413, 409, 405, 401, 397, 393, 389, 385, 381, 377, 373, 369, 365, 361, 357, 353, 349, 345, 341, 337, 333, 329, 325, 321, 317, 313, 309, 305, 301, 297, 289, 281, 273, 265, 257, 249, 241, 233, 225, 217, 209, 201, 193, 185, 177, 169, 161, 153, 145, 137, 129, 121, 113, 105, 97, 89, 81, 73, 65, 57, 49, 41, 33, 25, 12, 9, 0, -9, -12, -25, -33, -41, -49, -57, -65, -73, -81, -89, -97, -105, -113, -121, -129, -137, -145, -153, -161, -169, -177, -185, -193, -201, -209, -217, -225, -233, -241, -249, -257, -265, -273, -281, -289, -297, -301, -305, -309, -313, -317, -321, -325, -329, -333, -337, -341, -345, -349, -353, -357, -361, -365, -369, -373, -377, -381, -385, -389, -393, -397, -401, -405, -409, -413, -417, -421, -425, -427, -429, -431, -433, -435, -437, -439, -441, -443, -445, -447, -449, -451, -453, -455, -457, -459, -461, -463, -465, -467, -469, -471, -473, -475, -477, -479, -481, -482, -483, -484, -485, -486, -487, -488, -489, -490, -491, -492, -493, -494, -495, -496, -497, -498, -499, -500, -501, -502, -503, -504, -505, -506, -507, -508, -509, -510, -511};
    boolean audioEnabled = true;
    private AudioMixer.AudioOutputLine aol;
    MicroSequencer microSequencer;
    private int random = 1;
    int repeat;
    int period;
    int periodCounter;
    int amplitude;
    byte[] b = new byte[6];
    byte[] f = new byte[6];
    int[][] y = new int[6][2];
    byte periodInterpolation;
    byte amplitudeInterpolation;

    public int getClockSpeed() {
        return 10000;
    }

    public void reset() {
        this.amplitude = 0;
        this.period = 0;
        this.periodCounter = 1;
        this.isIdle = true;
        this.random = 1;
        int n = 0;
        while (n < 6) {
            this.y[n][0] = 0;
            this.y[n][1] = 0;
            ++n;
        }
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeInt(this.repeat);
        saveOutputStream.writeInt(this.period);
        saveOutputStream.writeInt(this.periodCounter);
        saveOutputStream.writeInt(this.amplitude);
        int n = 0;
        while (n < this.b.length) {
            saveOutputStream.writeInt(this.b[n]);
            ++n;
        }
        n = 0;
        while (n < this.f.length) {
            saveOutputStream.writeInt(this.f[n]);
            ++n;
        }
        n = 0;
        while (n < this.y.length) {
            int n2 = 0;
            while (n2 < this.y[0].length) {
                saveOutputStream.writeInt(this.y[n][n2]);
                ++n2;
            }
            ++n;
        }
        saveOutputStream.writeInt(this.periodInterpolation);
        saveOutputStream.writeInt(this.amplitudeInterpolation);
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.repeat = loadInputStream.readInt(0, 63);
        this.period = loadInputStream.readInt(0, 65535);
        this.periodCounter = loadInputStream.readInt(0, 65535);
        this.amplitude = loadInputStream.readInt(0, 65535);
        int n = 0;
        while (n < this.b.length) {
            this.b[n] = (byte)loadInputStream.readInt(-128, 127);
            ++n;
        }
        n = 0;
        while (n < this.f.length) {
            this.f[n] = (byte)loadInputStream.readInt(-128, 127);
            ++n;
        }
        n = 0;
        while (n < this.y.length) {
            int n2 = 0;
            while (n2 < this.y[0].length) {
                this.y[n][n2] = (byte)loadInputStream.readInt(-128, 127);
                ++n2;
            }
            ++n;
        }
        this.periodInterpolation = (byte)loadInputStream.readInt(-128, 127);
        this.amplitudeInterpolation = (byte)loadInputStream.readInt(-128, 127);
    }

    public int tick() {
        int n;
        int n2 = 0;
        if (this.period == 0) {
            if (this.periodCounter == 0) {
                this.periodCounter = 64;
                --this.repeat;
                n = 0;
                while (n < 6) {
                    this.y[n][1] = 0;
                    this.y[n][0] = 0;
                    ++n;
                }
            } else {
                --this.periodCounter;
            }
            n2 = (this.amplitude & 0x1F) << ((this.amplitude & 0xE0) >> 5);
            n = (this.random & 1) == 0 ? 0 : 1;
            this.random = this.random >> 1 ^ (n != 0 ? 81920 : 0);
            if (n == 0) {
                n2 = -n2;
            }
        } else if (this.periodCounter == 0) {
            this.periodCounter = this.period;
            --this.repeat;
            n2 = (this.amplitude & 0x1F) << ((this.amplitude & 0xE0) >> 5);
            n = 0;
            while (n < 6) {
                this.y[n][1] = 0;
                this.y[n][0] = 0;
                ++n;
            }
        } else {
            --this.periodCounter;
        }
        this.period = (this.period | 0x10000) + this.periodInterpolation & 0xFFFF;
        this.amplitude = (this.amplitude | 0x10000) + this.amplitudeInterpolation & 0xFFFF;
        if (this.repeat == 0) {
            this.isIdle = true;
            this.microSequencer.isIdle = false;
        }
        if (this.audioEnabled) {
            n = 0;
            while (n < 6) {
                n2 += qtbl[128 + this.b[n]] * this.y[n][1] >> 9;
                this.y[n][1] = this.y[n][0];
                this.y[n][0] = n2 += qtbl[128 + this.f[n]] * this.y[n][0] >> 8;
                ++n;
            }
            if (n2 > 2047) {
                n2 = 2047;
            }
            if (n2 < -2048) {
                n2 = -2048;
            }
            this.aol.writeSample(n2 << 4);
        }
        return 1;
    }

    public LPC12(AudioMixer.AudioOutputLine audioOutputLine) {
        this.aol = audioOutputLine;
    }
}

