/*
 * Decompiled with CFR 0.152.
 */
package com.bliss.core.ivoice;

import com.bliss.core.LoadInputStream;
import com.bliss.core.Memory;
import com.bliss.core.Processor;
import com.bliss.core.ROM;
import com.bliss.core.SaveOutputStream;
import com.bliss.core.ivoice.LPC12;
import java.io.IOException;

class MicroSequencer
extends Processor {
    private static final int[] bitMasks = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    private static final int FIFO_LOCATION = 6144;
    private static final int FIFO_SIZE = 64;
    private static final int FIFO_END = 6208;
    private int bitsLeft;
    private int currentBits;
    private int pc;
    private int stack;
    private int mode;
    private int repeatPrefix;
    private int page;
    private int command;
    private LPC12 lpc12;
    int[] ivoiceROMImage;
    private ROM ivoiceROM;
    Registers registers;
    private boolean lrqHigh;
    private boolean speaking;
    private int[] fifoBytes = new int[64];
    private int fifoHead;
    private int fifoSize;

    public int getClockSpeed() {
        return 1600000;
    }

    public void reset() {
        this.currentBits = 0;
        this.bitsLeft = 0;
        this.isIdle = true;
        this.pc = 0;
        this.page = 1;
        this.stack = 0;
        this.mode = 0;
        this.repeatPrefix = 0;
        this.command = 0;
        this.lrqHigh = true;
        this.fifoHead = 0;
        this.fifoSize = 0;
        this.speaking = false;
    }

    public void save(SaveOutputStream saveOutputStream) throws IOException {
        saveOutputStream.writeInt(this.bitsLeft);
        saveOutputStream.writeInt(this.currentBits);
        saveOutputStream.writeInt(this.pc);
        saveOutputStream.writeInt(this.mode);
        saveOutputStream.writeInt(this.repeatPrefix);
        saveOutputStream.writeInt(this.page);
        saveOutputStream.writeInt(this.command);
        saveOutputStream.writeBoolean(this.lrqHigh);
        saveOutputStream.writeBoolean(this.speaking);
        saveOutputStream.writeInt(this.fifoHead);
        saveOutputStream.writeInt(this.fifoSize);
        int n = 0;
        while (n < this.fifoBytes.length) {
            saveOutputStream.writeInt(this.fifoBytes[n]);
            ++n;
        }
    }

    public void load(LoadInputStream loadInputStream) throws IOException {
        this.bitsLeft = loadInputStream.readInt(0, 31);
        this.currentBits = loadInputStream.readInt(0, Integer.MAX_VALUE);
        this.pc = loadInputStream.readInt(0, 65535);
        this.mode = loadInputStream.readInt(0, 3);
        this.repeatPrefix = loadInputStream.readInt(0, 3);
        this.page = loadInputStream.readInt(0, 15);
        this.command = loadInputStream.readInt(0, 255);
        this.lrqHigh = loadInputStream.readBoolean();
        this.speaking = loadInputStream.readBoolean();
        this.fifoHead = loadInputStream.readInt(0, 63);
        this.fifoSize = loadInputStream.readInt(0, 64);
        int n = 0;
        while (n < this.fifoBytes.length) {
            this.fifoBytes[n] = loadInputStream.readInt(0, 1023);
            ++n;
        }
    }

    public int tick() {
        if (!this.speaking) {
            this.speaking = true;
            this.pc = 0x1000 | this.command << 1;
            this.bitsLeft = 0;
            this.command = 0;
            this.lrqHigh = true;
        }
        while (!this.isIdle) {
            int n = this.repeatPrefix;
            this.decode();
            if (n == 0) continue;
            this.repeatPrefix = 0;
        }
        return 1;
    }

    private byte readDelta(int n) {
        int n2 = this.readBits(n);
        if ((n2 & 1 << n - 1) != 0) {
            n2 |= -1 << n;
        }
        return (byte)n2;
    }

    private int readBits(int n) {
        return this.readBits(n, false);
    }

    private int readBits(int n, boolean bl) {
        while (this.bitsLeft < n) {
            if (this.pc < 6144) {
                this.currentBits |= this.ivoiceROM.peek(this.pc) << this.bitsLeft;
                this.bitsLeft += 8;
                this.pc = this.pc + 1 & 0xFFFF;
                continue;
            }
            if (this.pc == 6144 && this.fifoSize > 0) {
                this.currentBits |= this.fifoBytes[this.fifoHead] << this.bitsLeft;
                this.fifoHead = this.fifoHead + 1 & 0x3F;
                --this.fifoSize;
                this.bitsLeft += 10;
                continue;
            }
            this.currentBits |= 1023 << this.bitsLeft;
            this.bitsLeft += 10;
            this.pc = this.pc + 1 & 0xFFFF;
        }
        int n2 = this.currentBits & bitMasks[n - 1];
        if (bl) {
            n2 = MicroSequencer.flipEndian(n2, n);
        }
        this.currentBits >>= n;
        this.bitsLeft -= n;
        return n2;
    }

    private final void RTS() {
        if (this.stack == 0) {
            if (!this.lrqHigh) {
                this.pc = 0x1000 | this.command << 1;
                this.bitsLeft = 0;
                this.command = 0;
                this.lrqHigh = true;
            } else {
                this.speaking = false;
                this.isIdle = true;
            }
        } else {
            this.pc = this.stack;
            this.stack = 0;
            this.bitsLeft = 0;
        }
    }

    private final void SETPAGE(int n) {
        this.page = MicroSequencer.flipEndian(n, 4);
    }

    private final void LOADALL(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(8);
        this.lpc12.period = this.readBits(8);
        this.lpc12.b[0] = (byte)this.readBits(8);
        this.lpc12.f[0] = (byte)this.readBits(8);
        this.lpc12.b[1] = (byte)this.readBits(8);
        this.lpc12.f[1] = (byte)this.readBits(8);
        this.lpc12.b[2] = (byte)this.readBits(8);
        this.lpc12.f[2] = (byte)this.readBits(8);
        this.lpc12.b[3] = (byte)this.readBits(8);
        this.lpc12.f[3] = (byte)this.readBits(8);
        this.lpc12.b[4] = (byte)this.readBits(8);
        this.lpc12.f[4] = (byte)this.readBits(8);
        this.lpc12.b[5] = (byte)this.readBits(8);
        this.lpc12.f[5] = (byte)this.readBits(8);
        if ((this.mode & 1) == 0) {
            this.lpc12.amplitudeInterpolation = 0;
            this.lpc12.periodInterpolation = 0;
        } else {
            this.lpc12.amplitudeInterpolation = (byte)this.readBits(8);
            this.lpc12.periodInterpolation = (byte)this.readBits(8);
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void LOAD_2(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        this.lpc12.period = this.readBits(8);
        switch (this.mode) {
            case 0: {
                this.lpc12.b[0] = (byte)(this.readBits(3) << 4 | this.lpc12.b[0] & 0xF);
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.b[1] = (byte)(this.readBits(3) << 4 | this.lpc12.b[1] & 0xF);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.b[2] = (byte)(this.readBits(3) << 4 | this.lpc12.b[2] & 0xF);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 1: {
                this.lpc12.b[0] = (byte)(this.readBits(3) << 4 | this.lpc12.b[0] & 0xF);
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.b[1] = (byte)(this.readBits(3) << 4 | this.lpc12.b[1] & 0xF);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.b[2] = (byte)(this.readBits(3) << 4 | this.lpc12.b[2] & 0xF);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
            case 2: {
                this.lpc12.b[0] = (byte)(this.readBits(6) << 1 | this.lpc12.b[0] & 1);
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.b[1] = (byte)(this.readBits(6) << 1 | this.lpc12.b[1] & 1);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.b[2] = (byte)(this.readBits(6) << 1 | this.lpc12.b[2] & 1);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 3: {
                this.lpc12.b[0] = (byte)(this.readBits(6) << 1 | this.lpc12.b[0] & 1);
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.b[1] = (byte)(this.readBits(6) << 1 | this.lpc12.b[1] & 1);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.b[2] = (byte)(this.readBits(6) << 1 | this.lpc12.b[2] & 1);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
        }
        this.lpc12.amplitudeInterpolation = (byte)(this.lpc12.amplitudeInterpolation & 0xE0 | this.readBits(5));
        this.lpc12.periodInterpolation = (byte)(this.lpc12.periodInterpolation & 0xE0 | this.readBits(5));
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void SETMSB_3(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        if (this.mode == 0 || this.mode == 2) {
            this.lpc12.b[5] = 0;
            this.lpc12.f[5] = 0;
        }
        switch (this.mode) {
            case 0: 
            case 1: {
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                break;
            }
            case 2: 
            case 3: {
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                break;
            }
        }
        this.lpc12.amplitudeInterpolation = (byte)(this.lpc12.amplitudeInterpolation & 0xE0 | this.readBits(5));
        this.lpc12.periodInterpolation = (byte)(this.lpc12.periodInterpolation & 0xE0 | this.readBits(5));
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void LOAD_4(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        this.lpc12.period = this.readBits(8);
        this.lpc12.b[0] = 0;
        this.lpc12.f[0] = 0;
        this.lpc12.b[1] = 0;
        this.lpc12.f[1] = 0;
        this.lpc12.b[2] = 0;
        this.lpc12.f[2] = 0;
        switch (this.mode) {
            case 0: {
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 1: {
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
            case 2: {
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 3: {
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
        }
        this.lpc12.amplitudeInterpolation = 0;
        this.lpc12.periodInterpolation = 0;
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void SETMSB_5(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        this.lpc12.period = this.readBits(8);
        if (this.mode == 0 || this.mode == 2) {
            this.lpc12.b[5] = 0;
            this.lpc12.f[5] = 0;
        }
        switch (this.mode) {
            case 0: 
            case 1: {
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                break;
            }
            case 2: 
            case 3: {
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                break;
            }
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void SETMSB_6(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        if (this.mode == 0 || this.mode == 2) {
            this.lpc12.b[5] = 0;
            this.lpc12.f[5] = 0;
        }
        switch (this.mode) {
            case 0: {
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 1: {
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
            case 2: {
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 3: {
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void JMP(int n) {
        this.pc = this.page << 12 | MicroSequencer.flipEndian(n, 4) << 8 | this.readBits(8, true);
        this.bitsLeft = 0;
    }

    private final void SETMODE(int n) {
        n = MicroSequencer.flipEndian(n, 4);
        this.mode = n & 3;
        this.repeatPrefix = (n & 0xC) >> 2;
    }

    private final void DELTA_9(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = (this.lpc12.amplitude | 0x10000) + (this.readDelta(4) << 2) & 0xFFFF;
        this.lpc12.period = (this.lpc12.period | 0x10000) + this.readDelta(5) & 0xFFFF;
        switch (this.mode) {
            case 0: {
                this.lpc12.b[0] = (byte)(this.lpc12.b[0] + (this.readDelta(3) << 4));
                this.lpc12.f[0] = (byte)(this.lpc12.f[0] + (this.readDelta(3) << 3));
                this.lpc12.b[1] = (byte)(this.lpc12.b[1] + (this.readDelta(3) << 4));
                this.lpc12.f[1] = (byte)(this.lpc12.f[1] + (this.readDelta(3) << 3));
                this.lpc12.b[2] = (byte)(this.lpc12.b[2] + (this.readDelta(3) << 4));
                this.lpc12.f[2] = (byte)(this.lpc12.f[2] + (this.readDelta(3) << 3));
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(3) << 3));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(4) << 2));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + (this.readDelta(4) << 1));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + (this.readDelta(4) << 2));
                break;
            }
            case 1: {
                this.lpc12.b[0] = (byte)(this.lpc12.b[0] + (this.readDelta(3) << 4));
                this.lpc12.f[0] = (byte)(this.lpc12.f[0] + (this.readDelta(3) << 3));
                this.lpc12.b[1] = (byte)(this.lpc12.b[1] + (this.readDelta(3) << 4));
                this.lpc12.f[1] = (byte)(this.lpc12.f[1] + (this.readDelta(3) << 3));
                this.lpc12.b[2] = (byte)(this.lpc12.b[2] + (this.readDelta(3) << 4));
                this.lpc12.f[2] = (byte)(this.lpc12.f[2] + (this.readDelta(3) << 3));
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(3) << 3));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(4) << 2));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + (this.readDelta(4) << 1));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + (this.readDelta(4) << 2));
                this.lpc12.b[5] = (byte)(this.lpc12.b[5] + this.readDelta(5));
                this.lpc12.f[5] = (byte)(this.lpc12.f[5] + this.readDelta(5));
                break;
            }
            case 2: {
                this.lpc12.b[0] = (byte)(this.lpc12.b[0] + (this.readDelta(4) << 1));
                this.lpc12.f[0] = (byte)(this.lpc12.f[0] + (this.readDelta(4) << 2));
                this.lpc12.b[1] = (byte)(this.lpc12.b[1] + (this.readDelta(4) << 1));
                this.lpc12.f[1] = (byte)(this.lpc12.f[1] + (this.readDelta(4) << 2));
                this.lpc12.b[2] = (byte)(this.lpc12.b[2] + (this.readDelta(4) << 1));
                this.lpc12.f[2] = (byte)(this.lpc12.f[2] + (this.readDelta(4) << 2));
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(4) << 1));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(5) << 1));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + this.readDelta(5));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + this.readDelta(5));
                break;
            }
            case 3: {
                this.lpc12.b[0] = (byte)(this.lpc12.b[0] + (this.readDelta(4) << 1));
                this.lpc12.f[0] = (byte)(this.lpc12.f[0] + (this.readDelta(4) << 2));
                this.lpc12.b[1] = (byte)(this.lpc12.b[1] + (this.readDelta(4) << 1));
                this.lpc12.f[1] = (byte)(this.lpc12.f[1] + (this.readDelta(4) << 2));
                this.lpc12.b[2] = (byte)(this.lpc12.b[2] + (this.readDelta(4) << 1));
                this.lpc12.f[2] = (byte)(this.lpc12.f[2] + (this.readDelta(4) << 2));
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(4) << 1));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(5) << 1));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + this.readDelta(5));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + this.readDelta(5));
                this.lpc12.b[5] = (byte)(this.lpc12.b[5] + this.readDelta(5));
                this.lpc12.f[5] = (byte)(this.lpc12.f[5] + this.readDelta(5));
                break;
            }
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void SETMSB_A(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        switch (this.mode) {
            case 0: 
            case 1: {
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                break;
            }
            case 2: 
            case 3: {
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                break;
            }
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void JSR(int n) {
        int n2 = this.page << 12 | MicroSequencer.flipEndian(n, 4) << 8 | this.readBits(8, true);
        this.stack = this.pc;
        this.pc = n2;
        this.bitsLeft = 0;
    }

    private final void LOAD_C(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        this.lpc12.period = this.readBits(8);
        switch (this.mode) {
            case 0: {
                this.lpc12.b[0] = (byte)(this.readBits(3) << 4 | this.lpc12.b[0] & 0xF);
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.b[1] = (byte)(this.readBits(3) << 4 | this.lpc12.b[1] & 0xF);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.b[2] = (byte)(this.readBits(3) << 4 | this.lpc12.b[2] & 0xF);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 1: {
                this.lpc12.b[0] = (byte)(this.readBits(3) << 4 | this.lpc12.b[0] & 0xF);
                this.lpc12.f[0] = (byte)(this.readBits(5) << 3 | this.lpc12.f[0] & 7);
                this.lpc12.b[1] = (byte)(this.readBits(3) << 4 | this.lpc12.b[1] & 0xF);
                this.lpc12.f[1] = (byte)(this.readBits(5) << 3 | this.lpc12.f[1] & 7);
                this.lpc12.b[2] = (byte)(this.readBits(3) << 4 | this.lpc12.b[2] & 0xF);
                this.lpc12.f[2] = (byte)(this.readBits(5) << 3 | this.lpc12.f[2] & 7);
                this.lpc12.b[3] = (byte)(this.readBits(4) << 3 | this.lpc12.b[3] & 7);
                this.lpc12.f[3] = (byte)(this.readBits(6) << 2 | this.lpc12.f[3] & 3);
                this.lpc12.b[4] = (byte)(this.readBits(7) << 1 | this.lpc12.b[4] & 1);
                this.lpc12.f[4] = (byte)(this.readBits(6) << 2 | this.lpc12.f[4] & 3);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
            case 2: {
                this.lpc12.b[0] = (byte)(this.readBits(6) << 1 | this.lpc12.b[0] & 1);
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.b[1] = (byte)(this.readBits(6) << 1 | this.lpc12.b[1] & 1);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.b[2] = (byte)(this.readBits(6) << 1 | this.lpc12.b[2] & 1);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = 0;
                this.lpc12.f[5] = 0;
                break;
            }
            case 3: {
                this.lpc12.b[0] = (byte)(this.readBits(6) << 1 | this.lpc12.b[0] & 1);
                this.lpc12.f[0] = (byte)(this.readBits(6) << 2 | this.lpc12.f[0] & 3);
                this.lpc12.b[1] = (byte)(this.readBits(6) << 1 | this.lpc12.b[1] & 1);
                this.lpc12.f[1] = (byte)(this.readBits(6) << 2 | this.lpc12.f[1] & 3);
                this.lpc12.b[2] = (byte)(this.readBits(6) << 1 | this.lpc12.b[2] & 1);
                this.lpc12.f[2] = (byte)(this.readBits(6) << 2 | this.lpc12.f[2] & 3);
                this.lpc12.b[3] = (byte)(this.readBits(6) << 1 | this.lpc12.b[3] & 1);
                this.lpc12.f[3] = (byte)(this.readBits(7) << 1 | this.lpc12.f[3] & 1);
                this.lpc12.b[4] = (byte)this.readBits(8);
                this.lpc12.f[4] = (byte)this.readBits(8);
                this.lpc12.b[5] = (byte)this.readBits(8);
                this.lpc12.f[5] = (byte)this.readBits(8);
                break;
            }
        }
        this.lpc12.amplitudeInterpolation = 0;
        this.lpc12.periodInterpolation = 0;
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void DELTA_D(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = (this.lpc12.amplitude | 0x10000) + (this.readDelta(4) << 2) & 0xFFFF;
        this.lpc12.period = (this.lpc12.period | 0x10000) + this.readDelta(5) & 0xFFFF;
        switch (this.mode) {
            case 0: {
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(3) << 3));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(4) << 2));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + (this.readDelta(4) << 1));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + (this.readDelta(4) << 2));
                break;
            }
            case 1: {
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(3) << 3));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(4) << 2));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + (this.readDelta(4) << 1));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + (this.readDelta(4) << 2));
                this.lpc12.b[5] = (byte)(this.lpc12.b[5] + this.readDelta(5));
                this.lpc12.f[5] = (byte)(this.lpc12.f[5] + this.readDelta(5));
                break;
            }
            case 2: {
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(4) << 1));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(5) << 1));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + this.readDelta(5));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + this.readDelta(5));
                break;
            }
            case 3: {
                this.lpc12.b[3] = (byte)(this.lpc12.b[3] + (this.readDelta(4) << 1));
                this.lpc12.f[3] = (byte)(this.lpc12.f[3] + (this.readDelta(5) << 1));
                this.lpc12.b[4] = (byte)(this.lpc12.b[4] + this.readDelta(5));
                this.lpc12.f[4] = (byte)(this.lpc12.f[4] + this.readDelta(5));
                this.lpc12.b[5] = (byte)(this.lpc12.b[5] + this.readDelta(5));
                this.lpc12.f[5] = (byte)(this.lpc12.f[5] + this.readDelta(5));
                break;
            }
        }
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void LOAD_E(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = this.readBits(6) << 2 | this.lpc12.amplitude & 3;
        this.lpc12.period = this.readBits(8);
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private final void PAUSE(int n) {
        this.lpc12.repeat = this.repeatPrefix << 4 | n;
        if (this.lpc12.repeat == 0) {
            return;
        }
        this.lpc12.amplitude = 0;
        this.lpc12.period = 0;
        int n2 = 0;
        while (n2 < 6) {
            this.lpc12.b[n2] = 0;
            this.lpc12.f[n2] = 0;
            ++n2;
        }
        this.lpc12.amplitudeInterpolation = 0;
        this.lpc12.periodInterpolation = 0;
        this.lpc12.isIdle = false;
        this.isIdle = true;
    }

    private void decode() {
        int n = this.readBits(4);
        int n2 = this.readBits(4, true);
        switch (n2) {
            case 0: {
                if (n == 0) {
                    this.RTS();
                    break;
                }
                this.SETPAGE(n);
                break;
            }
            case 8: {
                this.SETMODE(n);
                break;
            }
            case 4: {
                this.LOAD_4(n);
                break;
            }
            case 12: {
                this.LOAD_C(n);
                break;
            }
            case 2: {
                this.LOAD_2(n);
                break;
            }
            case 10: {
                this.SETMSB_A(n);
                break;
            }
            case 6: {
                this.SETMSB_6(n);
                break;
            }
            case 14: {
                this.LOAD_E(n);
                break;
            }
            case 1: {
                this.LOADALL(n);
                break;
            }
            case 9: {
                this.DELTA_9(n);
                break;
            }
            case 5: {
                this.SETMSB_5(n);
                break;
            }
            case 13: {
                this.DELTA_D(n);
                break;
            }
            case 3: {
                this.SETMSB_3(n);
                break;
            }
            case 11: {
                this.JSR(n);
                break;
            }
            case 7: {
                this.JMP(n);
                break;
            }
            case 15: {
                this.PAUSE(n);
                break;
            }
        }
    }

    private static final int flipEndian(int n, int n2) {
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n2 - 1 - (n5 << 1);
            n3 = n6 > 0 ? (n3 |= (n & n4) << n6) : (n3 |= (n & n4) >> -n6);
            n4 <<= 1;
            ++n5;
        }
        return n3;
    }

    static /* synthetic */ int access$1(MicroSequencer microSequencer) {
        return microSequencer.command;
    }

    MicroSequencer(LPC12 lPC12) {
        this.lpc12 = lPC12;
        lPC12.microSequencer = this;
        MicroSequencer microSequencer = this;
        if (microSequencer == null) {
            throw null;
        }
        this.registers = microSequencer.new Registers();
        this.ivoiceROMImage = new int[2048];
        this.ivoiceROM = new ROM(this.ivoiceROMImage, 4096);
    }

    private class Registers
    extends Memory {
        public int getSize() {
            return 2;
        }

        public int getLocation() {
            return 128;
        }

        public void reset() {
        }

        public void save(SaveOutputStream saveOutputStream) {
        }

        public void load(LoadInputStream loadInputStream) {
        }

        public void poke(int n, int n2) {
            switch (n) {
                case 128: {
                    if (!MicroSequencer.this.lrqHigh) break;
                    MicroSequencer.this.command = n2 & 0xFF;
                    MicroSequencer.this.lrqHigh = false;
                    if (MicroSequencer.this.speaking) break;
                    MicroSequencer.this.isIdle = false;
                    break;
                }
                case 129: {
                    if ((n2 & 0x400) != 0) {
                        this.reset();
                        break;
                    }
                    if (MicroSequencer.this.fifoSize >= MicroSequencer.this.fifoBytes.length) break;
                    ((MicroSequencer)MicroSequencer.this).fifoBytes[((MicroSequencer)MicroSequencer.this).fifoHead + ((MicroSequencer)MicroSequencer.this).fifoSize & 0x3F] = n2;
                    MicroSequencer microSequencer = MicroSequencer.this;
                    microSequencer.fifoSize = microSequencer.fifoSize + 1;
                    break;
                }
            }
        }

        public int peek(int n) {
            switch (n) {
                case 128: {
                    return MicroSequencer.this.lrqHigh ? 32768 : 0;
                }
            }
            return MicroSequencer.this.fifoSize == MicroSequencer.this.fifoBytes.length ? 32768 : 0;
        }

        Registers() {
        }
    }
}

