/*
 * Decompiled with CFR 0.152.
 */
package com.blissjweb.applet;

import com.bliss.core.Intellivision;
import com.bliss.core.ROM;
import com.bliss.core.cartridge.Cartridge;
import com.blissjweb.plugin.AppletPlugIn;
import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class BlissJWeb
extends Applet {
    private Intellivision inty;
    private int[] ecsImage;
    private int[] ivoiceImage;

    public void init() {
        Object object;
        Object object2;
        Object object3;
        this.inty = new Intellivision();
        String string = this.getParameter("execfile");
        if (string == null || string.length() == 0) {
            string = "exec.bin";
        }
        try {
            object3 = new URL(this.getDocumentBase(), string);
            object2 = ((URL)object3).openStream();
            object = ROM.loadROMImage((InputStream)object2, true);
            ((InputStream)object2).close();
            this.inty.setExecImage((int[])object);
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Unable to load Executive ROM: " + string);
            return;
        }
        object3 = this.getParameter("gromfile");
        if (object3 == null || ((String)object3).length() == 0) {
            object3 = "grom.bin";
        }
        try {
            object2 = new URL(this.getDocumentBase(), (String)object3);
            object = ((URL)object2).openStream();
            int[] nArray = ROM.loadROMImage((InputStream)object, false);
            ((InputStream)object).close();
            this.inty.setGROMImage(nArray);
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Unable to load GROM: " + (String)object3);
            return;
        }
        boolean bl = true;
        object = this.getParameter("audioenabled");
        if (object != null && ((String)object).trim().equalsIgnoreCase("false")) {
            bl = false;
        }
        this.inty.setAudioEnabled(bl);
        boolean bl2 = true;
        object = this.getParameter("audiomixingquality");
        if (object != null && ((String)object).trim().equalsIgnoreCase("low")) {
            bl2 = false;
        }
        this.inty.setHighQualityAudioMixing(bl2);
        int n = 3;
        object = this.getParameter("audioaccuracy");
        if (object != null) {
            if (((String)(object = ((String)object).trim().toLowerCase())).equals("low")) {
                n = 4;
            } else if (((String)object).equals("moderate")) {
                n = 3;
            } else if (((String)object).equals("high")) {
                n = 2;
            } else if (((String)object).equals("highest")) {
                n = 1;
            }
        }
        this.inty.setAudioAccuracy(n);
        int n2 = 3;
        object = this.getParameter("frameskip");
        if (object != null) {
            try {
                int n3 = Integer.parseInt((String)object);
                if (n3 >= 0 && n3 <= 5) {
                    n2 = n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.inty.setFrameSkip(n2);
        this.inty.setPlugIn(new AppletPlugIn(this));
        String string2 = this.getParameter("cartfile");
        if (string2 != null && string2.length() > 0) {
            this.loadCartFile(string2);
        }
    }

    public void loadCartFile(String string) {
        InputStream inputStream;
        Object object;
        Object object2;
        this.inty.turnOff(true);
        this.repaint();
        this.inty.removeCartridge();
        Cartridge cartridge = null;
        try {
            object2 = new URL(this.getDocumentBase(), string);
            object = ((URL)object2).openStream();
            cartridge = Cartridge.loadCartridge((InputStream)object);
            ((InputStream)object).close();
        }
        catch (IOException iOException) {
            System.err.println("ERROR: Unable to load cartridge: " + string);
            return;
        }
        if (cartridge.requiresECS() && this.ecsImage == null) {
            object2 = this.getParameter("ecsfile");
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = "ecs.bin";
            }
            try {
                object = new URL(this.getDocumentBase(), (String)object2);
                inputStream = ((URL)object).openStream();
                this.ecsImage = ROM.loadROMImage(inputStream, false);
                inputStream.close();
                this.inty.enableECSSupport(this.ecsImage);
            }
            catch (IOException iOException) {
                System.err.println("ERROR: Unable to load ECS ROM: " + (String)object2);
                this.ecsImage = new int[0];
                return;
            }
        }
        if (cartridge.usesIntellivoice() && this.ivoiceImage == null) {
            object2 = this.getParameter("ivoicefile");
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = "ivoice.bin";
            }
            try {
                object = new URL(this.getDocumentBase(), (String)object2);
                inputStream = ((URL)object).openStream();
                this.ivoiceImage = ROM.loadROMImage(inputStream, false);
                inputStream.close();
                this.inty.enableIntellivoiceSupport(this.ivoiceImage);
            }
            catch (IOException iOException) {
                this.ivoiceImage = new int[0];
            }
        }
        this.inty.insertCartridge(cartridge);
        this.inty.turnOn();
    }

    public void start() {
        this.inty.turnOn();
    }

    public void stop() {
        this.inty.turnOff();
    }

    public void destroy() {
        this.inty.turnOff();
    }
}

