/*
 * Decompiled with CFR 0.152.
 */
package com.blissjweb.plugin;

import com.bliss.core.Option;
import com.bliss.core.devices.InputDevice;
import com.bliss.core.devices.InputSignal;
import com.blissjweb.plugin.AppletInputDevice;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class AppletInputDevice
implements InputDevice {
    private static final AppletInputSignal[] DEFAULTS_EMULATOR = new AppletInputSignal[]{new AppletInputSignal(112), new AppletInputSignal(116), new AppletInputSignal(117), new AppletInputSignal(120), new AppletInputSignal(123)};
    private static final AppletInputSignal[] DEFAULTS_PLAYER_ONE = new AppletInputSignal[]{new AppletInputSignal(38), new AppletInputSignal(33), new AppletInputSignal(39), new AppletInputSignal(34), new AppletInputSignal(40), new AppletInputSignal(35), new AppletInputSignal(37), new AppletInputSignal(36), new AppletInputSignal(17), new AppletInputSignal(90), new AppletInputSignal(88), null, null, null, new AppletInputSignal(49), new AppletInputSignal(50), new AppletInputSignal(51), new AppletInputSignal(52), new AppletInputSignal(53), new AppletInputSignal(54), new AppletInputSignal(55), new AppletInputSignal(56), new AppletInputSignal(57), new AppletInputSignal(48), new AppletInputSignal(127), new AppletInputSignal(10), null, null};
    private static final AppletInputSignal[] DEFAULTS_PLAYER_TWO = new AppletInputSignal[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private static final AppletInputSignal[] DEFAULTS_KEYBOARD = new AppletInputSignal[]{new AppletInputSignal(65), new AppletInputSignal(66), new AppletInputSignal(67), new AppletInputSignal(68), new AppletInputSignal(69), new AppletInputSignal(70), new AppletInputSignal(71), new AppletInputSignal(72), new AppletInputSignal(73), new AppletInputSignal(74), new AppletInputSignal(75), new AppletInputSignal(76), new AppletInputSignal(77), new AppletInputSignal(78), new AppletInputSignal(79), new AppletInputSignal(80), new AppletInputSignal(81), new AppletInputSignal(82), new AppletInputSignal(83), new AppletInputSignal(84), new AppletInputSignal(85), new AppletInputSignal(86), new AppletInputSignal(87), new AppletInputSignal(88), new AppletInputSignal(89), new AppletInputSignal(90), new AppletInputSignal(48), new AppletInputSignal(49), new AppletInputSignal(50), new AppletInputSignal(51), new AppletInputSignal(52), new AppletInputSignal(53), new AppletInputSignal(54), new AppletInputSignal(55), new AppletInputSignal(56), new AppletInputSignal(57), new AppletInputSignal(38), new AppletInputSignal(40), new AppletInputSignal(37), new AppletInputSignal(39), new AppletInputSignal(44), new AppletInputSignal(46), new AppletInputSignal(32), new AppletInputSignal(59), new AppletInputSignal(513), new AppletInputSignal(27), new AppletInputSignal(10), new AppletInputSignal(17), new AppletInputSignal(16)};
    private Component component;
    private boolean[] keyMap = new boolean[65535];
    private AppletInputSignal[] signalsPlayerOne;
    private AppletInputSignal[] signalsPlayerTwo;
    private AppletInputSignal[] signalsKeyboard;
    private AppletInputSignal[] signalsEmulator;
    private KeyListener keyListener;

    public Option[] getOptions() {
        return Option.EMPTY_CONTROLLER_ARRAY;
    }

    public void poll() {
    }

    public InputSignal getInputSignal(String string) {
        try {
            return new AppletInputSignal(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public InputSignal getInputSignal(int n) {
        if (n >= 1000 && n <= 1027) {
            return this.signalsPlayerOne[n - 1000];
        }
        if (n >= 2000 && n <= 2027) {
            return this.signalsPlayerTwo[n - 2000];
        }
        if (n >= 5000 && n <= 5048) {
            return this.signalsKeyboard[n - 5000];
        }
        if (n >= 7000 && n <= 7004) {
            return this.signalsEmulator[n - 7000];
        }
        return null;
    }

    public void setInputSignal(int n, InputSignal inputSignal) {
        AppletInputSignal appletInputSignal = (AppletInputSignal)inputSignal;
        if (n >= 1000 && n <= 1027) {
            this.signalsPlayerOne[n - 1000] = appletInputSignal;
        } else if (n >= 2000 && n <= 2027) {
            this.signalsPlayerTwo[n - 2000] = appletInputSignal;
        } else if (n >= 5000 && n <= 5048) {
            this.signalsKeyboard[n - 5000] = appletInputSignal;
        } else if (n >= 7000 && n <= 7004) {
            this.signalsEmulator[n - 7000] = appletInputSignal;
        }
    }

    public InputSignal getDefaultSignal(int n) {
        if (n >= 1000 && n <= 1027) {
            return DEFAULTS_PLAYER_ONE[n - 1000];
        }
        if (n >= 2000 && n <= 2027) {
            return DEFAULTS_PLAYER_TWO[n - 2000];
        }
        if (n >= 5000 && n <= 5048) {
            return DEFAULTS_KEYBOARD[n - 5000];
        }
        if (n >= 7000 && n <= 7004) {
            return DEFAULTS_EMULATOR[n - 7000];
        }
        return null;
    }

    public InputSignal pollForInputSignal() {
        int n = 0;
        while (n < this.keyMap.length) {
            if (this.keyMap[n]) {
                return new AppletInputSignal(n);
            }
            ++n;
        }
        return null;
    }

    public float getControlValue(int n) {
        AppletInputSignal appletInputSignal = null;
        if (n >= 1000 && n <= 1027) {
            appletInputSignal = this.signalsPlayerOne[n - 1000];
        } else if (n >= 2000 && n <= 2027) {
            appletInputSignal = this.signalsPlayerTwo[n - 2000];
        } else if (n >= 5000 && n <= 5048) {
            appletInputSignal = this.signalsKeyboard[n - 5000];
        } else if (n >= 7000 && n <= 7004) {
            appletInputSignal = this.signalsEmulator[n - 7000];
        }
        if (appletInputSignal == null) {
            return 0.0f;
        }
        int n2 = appletInputSignal.keyCode;
        return this.keyMap[n2] ? 1.0f : 0.0f;
    }

    public void initConfigMode() {
    }

    public void releaseConfigMode() {
    }

    public void init() {
        this.component.addKeyListener(this.keyListener);
    }

    public void release() {
        this.component.removeKeyListener(this.keyListener);
    }

    static /* synthetic */ boolean[] access$0(AppletInputDevice appletInputDevice) {
        return appletInputDevice.keyMap;
    }

    AppletInputDevice(Component component) {
        AppletInputDevice appletInputDevice = this;
        if (appletInputDevice == null) {
            throw null;
        }
        this.keyListener = new 1(appletInputDevice);
        this.component = component;
        this.signalsPlayerOne = new AppletInputSignal[DEFAULTS_PLAYER_ONE.length];
        System.arraycopy(DEFAULTS_PLAYER_ONE, 0, this.signalsPlayerOne, 0, DEFAULTS_PLAYER_ONE.length);
        this.signalsPlayerTwo = new AppletInputSignal[DEFAULTS_PLAYER_TWO.length];
        System.arraycopy(DEFAULTS_PLAYER_TWO, 0, this.signalsPlayerTwo, 0, DEFAULTS_PLAYER_TWO.length);
        this.signalsKeyboard = new AppletInputSignal[DEFAULTS_KEYBOARD.length];
        System.arraycopy(DEFAULTS_KEYBOARD, 0, this.signalsKeyboard, 0, DEFAULTS_KEYBOARD.length);
        this.signalsEmulator = new AppletInputSignal[DEFAULTS_EMULATOR.length];
        System.arraycopy(DEFAULTS_EMULATOR, 0, this.signalsEmulator, 0, DEFAULTS_EMULATOR.length);
    }

    private static class AppletInputSignal
    implements InputSignal {
        private int keyCode;
        private String description;

        public String getDescription() {
            return this.description;
        }

        public String getConfigString() {
            return Integer.toString(this.keyCode);
        }

        public AppletInputSignal(int n) {
            this.keyCode = n;
            this.description = "'" + KeyEvent.getKeyText(n) + "'";
        }
    }
}

