/**************************************
****   CDAUDIO.H  -  CD-DA Player  ****
****         Header File           ****
**************************************/

#ifndef	CDAUDIO_H
#define CDAUDIO_H

//-- Exported Variables ------------------------------------------------------
extern int	cdda_first_drive;
extern int	cdda_nb_of_drives;
extern int	cdda_current_drive;
extern int	cdda_current_track;
extern int	cdda_playing;
extern char	drive_list[26];
extern int	nb_of_drives;
extern int	cdda_autoloop;

//-- Exported Functions ------------------------------------------------------
extern int	cdda_init(void);
extern int	cdda_play(int);
extern void	cdda_stop(void);
extern void	cdda_resume(void);
extern void	cdda_shutdown(void);
extern void	cdda_loop_check(void);
extern int 	cdda_get_disk_info(void);
extern void	cdda_build_drive_list(void);
extern int	cdda_get_volume(void);
extern void	cdda_set_volume(int volume);
extern void audio_setup(void);

#endif

