; ***************************************
; ****         Memory Mapping        ****
; ***************************************


	BITS	32

	%include ".\src\helper.asm"

	GLOBAL	_initialize_memmap
	GLOBAL	_cpu_readmem24
	GLOBAL	_cpu_readmem24_word
	GLOBAL	_cpu_readmem24_dword
	GLOBAL	_cpu_writemem24
	GLOBAL	_cpu_writemem24_word
	GLOBAL	_cpu_writemem24_dword
	GLOBAL	_cpu_setOPbase24
	
	EXTERN	_OP_ROM
	EXTERN	_neogeo_rom_memory
	EXTERN	_neogeo_prg_memory
	EXTERN	_video_vidram
	EXTERN	_video_pointer
	EXTERN	_video_modulo
	EXTERN	_video_paletteram_ng
	EXTERN	_video_paletteram_pc
	EXTERN	_video_palette_bank0_ng
	EXTERN	_video_palette_bank1_ng
	EXTERN	_video_palette_bank0_pc
	EXTERN	_video_palette_bank1_pc
	EXTERN	_read_player1
	EXTERN	_read_player2
	EXTERN	_read_pl12_startsel
	EXTERN	_neogeo_frame_counter
	EXTERN	_neogeo_frame_counter_speed
	EXTERN	_neogeo_memorycard
	EXTERN	_video_color_lut
	EXTERN	_sound_code
	EXTERN	_z80_cycles
	EXTERN	_mz80nmi
	EXTERN	_mz80exec
	EXTERN	_neogeo_vline
	EXTERN	_pending_command
	EXTERN	_result_code

	SECTION	.data
	
	BeginMemMap
	DeclareZone	0000000h, 01FFFFFh, H_RAM		; *** RAM ***
	DeclareZone	0300000h, 030FFFFh, H_CTRL1		; *** CONTROLLER 1 ***
	DeclareZone 0320000h, 032FFFFh, H_COMZ80	; *** Z80 COMMUNICATION ***
	DeclareZone	0340000h, 034FFFFh, H_CTRL2		; *** CONTROLLER 2 ***
	DeclareZone	0380000h, 038FFFFh, H_STSEL		; *** ST/SEL ***
	DeclareZone	03A0000h, 03AFFFFh, H_SWITCH	; *** SWITCHES ***
	DeclareZone	03C0000h, 03CFFFFh, H_VIDREGS	; *** VIDREGS ***
	DeclareZone	0400000h, 040FFFFh, H_PALETTE	; *** PALETTERAM ***
	DeclareZone	0800000h, 080FFFFh, H_MEMCARD	; *** MEMORY CARD ***
	DeclareZone	0C00000h, 0C1FFFFh, H_ROM		; *** ROM ***
	EndMemMap

	AlignData

H_RAM:	dd	RHB_RAM
	dd	RHW_RAM
	dd	RHL_RAM
	dd	WHB_RAM
	dd	WHW_RAM
	dd	WHL_RAM

	AlignData

H_ROM:	dd	RHB_ROM
	dd	RHW_ROM
	dd	RHL_ROM
	dd	WH_NOP
	dd	WH_NOP
	dd	WH_NOP

	AlignData

H_NOP:	dd	RH_NOP
	dd	RH_NOP
	dd	RH_NOP
	dd	WH_NOP
	dd	WH_NOP
	dd	WH_NOP

	AlignData

H_CTRL1:
	dd	RHB_CTRL1
	dd	RH_NOP
	dd	RH_NOP
	dd	WH_NOP
	dd	WH_NOP
	dd	WH_NOP

	AlignData

H_CTRL2:
	dd	RHB_CTRL2
	dd	RH_NOP
	dd	RH_NOP
	dd	WH_NOP
	dd	WH_NOP
	dd	WH_NOP

	AlignData

H_STSEL:
	dd	RHB_STSEL
	dd	RH_NOP
	dd	RH_NOP
	dd	WH_NOP
	dd	WH_NOP
	dd	WH_NOP

	AlignData

H_SWITCH:
	dd	RH_NOP
	dd	RH_NOP
	dd	RH_NOP
	dd	WH_SWITCH
	dd	WH_SWITCH
	dd	WH_SWITCH

	AlignData

H_VIDREGS:
	dd	RH_NOP
	dd	RHW_VIDREGS
	dd	RHL_VIDREGS
	dd	WHB_VIDREGS
	dd	WHW_VIDREGS
	dd	WHL_VIDREGS

	AlignData

H_PALETTE:
	dd	RH_NOP
	dd	RHW_PAL
	dd	RHL_PAL
	dd	WH_NOP
	dd	WHW_PAL
	dd	WHL_PAL
	
	AlignData
	
H_MEMCARD:
	dd	RHB_MEMCD
	dd	RHW_MEMCD
	dd	RHL_MEMCD
	dd	WHB_MEMCD
	dd	WHW_MEMCD
	dd	WHL_MEMCD
	
	AlignData
	
H_COMZ80:
	dd	RHB_COMZ80
	dd	RH_NOP
	dd	RH_NOP
	dd	WHB_COMZ80
	dd	WH_NOP
	dd	WH_NOP

	AlignData

SwitchMap:
	dd	SW_NOP		; 00..01
	dd	SW_NOP		; 02..03
	dd	SW_NOP		; 04..05
	dd	SW_NOP		; 06..07
	dd	SW_NOP		; 08..09
	dd	SW_NOP		; 0A..0B
	dd	SW_NOP		; 0C..0D
	dd	SW_PALBNK0	; 0E..0F
	dd	SW_NOP		; 10..11
	dd	SW_NOP		; 12..13
	dd	SW_NOP		; 14..15
	dd	SW_NOP		; 16..17
	dd	SW_NOP		; 18..19
	dd	SW_NOP		; 1A..1B
	dd	SW_NOP		; 1C..1D
	dd	SW_PALBNK1	; 1E..1F

	AlignData

VidRegsMapR:
	dd	VIDR_POINTER
	dd	VIDR_DATA
	dd	VIDR_MODULO
	dd	VIDR_AUTOANM
	dd	VIDR_POINTER
	dd	VIDR_DATA
	dd	VID_NOP
	dd	VID_NOP	

	AlignData

VidRegsMapW:
	dd	VIDW_POINTER
	dd	VIDW_DATA
	dd	VIDW_MODULO
	dd	VIDW_AUTOANM
	dd	VID_NOP
	dd	VID_NOP	
	dd	VID_NOP
	dd	VID_NOP	
	
	AlignFunc
	
	SECTION	.bss
	
MemoryElements:
	RESD	256

	SECTION	.text

	AlignFunc

_cpu_readmem24:
	BEGIN
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx]
	
	pop	edx
	pop	ecx
	ret

	AlignFunc

_cpu_readmem24_word:
	BEGIN
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx + 4]
	
	pop	edx
	pop	ecx
	ret

	AlignFunc

_cpu_readmem24_dword:
	BEGIN
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx + 8]
	
	pop	edx
	pop	ecx
	ret

	AlignFunc

_cpu_writemem24:
	BEGIN
	PUSHL	ebx
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ebx, [esp + ARGS + 4]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx + 12]
	
	pop	edx
	pop	ecx
	pop	ebx
	ret

	AlignFunc

_cpu_writemem24_word:
	BEGIN
	PUSHL	ebx
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ebx, [esp + ARGS + 4]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx + 16]
	
	pop	edx
	pop	ecx
	pop	ebx
	ret

	AlignFunc

_cpu_writemem24_dword:
	BEGIN
	PUSHL	ebx
	PUSHL	ecx
	PUSHL	edx
	
	mov	edx, [esp + ARGS]
	mov	ebx, [esp + ARGS + 4]
	mov	ecx, edx
	shr	ecx, 14
	and	ecx, 0x000003FC
	and	edx, 0x00FFFFFF
	add	ecx, MemoryElements
	mov	ecx, [ecx]
	call	[ecx + 20]
	
	pop	edx
	pop	ecx
	pop	ebx
	ret

	AlignFunc

_cpu_setOPbase24:
	mov	eax, [esp+4]
	cmp	eax, 0C00000h
	jb	neo_RAM
	mov	eax, [_neogeo_rom_memory]
	sub	eax, 0C00000h
	mov	[_OP_ROM], eax
	ret
neo_RAM:
	mov	eax, [_neogeo_prg_memory]
	mov	[_OP_ROM], eax
	ret

	AlignFunc

_initialize_memmap:
	
	pusha
	
	mov	edi, MemoryElements
	xor	edx, edx

init_mm_loop0:
	mov	esi, MemoryMap
	mov	ecx, ZoneCount

init_mm_loop1:
	mov	ebx, [esi]
	cmp	edx, ebx
	jb	NextZone
	mov	ebx, [esi + 4]
	cmp	edx, ebx
	ja	NextZone
	
	mov	ebx, [esi + 8]
	mov	[edi], ebx
	jmp	NextElem

NextZone:
	add	esi, 12
	loop	init_mm_loop1
	
	mov	ebx, H_NOP
	mov	[edi], ebx
	
NextElem:
	add	edi, 4
	add	edx, 0x10000
	cmp	edx, 0x01000000
	jne	init_mm_loop0
	
	popa
	ret

	AlignFunc

RH_NOP:
	xor	eax, eax
	dec	eax
	ret

	AlignFunc

WH_NOP:
	ret

	AlignFunc

RHB_RAM:
	xor	eax, eax
	xor	edx, 1
	add	edx, [_neogeo_prg_memory]
	mov	al, [edx]
	ret

	AlignFunc

RHW_RAM:
	xor	eax, eax
	add	edx, [_neogeo_prg_memory]
	mov	ax, [edx]
	ret

	AlignFunc

RHL_RAM:
	add	edx, [_neogeo_prg_memory]
	mov	eax, [edx]
	ror	eax, 16
	ret

	AlignFunc

WHB_RAM:
	xor	edx, 1
	add	edx, [_neogeo_prg_memory]
	mov	[edx], bl
	ret

	AlignFunc

WHW_RAM:
	add	edx, [_neogeo_prg_memory]
	mov	[edx], bx
	ret

	AlignFunc

WHL_RAM:
	add	edx, [_neogeo_prg_memory]
	rol	ebx, 16
	mov	[edx], ebx
	ret

	AlignFunc

RHB_ROM:
	xor	eax, eax
	xor	edx, 1
	and	edx, 0x1FFFF
	add	edx, [_neogeo_rom_memory]
	mov	al, [edx]
	ret

	AlignFunc

RHW_ROM:
	xor	eax, eax
	and	edx, 0x1FFFE
	add	edx, [_neogeo_rom_memory]
	mov	ax, [edx]
	ret

	AlignFunc

RHL_ROM:
	and	edx, 0x1FFFE
	add	edx, [_neogeo_rom_memory]
	mov	eax, [edx]
	ror	eax, 16
	ret

	AlignFunc

RHB_CTRL1:
	call	_read_player1
	ret

	AlignFunc

RHB_CTRL2:
	call	_read_player2
	ret

	AlignFunc

RHB_STSEL:
	call	_read_pl12_startsel
	ret

	AlignFunc

WH_SWITCH:
	and	edx, 0x1E
	add	edx, edx
	add	edx, SwitchMap
	call	[edx]
	ret
	
	AlignFunc
	
SW_NOP	ret

	AlignFunc
	
SW_PALBNK0:
	mov	ebx, _video_palette_bank0_ng
	mov	[_video_paletteram_ng], ebx
	mov	ebx, _video_palette_bank0_pc
	mov	[_video_paletteram_pc], ebx
	ret
	
	AlignFunc
	
SW_PALBNK1:
	mov	ebx, _video_palette_bank1_ng
	mov	[_video_paletteram_ng], ebx
	mov	ebx, _video_palette_bank1_pc
	mov	[_video_paletteram_pc], ebx
	ret
	
	AlignFunc
	
RHW_VIDREGS:
	xor	eax, eax
	and	edx, 0xE
	add	edx, edx
	add	edx, VidRegsMapR
	call	[edx]
	ret
	
	AlignFunc
	
RHL_VIDREGS:
	and	edx, 0xE
	add	edx, edx
	add	edx, VidRegsMapR
	call	[edx]
	rol	eax, 16
	call	[edx + 4]
	ret
	
	AlignFunc
	
WHB_VIDREGS:
	test	edx, 1
	jnz	odd_write
	and	edx, 0xE
	add	edx, edx
	push	eax
	push	edx
	add	edx, VidRegsMapR
	call	[edx]
	pop	edx
	mov	bl, al
	pop	eax
	add	edx, VidRegsMapW
	call	[edx]
	ret

odd_write:
	and	edx, 0xE
	add	edx, edx
	push	eax
	push	edx
	add	edx, VidRegsMapR
	call	[edx]
	pop	edx
	mov	bh, ah
	pop	eax
	add	edx, VidRegsMapW
	call	[edx]
	ret
	
	AlignFunc
	
WHW_VIDREGS:
	and	edx, 0xE
	add	edx, edx
	add	edx, VidRegsMapW
	call	[edx]
	ret
	
	AlignFunc
	
WHL_VIDREGS:
	and	edx, 0xE
	add	edx, edx
	add	edx, VidRegsMapW
	rol	ebx, 16
	call	[edx]
	rol	ebx, 16
	call	[edx + 4]
	ret

	AlignFunc

VIDR_POINTER:
	mov	ax, [_video_pointer]
	ret

	AlignFunc
	
VIDR_DATA:
	push	edx
	mov	edx, [_video_vidram]
	xor	ecx, ecx
	mov	cx, [_video_pointer]
	add	ecx, ecx
	add	edx, ecx
	mov	ax, [edx]
	pop	edx
	ret

	AlignFunc
	
VIDR_MODULO:
	mov	ax, [_video_modulo]
	ret

	AlignFunc
	
VIDR_AUTOANM:
	mov	edx, [_neogeo_frame_counter_speed]
	mov	eax, [_neogeo_frame_counter]

	dec	edx
	shl	dx, 8
	and	ax, 7
	or	ax, 128
	or	ax, dx

	ret
	
	AlignFunc
	
VIDW_POINTER:
	mov	[_video_pointer], bx
	ret

	AlignFunc
	
VIDW_DATA:
	mov	eax, [_video_vidram]
	xor	ecx, ecx
	mov	cx, [_video_pointer]
	add	ecx, ecx
	add	eax, ecx
	mov	[eax], bx
	mov	bx, [_video_pointer]
	add	bx, [_video_modulo]
	mov	[_video_pointer], bx
	ret

	AlignFunc

VIDW_MODULO:
	mov	[_video_modulo], bx
	ret

	AlignFunc
	
VIDW_AUTOANM:
	mov	cx, bx
	shr	cx, 8
	and	ecx,0FFh
	inc	ecx
	mov	[_neogeo_frame_counter_speed], ecx
	ret

	AlignFunc
	
VID_NOP:
	ret
	
	AlignFunc
	
WHW_PAL:
	and	edx, 1FFFh
	and	ebx, 7FFFh
	mov	ecx, [_video_paletteram_ng]
	mov	[ecx + edx], bx
	mov	ecx, _video_color_lut
	mov	bx, [ecx + ebx * 2]
	mov	ecx, [_video_paletteram_pc]
	mov	[ecx + edx], bx
	ret
	
	AlignFunc
	
WHL_PAL:
	and	edx, 1FFFh
	push	ebx
	rol	ebx, 16
	and	ebx, 07FFFh
	mov	ecx, [_video_paletteram_ng]
	mov	[ecx + edx], bx
	mov	ecx, _video_color_lut
	mov	bx, [ecx + ebx * 2]
	mov	ecx, [_video_paletteram_pc]
	mov	[ecx + edx], bx
	pop	ebx
	and	ebx, 07FFFh
	add	edx, 2	
	mov	ecx, [_video_paletteram_ng]
	mov	[ecx + edx], bx
	mov	ecx, _video_color_lut
	mov	bx, [ecx + ebx * 2]
	mov	ecx, [_video_paletteram_pc]
	mov	[ecx + edx], bx
	ret

	AlignFunc
	
RHW_PAL:
	and	edx, 1FFFh
	add	edx, [_video_paletteram_ng]
	mov	ax, [edx]
	ret

	AlignFunc
	
RHL_PAL:
	and	edx, 1FFFh
	add	edx, [_video_paletteram_ng]
	mov	eax, [edx]
	rol	eax, 16
	ret

	AlignFunc

RHB_MEMCD:
	xor	eax, eax
	and	edx, 03FFFh
	test	edx, 1
	jnz	data_ok
	dec	eax
	ret
data_ok:
	mov	ecx, edx
	shr	ecx, 1
	add	ecx, _neogeo_memorycard
	mov	al, [ecx]
	ret
	
	AlignFunc
	
RHW_MEMCD:
	xor	eax, eax
	dec	ax
	and	edx, 03FFFh
	jmp	data_ok
	
	AlignFunc
	
RHL_MEMCD:
	xor	eax, eax
	dec	eax
	and	edx, 03FFFh
	call	data_ok
	rol	eax, 16
	add	edx, 2
	jmp	data_ok
	
WHB_MEMCD:
	and	edx, 03FFFh
	test	edx, 1
	jz	no_write
do_write:	
	mov	ecx, edx
	shr	ecx, 1
	add	ecx, _neogeo_memorycard
	mov	[ecx], bl
no_write:
	ret
	
	AlignFunc
	
WHW_MEMCD:
	and	edx, 03FFFh
	jmp	do_write

	AlignFunc
	
WHL_MEMCD:
	and	edx, 03FFFh
	rol	ebx, 16
	call	do_write
	rol	ebx, 16
	add	edx, 2
	jmp	do_write

	AlignFunc

WHB_COMZ80:
	and	edx, 0FFFFh
	jnz	no_com
	
	and	ebx, 0FFh
	mov	[_sound_code], ebx

	mov	dword [_pending_command], 1

	call	_mz80nmi

	sub dword [_z80_cycles], 300
	
	push	dword 300
	call	_mz80exec
	pop	ebx

no_com:
	ret
	
	AlignFunc

RHB_COMZ80:
	and	edx, 0FFFFh
	jnz	no_com
	
	mov	eax, [_result_code]
	
	cmp	dword [_pending_command], 1
	jz	no_com
	
	and	eax, 07Fh
	
	ret


