/*******************************************
**** VIDEO.H - Video Hardware Emulation ****
****            Header File             ****
*******************************************/

#ifndef	VIDEO_H
#define VIDEO_H

//-- Defines -----------------------------------------------------------------
#define VIDEO_TEXT		0
#define VIDEO_NORMAL	1
#define	VIDEO_SCANLINES	2

//-- Global Variables --------------------------------------------------------
extern char				*video_vidram;
extern short			video_modulo;
extern unsigned short	video_pointer;
extern unsigned short	*video_paletteram;
extern unsigned short	*video_paletteram_pc;
extern unsigned short	video_palette_bank0[4096];
extern unsigned short	video_palette_bank1[4096];
extern unsigned char	video_fix_usage[4096];
extern unsigned char	video_spr_usage[32768];
extern unsigned int		video_hide_fps;
extern unsigned short	video_color_lut[32768];
extern BITMAP			*video_buffer;
extern BITMAP			*game_title;
extern int				video_mode;
extern double			gamma_correction;

//-- Exported Functions ------------------------------------------------------
extern int	video_init(void);
extern void	video_shutdown(void);
extern int	video_set_mode(int);
extern void	video_draw_screen1(void);
//extern void	video_draw_screen2(void);
extern void	video_save_snapshot(void);
extern void	video_draw_spr(unsigned int code, unsigned int color, int flipx,
			int flipy, int sx, int sy, int zx, int zy);
extern void video_setup(void);

#endif

