	%include ".\src\helper.asm"

	BITS32
	
	GLOBAL	_extract8
	GLOBAL	_motorola_peek
	GLOBAL	_motorola_poke
	
	SECTION	.text

	AlignFunc
	
_extract8:
	BEGIN
	PUSHL	ebx
	PUSHL	ecx
	PUSHL	edi
	PUSHL	esi
	
	mov	esi, [esp + ARGS]
	mov	edi, [esp + ARGS + 4]
		
	mov	bh, byte [esi]
	mov	bl, byte [esi+1]
	mov	ch, byte [esi+2]
	mov	cl, byte [esi+3]

	%rep	4
	xor	eax, eax
	shr	ch, 1
	rcl	al, 1
	shr	cl, 1
	rcl	al, 1
	shr	bh, 1
	rcl	al, 1
	shr	bl, 1
	rcl	al, 1
	shr	ch, 1
	rcl	ah, 1
	shr	cl, 1
	rcl	ah, 1
	shr	bh, 1
	rcl	ah, 1
	shr	bl, 1
	rcl	ah, 1
	shl	ah, 4
	or	al, ah
	mov	[edi], al
	inc	edi
	%endrep
	
	pop	esi
	pop	edi
	pop	ecx
	pop	ebx
	ret

	AlignFunc
	
_motorola_peek:
	BEGIN
	mov	eax, [esp + ARGS]
	mov	eax, [eax]
	bswap	eax
	ret

	AlignFunc
	
_motorola_poke:
	BEGIN
	PUSHL	ecx
	PUSHL	edx

	mov	edx, [esp + ARGS]
	mov	ecx, [esp + ARGS + 4]
	bswap	ecx
	mov	[edx], ecx
	pop	edx
	pop	ecx
	ret

	AlignFunc
	
