/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */
#include <stdio.h>
#include <allegro.h>
#include "host.h"
#include "main.h"
#include "shinobi.h"

extern UINT8 *tiles_base;
extern UINT8 vid_bank, txt_bank;
extern UINT8 *s16_ptr[0x10000];
extern UINT8 *base_scr_hor_fg;
extern UINT8 *base_scr_ver_fg;
extern UINT8 *base_scr_pag_fg;
extern UINT8 *base_scr_hor_bg;
extern UINT8 *base_scr_ver_bg;
extern UINT8 *base_scr_pag_bg;
extern UINT8 *base_brq_page;

static void affiche_brique_simple(int bx, int by, int banque, int brique)
{
   rectfill(screen, bx, by, bx+7, by+7, brique);
}

static int base_color=0;
static UINT8 *brq_page;

static void affiche_brique_pixels(int bx, int by, int banque, int brique, int f)
{
   int x, y;
   UINT8 p = *brq_page;
   long a = brique | (banque<<8);

   if (f) {
      if (p>0xf) p >>= 4;
      a += ((long)p) << 12;
   }
   a *= 32;
   for (y=0; y<8; y++) {
      for (x=0; x<8; x+=2,a++) {
/*         if (x == 0 || y==0) _putpixel(screen, bx+x, by+y, 0);
         else */
         _putpixel(screen, bx+x, by+y, base_color+(tiles_base[a]&0xf));
         _putpixel(screen, bx+x+1, by+y, base_color+(tiles_base[a]>>4));
      }
   }
}

void D_ViewVideo(int p)
{
   int x, y, op=p;
   RGB pal;
   UINT8 k;
   char ws[80];
   set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0);
   pal.r=pal.g=pal.b=63;
   for (x=1;x!=256;x++) set_color(x, (RGB *)&pal);
   for (x=0;x!=8;x++) {
      pal.r=pal.g=9*x; pal.b=0;
      set_color(x, (RGB *)&pal);
      pal.r=0;
      set_color(32+x, (RGB *)&pal);
   }
   
   brq_page=(UINT8 *)base_brq_page;
   
   install_keyboard();
   
   do {
      op = p;
      for (y=0;y!=0x20;y++) {
	 for (x=0;x!=0x40;x++) {
	    base_color=((s16_ptr[vid_bank][p]&0x20)==0x20)? 32:0;
	    affiche_brique_pixels(x*8, y*8, 
				  s16_ptr[vid_bank][p]&0xF, s16_ptr[vid_bank][p+1],
				  s16_ptr[vid_bank][p]&0x10);
            p+=2;
	 }
      }
      
      for (y=0;y!=0x20;y++) {
	 for (x=0;x!=0x40;x++) {
	    base_color=((s16_ptr[vid_bank][p]&0x20)==0x20)? 32:0;
	    affiche_brique_pixels(512+x*8, y*8,
				  s16_ptr[vid_bank][p]&0xF, s16_ptr[vid_bank][p+1],
				  s16_ptr[vid_bank][p]&0x10);
	    p+=2;
	 }
      }
      
      for (y=0;y!=0x20;y++) {
	 for (x=0;x!=0x40;x++) {
	    base_color=((s16_ptr[vid_bank][p]&0x20)==0x20)? 32:0;
	    affiche_brique_pixels(x*8, 300+y*8, 
				  s16_ptr[vid_bank][p]&0xF, s16_ptr[vid_bank][p+1],
				  s16_ptr[vid_bank][p]&0x10);
	    p+=2;
	 }
      }
      
      for (y=0;y!=0x20;y++) {
	 for (x=0;x!=0x40;x++) {
	    base_color=((s16_ptr[vid_bank][p]&0x20)==0x20)? 32:0;
	    affiche_brique_pixels(512+x*8, 300+y*8, 
				  s16_ptr[vid_bank][p]&0xF, s16_ptr[vid_bank][p+1],
				  s16_ptr[vid_bank][p]&0x10);
	    p+=2;
	 }
      }
      
      rect(screen, 0, 0, 512, 257, 255);
      rect(screen, 0, 300, 512, 557, 255);
      rect(screen, 512, 0, 1024, 257, 255);
      rect(screen, 512, 300, 1024, 557, 255);
      p = op;
      for (y=0;y!=2;y++)
      	for (x=0;x!=2;x++) {
	   sprintf(ws, "PAGE %01x (%06x)", (p>>12)&0xF, (vid_bank * 0x10000) + p);
	   textout(screen, font, ws, 512*x, 260+(300*y), 255);
	   p+=0x1000;
	}
      clear_keybuf();
      while (!keypressed());
      k = readkey()>>8;
      p = op;
      switch (k) {
       case KEY_MINUS_PAD:
	 if (p!=0x0000) p-=0x4000;
	 clear(screen);
	 break;
       case KEY_PLUS_PAD:
	 if (p!=0xC000) p+=0x4000;
	 clear(screen);
	 break;
      }
   } while (k != KEY_ESC);

   remove_keyboard();
   set_gfx_mode(GFX_TEXT,0 ,0 ,0 ,0);
}

void dump_text_video() {
   int x, y, p=0,k;
   RGB pal;

   set_gfx_mode(GFX_AUTODETECT, 1024, 768, 0, 0);
   pal.r=pal.g=pal.b=63;
   for (x=1;x!=256;x++) set_color(x, (RGB *)&pal);
   for (x=0;x!=8;x++) {
      pal.r=pal.g=9*x; pal.b=0;
      set_color(x, (RGB *)&pal);
      pal.r=0;
      set_color(32+(x), (RGB *)&pal);
   }
   brq_page=(UINT8 *)base_brq_page;
   
   install_keyboard();

   set_color(255, (RGB *)&pal);
   rect(screen, 0, 0, 513, 513, 255);
   base_color=0;
   brq_page=(UINT8 *)base_brq_page;
   for (y=0;y!=0x40;y++) {
      for (x=0;x!=0x40;x++) {
         affiche_brique_pixels(1+x*8, 1+y*8, 
                               /*s16_ptr[txt_bank][p]&1*/0, s16_ptr[txt_bank][p+1], 0);
	 p+=2;
      }
   }
   clear_keybuf();
   while (!keypressed());
   k = readkey()>>8;

   remove_keyboard();
   set_gfx_mode(GFX_TEXT,0 ,0 ,0 ,0);
}

void NewDebugger() {
   Video(0);
   remove_keyboard();
   cpudebug_interactive();
   install_keyboard();
   Video(1);
}

static unsigned GetMW(UINT8 *vptr) {
   return ((vptr[0]<<8) | vptr[1]);
}

void DumpS16(void) {
   UINT8 *base = s16_ptr[txt_bank];
   
   printf("FG Hor [%02x%04lx] = %04x\n", txt_bank, base_scr_hor_fg-base,   GetMW(base_scr_hor_fg));
   printf("FG Ver [%02x%04lx] = %04x\n", txt_bank, base_scr_ver_fg-base-1, GetMW(base_scr_ver_fg-1));
   printf("FG PS  [%02x%04lx] = %04x\n", txt_bank, base_scr_pag_fg-base-1, GetMW(base_scr_pag_fg-1));
   
   printf("BG Hor [%02x%04lx] = %04x\n", txt_bank, base_scr_hor_bg-base,   GetMW(base_scr_hor_bg));
   printf("BG Ver [%02x%04lx] = %04x\n", txt_bank, base_scr_ver_bg-base-1, GetMW(base_scr_ver_bg-1));
   printf("BG PS  [%02x%04lx] = %04x\n", txt_bank, base_scr_pag_bg-base-1, GetMW(base_scr_pag_bg-1));
   
}

