#include "audio.h"

typedef AUDIOWAVE WaveBuffer;
typedef HAC AudioChannel;

// copy sound data from rendered_buffer to wave buffer
// if rendered_buffer is NULL, wave buffer will be filled with 0
static void WriteToWaveBuffer(WaveBuffer *wave, int write_pos, UINT8 *rendered_buffer, int size)
{
  if (write_pos+size < SIZEBUFFER) { // inside buffer
    if (rendered_buffer) memcpy(&wave->lpData[write_pos], rendered_buffer, size);
    else memset(&wave->lpData[write_pos], 0, size);
    AWriteAudioData(wave, write_pos , size);
  } else { // split to tail and head
    if (rendered_buffer) {
      memcpy(&wave->lpData[write_pos], rendered_buffer, SIZEBUFFER-write_pos);
      memcpy(&wave->lpData[0], rendered_buffer+SIZEBUFFER-write_pos, write_pos+size-SIZEBUFFER);
    } else {
      memset(&wave->lpData[write_pos], 0, SIZEBUFFER-write_pos);
      memset(&wave->lpData[0], 0, write_pos+size-SIZEBUFFER);
    }
    AWriteAudioData(wave, 0L , SIZEBUFFER);//cur_buf+cur_size-SIZEBUFFER);
  }
}

// return 0 if succ
static int init_wave_stream(WaveBuffer *wave, int bits)
{
  if (bits == 16)  wave->wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_MONO;
  else wave->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;
  wave->nSampleRate = SAMPLERATE;
  wave->dwLength = SIZEBUFFER;
  wave->dwLoopStart = 0L;
  wave->dwLoopEnd = SIZEBUFFER;
  wave->wFormat |= AUDIO_FORMAT_LOOP;
  if (ACreateAudioData(wave)!= AUDIO_ERROR_NONE) {
    return -1;
  }
  /* clean up the audio waveform buffer */
  memset(wave->lpData, 0, wave->dwLength);
  AWriteAudioData(wave, 0L, wave->dwLength);

  return 0;
}

inline static void GetPlayPosition(AudioChannel channel, UINT32 *pos1)
{
  AGetVoicePosition(channel, pos1); // pos1*=2;
}

inline static void GetPlayStatus(AudioChannel channel, int *stopped)
{
  AGetVoiceStatus(channel, stopped);
}   

inline static void PlayStaticWave(AudioChannel *channel, WaveBuffer *sample_buffer)
{
  APlayVoice(*channel, sample_buffer);
}

inline static void PlayWaveStream(AudioChannel *channel, WaveBuffer *wave_stream)
{
  APlayVoice(*channel, wave_stream);
}

inline static void StopPlaying(AudioChannel channel)
{
  AStopVoice(channel);
}

inline static void SetVol(AudioChannel channel, int volume)
{
  ASetVoiceVolume(channel, volume);
}

inline static void SetWaveBufferSampleRate(WaveBuffer *wave, int freq)
{
  wave->nSampleRate = freq;
}

inline static void SetChannelSampleRate(AudioChannel channel, int freq)
{
  ASetVoiceFrequency(channel, freq);
}

/* return 0 if succ */
inline static int CreatAudioChannel(AudioChannel *ch)
{
  return ACreateAudioVoice(ch);
}

inline static void CloseAllChannels()
{
  ACloseAudio();
}

inline static void UpdateAudio()
{
  AUpdateAudio();
}

static AUDIOINFO info;
static void audio_selection()
{
  if (AInitialize() == AUDIO_ERROR_NONE) {
/*
      if (sound_card == -1) {
         AUDIOCAPS caps;
         int i;
         printf("\nSelect the audio device:\n");
         for (i=0;i<AGetAudioNumDevs();i++) {
            if (AGetAudioDevCaps(i,&caps)==AUDIO_ERROR_NONE)
               printf("  %2d. %s\n", i, caps.szProductName);
         }
         printf("\n");
         if (i<10) {
            i = getch();
            sound_card = i - '0';
            if (sound_card==2) sound_card=1;
         } else scanf("%d", &sound_card);
      }
*/
    if (sound_card) {
      if (sound_type==3) sampled_sound_support = 1;
      if (pf_state) printf("Initializing audio device...\n");
      if (AInitialize()) {
        ierror("Audio initialisation error!\n");
      } else {
        info.nDeviceId = sound_card; // AUDIO_DEVICE_MAPPER;
        info.wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_MONO;
        info.nSampleRate = SAMPLERATE;
       }
    } else {
       sound_type = 0;
       sampled_sound_support = 0;
    }
  }
}


static int filesize(FILE *fp)
{
   int save_pos, size_of_file;

   save_pos = ftell(fp);
   fseek(fp, 0L, SEEK_END);
   size_of_file = ftell(fp);
   fseek(fp, save_pos, SEEK_SET);
   return(size_of_file);
}

static void LoopSample(LPAUDIOWAVE Sample)
{
   if (Sample->dwHandle) {
      Sample->wFormat |= AUDIO_FORMAT_LOOP;
      Sample->dwLoopStart = 0;;
      Sample->dwLoopEnd = Sample->dwLength;
   }
}

static void LoadSamplesWAV_V2(WaveBuffer **Samples)
{
   FILE *f;
   int i;
   char zipfn[64];
   char fn[120];
   char *fn_header;
   long size;
   int idx;
   char mymsg[256];
   UINT8 ZippedSampleExist = exists(zsmp_path);
   #define TEMP_FILE "__temp__"

   /* samples\shinobi\shin_ */
   /*                 ^here */
   if ((fn_header = strrchr(samples_path, '\\')) != NULL) fn_header++;
   else fn_header = "";

   if ((vce_start)&&(vce_end)) {
     for (i=vce_start; i<=vce_end; i++) {
       sprintf(zipfn,"%s%02x.wav", fn_header, i);
       sprintf(fn, "%s%02x.wav", samples_path, i);
       f = fopen(fn, "rb");
       sample_ok[i] = 0;
       if (f) {
         size = filesize(f);
         sprintf(mymsg, "Loading %s , size = %ld bytes\n", fn, size);
load1:   imessage(mymsg, 47, 46, 0, 0);
         fclose(f);
         if (!(ALoadWaveFile(fn, &Samples[i], 0L))) {
           sample_ok[i] = 1;
         }
       } else if (ZippedSampleExist) {
         UINT8 *buffer;
         if (!load_zipped_file(zsmp_path,zipfn,&buffer,&size)) {
           // save to temp file
           f = fopen(TEMP_FILE, "w+b");
           if (f) {
             fwrite(buffer, 1, size, f);
             fseek(f, 0, SEEK_SET);
             free(buffer);
             strcpy(fn, TEMP_FILE);
             sprintf(mymsg, "Loading %s from %s, size = %ld bytes\n", zipfn, zsmp_path, size);
             goto load1;
           }
         }
       }
     }
   }

   if ((sfx_start)&&(sfx_end)) {
     for (i=sfx_start;i<=sfx_end;i++) {
       sprintf(zipfn,"%s%02x.wav", fn_header, i);
       sprintf(fn, "%s%02x.wav", samples_path, i);
       f = fopen(fn, "rb");
       sample_ok[i] = 0;
       if (f) {
         size = filesize(f);
         sprintf(mymsg, "Loading %s , size = %ld bytes\n", fn, size);
load2:   imessage(mymsg, 47, 46, 0, 0);
         fclose(f);
         if (!(ALoadWaveFile(fn, &Samples[i], 0L))) {
           sample_ok[i] = 1;
         }
       } else if (ZippedSampleExist) {
         UINT8 *buffer;
         if (!load_zipped_file(zsmp_path,zipfn,&buffer,&size)) {
           // save to temp file
           f = fopen(TEMP_FILE, "w+b");
           if (f) {
             fwrite(buffer, 1, size, f);
             fseek(f, 0, SEEK_SET);
             free(buffer);
             strcpy(fn, TEMP_FILE);
             sprintf(mymsg, "Loading %s from %s, size = %ld bytes\n", zipfn, zsmp_path, size);
             goto load2;
           }
         }
       }
     }
   }

   if ((bgm_start)&&(bgm_end)) {
     for (i=bgm_start;i<=bgm_end;i++) {
       sprintf(zipfn,"%s%02x.wav", fn_header, i);
       sprintf(fn, "%s%02x.wav", samples_path, i);
       f = fopen(fn, "rb");
       sample_ok[i] = 0;
       if (f) {
         size = filesize(f);
         sprintf(mymsg, "Loading %s , size = %ld bytes\n", fn, size);
load3:   imessage(mymsg, 47, 46, 0, 0);
         fclose(f);
         if (!(ALoadWaveFile(fn, &Samples[i], 0L))) {
           sample_ok[i] = 1;
         }
       } else if (ZippedSampleExist) {
         UINT8 *buffer;
         if (!load_zipped_file(zsmp_path,zipfn,&buffer,&size)) {
           // save to temp file
           f = fopen(TEMP_FILE, "w+b");
           if (f) {
             fwrite(buffer, 1, size, f);
             fseek(f, 0, SEEK_SET);
             free(buffer);
             strcpy(fn, TEMP_FILE);
             sprintf(mymsg, "Loading %s from %s, size = %ld bytes\n", zipfn, zsmp_path, size);
             goto load3;
           }
         }
       }
     }
   }
   if (exists(TEMP_FILE)) unlink(TEMP_FILE);
   for (idx=0;idx!=256;idx++) if (sample_loop[idx]) LoopSample(Samples[idx]);
}

/* return 0 if succ */
static int InitAudio()
{
  int i;
  char mymsg[256];
  AUDIOCAPS caps;

  if (pf_state) printf("Opening audio device...\n");
  audio_selection();
  if (!sound_card) return -1;
  if (AOpenAudio(&info)) {
     ierror("Audio open error !\n");
     return -1;
  }

  AGetAudioDevCaps(info.nDeviceId,&caps);
  if (pf_state) printf("Using %s at %d-bit %s %u Hz\n",
                       caps.szProductName,
                       info.wFormat & AUDIO_FORMAT_16BITS ? 16 : 8,
                       info.wFormat & AUDIO_FORMAT_STEREO ? "stereo" : "mono",
                       info.nSampleRate);

  if (AOpenVoices(NUMBER_OF_CHANNELS)) {
     ierror("Audio voice open error!\n");
     return -1;
  }
  return 0;
}

