/*************************************************************
*
* eagle.h
*
* eagle header for use with DJGPP
* needs eagle.o to link
*
* Date : 15 March 1998
*
* Eagle Version : 0.20
*
* Includes the MMX version (autodetect)
*
* Please distribute this file with the complete eagle package
* 
**************************************************************/

int eagle_buffer1[2048];
int eagle_buffer2[2048];

extern void eagle_lines(	unsigned long *lb,
				unsigned long *lb2,
				int width,
				int *address,
				int *address2 );

inline void copy_eagle_buffer(	int *eagle_buffer1,
				int *eagle_buffer2,
				int width,
				short dest_seg,
				int address,
				int address2 )
{
	__asm__ __volatile__ ("
	pushw %%es			\n
	movw %%dx, %%es		\n
	cld                     \n
	.align 4                \n

	pushl %%ecx			\n

	rep				\n
	movsl				\n

	popl %%ecx			\n
	movl %%eax,%%edi		\n
	movl %%ebx,%%esi		\n
	
	rep				\n
	movsl				\n

	popw %%ax			\n
	movw %%ax, %%es		\n
	"
	::
	"S" (eagle_buffer1),
	"b" (eagle_buffer2),
	"c" (width),
	"d" (dest_seg),
	"D" (address),
	"a" (address2) :
	"ax", "bx", "cx", "dx", "si", "di", "cc", "memory");
}


void eagle( 	unsigned long *lb,
		unsigned long *lb2,
		short width,
		int destination_segment,
		int screen_address1,
		int screen_address2 )
{

 eagle_lines     (  lb,
		    lb2,
		    width,
		    eagle_buffer1,
		    eagle_buffer2  );

 copy_eagle_buffer ( eagle_buffer1,
		     eagle_buffer2,
		     width/2,
		     destination_segment,
		     screen_address1,
		     screen_address2 );
}
