#include <stdio.h>
#include "starcpu.h"
#include "host.h"
#include "main.h"
#include "shinobi.h"
#include "prototyp.h"

char *ASM_MESSAGE;
UINT32 ASM_ADDRESS,ASM_VALUE,ASM_CPU_PC;

FILE *LOG;
char LOG_ACTIVE=
#ifdef RELEASE
                 0;
#else
                 1;
#endif

void *s16_rpb[0x10000];
void *s16_wpb[0x10000];
void *s16_rpw[0x10000];
void *s16_wpw[0x10000];
void *s16_rpl[0x10000];
void *s16_wpl[0x10000];

extern UINT8 txt_bank,vid_bank,pal_bank,ctr_bank,game;
extern char game_gcs[80];
extern UINT8 pf_state;

UINT8 spr_bank,sta_bank,ex2_bank;
int code_size;

static UINT32 fake_page;
extern UINT8 *base_brq_page;

UINT8 *code, *fakeram;
UINT8 *s16_ptr[0x10000];

void ASM_MESSAGE_1() {
   if (LOG_ACTIVE) fprintf(LOG, "%s (PC:%lx)\n", ASM_MESSAGE, ASM_CPU_PC-(long)code);
}

void ASM_MESSAGE_2() {
   if (LOG_ACTIVE) fprintf(LOG, "%s (PC:%lx,A:%08x)\n", ASM_MESSAGE, ASM_CPU_PC-(long)code, ASM_ADDRESS);
}

void ASM_MESSAGE_3() {
   if (LOG_ACTIVE) fprintf(LOG, "%s (PC:%lx,A:%08x,V:%x)\n", ASM_MESSAGE, ASM_CPU_PC-(long)code, ASM_ADDRESS, ASM_VALUE);
}

void s16_uni() {
   if (LOG_ACTIVE) fprintf(LOG, "UNKNOW OPCODE AT PC:%08x\n", cpu_pc);
   if (LOG_ACTIVE) fprintf(LOG, "EXIT\n");
   NewDebugger();
   if (LOG_ACTIVE) fclose(LOG);
   exit(-1);
}

void fastcpu_init() {
   int i, i2;
   
   /* initial memory setup */
   if ((fakeram = (UINT8 *)malloc(0x10000))==NULL) {
     printf("Out of memory.\n");
     exit(-1);
   }
   memset(fakeram, 0xFF, 0x10000);
   for (i=0;i!=256;i++) {
      s16_ptr[i] = fakeram;
      s16_rpb[i] = s16_rpw[i] = s16_rpl[i] = no_memory_bank_r;
      s16_wpb[i] = no_memory_bank_wb;
      s16_wpw[i] = no_memory_bank_ww; 
      s16_wpl[i] = no_memory_bank_wl;
   }
   
   fake_page = 1;
   base_brq_page = (UINT8 *)&fake_page;

   ExecuteGCS(game_gcs);

   if (LOG_ACTIVE) LOG = fopen("system16.log", "w+");
   /* duplicates memory configuration */
   for (i=1;i<256;i++)
   for (i2=0;i2<256;i2++) {
      s16_ptr[i2+i*256]=s16_ptr[i2];
      s16_rpb[i2+i*256]=s16_rpb[i2];
      s16_rpw[i2+i*256]=s16_rpw[i2];
      s16_rpl[i2+i*256]=s16_rpl[i2];
      s16_wpb[i2+i*256]=s16_wpb[i2];
      s16_wpw[i2+i*256]=s16_wpw[i2];
      s16_wpl[i2+i*256]=s16_wpl[i2];
   }
}

void fastcpu_init2() {
   int i; extern int num_cpus;
   for (i=0; i<num_cpus; i++) {
     if (LOG_ACTIVE) {
       fprintf(LOG, "init cpu%d\n",i);
     }
     context_switch(i);
     cpu_init();
     cpu_reset();
   }
}

void fastcpu() {
   exit(1);
   fastcpu_init();
   cpu_init();
   cpu_reset();
   cpudebug_interactive();
   if (LOG_ACTIVE) fclose(LOG);
}

void save_cpu_content(UINT8 *buf)
{
  memcpy(buf,cpu_r,16*4); buf+=16*4;
  memcpy(buf,&cpu_pc,4); buf+=4;
  memcpy(buf,&cpu_tmpf,4); buf+=4;
  memcpy(buf,&cpu_intmask,4); buf+=4;
  memcpy(buf,&cpu_asp,4); buf+=4;
//  memcpy(buf,&cpu_odometer,4); buf+=4;
}

void load_cpu_content(UINT8 *buf)
{
  memcpy(cpu_r,buf,16*4); buf+=16*4;
  memcpy(&cpu_pc,buf,4); buf+=4;
  memcpy(&cpu_tmpf,buf,4); buf+=4;
  memcpy(&cpu_intmask,buf,4); buf+=4;
  memcpy(&cpu_asp,buf,4); buf+=4;
//  memcpy(&cpu_odometer,buf,4); buf+=4;
}

#define MAX_CPU 16
#define MAX_DEDICATED_BANK 16
typedef struct {
  UINT8 *code_space;
  int code_size;
  int num_dedicated_banks;
  UINT8 dedicated_bank_numbers[MAX_DEDICATED_BANK];
  UINT8 *dedicated_banks[MAX_DEDICATED_BANK];
  UINT8 *save_dedicated_banks[MAX_DEDICATED_BANK];
  UINT8 contents[120];
} CONTEXT;
static CONTEXT cpu_contexts[MAX_CPU];
static int current_cpu=0;
int num_cpus=0;
static UINT8 *common_area_memory=NULL;
static int common_area_length=0;
static UINT32 common_area_address=0;
extern UINT8 s_hangon;

/* switch to cpu#num_cpu, return old cpu# */
int context_switch(int new_cpu)
{
  int old_cpu=current_cpu;
  save_cpu_content(cpu_contexts[old_cpu].contents);
  current_cpu=new_cpu;
  code=cpu_contexts[current_cpu].code_space;
  // copy back common area
  if (common_area_memory) {
    memcpy(common_area_memory,
           &s16_ptr[common_area_address>>16][common_area_address&0xffff],
           common_area_length);
  }
  // swap code space
  {
    int i;
    for (i=0;i<cpu_contexts[current_cpu].code_size;i++)
      s16_ptr[i] = &cpu_contexts[current_cpu].code_space[i * 0x10000];
  }
  // swap dedicated banks
  {
    int i;
    // restore
    for (i=0;i<cpu_contexts[old_cpu].num_dedicated_banks;i++) {
      s16_ptr[cpu_contexts[old_cpu].dedicated_bank_numbers[i]] = cpu_contexts[old_cpu].save_dedicated_banks[i];
    }
    for (i=0;i<cpu_contexts[current_cpu].num_dedicated_banks;i++) {
      cpu_contexts[current_cpu].save_dedicated_banks[i] = s16_ptr[cpu_contexts[current_cpu].dedicated_bank_numbers[i]];
      s16_ptr[cpu_contexts[current_cpu].dedicated_bank_numbers[i]] = cpu_contexts[current_cpu].dedicated_banks[i];
    }
  }
  // copy common area to destination
  if (common_area_memory) {
    memcpy(&s16_ptr[common_area_address>>16][common_area_address&0xffff],
           common_area_memory,
           common_area_length);
  }
  // special for super hang-on
  if (s_hangon) {
    if (new_cpu==0) memcpy(&s16_ptr[0xc4][0],&s16_ptr[0x7f][0xfc00],0x400);
    else memcpy(&s16_ptr[0x7f][0xfc00],&s16_ptr[0xc4][0],0x400);
  }
  
  // special Z80/68000 communication method 4
  {
    extern UINT8 z80com;
    extern UINT8 *z80com_z80_addr;
    extern UINT8 *z80com_68k_addr;
    extern UINT8 z80com_len;
    if (z80com==4 && new_cpu==0) {
      memcpy(z80com_z80_addr, z80com_68k_addr, z80com_len);
    }
  }

  load_cpu_content(cpu_contexts[current_cpu].contents);

  return old_cpu;
}

/* return cpu#(starts from 0). return -1 if failed */
int add_cpu(UINT8 *code_space, int code_size)
{
  if (num_cpus<MAX_CPU) {
    cpu_contexts[num_cpus].code_space=code_space;
    cpu_contexts[num_cpus].code_size=code_size;
    cpu_contexts[num_cpus].num_dedicated_banks=0;
    return num_cpus++;
  } else return -1;
}

/* return -1 if failed */
int add_dedicated_bank(int cpu, int bank)
{
   int n = cpu_contexts[cpu].num_dedicated_banks;
   if (n<MAX_DEDICATED_BANK-1) {
     cpu_contexts[cpu].num_dedicated_banks++;
     cpu_contexts[cpu].dedicated_bank_numbers[n] = bank;
     cpu_contexts[cpu].dedicated_banks[n] = s16_ptr[bank];
     return 0;
   } else return -1;
}

UINT8 mask_int_cnt=0;
void reset_external_device()
{
   if (current_cpu==0) /* reset slave cpu's */
   {
     int i; extern int num_cpus;
     int old_cpu;
     for (i=1; i<num_cpus; i++) {
       if (LOG_ACTIVE) {
         fprintf(LOG, "reset cpu%d\n",i);
       }
       old_cpu=context_switch(i);
       cpu_reset();
       context_switch(old_cpu);
     }
     mask_int_cnt = 6; /* mask video int of cpu#0 for 100 ms */
   }
}

void set_common_area(UINT32 address, int length)
{
  common_area_memory=(UINT8 *)malloc(length);
  if (common_area_memory==NULL) {
    if (pf_state) printf("Out of memory.\n");
    exit(-1);
  }
  memset(common_area_memory,0xff,length);
  common_area_length=length;
  common_area_address=address;
}

