/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */
#include <allegro.h>
#include <math.h>
#include "host.h"
#include "main.h"
#include "shinobi.h"

int total_palette=0, total_new_colors=0, total_palette_reset=0;
UINT8 reset_palette=0;
extern UINT8 pal_bank;
extern UINT8 sync;

UINT8 Palette256[65536];        /* global reverse palette */
UINT32 NewColorsTab[4096];
UINT16 FastPalette[16];         /* old general-purpose palette cache */
UINT16 FastPaletteData[128];    /* palette cache for BG's */
UINT8 FastPaletteSet[8*128];    /* 128 8-color palettes = 1024 colors */
UINT16 FastPaletteData2[128];   /* palette cache for sprites */
UINT8 FastPaletteSet2[16*128];  /* 128 16-color palettes = 2048 colors */

struct {
  UINT8 prev,next;
  UINT16 color;
} pal_data[256];
UINT8 pal_free_head;

extern UINT8 *s16_ptr[0x100];

UINT8 *base_palette256;
UINT8 *base_palette_shinobi, *base_palette_sprite;

int number_of_new_colors;
int color_addition=0;

#define STEPS 64
static UINT8 gamma_value[STEPS];

#define GAMMA_CORRECTION(c) ( gamma_value[(c)] )
//#define GAMMA_CORRECTION(c) ( (c) )

// gamma 1.0 = no gamma
static void build_gamma_array(double initial_gamma)
{
  int i;
  double t;
  for (i=0; i<STEPS; i++) {
    if (i==0) t = 0;
    else t = pow(i*1.0/(STEPS-1), initial_gamma) * (STEPS-1);
    gamma_value[i] = (t-(int)t)>=0.5 ?(int)t+1 :(int)t;
    if (gamma_value[i] > STEPS-1) gamma_value[i] = STEPS-1;
//    printf("%d : %6.2lf (%d)\n", i, t, gamma_value[i]);
  }
}

void Reset_Palette()
{
   RGB pal; int i;
   memset(Palette256,0,sizeof(Palette256));
   memset(pal_data, 0, sizeof(pal_data));
   pal.r=pal.g=pal.b=0;
   for (i=0; i<=255; i++) set_color(i, (RGB *)&pal);
   Palette256[0x0000]=1;
   pal.r=pal.g=pal.b=63;
   set_color(255, (RGB *)&pal);
   Palette256[0xffff]=255;
   pal_free_head=2;
}

void Update_Palette() {
   int i;
   RGB pal[256];
   
   #ifndef NO_PALETTE
   if (number_of_new_colors > 253) number_of_new_colors = 253;
   for (i=0; i<number_of_new_colors; i++) {
      extern UINT8 s16_dac_type;
      UINT8 a=(NewColorsTab[i]&0x00F00000)>>20;
      pal[i].r=(NewColorsTab[i]&0x0F000000)>>22;
      pal[i].g=(NewColorsTab[i]&0xF0000000)>>26;
      pal[i].b=(NewColorsTab[i]&0x000F0000)>>14;

      switch (s16_dac_type) {
      case 0:
        if (a&1) pal[i].r+=2;
        if (a&2) pal[i].g+=2;
        if (a&8) pal[i].g+=1;
        if (a&4) pal[i].b+=2;
        break;
      case 1: // SHINOBI
        if (a&1) pal[i].r+=2;
        if (a&4) pal[i].g+=2;
        if (a&8) pal[i].g+=1;
        if (a&2) pal[i].b+=2;
        break;
      }
      pal[i].r=GAMMA_CORRECTION(pal[i].r);
      pal[i].g=GAMMA_CORRECTION(pal[i].g);
      pal[i].b=GAMMA_CORRECTION(pal[i].b);
   }
   if (!sync) {
     video_sync(0);
   }
   for (i=0;i!=number_of_new_colors;i++) {
     _set_color((NewColorsTab[i]&0x000000FF), (RGB *)&pal[i]);
   }

   #endif
   total_palette++;
   total_new_colors+=number_of_new_colors;
   if (reset_palette) {
      Reset_Palette();
      reset_palette=0;
      total_palette_reset++;
   }
   number_of_new_colors = 0;
}

void Create_Palette() {
   int i;
   extern UINT16 tile_palette_offset,sprite_palette_offset;
   extern double initial_gamma;
   
   base_palette256=&Palette256[0];

   base_palette_shinobi = s16_ptr[pal_bank] + tile_palette_offset;
   base_palette_sprite = s16_ptr[pal_bank] + sprite_palette_offset;

   build_gamma_array(initial_gamma);
   for (i=0; i<64; i++) {
     gamma_value[i] += color_addition;
     if (gamma_value[i] > 63) gamma_value[i]=63;
   }

   Reset_Palette();
}

int _white_color(void)
{
  return (Palette256[0xffff]);
}

void init_palette_freelist(void)
{
  int i;
  for (i=2; i<=254; i++) {
    pal_data[i].prev=i-1;
    pal_data[i].next=i+1;
  }
  // make a ring
  pal_data[2].prev=254;
  pal_data[254].next=2;

  // invalidate palette cache
  memset(FastPaletteData,0xff,sizeof(FastPaletteData));
  memset(FastPaletteData2,0xff,sizeof(FastPaletteData2));

}

