#ifndef ADPCM_H
#define ADPCM_H

#define MAX_ADPCM 2

/* NOTE: Actual sample data is specified in the sound_prom parameter of the game driver, but 
   since the MAME code expects this to be an array of char *'s, we do a small kludge here */

struct ADPCMsample
{
	int num;       /* trigger number (-1 to mark the end) */
	int region;    /* ROM region number */
	int offset;    /* offset in that region */
	int length;    /* length of the sample */
	int rate;      /* sample rate */
};

#define ADPCM_SAMPLES_START(name) struct ADPCMsample name[] = {
#define ADPCM_SAMPLE(n,r,o,l,a) { (n), (r), (o), (l), (a) },
#define ADPCM_SAMPLES_END { 0, 0, 0, 0, 0 } };



struct ADPCMinterface
{
	int num;			       /* total number of ADPCM decoders in the machine */
	int volume[MAX_ADPCM];     /* master volume */
};

int ADPCM_sh_start (struct ADPCMinterface *interface);
void ADPCM_sh_stop (void);
void ADPCM_sh_update (void);

void ADPCM_trigger (int num, int which);

#endif
