;	output generated by as2nasm (c) 1998 by Bartman/Abyss
;	source: ASM.S
;	/*
;	* SYSTEM 16 ARCADE EMULATOR SOURCE CODE
;	* 
;	* Copyright 1996/97 Thierry Lescot
;	* Modified by Nao '97
;	*/


	bits	32

;.set	BG_DEBUG, OK

	section	.data
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
SPR_BASE:	dd 0
SCR_BASE:	dd 0
SPR_WIDTH:	dd 0
SPR_WIDTHD:	dd 0
SPR_HEIGHT:	db 0
SPR_OFFSET:	db 0
SPR_MODE:	dw 0
SPR_COLOR:	dd 0

;.globl	_SPR_ZOOMX_LIMIT
;_SPR_ZOOMX_LIMIT:	.long 2060
;.globl	_SPR_ZOOMY_LIMIT
;_SPR_ZOOMY_LIMIT:	.long 1060

SPR_ZOOM:	dd 0
SPR_ZOOMX0:	dd 0
SPR_ZOOMY0:	dd 0
SPR_ZOOMX:	dd 0
SPR_ZOOMY:	dd 0

LAST_DOT:	dd 0

END_OF_SPRITE:	dw 0
SPR_REVERSE_FLAG:	db 0
SPR_FLIP_FLAG:	db 0

CPT_LINE:	dw 0
CPT_COLUMN:	dd 0
VIDEO_BASE_SAVE:	dd 0
DISPLAY_BASE_SAVE:	dd 0
DISPLAY_BASE:	dd 0
BASE_COULEUR_BRIQUE:	dd 0
BASE_SCR_HOR_SPLITTAB:	dd 0
BASE_SCR_VER_SPLITTAB:	dd 0
BG_DRAW_TILE_FORE:	dd 0
BG_DRAW_TILE_BACK:	dd 0
BG_DRAW_TILE:           dd 0
BG_SPLIT_MODE:	db 0
BG_FORE_FLAG:	db 0
BG_CLEAR_FLAG:	db 0
BG_LINE_COUNTER:	db 0
BG_PAGEADDR:	dd 0
		dd 0
		dd 0
		dd 0
BG_VER:	dd 0
BG_HOR:	dd 0
BG_SX:	dd 0
BG_TILE_BANK_0:	dd 0
BG_TILE_BANK_1:	dd 0
BG_SY_OFFSET:	dd 0
BG_PRIORITY:	dw 0
BG_YOFFSET:	db 0

SPR_ACTIVE:	db 1

LAST_BANK:	dd 0

GR_FASTPAL:	dd 0
	dd	0
GR_MASK:	dw 0
GR_SECOND_ROAD_ON:	dw 0
GR_PALETTE_DEFAULT:	dd 0
GR_BITMAP:	dd 0
GR_PALETTE:	dd 0
GR_CONTROL_AREA:	dd 0
GR_CONTROL_AREA_HOR:	dd 0
GR_CONTROL_AREA_PAL:	dd 0
GR_CONTROL_AREA_FLIP:	dd 0
GR_FLIPINDEX:	dd 0

fake_hor_bg:	dw 0
fake_hor_fg:	dw 0
fake_splittab0:	dd 0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
fake_splittab1:	dd 0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0
	dd	0

	section	.text 
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
	global	 _rotate_screen
_rotate_screen:	
	pushad
	mov	ebx,dword[_display_base]
	mov	edi,dword[_vdisplay_base]
	mov	esi,-224
	add	ebx,319+5
L88:	
	lea	ebp,[224+esi+edi]
        mov     ecx,80
L92:	
        mov     eax,dword[ebx]
        mov     byte[448+ebp],ah
	mov	byte[672+ebp],al
        shr     eax,16
        sub     ebx,4
        mov     byte[ebp],ah
        mov     byte[224+ebp],al
        add     ebp,896
        loop    L92

        add     ebx,1344
	inc	esi
        jnz     L88
	popad
	ret

        global   _rotate_screen2
_rotate_screen2:
	pushad
	mov	ebx,dword[_display_base]
	mov	edi,dword[_vdisplay_base]
        mov     esi,224
        add     ebx,8
L881:
        lea     ebp,[-1+esi+edi]
        mov     ecx,80
L921:
        mov     eax,dword[ebx]
        mov     byte[ebp],al
        mov     byte[ebp+224],ah
        shr     eax,16
        add     ebp,224*2
        add     ebx,4
        mov     byte[ebp],al
        mov     byte[ebp+224],ah
        add     ebp,224*2
        loop    L921

        add     ebx,1024-320
        dec     esi
        jnz     L881
	popad
        ret

	times	($$-$) & 3 nop
	global	 _asm_render_screen
_asm_render_screen:	
	pushad

	mov	dword[BG_DRAW_TILE_BACK],draw_tile_back
	mov	dword[BG_DRAW_TILE_FORE],draw_tile_fore
	cmp	byte[_pentium_pro_cpu],0
        jne     __pentium_pro
	mov	dword[BG_DRAW_TILE_BACK],draw_tile_back_for_p5
	mov	dword[BG_DRAW_TILE_FORE],draw_tile_fore_for_p5
__pentium_pro:	

;	build tile bank selectors
	mov	eax,dword[_base_brq_page]
	movzx	ecx,byte[eax]
	mov	eax,ecx
	and	ecx,0x0f
	and	eax,0xf0
	shl	ecx,12
	shl	eax,8
	mov	dword[BG_TILE_BANK_1],ecx
        mov     dword[BG_TILE_BANK_0],eax

;	??
	mov	edi,dword[_bank_ff_base]
	mov	edx,0x0000F01E
	mov	al,byte[edi+edx]
	mov	byte[SPR_ACTIVE],al

	mov	dword[_number_of_new_colors],0
;	       call    _clear_framebuf
	cmp	byte[_game],0
        je      near _render_sega3d
	cmp	byte[_game],20
        je      near _render_sega3dv2

	cmp	byte[_game],6
        jae     near _render_sys18

;	BG
	test	byte[_background_active],1
        jz      __no_bg
	test	byte[_bg_layer],02
        jz      __no_bg
        mov     eax,0x01ffff00
	mov	ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword[_base_scr_hor_bg]
	call	_asm_render_bg
__no_bg:	

;	SPR 00
	cmp	byte[SPR_ACTIVE],0xFF
        je      __no_spr00
	mov	word[SPR_MODE],0x00
	call	_asm_render_sprites
__no_spr00:	
;	SPR 01
	cmp	byte[SPR_ACTIVE],0xFF
        je      __no_spr01
	mov	byte[SPR_MODE],0x40
	call	_asm_render_sprites
__no_spr01:

;       BG HI
        test    byte[_bg_layer],0x10
        jz      __no_bghi
        mov     eax,0x00ffff80
        push    dword[_tiles_base]
        mov     ebx,dword[_tiles_hi]
        mov     dword[_tiles_base],ebx
        mov     ebx,dword[_base_scr_pag_bg]
        mov     ecx,dword[_base_scr_ver_bg]
        mov     edx,dword[_base_scr_hor_bg]
	call	_asm_render_bg
        pop     dword[_tiles_base]
__no_bghi:

;	FG N
	test	byte[_bg_layer],0x01
        jz      __no_fgn
        mov     eax,0x00ff0000
	mov	ah,byte[_fg_priority]
        dec     ah
	mov	ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	call	_asm_render_bg
__no_fgn:	

;	SPR 10
	cmp	byte[SPR_ACTIVE],0xFF
        je      __no_spr10
	mov	byte[SPR_MODE],0x80
	call	_asm_render_sprites
__no_spr10:	

;	FG P
	test	byte[_bg_layer],0x01
        jz      __no_fgp
        mov     eax,0x00ffff00
        mov     al,byte[_fg_priority]
        mov     ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	call	_asm_render_bg
__no_fgp:	

;       TEXT N
        mov     ax,0x7f00
        call    _asm_render_text

;       SPR 11
        cmp     byte[SPR_ACTIVE],0xFF
        je      __no_spr11
        mov     byte[SPR_MODE],0xc0
        call    _asm_render_sprites
__no_spr11:     

;       TEXT P
        mov     ax,0xff80
	call	_asm_render_text


	jmp	_fin_render

;	/////////////////////////////////////
_render_sega3d:	

;	build fake split table from _gr_control:0~1ff
	mov	edx,dword[_base_scr_hor_bg]
	mov	cx,word[edx]
	shl	ecx,16
	mov	edx,dword[_base_scr_hor_fg]
	mov	cx,word[edx]
;	ecx=(hor_bg:hor_fg)

	mov	byte[CPT_LINE],32
	mov	ebx,dword[_gr_control]
	mov	esi,fake_splittab0
	mov	edi,fake_splittab1

___build_fakesplittab:	
	mov	eax,ecx
	test	byte[ebx],0x4
        jz      ___gr_no_priority

;	       movl    $0x00800080,%eax

___gr_no_priority:	
	mov	word[esi],ax
	shr	eax,16
	mov	word[edi],ax

	add	esi,2
	add	edi,2
	add	ebx,0x10
	dec	byte[CPT_LINE]
        jnz     ___build_fakesplittab

	mov	word[fake_hor_fg],0x0080
	mov	word[fake_hor_bg],0x0080

;	       call    _clear_framebuf

;	GR N
	test	byte[_background_active],1
        jz      ___no_grn
	test	byte[_bg_layer],0x40
        jz      ___no_grn

	mov	al,0x0
	mov	ebx,dword _gr_control
	mov	ecx,dword[_gr_palette]
	mov	edx,dword[_gr_palette_default]
	mov	esi,dword[_gr_bitmap]
	mov	edi,dword _gr_color_flipindex
	call	render_gr

___no_grn:	

;	BG
	test	byte[_background_active],1
        jz      ___no_bg
	test	byte[_bg_layer],02
        jz      ___no_bg

        mov     eax,0x0000ff00
	mov	ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword fake_hor_bg
	mov	esi,dword fake_splittab1
	call	_asm_render_bg
___no_bg:	


;	FG
	test	byte[_bg_layer],0x01
        jz      ___no_fg
        mov     eax,0x0000ff00
	mov	ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	mov	edx,fake_hor_fg
	mov	esi,fake_splittab0
	call	_asm_render_bg
___no_fg:	

;	GR P
	test	byte[_background_active],1
        jz      ___no_grp
	test	byte[_bg_layer],0x40
        jz      ___no_grp

	mov	al,0x4
	mov	ebx,dword _gr_control
	mov	ecx,dword[_gr_palette]
	mov	edx,dword[_gr_palette_default]
	mov	esi,dword[_gr_bitmap]
	mov	edi,dword _gr_color_flipindex
	call	render_gr

___no_grp:	

;	SPR 00
	cmp	byte[SPR_ACTIVE],0xFF
        je      ___no_spr00
	mov	word[SPR_MODE],0x00
	call	_asm_render_sprites
___no_spr00:	

;	SPR 01
	cmp	byte[SPR_ACTIVE],0xFF
        je      ___no_spr01
	mov	byte[SPR_MODE],0x40
	call	_asm_render_sprites
___no_spr01:	

;	SPR 10
	cmp	byte[SPR_ACTIVE],0xFF
        je      ___no_spr10
	mov	byte[SPR_MODE],0x80
	call	_asm_render_sprites
___no_spr10:	

;	SPR 11
	cmp	byte[SPR_ACTIVE],0xFF
        je      ___no_spr11
	mov	byte[SPR_MODE],0xc0
	call	_asm_render_sprites
___no_spr11:	

;	TEXT
	mov	ax,0xff00
	call	_asm_render_text

	jmp	_fin_render





;	/////////////////////////////////////
_render_sega3dv2:	

;	build fake split table from _gr_control:0~1ff
	mov	edx,dword[_base_scr_hor_bg]
	mov	cx,word[edx]
	shl	ecx,16
	mov	edx,dword[_base_scr_hor_fg]
	mov	cx,word[edx]
;	ecx=(hor_bg:hor_fg)

	mov	byte[CPT_LINE],32
	mov	ebx,dword[_gr_control]
	mov	esi,dword fake_splittab0
	mov	edi,dword fake_splittab1

___3dv2build_fakesplittab:	
	mov	eax,ecx
	test	byte[ebx],0x8
        jnz     ___3dv2gr_no_priority

	mov	eax,0x00800080

___3dv2gr_no_priority:	
	mov	word[esi],ax
	shr	eax,16
	mov	word[edi],ax

	add	esi,2
	add	edi,2
	add	ebx,0x10
	dec	byte[CPT_LINE]
        jnz     ___3dv2build_fakesplittab

	mov	word[fake_hor_fg],0x0080
	mov	word[fake_hor_bg],0x0080

;	       call    _clear_framebuf

;	GR N
	test	byte[_background_active],1
        jz      ___3dv2no_grn
	test	byte[_bg_layer],0x40
        jz      ___3dv2no_grn

	mov	al,0x8
	mov	ebx,dword[_second_road_on]
	mov	ah,byte[ebx]
	mov	ebx,dword _gr_control
	mov	ecx,dword[_gr_palette]
	mov	edx,dword[_gr_palette_default]
	mov	esi,dword[_gr_bitmap]
	mov	edi,dword _gr_color_flipindex
	call	render_grv2

___3dv2no_grn:	

;	BG
	test	byte[_background_active],1
        jz      ___3dv2no_bg
	test	byte[_bg_layer],02
        jz      ___3dv2no_bg

        mov     eax,0x0000ff00
	mov	ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword fake_hor_bg
	mov	esi,dword fake_splittab1
	call	_asm_render_bg
___3dv2no_bg:	


;	FG
	test	byte[_bg_layer],0x01
        jz      ___3dv2no_fg
        mov     eax,0x0000ff00
	mov	ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	mov	edx,dword fake_hor_fg
	mov	esi,dword fake_splittab0
	call	_asm_render_bg
___3dv2no_fg:	

;	GR P
	test	byte[_background_active],1
        jz      ___3dv2no_grp
	test	byte[_bg_layer],0x40
        jz      ___3dv2no_grp

	mov	al,0x0
	mov	ebx,dword[_second_road_on]
	mov	ah,byte[ebx]
	mov	ebx,dword _gr_control
	mov	ecx,dword[_gr_palette]
	mov	edx,dword[_gr_palette_default]
	mov	esi,dword[_gr_bitmap]
	mov	edi,dword _gr_color_flipindex
	call	render_grv2

___3dv2no_grp:	

;	SPR
	cmp	byte[SPR_ACTIVE],0xFF
        je      ___3dv2no_spr
;	       movb    $0xc0,SPR_MODE
	call	_3dv2_asm_render_sprites
___3dv2no_spr:	

;	TEXT
	mov	ax,0xff00
	call	_asm_render_text

	jmp	_fin_render






;	//////////////////////////////////////////
_render_sys18:	
;	SWAP tile bank selectors
	test	byte[_bg_layer],0x0c
        jz      _no_swap_bank_selectors
	mov	eax,dword[BG_TILE_BANK_1]
	mov	ecx,dword[BG_TILE_BANK_0]
	mov	dword[BG_TILE_BANK_0],eax
	mov	dword[BG_TILE_BANK_1],ecx
_no_swap_bank_selectors:	

;	BG3
	test	byte[_background_active],1
        jz      _no_bg3
	test	byte[_bg_layer],0x8
        jz      _no_bg3
        mov     eax,0x0180ff00
	mov	ebx,dword[_base_scr_pag_bg3]
	mov	ecx,dword[_base_scr_ver_bg3]
	mov	edx,dword[_base_scr_hor_bg3]
	mov	si,word[-1+ebx]
	or	si,word[ecx]
	or	si,word[edx]
        or      si,si
        jz      _no_bg3
	mov	esi,dword[_base_scr_hor_bg_splittab1]
	mov	edi,dword[_base_scr_ver_bg_splittab1]
	call	_asm_render_bg
_no_bg3:	

;	BG1 N
	test	byte[_background_active],1
        jz      _no_bg1n
	test	byte[_bg_layer],02
        jz      _no_bg1n
        mov     eax,0x01000000
	mov	ah,byte[_bg_priority]
	dec	ah

	mov	ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword[_base_scr_hor_bg]
	mov	esi,dword[_base_scr_hor_bg_splittab1]
	mov	edi,dword[_base_scr_ver_bg_splittab1]
	call	_asm_render_bg
_no_bg1n:	

;	SPR 00
	cmp	byte[SPR_ACTIVE],0xFF
        je      _no_spr00
	mov	word[SPR_MODE],0x00
	call	_asm_render_sprites
_no_spr00:	



;	BG1 P
	test	byte[_background_active],1
        jz      _no_bg1p
	test	byte[_bg_layer],02
        jz      _no_bg1p
        mov     eax,0x00007f00
        mov     al,byte[_bg_priority]

	mov	ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword[_base_scr_hor_bg]
	mov	esi,dword[_base_scr_hor_bg_splittab1]
	mov	edi,dword[_base_scr_ver_bg_splittab1]
	call	_asm_render_bg
_no_bg1p:	

;	SPR 01
	cmp	byte[SPR_ACTIVE],0xFF
        je      _no_spr01
	mov	byte[SPR_MODE],0x40
	call	_asm_render_sprites
_no_spr01:	

;	BG1 sP
	test	byte[_background_active],1
        jz      _no_bg1sp
	test	byte[_bg_layer],02
        jz      _no_bg1sp

        mov     eax,0x0000ff80
        mov     ebx,dword[_base_scr_pag_bg]
	mov	ecx,dword[_base_scr_ver_bg]
	mov	edx,dword[_base_scr_hor_bg]
	mov	esi,dword[_base_scr_hor_bg_splittab1]
	mov	edi,dword[_base_scr_ver_bg_splittab1]
	call	_asm_render_bg
_no_bg1sp:	


;       BG2 N
	test	byte[_background_active],1
        jz      _no_bg2
	test	byte[_bg_layer],04
        jz      _no_bg2
        mov     eax,0x0080ff00
        mov     ah,byte[_fg_priority]
        dec     ah
        mov     ebx,dword[_base_scr_pag_bg2]
	mov	ecx,dword[_base_scr_ver_bg2]
	mov	edx,dword[_base_scr_hor_bg2]
	xor	esi,esi
	mov	si,word[-1+ebx]
	or	si,word[ecx]
	or	si,word[edx]
	or	esi,esi
        jz      _no_bg2
	mov	esi,dword[_base_scr_hor_bg_splittab0]
	mov	edi,dword[_base_scr_ver_bg_splittab0]
	call	_asm_render_bg
_no_bg2:	


;	FG N
	test	byte[_bg_layer],0x01
        jz      _no_fgn
        xor     eax,eax
	mov	ah,byte[_fg_priority]
	dec	ah

	mov	ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	mov	esi,dword[_base_scr_hor_bg_splittab0]
	mov	edi,dword[_base_scr_ver_bg_splittab0]
	call	_asm_render_bg
_no_fgn:	

;	SPR 10
	cmp	byte[SPR_ACTIVE],0xFF
        je      _no_spr10
	mov	byte[SPR_MODE],0x80
	call	_asm_render_sprites
_no_spr10:	

;       BG2 P
	test	byte[_background_active],1
        jz      _no_bg2p
	test	byte[_bg_layer],04
        jz      _no_bg2p

        mov     eax,0x0080ff80
        mov     al,byte[_fg_priority]
        mov     ebx,dword[_base_scr_pag_bg2]
	mov	ecx,dword[_base_scr_ver_bg2]
	mov	edx,dword[_base_scr_hor_bg2]
	xor	esi,esi
	mov	si,word[-1+ebx]
	or	si,word[ecx]
	or	si,word[edx]
	or	esi,esi
        jz      _no_bg2p
	mov	esi,dword[_base_scr_hor_bg_splittab0]
	mov	edi,dword[_base_scr_ver_bg_splittab0]
	call	_asm_render_bg
_no_bg2p:


;	FG P
	test	byte[_bg_layer],0x01
        jz      _no_fgp

        mov     eax,0x0000ff00
        mov     al,byte[_fg_priority]
        mov     ebx,dword[_base_scr_pag_fg]
	mov	ecx,dword[_base_scr_ver_fg]
	mov	edx,dword[_base_scr_hor_fg]
	mov	esi,dword[_base_scr_hor_bg_splittab0]
	mov	edi,dword[_base_scr_ver_bg_splittab0]
	call	_asm_render_bg
_no_fgp:	

;	TEXT N
	test	byte[_bg_layer],0x80
        jz      _no_textn
	mov	ax,0x1f00
	call	_asm_render_text
_no_textn:	

;	SPR 11
	cmp	byte[SPR_ACTIVE],0xFF
        je      _no_spr11
	mov	byte[SPR_MODE],0xc0
	call	_asm_render_sprites
_no_spr11:	

;	TEXT P
	test	byte[_bg_layer],0x80
        jz      _no_textp
	mov	ax,0xff20
	call	_asm_render_text
_no_textp:	

;	/////////////////////////////////////////////

_fin_render:	
	popad
	ret


	global	 render_gr
;	%al=mask, %ebx=control_area %ecx=palette %edx=def_pal %esi=bitmap %edi=flipindex
render_gr:	
	mov	byte[GR_MASK],al
	mov	dword[GR_BITMAP],esi
	mov	dword[GR_PALETTE],ecx
	mov	eax,dword[ebx]
	mov	dword[GR_CONTROL_AREA],eax
	mov	eax,dword[4+ebx]
	mov	dword[GR_CONTROL_AREA_HOR],eax
	mov	eax,dword[8+ebx]
	mov	dword[GR_CONTROL_AREA_PAL],eax
	mov	eax,dword[12+ebx]
	mov	dword[GR_CONTROL_AREA_FLIP],eax
	mov	dword[GR_PALETTE_DEFAULT],edx
	mov	dword[GR_FLIPINDEX],edi

	mov	edi,dword[_display_base]
	mov	dword[DISPLAY_BASE],edi
	mov	ebx,dword[GR_CONTROL_AREA]
	mov	byte[CPT_LINE],224

render_gr_line:	
	mov	edi,dword[DISPLAY_BASE]
	mov	dx,word[ebx]
	mov	cl,dl
	and	cl,0x4
	cmp	cl,byte[GR_MASK]
        jne     near render_gr_nextline

	ror	dx,8

	mov	ecx,edx
	and	ecx,0xff
	shl	ecx,1
	add	ecx,dword[GR_CONTROL_AREA_PAL]
	movzx	eax,byte[ecx]
	shl	eax,1
	add	eax,dword[GR_PALETTE]
	movzx	ecx,word[eax]

render_gr_color_ok:	
;	cx=sky color (color0)
	push	edx
	push	ebx
	mov	ebp,dword GR_FASTPAL
	mov	eax,0
	call	alloc_color
	pop	ebx
	pop	edx

	test	dh,1
        jnz     _gr_hangon
	test	dh,2
        jz      render_gr_bitmap
        jmp     short render_gr_fillline
_gr_hangon:	
	test	dh,4
        jnz     render_gr_bitmap

render_gr_fillline:	
;	fill whole scanline with color0
	mov	al,byte[GR_FASTPAL]
	mov	ah,al
	mov	cx,ax
	shl	eax,16
	mov	ax,cx

	mov	ecx,82
render_gr_fill:	
	mov	dword[edi],eax
	add	edi,4
	dec	ecx
        jnz     render_gr_fill
	jmp	render_gr_nextline

;	general case:copy whole line from source bitmap
render_gr_bitmap:	
	and	edx,0x0ff
	mov	eax,dword[GR_CONTROL_AREA_FLIP]
	movzx	eax,word[eax+(edx*2)]
;	ax=color flip data

	push	ebx
	push	edx

	and	eax,0x0800
	shr	eax,9
	mov	ecx,dword[GR_FLIPINDEX]
	mov	edx,dword[ecx+eax]

;	allocate ground color
	push	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,24
	movzx	ecx,word[eax+edx]
	mov	eax,1
	call	alloc_color

	pop	edx
	push	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,16
	and	edx,0xff
	movzx	ecx,word[eax+edx]
	mov	eax,2
	call	alloc_color

	pop	edx
	push	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,8
	and	edx,0xff
	movzx	ecx,word[eax+edx]
	mov	eax,3
	call	alloc_color

	pop	edx
	mov	eax,dword[GR_PALETTE_DEFAULT]
	and	edx,0xff
	movzx	ecx,word[eax+edx]
	mov	eax,4
	call	alloc_color

	pop	edx
	pop	ebx

	mov	eax,dword[GR_CONTROL_AREA_HOR]
	movzx	eax,word[eax+(edx*2)]
	ror	ax,8

	mov	cl,byte[_gr_bitmap_width]
	shl	edx,cl

	test	ah,0xf0
        jnz     render_gr_reverse
	add	eax,0x200
	and	eax,0x3ff
        jmp     short render_gr_xoffset_ok
render_gr_reverse:	
	and	eax,0x7ff
	xor	eax,0x07
	neg	eax
	add	eax,0x9f8
	and	eax,0x3ff

render_gr_xoffset_ok:	
	add	edx,eax
	add	edx,esi
	add	edx,18

	mov	ecx,328

render_gr_dot:	

	movzx	eax,byte[edx]
	mov	al,byte[GR_FASTPAL+eax]
	inc	edx
	mov	byte[edi],al
	inc	edi
	dec	ecx
        jnz     render_gr_dot

render_gr_nextline:	
	add	ebx,2
	add	dword[DISPLAY_BASE],1024
	dec	byte[CPT_LINE]
	jnz	near render_gr_line

	ret




	global	 render_grv2
;	%al=mask, %ah=second_road_on
;	%ebx=control_area %ecx=palette %edx=def_pal %esi=bitmap %edi=flipindex
render_grv2:	
	mov	byte[GR_MASK],al
	mov	byte[GR_SECOND_ROAD_ON],ah

	mov	dword[GR_BITMAP],esi
	mov	dword[GR_PALETTE],ecx
	mov	eax,dword[ebx]
	mov	dword[GR_CONTROL_AREA],eax
	mov	eax,dword[4+ebx]
	mov	dword[GR_CONTROL_AREA_HOR],eax
	mov	eax,dword[8+ebx]
	mov	dword[GR_CONTROL_AREA_PAL],eax
	mov	eax,dword[12+ebx]
	mov	dword[GR_CONTROL_AREA_FLIP],eax
	mov	dword[GR_PALETTE_DEFAULT],edx
	mov	dword[GR_FLIPINDEX],edi

	mov	edi,dword[_display_base]
	mov	dword[DISPLAY_BASE],edi
	mov	ebx,dword[GR_CONTROL_AREA]
	mov	byte[CPT_LINE],224
	mov	ebp,GR_FASTPAL

render_grv2_line:	
	mov	edi,dword[DISPLAY_BASE]
	movzx	edx,word[ebx]
	mov	cl,dl
	and	cl,0x8
	cmp	cl,byte[GR_MASK]
	jne	near render_grv2_nextline

	shl	edx,16
	bswap	edx
	cmp	cl,0x8
	jne	near render_grv2_ground

	mov	eax,edx
	and	eax,0x3f
	add	eax,eax
	add	eax,dword[GR_PALETTE]
	movzx	ecx,word[eax]

render_grv2_sky:	
;	cx=sky color (color0)
	push	edx
	push	ebx
	mov	eax,0
	call	alloc_color
	pop	ebx
	pop	edx

render_grv2_fillline:	
;	fill whole scanline with color0
	movzx	ecx,byte[GR_FASTPAL]
	mov	eax,ecx
	shl	eax,8
	or	ecx,eax
	mov	eax,ecx
	shl	ecx,16
	or	eax,ecx

;	       xorl    %eax,%eax
;	       movb    GR_FASTPAL,%al
;	       movb    %al,%ah
;	       movl    %eax,%ecx
;	       shll    $16,%eax
;	       orl     %ecx,%eax

	mov	ecx,82
render_grv2_fill:	
	mov	dword[edi],eax
	add	edi,4
	dec	ecx
        jnz     render_grv2_fill
	jmp	render_grv2_nextline


;	general case:copy whole line from source bitmap
render_grv2_ground:	
	and	edx,0x1ff

	mov	eax,dword[GR_CONTROL_AREA_FLIP]
	mov	ax,word[eax+edx*2]

;	ax=color flip data

	push	ebx
	push	edx

;	allocate ground colors(0=ground 1~3=road)

	push	eax
	and	eax,0x1f
	mov	edx,dword[GR_PALETTE_DEFAULT]
	movzx	ecx,word[0x40+edx+eax*2]
	mov	eax,0
	and	ecx,0xffff
	call	alloc_color
	pop	eax

	and	eax,0x0800
	shr	eax,9
	mov	ecx,dword[GR_FLIPINDEX]
	mov	edx,dword[ecx+eax]

	push	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,24
	movzx	ecx,word[eax+edx]
	and	ecx,0xffff
	mov	eax,1
	call	alloc_color

	pop	edx
	push	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,16
	and	edx,0xff
	movzx	ecx,word[eax+edx]
	and	ecx,0xffff
	mov	eax,2
	call	alloc_color

	pop	edx

	mov	eax,dword[GR_PALETTE_DEFAULT]
	shr	edx,8
	and	edx,0xff
	movzx	ecx,word[eax+edx]
	and	ecx,0xffff
	mov	eax,3
	call	alloc_color

	pop	edx


;	grv2 roads
	mov	ecx,dword[GR_CONTROL_AREA_HOR]

	xor	eax,eax
	mov	ax,word[ecx+edx*2]
	ror	ax,8
	xor	ebx,ebx
	mov	bx,word[0x400+ecx+edx*2]
	ror	bx,8


	shr	edx,1
        jz      render_grv2_no_fixy
	mov	cl,byte[_gr_bitmap_width]
	dec	edx
	shl	edx,cl

render_grv2_no_fixy:	
	add	eax,0x200
	add	ebx,0x200
	and	eax,0x7ff
	and	ebx,0x7ff

	add	eax,768
	add	ebx,768

render_grv2_xoffset_ok:	
	add	eax,edx
	add	ebx,edx
	add	eax,esi
	add	ebx,esi

	mov	cl,byte[GR_SECOND_ROAD_ON]
	cmp	cl,1
        je      render_grv2_01
	cmp	cl,3
        je      render_grv2_11
	cmp	cl,0
        jne     render_grv2_10

	mov	ebx,eax
        jmp     short render_grv2_01
render_grv2_10:	
	xchg	ebx,eax
        jmp     short render_grv2_01
render_grv2_11:	
	mov	eax,ebx
render_grv2_01:	
	xor	edx,edx
	mov	ecx,328

	inc	ebx

render_grv2_dot:	

;	merge leftside&rightside roads

	mov	dl,byte[eax]
	cmp	byte[ebx],dl
        jle     render_grv2_color_ok

render_grv2_road2:	
	mov	dl,byte[ebx]
render_grv2_color_ok:	

	mov	dl,byte[GR_FASTPAL+edx]
	inc	eax
	mov	byte[edi],dl
	inc	ebx
	inc	edi
	dec	ecx
        jnz     render_grv2_dot

	pop	ebx

render_grv2_nextline:	
	add	ebx,0x2
	add	dword[DISPLAY_BASE],1024
	dec	byte[CPT_LINE]
	jnz	near render_grv2_line

	ret







	global	 _clear_framebuf
_clear_framebuf:	
	mov	ebx,dword[_display_base]
	xor	eax,eax
	mov	edx,ebx
_text_clr2:	
	mov	ebx,edx
	mov	ecx,82
_text_clr1:	
	mov	dword[ebx],eax
	add	ebx,4
	dec	ecx
        jnz     _text_clr1
	add	edx,1024
	cmp	edx,dword[_display_bottom]
        jb      _text_clr2
	ret




	times	($$-$) & 3 nop
;	esi=pattern edi=screen ebp=palette (dh,dl)=(skipped scr lines,1st tile line)
draw_tile_fore:	
	movzx	ecx,dh
	movzx	ebx,dl

	shl	ecx,10
	mov	al,8
	shl	ebx,2
	sub	al,dh
	add	edi,ecx
	sub	al,dl
	add	esi,ebx
	mov	byte[BG_LINE_COUNTER],al

draw_tile_fore_1:	
	mov	ecx,dword[esi]
	mov	ebx,dword[edi]

	xor	edx,edx
	mov	dl,cl
	shr	cl,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]
	mov	byte[edi],al
	inc	edi

	mov	dl,cl
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]
	mov	byte[edi],ah
	inc	edi

	shr	ebx,16

	mov	dl,ch
	shr	ch,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]
	mov	byte[edi],al
	inc	edi

	mov	dl,ch
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]
	mov	byte[edi],ah
	inc	edi

	shr	ecx,16
	mov	ebx,dword[edi]

	mov	dl,cl
	shr	cl,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]
	mov	byte[edi],al
	inc	edi

	mov	dl,cl
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]
	mov	byte[edi],ah
	inc	edi

	shr	ebx,16

	mov	dl,ch
	shr	ch,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]
	mov	byte[edi],al
	inc	edi

	mov	dl,ch
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]
	mov	byte[edi],ah

	add	esi,4
	add	edi,1017

	dec	byte[BG_LINE_COUNTER]
        jnz     near draw_tile_fore_1

	ret

	times	($$-$) & 3 nop
draw_tile_fore_for_p5:	
	movzx	ecx,dh
	movzx	ebx,dl

	shl	ecx,10
	mov	al,8
	shl	ebx,2
	sub	al,dh
	add	edi,ecx
	sub	al,dl
	add	esi,ebx
	mov	byte[BG_LINE_COUNTER],al

	xor	edx,edx

draw_tile_fore_for_p5_1:	
	mov	ecx,dword[esi]
	mov	ebx,dword[edi]

	mov	dl,cl
	shr	cl,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]

	mov	dl,cl
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]

	shl	eax,16
	shr	ebx,16

	mov	dl,ch
	shr	ch,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]

	mov	dl,ch
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]

	rol	eax,16
	mov	dword[edi],eax
	add	edi,4

	shr	ecx,16
	mov	ebx,dword[edi]

	mov	dl,cl
	shr	cl,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]

	mov	dl,cl
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]

	shl	eax,16
	shr	ebx,16

	mov	dl,ch
	shr	ch,4
	and	dl,0xf

	mov	byte[ebp],bl
	mov	al,byte[ebp+edx]

	mov	dl,ch
	mov	byte[ebp],bh
	mov	ah,byte[ebp+edx]

	rol	eax,16
	mov	dword[edi],eax

	add	edi,1020
	add	esi,4

	dec	byte[BG_LINE_COUNTER]
	jnz	near draw_tile_fore_for_p5_1

	ret

	times	($$-$) & 3 nop
;	esi=pattern edi=screen ebp=palette (dh,dl)=(skipped scr lines,1st tile line)
draw_tile_back:	
	movzx	ecx,dh
	movzx	ebx,dl

	shl	ecx,10
	mov	al,8
	shl	ebx,2
	sub	al,dh
	add	esi,ebx
	sub	al,dl
	add	edi,ecx
	mov	byte[BG_LINE_COUNTER],al

draw_tile_back_1:	
	mov	ecx,dword[esi]
	xor	edx,edx
	xor	ebx,ebx

	mov	bl,cl
	mov	dl,cl
	shr	bl,4
	and	dl,0xf

	mov	ah,byte[ebp+edx]
	mov	dl,byte[ebp+ebx]
	mov	byte[edi],ah
	inc	edi
	mov	byte[edi],dl
	inc	edi

	mov	bl,ch
	mov	dl,ch
	shr	bl,4
	and	dl,0xf

	mov	ah,byte[ebp+edx]
	mov	dl,byte[ebp+ebx]
	mov	byte[edi],ah
	inc	edi
	mov	byte[edi],dl
	inc	edi

	shr	ecx,16
	add	esi,4

	mov	bl,cl
	mov	dl,cl
	shr	bl,4
	and	dl,0xf

	mov	ah,byte[ebp+edx]
	mov	dl,byte[ebp+ebx]
	mov	byte[edi],ah
	inc	edi
	mov	byte[edi],dl
	inc	edi

	mov	bl,ch
	mov	dl,ch
	shr	bl,4
	and	dl,0xf

	mov	ah,byte[ebp+edx]
	mov	dl,byte[ebp+ebx]
	mov	byte[edi],ah
	inc	edi
	mov	byte[edi],dl

	add	edi,1017

	dec	byte[BG_LINE_COUNTER]
	jnz	near draw_tile_back_1
	ret
	times	($$-$) & 3 nop
draw_tile_back_for_p5:	
	movzx	ecx,dh
	movzx	ebx,dl

	shl	ecx,10
	mov	al,8
	shl	ebx,2
	sub	al,dh
	add	esi,ebx
	sub	al,dl
	add	edi,ecx
	mov	byte[BG_LINE_COUNTER],al

	xor	ebx,ebx
	xor	edx,edx

draw_tile_back_for_p5_1:	
	mov	ecx,dword[esi]
	xor	eax,eax

	mov	bl,cl
	mov	dl,cl
	shr	bl,4
	and	dl,0xf

	mov	al,byte[ebp+edx]
	mov	dl,ch
	mov	ah,byte[ebp+ebx]
	mov	bl,ch

	shr	bl,4
	and	dl,0xf

	shl	eax,16
	add	esi,4

	shr	ecx,16
	mov	al,byte[ebp+edx]
	mov	ah,byte[ebp+ebx]
	mov	bl,cl

	rol	eax,16
	mov	dword[edi],eax
	add	edi,4

	shr	bl,4
	mov	dl,cl

	and	dl,0xf
	mov	ah,byte[ebp+ebx]

	mov	al,byte[ebp+edx]
	mov	bl,ch

	shr	bl,4
	mov	dl,ch

	shl	eax,16
	and	dl,0xf

	mov	al,byte[ebp+edx]

	mov	ah,byte[ebp+ebx]

	rol	eax,16
	mov	dword[edi],eax

	add	edi,1020

	dec	byte[BG_LINE_COUNTER]
	jnz	near draw_tile_back_for_p5_1

	ret




	times	($$-$) & 3 nop
;	edi=screen ebp=palette(only use color#0) (dh,dl)=(skipped scr lines,1st tile line)
draw_tile_clear:	
;	clear an 8x8 tile
	movzx	ecx,dh

	shl	ecx,10
	mov	al,8

	sub	al,cl
	add	edi,ecx

	sub	al,dl
	xor	edx,edx

	mov	byte[BG_LINE_COUNTER],al
	mov	dl,byte[ebp]

	mov	dh,dl
	mov	ecx,edx
	shl	ecx,16
	or	edx,ecx

draw_tile_clear_1:	
	mov	dword[edi],edx
	mov	dword[4+edi],edx
	add	edi,1024
	dec	byte[BG_LINE_COUNTER]
        jnz     draw_tile_clear_1

	ret

	global	 alloc_color
	times	($$-$) & 3 nop
;	ecx=16bit_colorvalue ebp=fastpalette_buf eax=fastpalette_index
alloc_color:	
	movzx	edx,byte[_Palette256+ecx]
	cmp	dl,0
        jne     _alloc_color_ok

;	get a free entry to %dl, un-reg old color data, reg new color data
	movzx	edx,byte[_pal_free_head]
	movzx	ebx,word[2+_pal_data+edx*4]
	mov	word[2+_pal_data+edx*4],cx
	mov	byte[_Palette256+ecx],dl
	or	ebx,ebx
        jz      _alloc_color_no_reset
	mov	byte[_Palette256+ebx],0
_alloc_color_no_reset:	
	mov	ebx,dword[_number_of_new_colors]
	inc	dword[_number_of_new_colors]
	lea	ebx,[_NewColorsTab+ebx*4]
	mov	byte[ebx],dl
	mov	word[2+ebx],cx

_alloc_color_ok:	
;	remove %dl from palette freelist
	mov	ecx,dword[_pal_data+edx*4]
	mov	byte[ebp+eax],dl
	mov	word[_pal_data+edx*4],0
	or	cx,cx
        jz      _alloc_color_ok_2
;	cl=prev ch=next
	xor	ebx,ebx
	mov	bl,cl
	mov	byte[1+_pal_data+ebx*4],ch
	mov	bl,ch
	mov	byte[_pal_data+ebx*4],cl
	cmp	dl,byte[_pal_free_head]
        jne     _alloc_color_ok_2
	mov	byte[_pal_free_head],ch
_alloc_color_ok_2:	

	ret


;/*	GENERATION DE L'ECRAN TEXTE */

	global	_asm_render_text
_asm_render_text:	
	mov	word[BG_PRIORITY],ax
	mov	ebx,dword[_display_base]
	mov	dword[DISPLAY_BASE_SAVE],ebx

	mov	ebx,dword[_text_base]
	mov	dword[VIDEO_BASE_SAVE],ebx
	mov	dword[LAST_BANK],0
	mov	byte[CPT_LINE],29

_render_text_line:	
	mov	byte[CPT_COLUMN],42
	mov	esi,dword[VIDEO_BASE_SAVE]
	mov	edi,dword[DISPLAY_BASE_SAVE]
	mov	edx,dword[_tiles_transparent]

_render_text_column:	
	mov	ecx,dword[esi]
	xor	ebx,ebx

;	       testl   _text_mask,%ecx
;	       jz      _text_nextchar

	xor	eax,eax
	mov	bl,ch
	mov	al,cl

	cmp	al,byte[BG_PRIORITY]
        jb      near _text_nextchar
	cmp	al,byte[BG_PRIORITY+1]
        ja      near _text_nextchar

	cmp	byte[_bg_text_mode],0
        je      _text_withbank

	and	al,0x07
	shl	eax,4
        jmp     short short _text_nobank
_text_withbank:	
	mov	bh,al
	and	eax,0x0e
	shl	eax,3
	and	ebx,0x01ff
_text_nobank:

        add     ebx,dword[BG_TILE_BANK_0]

;	check #%ebx tile is not a space
	cmp	byte[edx+ebx],0
	je	near _text_nextchar

	shl	ebx,5
;	%ebx = pattern offset  %eax = palette offset(0000~0070)
	mov	ecx,eax
	shr	ecx,3
	mov	ebp,eax
	add	ebx,dword[_tiles_base]

	push	edx
        shr     ebp,1
        push    edi
        add     ebp,_FastPaletteSet

	cmp	ax,word[_FastPaletteData+ecx]
        je      _no_color_init_text
	mov	word[_FastPaletteData+ecx],ax

	push	ebx

	mov	edi,eax
	mov	eax,0
	add	edi,dword[_base_palette_shinobi]
_init_color_text:	
	movzx	ecx,word[edi]
	call	alloc_color

	add	edi,2
	inc	eax
	cmp	eax,8
        jb      _init_color_text

	pop	ebx
_no_color_init_text:	

_text_brique_line:	
_text_brique_column:	
	pop	edi
	push	edi
	push	esi
	mov	esi,ebx

	mov	edx,0
	call	[BG_DRAW_TILE_FORE]

	pop	esi
	pop	edi
	pop	edx

_text_nextchar:	
	add	esi,2
	add	edi,8
	dec	byte[CPT_COLUMN]
	jnz	near _render_text_column

	add	dword[VIDEO_BASE_SAVE],0x80
	add	dword[DISPLAY_BASE_SAVE],0x2000
	dec	byte[CPT_LINE]
	jnz	near _render_text_line

	ret






	global	 _asm_render_bg
_asm_render_bg:	

	mov	word[BG_PRIORITY],ax
	shr	eax,16
	mov	byte[BG_FORE_FLAG],ah
        mov     byte[BG_SPLIT_MODE],al

        cmp     ah,0
        jne     __bg_draw_back
        mov     eax,dword[BG_DRAW_TILE_FORE]
        jmp     short __bg_draw_fore
__bg_draw_back:
        mov     eax,dword[BG_DRAW_TILE_BACK]
__bg_draw_fore:
        mov     dword[BG_DRAW_TILE],eax

;	       movl    %ebx,BASE_SCR_PAG
	movzx	eax,word[-1+ecx]
	ror	ax,8
	mov	dword[BG_VER],eax
	movzx	eax,word[edx]
	ror	ax,8
	mov	dword[BG_HOR],eax
	mov	dword[BASE_SCR_HOR_SPLITTAB],esi
	mov	dword[BASE_SCR_VER_SPLITTAB],edi

;	build bg page cache
	mov	edx,dword[_foreground_base]
	mov	bx,word[-1+ebx]

	cmp	byte[_reverse_bgpage_flag],0
        je      no_reverse_bgpage
;	0123 -> 1302
	rol	bx,4
	ror	bh,4
	rol	bx,4
no_reverse_bgpage:	

	mov	al,bh
	and	eax,0xf0
	shl	eax,8
	add	eax,edx
	mov	dword[BG_PAGEADDR],eax
	mov	al,bh
	and	eax,0x0f
	shl	eax,12
	add	eax,edx
	mov	dword[BG_PAGEADDR+4],eax
	mov	al,bl
	and	eax,0xf0
	shl	eax,8
	add	eax,edx
	mov	dword[BG_PAGEADDR+8],eax
	mov	al,bl
	and	eax,0x0f
	shl	eax,12
	add	eax,edx
	mov	dword[BG_PAGEADDR+12],eax

	mov	eax,dword[_display_base]
	add	eax,8
	mov	dword[DISPLAY_BASE],eax
	mov	dword[BG_SY_OFFSET],0

	mov	byte[CPT_LINE],28

_render_bg_line:	
	mov	dl,byte[BG_SPLIT_MODE]
	mov	eax,dword[BG_HOR]
;	0xff = sys16 compatible mode (no alternate bg's)
	cmp	dl,0xff
        je      _bg_access_HOR_normal

	mov	ebx,eax

	mov	esi,dword[BASE_SCR_HOR_SPLITTAB]
	movzx	eax,word[esi]
	add	dword[BASE_SCR_HOR_SPLITTAB],2
	mov	dh,al
	and	dh,0x80
	cmp	dh,dl
	jne	near _bg_next_line

	ror	ax,8
	cmp	bh,0x80
        je      _bg_access_HOR_normal
	mov	eax,ebx

_bg_access_HOR_normal:	
	sub	eax,dword[_bg_xoffset]
	and	eax,0x03FF
	neg	eax
	add	eax,0x02c0
	and	eax,0x03FF

;	eax=sx
	mov	ebx,eax
	and	ebx,7
	mov	edi,dword[DISPLAY_BASE]
	sub	edi,ebx
	mov	dword[DISPLAY_BASE_SAVE],edi

	mov	dword[BG_SX],eax
;	edi=screen

	mov	byte[CPT_COLUMN],41

_render_bg_column:	
	mov	ebx,dword[BG_VER]
	mov	eax,dword[BG_SX]

;	       cmpb    $0x80,%bl
;	       jne     _bg_access_VER_normal
	test	bh,0x80
        jz      _bg_access_VER_normal

;	       movl    %eax,%ecx
;	       movl    BASE_SCR_VER_SPLITTAB,%esi
;	       addl    $8,%ecx
;	       andl    $0x1f0,%ecx
;	       shrl    $3,%ecx
;	       xorl    %ebx,%ebx
;	       negl    %ecx
;	       movw    62(%ecx,%esi),%bx

	mov	esi,dword[BASE_SCR_VER_SPLITTAB]
	movzx	ecx,byte[CPT_COLUMN]
	neg	ecx
	add	ecx,40
	and	ecx,0xfffffffe
	mov	bx,word[24+ecx+esi]

	ror	bx,8

_bg_access_VER_normal:	

	add	ebx,dword[BG_SY_OFFSET]
	mov	cl,bl
	and	cl,7
	mov	byte[BG_YOFFSET],cl

;	ebx=sy eax=sx
	push	ebx
	push	eax

	mov	ecx,eax
	mov	edx,ebx
	and	ecx,0x200
	and	edx,0x100
	shr	ecx,7
	shr	edx,5
	add	ecx,edx

	mov	esi,dword[BG_PAGEADDR+ecx]

	and	ebx,0xf8
	shl	ebx,4
	add	esi,ebx

	and	eax,0x1f8
	shr	eax,2
	mov	ax,word[esi+eax]
	ror	ax,8

;	ax=tile (ah=attr,al=char)
	mov	ebx,eax

	and	ebx,0x0fff
	or	ebx,dword[BG_TILE_BANK_0]
	test	ah,0x10
        jz      _bg_nobanksel
	and	ebx,0x0fff
	or	ebx,dword[BG_TILE_BANK_1]
_bg_nobanksel:	

	mov	dl,byte[BG_FORE_FLAG]
	mov	byte[BG_CLEAR_FLAG],0
	cmp	dl,0
        jne     _bg_checkpriority

	mov	ecx,dword[_tiles_transparent]
	cmp	byte[ecx+ebx],0
	je	near _bg_L

_bg_checkpriority:	
	cmp	ah,byte[BG_PRIORITY]
        jb      _bg_checkforclear
	cmp	ah,byte[BG_PRIORITY+1]
        ja      _bg_checkforclear
        jmp     short _bg_startdrawtile1
_bg_checkforclear:	
	cmp	dl,0
	je	near _bg_L

	mov	byte[BG_CLEAR_FLAG],1
_bg_startdrawtile1:	


;	draw tile

	mov	esi,ebx
	shl	esi,5
	add	esi,dword[_tiles_base]

;	esi=pattern addr

	cmp	byte[_bg_colormode],0
        jne     _bg_mode_couleur2
	and	eax,0x1fc0
	shr	eax,2
        jmp     short _bg_saut6
_bg_mode_couleur2:	
	and	eax,0x0fe0
	shr	eax,1

;	eax=palette offset(0000~07f0)
_bg_saut6:	

	mov	ecx,eax
	mov	ebp,eax

	shr	ebp,1
	shr	ecx,3
	add	ebp,_FastPaletteSet

	cmp	ax,word[_FastPaletteData+ecx]
        je      _no_color_init_bg
	mov	word[_FastPaletteData+ecx],ax

	mov	edi,eax
	mov	eax,0
	add	edi,dword[_base_palette_shinobi]
_init_color_bg:	
	movzx	ecx,word[edi]

	call	alloc_color

	add	edi,2
	inc	eax
	cmp	eax,8
        jb      _init_color_bg

_no_color_init_bg:	


	mov	edi,dword[DISPLAY_BASE_SAVE]
	mov	dh,0
	mov	dl,byte[BG_YOFFSET]
;	esi=pattern edi=screen ebp=palette (dh,dl)=(skipped scr lines,1st tile line)

        cmp     byte[BG_CLEAR_FLAG],0
        je      _bg_tile
	call	draw_tile_clear
        jmp     short _bg_drawtile2
_bg_tile:
        call    [BG_DRAW_TILE]


_bg_drawtile2:	
;///////end	of upper half tile//////////////////////////////

_bg_L:	


;/////	lower half tile////////////////////////////

;	ebx=sy eax=sx
	pop	eax
	pop	ebx
	test	bl,7
	jz	near _bg_nextchar

	add	ebx,8

	mov	ecx,eax
	mov	edx,ebx
	and	ecx,0x200
	and	edx,0x100
	shr	ecx,7
	shr	edx,5
	add	ecx,edx

	mov	esi,dword[BG_PAGEADDR+ecx]

	and	ebx,0xf8
	shl	ebx,4
	add	esi,ebx

	and	eax,0x1f8
	shr	eax,2
	mov	ax,word[esi+eax]
	ror	ax,8


;	ax=tile (ah=attr,al=char)
	mov	ebx,eax

	and	ebx,0x0fff
	or	ebx,dword[BG_TILE_BANK_0]
	test	ah,0x10
        jz      _bg_L_nobanksel
	and	ebx,0x0fff
	or	ebx,dword[BG_TILE_BANK_1]
_bg_L_nobanksel:	

	mov	dl,byte[BG_FORE_FLAG]
	mov	byte[BG_CLEAR_FLAG],0
	cmp	dl,0
        jne     _bg_L_checkpriority

	mov	ecx,dword[_tiles_transparent]
	cmp	byte[ecx+ebx],0
	je	near _bg_nextchar

_bg_L_checkpriority:	
	cmp	ah,byte[BG_PRIORITY]
        jb      _bg_L_checkforclear
	cmp	ah,byte[BG_PRIORITY+1]
        ja      _bg_L_checkforclear
        jmp     short _bg_L_startdrawtile1
_bg_L_checkforclear:	
	cmp	dl,0
	je	near _bg_nextchar

	mov	byte[BG_CLEAR_FLAG],1
_bg_L_startdrawtile1:	


;	draw tile

	mov	esi,ebx
	shl	esi,5
	add	esi,dword[_tiles_base]

;	esi=pattern addr

	cmp	byte[_bg_colormode],0
        jne     _bg_L_mode_couleur2
	and	eax,0x1fc0
	shr	eax,2
        jmp     short _bg_L_saut6
_bg_L_mode_couleur2:	
	and	eax,0x0fe0
	shr	eax,1

;	eax=palette offset(0000~07f0)
_bg_L_saut6:	

	mov	ecx,eax
	mov	ebp,eax
	shr	ebp,1
	shr	ecx,3
	add	ebp,_FastPaletteSet

	cmp	ax,word[_FastPaletteData+ecx]
        je      _no_color_init_bg_L
	mov	word[_FastPaletteData+ecx],ax

	mov	edi,eax
	mov	eax,0
	add	edi,dword[_base_palette_shinobi]
_init_color_bg_L:	
	movzx	ecx,word[edi]

	call	alloc_color

	add	edi,2
	inc	eax
	cmp	eax,8
        jb      _init_color_bg_L

_no_color_init_bg_L:	

	mov	edi,dword[DISPLAY_BASE_SAVE]
	mov	dh,8
	sub	dh,byte[BG_YOFFSET]
	mov	dl,0
;	esi=pattern edi=screen ebp=palette (dh,dl)=(skipped scr lines,1st tile line)

	cmp	byte[BG_CLEAR_FLAG],0
        je      _bg_L_tile
	call	draw_tile_clear
        jmp     short _bg_L_drawtile2
_bg_L_tile:
        call    [BG_DRAW_TILE]

_bg_L_drawtile2:	

;////end	of lower half tile//////////////////////////////

_bg_nextchar:	
	add	dword[DISPLAY_BASE_SAVE],8
	add	dword[BG_SX],8

	dec	byte[CPT_COLUMN]
	jnz	near _render_bg_column

_bg_next_line:	
	add	dword[DISPLAY_BASE],8192
	add	dword[BG_SY_OFFSET],8
	dec	byte[CPT_LINE]
	jnz	near _render_bg_line
_fin_bg:	
	ret




;/*	gestion des sprites */

	global	_asm_render_sprites
_asm_render_sprites:	
	mov	ebx,dword[_vscreen_base]
	mov	esi,dword[_base_spr_regist]
	mov	dword[LAST_BANK],0
	mov	edx,0

	cmp	byte[_game],0x06
        je      _sprites_shadow_dancer
	cmp	word[esi],0xFFFF
	je	near _fin_des_sprites
	cmp	word[4+esi],0xFFFF
	je	near _fin_des_sprites
_recherche_debut:	
	cmp	word[16+esi+edx],0xFFFF
        je      _sprite_loop0
	cmp	word[20+esi+edx],0xFFFF
        je      _sprite_loop0
	add	edx,0x10
	cmp	edx,dword[_spr_limit]
        jl      _recherche_debut
	jmp	_sprite_loop0

_sprites_shadow_dancer:	
	test	byte[4+esi],0x80
	jnz	near _fin_des_sprites
_recherche_debut2:	
	test	byte[4+esi+edx],0x80
        jnz     _sprite_loop0
	add	edx,0x10
	cmp	edx,dword[_spr_limit]
        jl      _recherche_debut2

_sprite_loop0:	
	mov	word[END_OF_SPRITE],dx
	xor	edx,edx

_sprite_loop:	
	mov	al,byte[9+esi+edx]
	and	al,0xC0
	cmp	byte[SPR_MODE],al
	jne	near _sprite_non_actif

	mov	eax,dword[esi+edx]
;	al,ah al2,ah2
;	y1 y0  x

;/*	check Y position */
	cmp	al,0
	je	near _sprite_non_actif
	cmp	ah,al
	jae	near _sprite_non_actif

	mov	ebx,eax

	sub	al,ah
	mov	byte[SPR_HEIGHT],al
	movzx	ecx,ah

;	(400-224)/2 = 88
	add	ecx,88
;	2^10 = 1024
	shl	ecx,10
	add	ecx,dword[_vscreen_base]

;	%ecx = address of start line of sprite in frame buffer

;/*	X position */
	and	ebx,0xffff0000
	bswap	ebx
	sub	ebx,dword[_spr_xoffset]
	cmp	ebx,520
	jg	near _sprite_non_actif

;	(1024-512)/2-88 = 178
	add	ebx,168

	add	ecx,ebx
	mov	dword[SCR_BASE],ecx

	mov	eax,dword[4+esi+edx]
;	al,ah al2,ah2 = 4 5 6 7
;	r  w   addr

;       check for sys18 disabled sprites
        cmp     ax,0x0080
        je      near _sprite_non_actif

	test	ah,0x80
        jz      _pas_flip_vertical

	movsx	ecx,ah
	xor	ebx,ebx
	mov	byte[SPR_FLIP_FLAG],1
	sub	ebx,ecx
        test    al,1
        jz      _fin_flip

;       v-flip & reversed
        dec     dword[SCR_BASE]

        jmp     short _fin_flip

_pas_flip_vertical:     
	movzx	ecx,ah
	mov	byte[SPR_FLIP_FLAG],0
	mov	ebx,ecx
_fin_flip:	
	add	ebx,ebx
	mov	dword[SPR_WIDTH],ebx

;	%ecx = raw signed width

	mov	byte[SPR_REVERSE_FLAG],al
	xor	ebx,ebx
	cmp	byte[_obj_is_32bit],1
        jne     SPR_not32bit2
	test	al,1
        jz      SPR_not32bit2
	add	ebx,2
SPR_not32bit2:	
	mov	dword[SPR_BASE],ebx

	and	eax,0xffff0000
	bswap	eax
;	%eax = raw pattern address
;	should be added with raw signed width
	add	eax,ecx
	and	eax,0xffff

	cmp	byte[_obj_is_32bit],1
        jne     SPR_not32bit

	shl	dword[SPR_WIDTH],1
	shl	eax,2
	movzx	ecx,byte[8+esi+edx]
	and	ecx,0xF
	movzx	ebx,byte[_spr_tab+ecx]
	shl	ebx,17
	add	ebx,eax
        jmp     short _spr_adrs_ok

SPR_not32bit:	
	shl	eax,1

	movzx	ecx,byte[8+esi+edx]
	and	ecx,0xF
	movzx	ebx,byte[_spr_tab+ecx]

	shl	ebx,16
	add	ebx,eax

_spr_adrs_ok:	
	add	ebx,dword[_sprites_base_data]
	add	dword[SPR_BASE],ebx

;/*	get zoom factor */
	mov	ax,word[10+esi+edx]
	ror	ax,8
	mov	word[SPR_ZOOM],ax
	mov	word[SPR_ZOOMX0],ax
	mov	word[SPR_ZOOMY0],ax
	mov	ax,word[12+esi+edx]
	test	ax,ax
        jz      _spr_no_zoomy_cofficient
	ror	ax,8
	mov	word[SPR_ZOOMY0],ax
_spr_no_zoomy_cofficient:	
	mov	al,byte[14+esi+edx]
	mov	byte[SPR_OFFSET],al

;/*	calcul base palette du sprite */
	movzx	ebx,byte[9+esi+edx]
	and	ebx,0x3F
	shl	ebx,5

	add	ebx,0x800
	add	ebx,dword[_base_palette_shinobi]
	mov	dword[SPR_COLOR],ebx

	push	edx

	mov	ebp,dword _FastPalette
	cmp	dword[LAST_BANK],ebx
        je      _no_color_init_spr

	mov	dword[LAST_BANK],ebx
	mov	eax,15

_init_color_spr:	
	mov	ebx,dword[SPR_COLOR]
	movzx	ecx,word[ebx+eax*2]

	call	alloc_color

	dec	eax
        jnz     _init_color_spr

_no_color_init_spr:	
	cmp	word[SPR_ZOOM],0
	je	near _old_sprite

	mov	eax,dword[SPR_BASE]
	test	byte[SPR_FLIP_FLAG],1
        jnz     _sprite_flip_selection
	test	byte[SPR_REVERSE_FLAG],1
        jnz     near _sprite_reverse_pre
	jmp	_sprite_normal_pre
_sprite_flip_selection:	
	test	byte[SPR_REVERSE_FLAG],1
        jz      near _sprite_flip_reverse_pre
	jmp	_sprite_flip_normal_pre






;	ZOOM RATE:
;	Y direction = 1024/(1024+W) W:0~1023
;	X direction = (2048-W)/2048 W:0~1023

_sprite_normal_pre:	
	push	esi
	push	edi
	push	ebx
        movsx   ebx,byte[SPR_OFFSET]
	add	eax,ebx
	mov	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1060

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_sprite_normal:	
	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _sprite_normal_drawline
	add	dword[SPR_ZOOMY],1060
	add	esi,dword[SPR_WIDTH]

_sprite_normal_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
        jl      _sprite_normal_end
	xor	edx,edx

_sprite_normal_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0x0f
        jne     _sprite_normal_loop_column_2

	add	esi,ebx
        jmp     short _sprite_normal_nextline

_sprite_normal_loop_column_2:	
;	draw p0
	shr	eax,4
        jz      _sprite_normal_p0_trans
	cmp	al,0x0f
        je      _sprite_normal_p0_trans
	mov	al,byte[_FastPalette+eax]
	mov	byte[edi],al

_sprite_normal_p0_trans:	
	movzx	eax,byte[esi]
	inc	edi

	sub	edx,ecx
        jg      _sprite_normal_p1
	add	edx,1024
        jmp     short _sprite_normal_nextbyte

_sprite_normal_p1:	

;	draw p1
	and	eax,0x0f
        jz      _sprite_normal_p1_trans
	cmp	al,0x0f
        je      _sprite_normal_p1_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_sprite_normal_p1_trans:	
	inc	edi


_sprite_normal_nextbyte:	
	inc	esi
	dec	ebx
        jnz     _sprite_normal_loop_column

_sprite_normal_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
        jnz     near _sprite_normal

_sprite_normal_end:	
	pop	ebx
	pop	edi
	pop	esi
	jmp	_fin_du_sprite










_sprite_reverse_pre:	
	push	esi
	mov	esi,eax
	mov	eax,dword[SPR_WIDTH]
	inc	esi
	push	edi
	sub	esi,eax
	push	ebx
	sub	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1060

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_sprite_reverse:	
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax
	add	esi,eax

	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _sprite_reverse_drawline
	add	dword[SPR_ZOOMY],1060
	add	esi,eax

_sprite_reverse_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
	jl	near _sprite_normal_end
	xor	edx,edx

_sprite_reverse_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0xf0
        jne     _sprite_reverse_loop_column_2

	sub	esi,ebx
        jmp     short _sprite_reverse_nextline


_sprite_reverse_loop_column_2:	

;	draw p0
	and	eax,0x0f
        jz      _sprite_reverse_p0_trans
	cmp	al,0x0f
        je      _sprite_reverse_p0_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_sprite_reverse_p0_trans:	
	movzx	eax,byte[esi]
	inc	edi

	sub	edx,ecx
        jg      _sprite_reverse_p1
	add	edx,1024
        jmp     short _sprite_reverse_nextbyte

_sprite_reverse_p1:	

;	draw p1
	shr	eax,4
        jz      _sprite_reverse_p1_trans
	cmp	al,0x0f
        je      _sprite_reverse_p1_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_sprite_reverse_p1_trans:	
	inc	edi


_sprite_reverse_nextbyte:	
	dec	esi
	dec	ebx
	jnz	near _sprite_reverse_loop_column

_sprite_reverse_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _sprite_reverse
	jmp	_sprite_normal_end









_sprite_flip_normal_pre:	
	mov	word[SPR_ZOOMY],0

_sprite_flip_normal:	
	inc	eax
	inc	dword[SCR_BASE]

_sprite_flip_normal_loop:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMY],cx
	cmp	word[SPR_ZOOMY],1060
        jl      _sprite_flip_normal_loop_1
	sub	word[SPR_ZOOMY],1060

	mov	ecx,dword[SPR_WIDTH]
	sub	eax,ecx

_sprite_flip_normal_loop_1:	
	mov	word[SPR_ZOOMX],0
	mov	dl,byte[SPR_WIDTH]
	mov	byte[SPR_WIDTHD],dl
	mov	edx,dword[SCR_BASE]
	cmp	dword[_display_bottom],edx
	jl	near _fin_du_sprite

_loop_column_spr_flip:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMX],cx
	cmp	word[SPR_ZOOMX],2048
        jl      _spr_force1_flip_0
	sub	word[SPR_ZOOMX],2048
        jmp     short _spr_force2_flip_0

_spr_force1_flip_0:	
_spr_force1_flip:	
	mov	cl,byte[eax]
	and	ecx,0xF
        jz      _spr_trans1_flip
	cmp	cl,0xF
        je      _spr_trans1_flip
	mov	cl,byte[_FastPalette+ecx]
	mov	byte[edx],cl

_spr_trans1_flip:	
	inc	edx

_spr_force2_flip_0:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMX],cx
	cmp	word[SPR_ZOOMX],2048
        jl      _spr_force2_flip_1
	sub	word[SPR_ZOOMX],2048
	dec	eax
        jmp     short _spr_trans2_flip_1

_spr_force2_flip_1:	
_spr_force2_flip:	
	mov	cl,byte[eax]
	and	ecx,0xF0
        jz      _spr_trans2_flip
	shr	cl,4
	cmp	cl,0xF
        je      _spr_trans2_flip

	mov	cl,byte[_FastPalette+ecx]
	mov	byte[edx],cl

_spr_trans2_flip:	
	inc	edx
	dec	eax

_spr_trans2_flip_1:	
	dec	byte[SPR_WIDTHD]
        jnz     near _loop_column_spr_flip

	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _sprite_flip_normal_loop

	jmp	_fin_du_sprite












_sprite_flip_reverse_pre:	
	mov	word[SPR_ZOOMY],0

_sprite_flip_reverse:	
	mov	edx,0
	mov	dl,byte[SPR_WIDTH]
	add	eax,edx
	dec	eax
	dec	dword[SCR_BASE]
	add	dx,dx
	add	dword[SCR_BASE],edx

_sprite_reverse_loop_flip:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMY],cx
	cmp	word[SPR_ZOOMY],1060
        jl      _sprite_reverse_loop_flip_1
	sub	word[SPR_ZOOMY],1060

	movzx	ecx,byte[SPR_WIDTH]
	sub	eax,ecx

_sprite_reverse_loop_flip_1:	
	mov	word[SPR_ZOOMX],0
	mov	dl,byte[SPR_WIDTH]
	mov	byte[SPR_WIDTHD],dl
	mov	edx,dword[SCR_BASE]
	cmp	dword[_display_bottom],edx
	jl	near _fin_du_sprite

_loop_column_spr_r_flip:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMX],cx
	cmp	word[SPR_ZOOMX],2048
        jl      _spr_force1_r_flip_0
	sub	word[SPR_ZOOMX],2048
        jmp     short _spr_force2_r_flip_0

_spr_force1_r_flip_0:	
_spr_force1_r_flip:	
	mov	cl,byte[eax]
	and	ecx,0xF
        jz      _spr_trans1_r_flip
	cmp	cl,0xF
        je      _spr_trans1_r_flip
	mov	cl,byte[_FastPalette+ecx]
	mov	byte[edx],cl

_spr_trans1_r_flip:	
	dec	edx

_spr_force2_r_flip_0:	
	mov	cx,word[SPR_ZOOM]
	add	word[SPR_ZOOMX],cx
	cmp	word[SPR_ZOOMX],2048
        jl      _spr_force2_r_flip_1
	sub	word[SPR_ZOOMX],2048
	dec	eax
        jmp     short _spr_trans2_r_flip_1

_spr_force2_r_flip_1:	
_spr_force2_r_flip:	
	mov	cl,byte[eax]
	and	ecx,0xF0
        jz      _spr_trans2_r_flip
	shr	cl,4
	cmp	cl,0xF
        je      _spr_trans2_r_flip
	mov	cl,byte[_FastPalette+ecx]
	mov	byte[edx],cl

_spr_trans2_r_flip:	
	dec	eax
	dec	edx

_spr_trans2_r_flip_1:	
	dec	byte[SPR_WIDTHD]
	jnz	near _loop_column_spr_r_flip

	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _sprite_reverse_loop_flip

	jmp	_fin_du_sprite





_fin_du_sprite:	
	pop	edx

_sprite_non_actif:	
	add	dx,16
	cmp	dx,word[END_OF_SPRITE]
	ja	near _fin_des_sprites
	jmp	_sprite_loop

_fin_des_sprites:	
	ret







;	FAST SPRITE ROUTINES WITH NO ZOOM SUPPORTS ////////////////////////////////

_old_sprite:	
	mov	eax,dword[SPR_BASE]
	test	byte[SPR_FLIP_FLAG],1
        jnz     _old_sprite_flip_selection
	test	byte[SPR_REVERSE_FLAG],1
	jnz	near _old_sprite_reverse_pre
	jmp	_old_sprite_normal_pre
_old_sprite_flip_selection:	
	test	byte[SPR_REVERSE_FLAG],1
	jz	near _old_sprite_flip_reverse
	jmp	_old_sprite_flip_normal




_old_sprite_normal_pre:	
	push	edi
	push	esi
	push	ebx
        movsx   ebx,byte[SPR_OFFSET]
	add	eax,ebx
	mov	esi,eax

_old_sprite_normal:	
	mov	ecx,dword[SPR_WIDTH]
        or      ecx,ecx
        jz      _old_sprite_normal_zero_length
	mov	edi,dword[SCR_BASE]

	cmp	dword[_display_bottom],edi
	jl	near _old_sprite_normal_end

_loop_column_old_spr:	
	movzx	ebx,byte[esi]
;	 Altered Beast black-hole patch
        cmp     bl,0x0f
        jne     _loop_column_old_spr_2

	add	esi,ecx
	jmp	_old_spr_normal_nextline

_loop_column_old_spr_2:	
	mov	eax,ebx
	shr	eax,4
        jz      _old_spr_trans1
	cmp	al,0xf
        je      _old_spr_trans1

	mov	dl,byte[_FastPalette+eax]
	mov	byte[edi],dl

_old_spr_trans1:	
	inc	edi

	and	ebx,0xf
        jz      _old_spr_trans2
	cmp	bl,0xf
        je      _old_spr_trans2
	mov	al,byte[_FastPalette+ebx]
	mov	byte[edi],al

_old_spr_trans2:	
	inc	esi
	inc	edi

_old_spr_trans2_1:	
        dec     ecx
        jnz     _loop_column_old_spr
_old_spr_normal_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _old_sprite_normal

_old_sprite_normal_end:	
	pop	ebx
	pop	esi
	pop	edi
	jmp	_fin_du_old_sprite




; special case for sprites with zero length
_old_sprite_normal_zero_length:
	mov	edi,dword[SCR_BASE]

	cmp	dword[_display_bottom],edi
        jl      _old_sprite_normal_end

        mov     dh,160  ;max len=160(320 dots)
        push    esi     ;save source address

_loop_column_old_spr_z:
	movzx	ebx,byte[esi]
;	 Altered Beast black-hole patch
        cmp     bl,0x0f
        je      _old_spr_normal_nextline_z

_loop_column_old_spr_2_z:
	mov	eax,ebx
	shr	eax,4
        jz      _old_spr_trans1_z
	cmp	al,0xf
        je      _old_spr_trans1_z

	mov	dl,byte[_FastPalette+eax]
	mov	byte[edi],dl

_old_spr_trans1_z:
	inc	edi

	and	ebx,0xf
        jz      _old_spr_trans2_z
	cmp	bl,0xf
        je      _old_spr_trans2_z
	mov	al,byte[_FastPalette+ebx]
	mov	byte[edi],al

_old_spr_trans2_z:
	inc	esi
	inc	edi

_old_spr_trans2_1_z:
        dec     dh
        jnz     _loop_column_old_spr_z

_old_spr_normal_nextline_z:
	add	dword[SCR_BASE],1024
        pop     esi
        dec     byte[SPR_HEIGHT]
        jnz     near _old_sprite_normal_zero_length
        jmp     _old_sprite_normal_end




_old_sprite_reverse_pre:	
	push	edi
	push	esi
	push	ebx
	mov	esi,eax

	mov	eax,dword[SPR_WIDTH]
	inc	esi
	sub	esi,eax
	sub	esi,eax

_old_sprite_reverse_loop:	
	mov	ecx,dword[SPR_WIDTH]
	add	esi,ecx
	mov	edi,dword[SCR_BASE]
	add	esi,ecx

	cmp	dword[_display_bottom],edi
	jl	near _old_sprite_normal_end

_loop_column_old_spr_r:	
	movzx	ebx,byte[esi]

;	 Altered Beast black-hole patch
	cmp	bl,0xf0
        jne     _loop_column_old_spr_r2

	sub	esi,ecx
	jmp	_old_spr_reverse_nextline

_loop_column_old_spr_r2:	
	mov	eax,ebx
	and	eax,0xf
        jz      _old_spr_trans1_r
	cmp	al,0xf
        je      _old_spr_trans1_r
	mov	dl,byte[_FastPalette+eax]
	mov	byte[edi],dl

_old_spr_trans1_r:	
	inc	edi

	shr	ebx,4
        jz      _old_spr_trans2_r
	cmp	bl,0xf
        je      _old_spr_trans2_r
	mov	al,byte[_FastPalette+ebx]
	mov	byte[edi],al

_old_spr_trans2_r:	
	dec	esi
	inc	edi

_old_spr_trans2_r_1:	
	dec	ecx
        jnz     _loop_column_old_spr_r

_old_spr_reverse_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]

	jnz	near _old_sprite_reverse_loop
_old_sprite_reverse_end:	

	jmp	_old_sprite_normal_end





_old_sprite_flip_normal:	
	push	edi
	push	esi
	push	ebx

	inc	eax
	inc	dword[SCR_BASE]

	mov	esi,eax

_old_sprite_flip_normal_loop:	
	mov	edi,dword[SCR_BASE]
	mov	ecx,dword[SPR_WIDTH]

	cmp	dword[_display_bottom],edi
	jl	near _old_sprite_normal_end

_loop_column_old_spr_flip:	
	movzx	ebx,byte[esi]
	mov	eax,ebx

	and	eax,0xf
        jz      _old_spr_trans1_flip
	cmp	al,0xf
        je      _old_spr_trans1_flip
	mov	dl,byte[_FastPalette+eax]
	mov	byte[edi],dl

_old_spr_trans1_flip:	
	inc	edi
	shr	ebx,4
        jz      _old_spr_trans2_flip
	cmp	bl,0xf
        je      _old_spr_trans2_flip
	mov	al,byte[_FastPalette+ebx]
	mov	byte[edi],al

_old_spr_trans2_flip:	
	dec	esi
	inc	edi
	dec	ecx
        jnz     _loop_column_old_spr_flip

	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _old_sprite_flip_normal_loop

	jmp	_old_sprite_normal_end




_old_sprite_flip_reverse:	
	push	edi
	push	esi
	push	ebx
	mov	esi,eax

	mov	eax,dword[SPR_WIDTH]
	mov	edi,dword[SCR_BASE]
	add	esi,eax

	dec	edi
	dec	esi
	add	edi,eax
	add	edi,eax
	mov	dword[SCR_BASE],edi

_old_sprite_reverse_loop_flip:	
	mov	ecx,dword[SPR_WIDTH]
	mov	edi,dword[SCR_BASE]

	cmp	dword[_display_bottom],edi
	jl	near _old_sprite_normal_end

_loop_column_old_spr_r_flip:	
	movzx	ebx,byte[esi]
	mov	eax,ebx

	and	eax,0xf
        jz      _old_spr_trans1_r_flip
	cmp	al,0xf
        je      _old_spr_trans1_r_flip
	mov	dl,byte[_FastPalette+eax]
	mov	byte[edi],dl

_old_spr_trans1_r_flip:	
	dec	edi

	shr	ebx,4
        jz      _old_spr_trans2_r_flip
	cmp	bl,0xf
        je      _old_spr_trans2_r_flip
	mov	al,byte[_FastPalette+ebx]
	mov	byte[edi],al

_old_spr_trans2_r_flip:	
	dec	esi
	dec	edi

	dec	ecx
        jnz     _loop_column_old_spr_r_flip

	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _old_sprite_reverse_loop_flip
	jmp	_old_sprite_normal_end





_fin_du_old_sprite:	
	pop	edx
_old_sprite_non_actif:	
	jmp	_sprite_non_actif






;//////////////////////////////////////////////////////////////////////
;/*	for OUTRUN only */
	global	_3dv2_asm_render_sprites
_3dv2_asm_render_sprites:	
	mov	ebx,dword[_vscreen_base]
	mov	esi,dword[_base_spr_regist]
	mov	dword[LAST_BANK],0
	mov	edx,0

	cmp	word[esi],0xFFFF
	je	near _3dv2_fin_des_sprites
	cmp	word[4+esi],0xFFFF
	je	near _3dv2_fin_des_sprites
_3dv2_recherche_debut:	
	cmp	word[16+esi+edx],0xFFFF
        je      _3dv2_sprite_loop0
	cmp	word[20+esi+edx],0xFFFF
        je      _3dv2_sprite_loop0
	add	dx,0x10
	cmp	dx,word[_spr_limit] ;BARTMAN: changed edx->dx, converter didn't handle this apperently
        jl      _3dv2_recherche_debut
_3dv2_sprite_loop0:	
	mov	word[END_OF_SPRITE],dx
	mov	edx,0

_3dv2_sprite_loop:	
	mov	ebx,dword[_vscreen_base]
	cmp	byte[esi+edx],0x00
	je	near _3dv2_sprite_non_actif
	cmp	byte[5+esi+edx],0x00
	je	near _3dv2_sprite_non_actif

;/*	controle bits de priorit */
;	       movb    9(%esi,%edx),%cl
;	       movb    %cl,%ch
;	       andb    $0xC0,%ch
;	       cmpb    %ch,SPR_MODE
;	       jne     _3dv2_sprite_non_actif

;/*	get zoom factor */
	mov	cx,word[10+esi+edx]
	ror	cx,8
	mov	word[SPR_ZOOM],cx
	mov	word[SPR_ZOOMX0],cx
	mov	word[SPR_ZOOMY0],cx

	movzx	ecx,byte[1+esi+edx]
	cmp	cl,byte[esi+edx]
	jae	near _3dv2_sprite_non_actif

	add	ecx,88
	shl	ecx,10
	add	ebx,ecx

	movzx	ecx,word[2+esi+edx]
	ror	cx,8
	sub	ecx,dword[_spr_xoffset]
;	       cmpl    $520,%ecx
;	       jg      _3dv2_sprite_non_actif
;	addl $256,%ecx
	sub	ecx,88
	add	ebx,ecx
	mov	dword[SCR_BASE],ebx

	mov	ebx,0
	mov	ecx,0
	mov	bl,byte[5+esi+edx]
	test	bl,128
	jz	near _3dv2_pas_flip_vertical
	sub	cl,bl
	add	cx,cx
	mov	word[SPR_WIDTH],cx
	mov	ecx,0xFFFFFF00
	mov	cl,byte[5+esi+edx]
	mov	byte[SPR_FLIP_FLAG],1
        jmp     short _3dv2_fin_flip
_3dv2_pas_flip_vertical:	
	movzx	ecx,bl
	add	bx,bx
	mov	word[SPR_WIDTH],bx
	mov	byte[SPR_FLIP_FLAG],0
_3dv2_fin_flip:	

	movzx	ebx,word[6+esi+edx]
	ror	bx,8
	add	bx,cx

	shl	word[SPR_WIDTH],1
	shl	ebx,2
	mov	cl,byte[8+esi+edx]
	and	ecx,0xF
	movzx	eax,byte[_spr_tab+ecx]
	shl	eax,17
	add	ebx,eax

_3dv2_spr_adrs_ok:	
	mov	ecx,dword[_sprites_base_data]
	add	ecx,ebx
	mov	dword[SPR_BASE],ecx

	mov	bl,byte[0+esi+edx]
	sub	bl,byte[1+esi+edx]
	mov	byte[SPR_HEIGHT],bl

	mov	ebx,0
	mov	bl,byte[4+esi+edx]
	mov	byte[SPR_REVERSE_FLAG],bl

;	add 2 to SPR_BASE if rev bit is set
	add	ebx,ebx
	add	dword[SPR_BASE],ebx

;/*	calcul base palette du sprite */
	movzx	ebx,byte[9+esi+edx]
	and	ebx,0x7f
	shl	ebx,5

;	%ebx = palette offset (0000~0fe0)

	mov	eax,ebx
	mov	ebp,ebx
	shr	ebp,1
	shr	eax,4
	add	ebp,_FastPaletteSet2

	push	edx

	cmp	bx,word[_FastPaletteData2+eax]
        je      _3dv2_no_color_init_spr
	mov	word[_FastPaletteData2+eax],ax

	add	ebx,dword[_base_palette_sprite]
	mov	dword[SPR_COLOR],ebx

	mov	eax,15
_3dv2_init_color_spr:	
	mov	ebx,eax
	add	ebx,ebx

	add	ebx,dword[SPR_COLOR]
	movzx	ecx,word[ebx]

	call	alloc_color

	dec	eax
        jnz     _3dv2_init_color_spr

_3dv2_no_color_init_spr:	
	mov	eax,dword[SPR_BASE]

	cmp	word[SPR_ZOOM],1024
	jae	near _3dv2_sprite_zoomup

	test	byte[SPR_FLIP_FLAG],1
        jnz     _3dv2_sprite_flip_selection

	test	byte[SPR_REVERSE_FLAG],1
	jnz	near _3dv2_sprite_reverse_pre
	test	byte[SPR_REVERSE_FLAG],2
	jnz	near _3dv2_sprite_rightup_pre
	jmp	_3dv2_sprite_normal_pre

_3dv2_sprite_flip_selection:	
	test	byte[SPR_REVERSE_FLAG],1
	jz	near _3dv2_sprite_flip_reverse_pre
	jmp	_3dv2_sprite_flip_normal_pre

_3dv2_sprite_zoomup:	
	sub	word[SPR_ZOOM],1024
	sub	word[SPR_ZOOMX0],1024
	sub	word[SPR_ZOOMY0],1024

	test	byte[SPR_FLIP_FLAG],1
        jnz     _3dv2_zoomup_sprite_flip_selection

        test    byte[SPR_REVERSE_FLAG],1
        jnz     near _3dv2_zoomup_sprite_reverse_pre
        test    byte[SPR_REVERSE_FLAG],2
        jnz     near _3dv2_zoomup_sprite_rightup_pre
	jmp	_3dv2_zoomup_sprite_normal_pre

_3dv2_zoomup_sprite_flip_selection:	
	test	byte[SPR_REVERSE_FLAG],1
	jz	near _3dv2_zoomup_sprite_flip_reverse_pre
	jmp	_3dv2_zoomup_sprite_flip_normal_pre




;//////	SPRITE: ZOOM DOWN VERSION////////////////////////////////////
;//////	ZOOM RATE = 1024/(1024+W), W:0~1023

_3dv2_sprite_normal_pre:	
	push	esi
	push	edi
	push	ebx
	mov	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1060

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_sprite_normal:	
	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _3dv2_sprite_normal_drawline
	add	dword[SPR_ZOOMY],1060
	add	esi,dword[SPR_WIDTH]

_3dv2_sprite_normal_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
        jl      _3dv2_sprite_normal_end

	xor	edx,edx

_3dv2_sprite_normal_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0xf0
        jne     _3dv2_sprite_normal_loop_column_2

	add	esi,ebx
        jmp     short _3dv2_sprite_normal_nextline


_3dv2_sprite_normal_loop_column_2:	
;	draw p0
	shr	eax,4
        jz      _3dv2_sprite_normal_p0_trans
	cmp	al,0x0F
        je      _3dv2_sprite_normal_p0_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_normal_p0_trans:	
	movzx	eax,byte[esi]
	inc	edi

	sub	edx,ecx
        jg      _3dv2_sprite_normal_p1
	add	edx,1024
        jmp     short _3dv2_sprite_normal_nextbyte

_3dv2_sprite_normal_p1:	
	sub	edx,ecx

;	draw p1
	and	eax,0x0f
        jz      _3dv2_sprite_normal_p1_trans
	cmp	al,0x0F
        je      _3dv2_sprite_normal_p1_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_normal_p1_trans:	
	inc	edi


_3dv2_sprite_normal_nextbyte:	
	inc	esi
	dec	ebx
        jnz     _3dv2_sprite_normal_loop_column

_3dv2_sprite_normal_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
        jnz     near _3dv2_sprite_normal

_3dv2_sprite_normal_end:	
	pop	ebx
	pop	edi
	pop	esi
	jmp	_3dv2_fin_du_sprite










_3dv2_sprite_reverse_pre:	
	push	esi
	mov	esi,eax
	mov	eax,dword[SPR_WIDTH]
	inc	esi
	push	edi
	sub	esi,eax
	push	ebx
	sub	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]

	mov	dword[SPR_ZOOMY],1060

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_sprite_reverse:	
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax
	add	esi,eax

	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _3dv2_sprite_reverse_drawline
	add	dword[SPR_ZOOMY],1060
	add	esi,eax

_3dv2_sprite_reverse_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
	jl	near _3dv2_sprite_normal_end

	xor	edx,edx

_3dv2_sprite_reverse_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0x0f
        jne     _3dv2_sprite_reverse_loop_column_2

	sub	esi,ebx
        jmp     short _3dv2_sprite_reverse_nextline


_3dv2_sprite_reverse_loop_column_2:	

;	draw p0
	and	eax,0x0f
        jz      _3dv2_sprite_reverse_p0_trans
	cmp	al,0x0f
        je      _3dv2_sprite_reverse_p0_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_reverse_p0_trans:	
	movzx	eax,byte[esi]
	inc	edi

	sub	edx,ecx
        jg      _3dv2_sprite_reverse_p1
	add	edx,1024
        jmp     short _3dv2_sprite_reverse_nextbyte

_3dv2_sprite_reverse_p1:	
	sub	edx,ecx

;	draw p1
	shr	eax,4
        jz      _3dv2_sprite_reverse_p1_trans
	cmp	al,0x0f
        je      _3dv2_sprite_reverse_p1_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_reverse_p1_trans:	
	inc	edi


_3dv2_sprite_reverse_nextbyte:	
	dec	esi
	dec	ebx
        jnz     _3dv2_sprite_reverse_loop_column

_3dv2_sprite_reverse_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _3dv2_sprite_reverse
	jmp	_3dv2_sprite_normal_end





_3dv2_fin_du_sprite:	
	pop	edx
_3dv2_sprite_non_actif:	
	add	dx,16
	cmp	dx,word[END_OF_SPRITE]
	ja	near _3dv2_fin_des_sprites
	jmp	_3dv2_sprite_loop
_3dv2_fin_des_sprites:	
	ret






_3dv2_sprite_rightup_pre:	

	push	esi
	mov	esi,eax
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax

	sub	esi,5

	push	edi
	sub	esi,eax
	push	ebx
	sub	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1060

	sub	dword[SCR_BASE],2

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_sprite_rightup:	
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax
	add	esi,eax

	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _3dv2_sprite_rightup_drawline
	add	dword[SPR_ZOOMY],1060
	add	esi,eax

_3dv2_sprite_rightup_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
	jl	near _3dv2_sprite_normal_end

	xor	edx,edx

_3dv2_sprite_rightup_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0x0f
        jne     _3dv2_sprite_rightup_loop_column_2

	sub	esi,ebx
        jmp     short _3dv2_sprite_rightup_nextline


_3dv2_sprite_rightup_loop_column_2:	

;	draw p0
	and	eax,0x0f
        jz      _3dv2_sprite_rightup_p0_trans
	cmp	al,0x0f
        je      _3dv2_sprite_rightup_p0_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_rightup_p0_trans:	
	movzx	eax,byte[esi]
	dec	edi

	sub	edx,ecx
        jg      _3dv2_sprite_rightup_p1
	add	edx,1024
        jmp     short _3dv2_sprite_rightup_nextbyte

_3dv2_sprite_rightup_p1:	
	sub	edx,ecx

;	draw p1
	shr	eax,4
        jz      _3dv2_sprite_rightup_p1_trans
	cmp	al,0x0F
        je      _3dv2_sprite_rightup_p1_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al

_3dv2_sprite_rightup_p1_trans:	
	dec	edi


_3dv2_sprite_rightup_nextbyte:	
	dec	esi
	dec	ebx
        jnz     _3dv2_sprite_rightup_loop_column

_3dv2_sprite_rightup_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _3dv2_sprite_rightup
	jmp	_3dv2_sprite_normal_end






_3dv2_sprite_flip_reverse_pre:	
	jmp	_3dv2_sprite_normal_end






_3dv2_sprite_flip_normal_pre:	
	jmp	_3dv2_sprite_normal_end








ZOOMUP_X_LIMIT:	equ  1024
ZOOMUP_Y_LIMIT:	equ  1024

;//////	SPRITE: ZOOM UP VERSION ///////////////////////////
;//////	ZOOM RATE = 1024/(1024-W)  W:0~512

_3dv2_zoomup_sprite_normal_pre:	
	push	esi
	push	edi
	push	ebx
	mov	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1024

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_zoomup_sprite_normal:	
	mov	eax,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],eax
        jg      _3dv2_zoomup_sprite_normal_drawline

	add	dword[SPR_ZOOMY],1024

;	back one source line to repeat last line
	sub	esi,dword[SPR_WIDTH]

_3dv2_zoomup_sprite_normal_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width
	xor	edx,edx

	cmp	dword[_display_bottom],edi
        jl      near _3dv2_sprite_normal_end


_3dv2_zoomup_sprite_normal_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0xf0
        jne     _3dv2_zoomup_sprite_normal_loop_column_2

	add	esi,ebx
        jmp     _3dv2_zoomup_sprite_normal_nextline

_3dv2_zoomup_sprite_normal_loop_column_2:	

;	draw p0
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_normal_p0_single_dot
_3dv2_zoomup_sprite_normal_p0_double_dot:	
	add	edx,1024
	sub	edx,ecx
	shr	eax,4
        jz      _3dv2_zoomup_sprite_normal_p0_double_dot_trans
	cmp	eax,0x0f
        je      _3dv2_zoomup_sprite_normal_p0_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[1+edi],al
_3dv2_zoomup_sprite_normal_p0_double_dot_trans:	
	add	edi,2
        jmp     short _3dv2_zoomup_sprite_normal_p1

_3dv2_zoomup_sprite_normal_p0_single_dot:	
	shr	eax,4
        jz      _3dv2_zoomup_sprite_normal_p0_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_normal_p0_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_normal_p0_single_dot_trans:	
	inc	edi

_3dv2_zoomup_sprite_normal_p1:	
	movzx	eax,byte[esi]

;	draw p1
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_normal_p1_single_dot
_3dv2_zoomup_sprite_normal_p1_double_dot:	
	add	edx,1024
	sub	edx,ecx
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_normal_p1_double_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_normal_p1_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[1+edi],al
_3dv2_zoomup_sprite_normal_p1_double_dot_trans:	
	add	edi,2
        jmp     short _3dv2_zoomup_sprite_normal_nextbyte

_3dv2_zoomup_sprite_normal_p1_single_dot:	
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_normal_p1_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_normal_p1_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_normal_p1_single_dot_trans:	
	inc	edi


_3dv2_zoomup_sprite_normal_nextbyte:	
	inc	esi
	dec	ebx
        jnz     near _3dv2_zoomup_sprite_normal_loop_column

_3dv2_zoomup_sprite_normal_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _3dv2_zoomup_sprite_normal

_3dv2_zoomup_sprite_normal_end:	
	pop	ebx
	pop	edi
	pop	esi
	jmp	_3dv2_fin_du_sprite










_3dv2_zoomup_sprite_reverse_pre:	
	push	esi
	mov	esi,eax
	mov	eax,dword[SPR_WIDTH]
	inc	esi
	push	edi
	sub	esi,eax
	push	ebx
	sub	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1024

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_zoomup_sprite_reverse:	
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax
	add	esi,eax

	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _3dv2_zoomup_sprite_reverse_drawline

	add	dword[SPR_ZOOMY],1024

;	back one source line to repeat last line
	sub	esi,eax

_3dv2_zoomup_sprite_reverse_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
	jl	near _3dv2_sprite_normal_end

	xor	edx,edx

_3dv2_zoomup_sprite_reverse_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0x0f
        jne     _3dv2_zoomup_sprite_reverse_loop_column_2

	sub	esi,ebx
	jmp	_3dv2_zoomup_sprite_reverse_nextline

_3dv2_zoomup_sprite_reverse_loop_column_2:	

;	draw p0
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_reverse_p0_single_dot
_3dv2_zoomup_sprite_reverse_p0_double_dot:	
	add	edx,1024
	sub	edx,ecx
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_reverse_p0_double_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_reverse_p0_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[1+edi],al
_3dv2_zoomup_sprite_reverse_p0_double_dot_trans:	
	add	edi,2
        jmp     short _3dv2_zoomup_sprite_reverse_p1

_3dv2_zoomup_sprite_reverse_p0_single_dot:	
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_reverse_p0_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_reverse_p0_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_reverse_p0_single_dot_trans:	
	inc	edi

_3dv2_zoomup_sprite_reverse_p1:	
	movzx	eax,byte[esi]

;	draw p1
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_reverse_p1_single_dot
_3dv2_zoomup_sprite_reverse_p1_double_dot:	
	add	edx,1024
	sub	edx,ecx
	shr	eax,4
        jz      _3dv2_zoomup_sprite_reverse_p1_double_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_reverse_p1_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[1+edi],al
_3dv2_zoomup_sprite_reverse_p1_double_dot_trans:	
	add	edi,2
        jmp     short _3dv2_zoomup_sprite_reverse_nextbyte

_3dv2_zoomup_sprite_reverse_p1_single_dot:	
	shr	eax,4
        jz      _3dv2_zoomup_sprite_reverse_p1_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_reverse_p1_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_reverse_p1_single_dot_trans:	
	inc	edi


_3dv2_zoomup_sprite_reverse_nextbyte:	
	dec	esi
	dec	ebx
	jnz	near _3dv2_zoomup_sprite_reverse_loop_column

_3dv2_zoomup_sprite_reverse_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _3dv2_zoomup_sprite_reverse
	jmp	_3dv2_zoomup_sprite_normal_end




_3dv2_zoomup_sprite_rightup_pre:	
	push	esi
	mov	esi,eax
	mov	eax,dword[SPR_WIDTH]

	add	esi,eax
	sub	esi,5

	push	edi
	sub	esi,eax
	push	ebx
	sub	esi,eax

	mov	ecx,dword[SPR_ZOOMX0]
	mov	dword[SPR_ZOOMY],1024

;	edx: zoomx accu. ecx: zoomx const.

;	start a line
_3dv2_zoomup_sprite_rightup:	
	mov	eax,dword[SPR_WIDTH]
	add	esi,eax
	add	esi,eax

	mov	edx,dword[SPR_ZOOMY0]
	sub	dword[SPR_ZOOMY],edx
        jg      _3dv2_zoomup_sprite_rightup_drawline

	add	dword[SPR_ZOOMY],1024

;	back one source line to repeat last line
	sub	esi,eax

_3dv2_zoomup_sprite_rightup_drawline:	
	mov	edi,dword[SCR_BASE]
	mov	ebx,dword[SPR_WIDTH]
;	ebx: width

	cmp	dword[_display_bottom],edi
	jl	near _3dv2_sprite_normal_end

	xor	edx,edx

_3dv2_zoomup_sprite_rightup_loop_column:	
	movzx	eax,byte[esi]

;	Altered Beast black-hole patch : the economical way
	cmp	al,0x0f
        jne     _3dv2_zoomup_sprite_rightup_loop_column_2

	sub	esi,ebx
	jmp	_3dv2_zoomup_sprite_rightup_nextline

_3dv2_zoomup_sprite_rightup_loop_column_2:	

;	draw p0
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_rightup_p0_single_dot
_3dv2_zoomup_sprite_rightup_p0_double_dot:	
	add	edx,1024
	sub	edx,ecx
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_rightup_p0_double_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_rightup_p0_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[-1+edi],al
_3dv2_zoomup_sprite_rightup_p0_double_dot_trans:	
	sub	edi,2
        jmp     short _3dv2_zoomup_sprite_rightup_p1

_3dv2_zoomup_sprite_rightup_p0_single_dot:	
	and	eax,0x0f
        jz      _3dv2_zoomup_sprite_rightup_p0_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_rightup_p0_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_rightup_p0_single_dot_trans:	
	dec	edi

_3dv2_zoomup_sprite_rightup_p1:	
	movzx	eax,byte[esi]

;	draw p1
	sub	edx,ecx
        jg      _3dv2_zoomup_sprite_rightup_p1_single_dot
_3dv2_zoomup_sprite_rightup_p1_double_dot:	
	add	edx,1024
	sub	edx,ecx
	shr	eax,4
        jz      _3dv2_zoomup_sprite_rightup_p1_double_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_rightup_p1_double_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
	mov	byte[-1+edi],al
_3dv2_zoomup_sprite_rightup_p1_double_dot_trans:	
	sub	edi,2
        jmp     short _3dv2_zoomup_sprite_rightup_nextbyte

_3dv2_zoomup_sprite_rightup_p1_single_dot:	
	shr	eax,4
        jz      _3dv2_zoomup_sprite_rightup_p1_single_dot_trans
	cmp	al,0x0f
        je      _3dv2_zoomup_sprite_rightup_p1_single_dot_trans
	mov	al,byte[ebp+eax]
	mov	byte[edi],al
_3dv2_zoomup_sprite_rightup_p1_single_dot_trans:	
	dec	edi


_3dv2_zoomup_sprite_rightup_nextbyte:	
	dec	esi
	dec	ebx
	jnz	near _3dv2_zoomup_sprite_rightup_loop_column

_3dv2_zoomup_sprite_rightup_nextline:	
	add	dword[SCR_BASE],1024
	dec	byte[SPR_HEIGHT]
	jnz	near _3dv2_zoomup_sprite_rightup
	jmp	_3dv2_zoomup_sprite_normal_end










_3dv2_zoomup_sprite_flip_reverse_pre:	
	jmp	_3dv2_zoomup_sprite_normal_end









_3dv2_zoomup_sprite_flip_normal_pre:	
	jmp	_3dv2_zoomup_sprite_normal_end









	global	  _ScanlinesBlit320
_ScanlinesBlit320:	
	push	es
	mov	es,word[_VIDEOSEG]
	pushad

	mov	edi,dword[_VIDEOPTR]
	mov	esi,dword[_SOURCEPTR]
        mov     edx,224
	mov	eax,dword[_LINEOFFSET]
        shl     eax,1
	sub	eax,320
__nb:	
        mov     ecx,80
        rep
        movsd

	add	esi,704
	add	edi,eax

	dec	edx
        jne     __nb

	popad
	pop	es
	ret


	global	  _ScanlinesBlit640
_ScanlinesBlit640:
	push	es
	mov	es,word[_VIDEOSEG]
	pushad

	mov	edi,dword[_VIDEOPTR]
	mov	esi,dword[_SOURCEPTR]
	mov	eax,dword[_LINEOFFSET]
        shl     eax,1
        sub     eax,640
        mov     edx,224
__nb2:	
	push	eax
	mov	ecx,80
lll:
	lodsd
	mov	ebx,eax
	bswap	eax
	xchg	bx,ax
	rol	eax,8
	stosd
	mov	eax,ebx
	ror	eax,8
	stosd
        loop lll
	pop	eax

	add	esi,704
	add	edi,eax

	dec	edx
        jne     __nb2

	popad
	pop	es
	ret

        global    _ScanlinesBlit640_2
_ScanlinesBlit640_2:
	push	es
	mov	es,word[_VIDEOSEG]
	pushad

	mov	edi,dword[_VIDEOPTR]
	mov	esi,dword[_SOURCEPTR]
	mov	eax,dword[_LINEOFFSET]
;        shl     eax,1
        sub     eax,640
        mov     edx,224
__nb2_2:
	push	eax
	mov	ecx,80
lll_2:
	lodsd
	mov	ebx,eax
	bswap	eax
	xchg	bx,ax
	rol	eax,8
	stosd
	mov	eax,ebx
	ror	eax,8
	stosd
        loop lll_2
        pop     eax

        sub     esi,320
        add     edi,eax
        push    eax

        mov     ecx,80
lll_3:
	lodsd
	mov	ebx,eax
	bswap	eax
	xchg	bx,ax
	rol	eax,8
	stosd
	mov	eax,ebx
	ror	eax,8
	stosd
        loop lll_3
        pop     eax


        add     esi,704
	add	edi,eax

	dec	edx
        jne     __nb2_2

	popad
	pop	es
        ret

        times   ($$-$) & 3 nop
        global    _ScanlinesBlit1024
_ScanlinesBlit1024:
	push	es
        push    ds

	pushad

	mov	edi,dword[_VIDEOPTR]
	mov	esi,dword[_SOURCEPTR]
        mov     edx,dword[_LINEOFFSET]

        mov     dword[CPT_LINE],224
        push    ds
        pop     es

        mov     ds,word[_VIDEOSEG]

__nb22:
        mov     ecx,80
lll23:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],ah
        shr     eax,8
        mov     byte[edi+4],al
        mov     byte[edi+4+1],al
        mov     byte[edi+4+2],ah
        mov     byte[edi+4+3],ah
        shr     eax,8
        mov     byte[edi+8],al
        mov     byte[edi+8+1],ah
        mov     byte[edi+8+2],ah
        mov     byte[edi+8+3],ah

        add     edi,4*3

        dec     ecx
        jnz     near lll23

        add     edi,edx
        sub     edi,320*3
        sub     esi,320
        mov     ecx,80
lll24:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],ah
        shr     eax,8
        mov     byte[edi+4],al
        mov     byte[edi+4+1],al
        mov     byte[edi+4+2],ah
        mov     byte[edi+4+3],ah
        shr     eax,8
        mov     byte[edi+8],al
        mov     byte[edi+8+1],ah
        mov     byte[edi+8+2],ah
        mov     byte[edi+8+3],ah

        add     edi,4*3

        dec     ecx
        jnz     near lll24

        add     esi,1024-320
        add     edi,edx         ; advance one more line
        add     edi,edx
        sub     edi,320*3

        dec     dword[es:CPT_LINE]
        jnz     near __nb22

	popad
        pop     ds
	pop	es
        ret

        times   ($$-$) & 3 nop
        global    _ScanlinesBlit1280
_ScanlinesBlit1280:
	push	es
        push    ds

	pushad

	mov	edi,dword[_VIDEOPTR]
	mov	esi,dword[_SOURCEPTR]
        mov     edx,dword[_LINEOFFSET]

        mov     dword[CPT_LINE],224
        push    ds
        pop     es

        mov     ds,word[_VIDEOSEG]

__nb222:
        mov     ecx,80
lll232:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al

        add     edi,4

        dec     ecx
        jnz     near lll232

        add     edi,edx
        sub     edi,320*4
        sub     esi,320
        mov     ecx,80
lll242:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al
        shr     eax,8
        add     edi,4
        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],al

        add     edi,4

        dec     ecx
        jnz     near lll242

        add     esi,1024-320
        add     edi,edx         ; advance one more line
        add     edi,edx
        add     edi,edx
        sub     edi,320*4

        dec     dword[es:CPT_LINE]
        jnz     near __nb222

	popad
        pop     ds
	pop	es
        ret


        times   ($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
        global    _VerticalScanlinesBlit1280
_VerticalScanlinesBlit1280:
        push    es
        push    ds
        pushad

        mov     edi,dword[_VIDEOPTR]
        mov     edx,dword[_LINEOFFSET]
        mov     esi,dword[_vdisplay_base]

        push    ds
        pop     es
        mov     ds,word[_VIDEOSEG]

        mov     ebx,320
lll27:
        mov     ecx,224/4
lll28:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],ah
        shr     eax,8
        mov     byte[edi+4],al
        mov     byte[edi+4+1],al
        mov     byte[edi+4+2],ah
        mov     byte[edi+4+3],ah
        shr     eax,8
        mov     byte[edi+8],al
        mov     byte[edi+8+1],ah
        mov     byte[edi+8+2],ah
        mov     byte[edi+8+3],ah

        add     edi,4*3

        dec     ecx
        jnz     lll28

        lea     edi,[edi+edx-(224*3)]
        sub     esi,224/4*4

        mov     ecx,224/4
lll281:
        mov     eax,dword[es:esi]
        add     esi,4

        mov     byte[edi],al
        mov     byte[edi+1],al
        mov     byte[edi+2],al
        mov     byte[edi+3],ah
        shr     eax,8
        mov     byte[edi+4],al
        mov     byte[edi+4+1],al
        mov     byte[edi+4+2],ah
        mov     byte[edi+4+3],ah
        shr     eax,8
        mov     byte[edi+8],al
        mov     byte[edi+8+1],ah
        mov     byte[edi+8+2],ah
        mov     byte[edi+8+3],ah

        add     edi,4*3

        dec     ecx
        jnz     lll281

        lea     edi,[edi+edx*2-(224*3)]

        dec     ebx
        jnz     near lll27

        popad
        pop     ds
        pop     es
        ret


        times   ($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
        global    _VerticalScanlinesBlit1024
_VerticalScanlinesBlit1024:
        push    es
        push    ds
        pushad

        mov     edi,dword[_VIDEOPTR]
        mov     es,word[_VIDEOSEG]
        mov     edx,dword[_LINEOFFSET]
        shl     edx,1
        sub     edx,224*2
        mov     esi,dword[_vdisplay_base]

        mov     dword[CPT_LINE],320
lll271:
        mov     ecx,224/4
lll282:
        lodsd
	mov	ebx,eax
	bswap	eax
	xchg	bx,ax
	rol	eax,8
	stosd
	mov	eax,ebx
	ror	eax,8
        stosd

        loop    lll282

        add     edi,edx

        dec     dword[CPT_LINE]
        jnz     near lll271

        popad
        pop     ds
        pop     es
        ret





;BARTMAN:these	extern definitions have been added manually, because NASM needs them
;	       and AS doesn't need them

	extern	_FastPalette
	extern	_FastPaletteData
	extern	_FastPaletteData2
	extern	_FastPaletteSet
	extern	_FastPaletteSet2
	extern	_LINEOFFSET
	extern	_NewColorsTab
	extern	_Palette256
	extern	_SOURCEPTR
	extern	_VIDEOPTR
	extern	_VIDEOSEG
	extern	_background_active
	extern	_bank_ff_base
	extern	_base_brq_page
	extern	_base_palette_shinobi
	extern	_base_palette_sprite
	extern	_base_scr_hor_bg
	extern	_base_scr_hor_bg2
	extern	_base_scr_hor_bg3
	extern	_base_scr_hor_bg_splittab0
	extern	_base_scr_hor_bg_splittab1
	extern	_base_scr_hor_fg
	extern	_base_scr_pag_bg
	extern	_base_scr_pag_bg2
	extern	_base_scr_pag_bg3
	extern	_base_scr_pag_fg
	extern	_base_scr_ver_bg
	extern	_base_scr_ver_bg2
	extern	_base_scr_ver_bg3
	extern	_base_scr_ver_bg_splittab0
	extern	_base_scr_ver_bg_splittab1
	extern	_base_scr_ver_fg
	extern	_base_spr_regist
	extern	_bg_colormode
	extern	_bg_layer
	extern	_bg_priority
	extern	_bg_text_mode
	extern	_bg_xoffset
	extern	_display_base
	extern	_display_bottom
	extern	_fg_priority
	extern	_foreground_base
	extern	_game
	extern	_gr_bitmap
	extern	_gr_bitmap_width
	extern	_gr_color_flipindex
	extern	_gr_control
	extern	_gr_palette
	extern	_gr_palette_default
	extern	_number_of_new_colors
	extern	_obj_is_32bit
	extern	_pal_data
	extern	_pal_free_head
	extern	_pentium_pro_cpu
	extern	_reverse_bgpage_flag
	extern	_second_road_on
	extern	_spr_limit
	extern	_spr_tab
	extern	_spr_xoffset
	extern	_sprites_base_data
	extern	_text_base
	extern	_tiles_base
	extern	_tiles_transparent
	extern	_vdisplay_base
	extern	_vscreen_base
        extern  _tiles_hi
