#include <stdio.h>
#include <allegro.h>
#include "host.h"
#include "shinobi.h"

typedef struct
   {
      char game_name[40];
      char gcs_name[15];
      char remark[80];
   } t_gcs_list;

static unsigned char boottext[][80] =
   {
      {"Welcome to the System 16 Arcade Emulator v0.82a"},
      {"Presented to you by Thierry Lescot and Li Jih Hwa"},
      {" "},
      {"CREDITS"},
      {"Neill Corlett for his 68000 emulator (Starscream)"},
      {"Neil Bradley for his Z80 emulator"},
      {"Jarek Burczynski for his YM2151 emulator"},
      {"Tatsuyuki Satoh for his YM2151/YM2203C emulator"},
      {"The whole MAME team for their great project and the ZIP code"},
      {"The peoples who provided me the ROMs to emulate :"},
      {"Gerald Coy, Cabbe & Org, Andrea Turci, Paolo Venturi, J-Rom, Tim"},
      {"Kev, Michael Appolo and all the other that I forgot! "},
      {" "},
      {"If you experience any problem when running the emulator, don't forget"},
      {"to READ THE DOCS before e-mailing me or Li Jih Hwa. Thanks."},
      {" "},
      {"This emulator is freeware and can't be sold or distribued with roms !"},
      {" "},
      {" "},
      {"PRESS ANY KEY TO CONTINUE"},
      {"\0"}
   };

extern UINT8 pf_state;

static BITMAP *vi_screen = 0, *my_logo = 0, *msg_box = 0;
static t_gcs_list *gcs;
static int total_gcs = 0, select_gcs = 0;
static int first_gcs = 0;

static int c1x = 40;
static int c2x = 360;
static int c_y = 100;
static int c_Y = 440;
static int c_X = 600;
static RGB bootintf_pal[256];

void sort_list()
{
   t_gcs_list p;
   int i, m, c;
   m = total_gcs;
   c = 0;
   do {
      for (i=0;i!=(m-1);i++) {
         if (strcmp(gcs[i].game_name,gcs[i+1].game_name)>0) {
            c = 1;
            memcpy(&p,&gcs[i],sizeof(t_gcs_list));
            memcpy(&gcs[i],&gcs[i+1],sizeof(t_gcs_list));
            memcpy(&gcs[i+1],&p,sizeof(t_gcs_list));
         }
      }
      m--;
   } while ((c)&&(m));
}

void get_gcs_infos(char *fn, int attr, int p)
{
   FILE *f;
   int i, trouve = 0;
   char gcs_line[256];
   if ((f = fopen(fn,"r")) != NULL) {
      while ((!feof(f))&&(!trouve)) {
         fscanf(f,"%s",gcs_line);
         if (gcs_line[0]=='.') {
            if (!strcmp(gcs_line,".game")) trouve = 1;
         }
      }
      if (trouve) {
         sprintf(gcs[total_gcs].gcs_name,"%s",get_filename(fn));
         fscanf(f,"%s",gcs[total_gcs].game_name);
         for (i=0;i!=strlen(gcs[total_gcs].game_name);i++)
            if (gcs[total_gcs].game_name[i]=='_') gcs[total_gcs].game_name[i] = ' ';
         total_gcs++;
         trouve = 0;
         while ((!feof(f))&&(!trouve)) {
            fscanf(f,"%s",gcs_line);
            if (gcs_line[0]=='!') {
               if (!strcmp(gcs_line,"!REM")) trouve = 1;
            }
         }
         if (trouve) fscanf(f,"%s",gcs[total_gcs-1].remark);
         else gcs[total_gcs-1].remark[0] = 0;
         for (i=0;i!=strlen(gcs[total_gcs-1].remark);i++)
            if (gcs[total_gcs-1].remark[i]=='_') gcs[total_gcs-1].remark[i] = ' ';
      }
      fclose(f);
   }
}

void bi_update(int ut)
{
   vsync();
   switch(ut) {
      case 0:
         blit(vi_screen,screen,0,0,0,0,640,480);
         break;
   }
}

void outline_text(int x, int y, int c, char *txt)
{
   int dx, dy;
   for (dx=-1;dx!=2;dx++) for (dy=-1;dy!=2;dy++)
      textout(vi_screen, font, txt, x+dx, y+dy, 54);
   textout(vi_screen, font, txt, x, y, c);
}

void outline_text_center(int x, int y, int c, char *txt)
{
   int dx, dy;
   for (dx=-1;dx!=2;dx++) for (dy=-1;dy!=2;dy++)
      textout_centre(vi_screen, font, txt, x+dx, y+dy, 54);
   textout_centre(vi_screen, font, txt, x, y, c);
}

void mboutline_text_center(int x, int y, int c, char *txt)
{
   int dx, dy;
   for (dx=-1;dx!=2;dx++) for (dy=-1;dy!=2;dy++)
      textout_centre(msg_box, font, txt, x+dx, y+dy, 54);
   textout_centre(msg_box, font, txt, x, y, c);
}

void redraw_list()
{
   int x, y, i;
   rectfill(vi_screen,c1x,c_y,c_X,c_Y,55);
   x = c1x;
   y = c_y;
   for (i=0;(((first_gcs+i)!=total_gcs)&&(i!=24));i++) {
      if (select_gcs==i) {
         rectfill(vi_screen,c1x,y,c_X,y+16,49);
         rectfill(vi_screen,c1x+1,y+1,c_X-1,y+15,50);
      }
      outline_text(c1x+5,y+5,52,gcs[first_gcs+i].game_name);
      if (gcs[first_gcs+i].remark[0]) {
         outline_text(c2x+5,y+5,51,gcs[first_gcs+i].remark);
      }
      y+=14;
   }
//   text_mode(0);
//   textprintf(vi_screen,font,5,5,255,"total=%02d  select=%02d  first=%02d",total_gcs,select_gcs,first_gcs);
//   text_mode(-1);
}

void redraw_screen_list()
{
   clear_to_color(vi_screen, 255);
   blit(my_logo,vi_screen,0,0,(640-my_logo->w)/2,(c_y-my_logo->h)/2,my_logo->w,my_logo->h);
   rect(vi_screen,c1x-5,c_y-5,c_X+5,c_Y+5,54);
   rect(vi_screen,c1x-4,c_y-4,c_X+4,c_Y+4,53);
   text_mode(-1);
   redraw_list();
   bi_update(0);
}

void draw_first_screen()
{
   int nl = 0, nlt = 0, sp, i, it = 0, col = 51;
   clear_to_color(vi_screen, 255);
   blit(my_logo,vi_screen,0,0,(640-my_logo->w)/2,(c_y-my_logo->h)/2,my_logo->w,my_logo->h);
   rect(vi_screen,c1x-5,c_y-5,c_X+5,c_Y+5,54);
   rect(vi_screen,c1x-4,c_y-4,c_X+4,c_Y+4,53);
   rectfill(vi_screen,c1x-3,c_y-3,c_X+3,c_Y+3,50);
   text_mode(-1);
   while (boottext[nl][0]) {
      nl++;
      if (boottext[nl][0]!=1) nlt++;
   }
   sp = (c_Y-c_y-20)/nlt;
   for (i=0;i!=nl;i++) {
      if (boottext[i][0]>=32) {
         outline_text_center(320,c_y+10+it,col,boottext[i]);
         it+=sp;
      } else {
         col = 40+boottext[i][0];
      }
   }
   
   bi_update(0);
   fade_in(bootintf_pal, 2);

   #ifdef RELEASE
   while (!keypressed());
   #endif
}

int build_screen()
{
   vi_screen = create_bitmap(640,480);
   if (!vi_screen) return 1;
   clear(vi_screen);
   set_menuvideomode();
   memset(bootintf_pal, 0, sizeof(bootintf_pal));
   my_logo = load_bitmap("logo16.pcx", bootintf_pal);
   #define set_bootintf_pal_entry(c, red, green, blue) { bootintf_pal[c].r = red; bootintf_pal[c].g = green; bootintf_pal[c].b = blue; }
   set_bootintf_pal_entry(55,63,63,63);
   set_bootintf_pal_entry(54,0,0,0);
   set_bootintf_pal_entry(53,32,32,32);
   set_bootintf_pal_entry(52,63,50,0);    // jaune pale
   set_bootintf_pal_entry(51,10,63,10);   // vert
   set_bootintf_pal_entry(50,40,40,63);   // fond select
   set_bootintf_pal_entry(49,0,0,0);      // tour select
   set_bootintf_pal_entry(48,63,0,0);     // rouge
   set_bootintf_pal_entry(47,63,63,0);    // jaune vif
   set_bootintf_pal_entry(46,0,0,63);     // bleu
   return 0;
}

int boot_interface(char *p)
{
   int k;

   gcs = (t_gcs_list *)malloc(sizeof(t_gcs_list)*40);
   for_each_file("*.gcs",0, &get_gcs_infos,0);
   sort_list();
   redraw_screen_list();
   clear_keybuf();

   k = 0;
   do {
      if (keypressed()) {
         k = readkey()>>8;
         switch(k) {
            case KEY_UP:
               if (!select_gcs) {
                  if (!first_gcs) {
                     if (total_gcs<=24) select_gcs=total_gcs-1;
                     else {
                        select_gcs = 23;
                        first_gcs = total_gcs - 24;
                     }
                  }
                  else first_gcs--;
               } else select_gcs--;
               redraw_list();
               bi_update(0);
               break;
            case KEY_DOWN:
               if (select_gcs==23) {
                  if ((first_gcs+select_gcs)>=total_gcs-1) {
                     select_gcs = 0;
                     first_gcs = 0;
                  } else first_gcs++;
               } else {
                  select_gcs++;
                  if (select_gcs==total_gcs) select_gcs = 0;
               }
               redraw_list();
               bi_update(0);
               break;
            case KEY_HOME:
               first_gcs = 0;
               select_gcs = 0;
               redraw_list();
               bi_update(0);
               break;
            case KEY_END:
               if (total_gcs>24) {
                  select_gcs = 23;
                  first_gcs = total_gcs - 24;
               } else {
                  select_gcs = total_gcs - 1;
                  first_gcs = 0;
               }
               redraw_list();
               bi_update(0);
               break;
         }
      }
   } while ((k!=KEY_ENTER)&&(k!=KEY_ESC));

   select_gcs+=first_gcs;

   if (k==KEY_ENTER) {
      sprintf(p,"%s",gcs[select_gcs].gcs_name);
      free(gcs);
      return 1;
   }
   free(gcs);
   return 0;
}

int bootintf_off()
{
   if (!vi_screen) return 0;
   fade_out(12);
   rectfill(screen, 0, 0, 639, 479, 0);
   set_gfx_mode(GFX_TEXT,0,0,0,0);
   destroy_bitmap(vi_screen);
   destroy_bitmap(my_logo);
   if (msg_box) destroy_bitmap(msg_box);
   return 0;
}

int first_screen()
{
   if (build_screen()) return 1;
   draw_first_screen();
   return 0;
}

void imessage(char *m1, int ct, int cf, int d, int mode)
{
   int i;
   if (!vi_screen) {
      printf("%s", m1);
      return;
   }
   if (!msg_box) msg_box = create_bitmap(600,50);
   clear_to_color(msg_box, cf);
   rect(msg_box,0,0,599,49,47);
   rect(msg_box,1,1,598,48,47);
   mboutline_text_center(msg_box->w/2,22,ct,m1);
   switch (mode) {
      case 0:
         blit(msg_box,screen,0,0,(640-msg_box->w)/2,(480-msg_box->h)/2,msg_box->w,msg_box->h);
         break;
      case 1:
         for (i=0;i<=300;i+=5) {
            blit(msg_box,screen,300-i,0,20,215,i,50);
            blit(msg_box,screen,300,0,620-i,215,i,50);
            rest(500/(300/5));
         }
         break;
      case 2:
         for (i=0;i<=300;i+=5) {
            blit(msg_box,screen,300-i,0,20,215,i,50);
            blit(msg_box,screen,300,0,620-i,215,i,50);
            rest(50/(300/5));
         }
         break;
   }
   if (d) {
      if (d==1) {
         clear_keybuf();
         while (!keypressed());
         clear_keybuf();
      } else rest(d);
      bi_update(0);
   }
}

void imessage2(char *m1, char *m2)
{
   int ct = 47, cf = 46;
   if (!vi_screen) {
      if (m2) printf("%s\n%s\n", m1, m2); else printf("%s\n", m1);
      return;
   }
   if (!msg_box) msg_box = create_bitmap(600,50);
   clear_to_color(msg_box, cf);
   rect(msg_box,0,0,599,49,47);
   rect(msg_box,1,1,598,48,47);
   if (m2) {
      mboutline_text_center(msg_box->w/2,22-5,ct,m1);
      mboutline_text_center(msg_box->w/2,22+5,ct,m2);
   } else {
      mboutline_text_center(msg_box->w/2,22,ct,m1);
   }
   blit(msg_box,screen,0,0,(640-msg_box->w)/2,(480-msg_box->h)/2,msg_box->w,msg_box->h);
}

void clear_imessage2()
{
   if (vi_screen) bi_update(0);
}

