#include <stdio.h>
#include <allegro.h>
#include "host.h"
#include "main.h"
#include "starcpu.h"

static BITMAP *logo16, *pointeur;
static PALETTE pal, save_pal;
long sound_driver_magic=0x034a;

static char i_menu[20][80], i_menu_keystr[20][10], i_menu_key[20];

static int logo_x, logo_y, m, pgi, pgk;
static int menu_y;
static int ci;
static int choice;

extern char ram_path[80];
extern char game_gcs[], game_name[20], shortname[9], rom_path[80], game;
extern UINT8 sampled_sound_support;

/* variables used by Save/Load game */
extern UINT8 *s16_ptr[0x10000];
extern UINT8 fakeio, vid_bank, pal_bank, txt_bank, spr_bank, reset_palette;

/* variables used by Dip Switches settings */
#define DS_MAX 10
#define DS_MAX_VALUES 8
extern UINT8 total_ds, dipswitch1, dipswitch2;
extern UINT8 ds_mask[DS_MAX], ds_shift[DS_MAX];
extern char ds_values[DS_MAX * DS_MAX_VALUES][20], ds_desc[DS_MAX][30];

/* variable used for the key definition */
extern char labelgen[8][20], labeljoy[8][20];

static char labelkey[10][80];

extern int keydef[50];
extern UINT8 joydef[50];

void Save_GameSRAM(void)
{
   char fn[256];
   PACKFILE *f;
   sprintf(fn, "%s%s.ram", ram_path, shortname);
   printf("Saving game SRAM to %s\n", fn);
   if ((f = pack_fopen(fn, "wp")) != NULL) {
      pack_fwrite(s16_ptr[0xFF], 65536, f);
      pack_fclose(f);
   }
}

void Load_GameSRAM(void)
{
   char fn[256];
   PACKFILE *f;
   sprintf(fn, "%s%s.ram", ram_path, shortname);
   if ((f = pack_fopen(fn, "rp")) != NULL) {
      pack_fread(s16_ptr[0xFF], 65536, f);
      pack_fclose(f);
   }
}

extern UINT8 current_bgm;
int SaveGame(char *fn, char *desc)
{
   extern int num_cpus;
   extern char sav_path[256];
   char game_desc[61], full_path[256];

   sprintf(game_desc, "%s", desc);
   sprintf(full_path, "%s%s", sav_path, fn);
   
   if (num_cpus<=1) { // normal system16/18 game
      FILE *SG;
      extern int save_extra[];
      int i;
     
      if ((SG=fopen(full_path, "wb+")) != NULL) {
         fwrite(game_desc, 60, 1, SG);
         fwrite(&cpu_r[0], 16, 4, SG);
         fwrite(&cpu_pc, 1, 4, SG);
         fwrite(&cpu_tmpf, 1, 4, SG);
         fwrite(&cpu_intmask, 1, 4, SG);
         fwrite(&cpu_odometer, 1, 4, SG);
         fwrite(s16_ptr[vid_bank], 65536, 1, SG);
         fwrite(s16_ptr[pal_bank], 65536, 1, SG);
         fwrite(s16_ptr[txt_bank], 4096, 1, SG);
         fwrite(s16_ptr[spr_bank], 4096, 1, SG);
         fwrite(s16_ptr[0xFF], 65536, 1, SG);
         for (i=0; i<save_extra[0]; i++) {
            fwrite(s16_ptr[(save_extra[1+i*2]&0xff0000)>>16] + (save_extra[1+i*2]&0xffff), save_extra[1+i*2+1], 1, SG);
         }
         fwrite(&sound_driver_magic, sizeof(sound_driver_magic), 1, SG);
         fwrite(&current_bgm, sizeof(current_bgm), 1, SG);
         fwrite(&cpu_asp, 1, 4, SG);
         
         fclose(SG);
      } else return -1;

   } else { // multi-cpu game
      PACKFILE *f;
      extern int save_extra[];
      extern UINT16 txt_offset;
      UINT8 cpu_savebuf[256];
      int old_cpu;
      int i;

      if ((f=pack_fopen(full_path,F_WRITE_PACKED)) != NULL) {
         pack_fwrite(game_desc, 60, f);
         old_cpu=context_switch(0);
         for (i=0; i<num_cpus; i++) {
            context_switch(i);
            save_cpu_content(cpu_savebuf);
            pack_fwrite(cpu_savebuf, sizeof(cpu_savebuf), f);
         }
         pack_fwrite(s16_ptr[vid_bank], 0x10000, f);
         pack_fwrite(s16_ptr[pal_bank], 0x4000, f);
         pack_fwrite(s16_ptr[txt_bank]+txt_offset, 0x1000, f);
         pack_fwrite(s16_ptr[spr_bank], 0x4000, f);
         pack_fwrite(s16_ptr[0xFF], 0x10000, f);
         context_switch(0);
         for (i=0; i<save_extra[0]; i++) {
            pack_fwrite(s16_ptr[(save_extra[1+i*2]&0xff0000)>>16] + (save_extra[1+i*2]&0xffff), save_extra[1+i*2+1], f);
         }
         pack_iputl(sound_driver_magic, f);
         pack_fwrite(&current_bgm, sizeof(current_bgm), f);

         pack_fclose(f);
         context_switch(old_cpu);
      } else return -1;
   }
   return 0;
}

void sound_request(UINT8 sound_cmd);
int LoadGame(char *fn)
{
   extern int num_cpus;
   extern char sav_path[256];
   extern int save_extra[];
   char game_desc[61], full_path[256];

   sprintf(full_path, "%s%s", sav_path, fn);

   if (num_cpus<=1) { // normal system16/18 game
      FILE *SG;
      int i;
      long magic;

      if ((SG=fopen(full_path, "rb")) != NULL) {
         fread(game_desc, 60, 1, SG);
         fread(&cpu_r[0], 16, 4, SG);
         fread(&cpu_pc, 1, 4, SG);
         fread(&cpu_tmpf, 1, 4, SG);
         fread(&cpu_intmask, 1, 4, SG);
         fread(&cpu_odometer, 1, 4, SG);
         fread(s16_ptr[vid_bank], 65536, 1, SG);
         fread(s16_ptr[pal_bank], 65536, 1, SG);
         fread(s16_ptr[txt_bank], 4096, 1, SG);
         fread(s16_ptr[spr_bank], 4096, 1, SG);
         fread(s16_ptr[0xFF], 65536, 1, SG);
         for (i=0; i<save_extra[0]; i++) {
            fread(s16_ptr[(save_extra[1+i*2]&0xff0000)>>16] + (save_extra[1+i*2]&0xffff), save_extra[1+i*2+1], 1, SG);
         }

         magic = -1;
         if (fread(&magic, sizeof(magic), 1, SG) >0 && magic == sound_driver_magic) {
           UINT8 new_music_code;
           fread(&new_music_code, sizeof(current_bgm), 1, SG);
//           printf("get new music code = %02x\n", new_music_code);

           if (new_music_code != current_bgm) {
//             printf("set new bgm %02x\n", new_music_code);
             sound_request(new_music_code);
           }
           mz80exec(1000);
         }
         fread(&cpu_asp, 1, 4, SG);

         fclose(SG);
      } else return -1;
   } else { // multi-cpu game
      PACKFILE *f;
      extern UINT16 txt_offset;
      UINT8 cpu_savebuf[256];
      int old_cpu;
      int i;
      if ((f=pack_fopen(full_path,F_READ_PACKED)) != NULL) {
         pack_fread(game_desc, 60, f);
         old_cpu=context_switch(0);
         for (i=0; i<num_cpus; i++) {
            context_switch(i);
            pack_fread(cpu_savebuf, sizeof(cpu_savebuf), f);
            load_cpu_content(cpu_savebuf);
         }
         pack_fread(s16_ptr[vid_bank], 0x10000, f);
         pack_fread(s16_ptr[pal_bank], 0x4000, f);
         pack_fread(s16_ptr[txt_bank]+txt_offset, 0x1000, f);
         pack_fread(s16_ptr[spr_bank], 0x4000, f);
         pack_fread(s16_ptr[0xFF], 0x10000, f);
         context_switch(0);
         for (i=0; i<save_extra[0]; i++) {
            pack_fread(s16_ptr[(save_extra[1+i*2]&0xff0000)>>16] + (save_extra[1+i*2]&0xffff), save_extra[1+i*2+1], f);
         }

         if (pack_igetl(f) == sound_driver_magic) {
           UINT8 new_music_code;
           pack_fread(&new_music_code, sizeof(current_bgm), f);
//            printf("get new music code = %02x\n", new_music_code);
           if (new_music_code != current_bgm) {
//             printf("set new bgm %02x\n", new_music_code);
             sound_request(new_music_code);
           }
         }

         pack_fclose(f);
         context_switch(old_cpu);
      } else return -1;
  }
  return 0;
}

int I_GetString(int max, char *lab, char *s) {
   int l = (8 * (UINT16)max)+20;
   int x = (640-l)/2;
   char disp[256];
   int k;
   int p;

   clear_keybuf();
   rectfill(screen,x-2,210,x+l+2,269,0);
   rectfill(screen,x,212,x+l,267,18);
   rectfill(screen,x+5,224,x+l-5,265,0);
   rectfill(screen,x+6,225,x+l-6,264,65);
   textout_centre(screen,font,lab,x+(l/2)+1,214,66);
   text_mode(65);
   p = strlen(s);
   do {
      sprintf(disp, " %s_ ", s);
      textout_centre(screen,font,disp,x+(l/2)+1,237,66);
      clear_keybuf();
      k = readkey()&0xFF;
      if (((k>='0')&&(k<='9'))||((k>='A')&&(k<='Z'))||((k>='a')&&(k<='z'))
	  ||(k==' ')||(k==',')||(k=='-')) {
	     if ((k>='a')&&(k<='z')) k-=32;
	     if (p<max) {
		s[p++]=k;
		s[p]=0;
	     }
	  }
      if ((k==8)&&(p)) {
	 s[--p]=0;
      }
   } while ((k!=13)&&(k!=27));
   text_mode(-1);
   return((k==13)? 1:0);
}

void I_Rect(int y, int l, int h, char *texte, int c, int ct)
{
   int x = (640-l)/2;
   rectfill(screen,x+7,y+7,x+l+7,y+h+7,0);
   rectfill(screen,x-2,y-2,x+l+2,y+h+2,35);
   rectfill(screen,x,y,x+l,y+h,c);
   textout_centre(screen,font,texte,x+(l/2)+1,y+(h/2)-3,0);
   textout_centre(screen,font,texte,x+(l/2),y+(h/2)-4,ct);
}

void I_Info(char *t1, char *t2, char *t3)
{
   int l = 500, h = 40, y = 420, x = 70;
   rectfill(screen,x+7,y+7,x+l+7,y+h+7,0);
   rectfill(screen,x-2,y-2,x+l+2,y+h+2,35);
   rectfill(screen,x,y,x+l,y+h,64);
   textout_centre(screen,font,t1,321,426,0);
   textout_centre(screen,font,t1,320,425,69);
   textout_centre(screen,font,t2,321,436,0);
   textout_centre(screen,font,t2,320,435,69);
   textout_centre(screen,font,t3,321,446,0);
   textout_centre(screen,font,t3,320,445,69);
}

void I_Rect2(int y, int lk, int l, int h, char *k, char *texte, int c, int ct)
{
   int x = (640-(l+lk+20))/2;
   int x2 = x + lk + 20;
   rectfill(screen,x+7,y+7,x+lk+7,y+h+7,0);
   rectfill(screen,x-2,y-2,x+lk+2,y+h+2,35);
   rectfill(screen,x,y,x+lk,y+h,c);
   textout_centre(screen,font,k,x+(lk/2)+1,y+(h/2)-3,0);
   textout_centre(screen,font,k,x+(lk/2),y+(h/2)-4,ct);
   rectfill(screen,x2+7,y+7,x2+l+7,y+h+7,0);
   rectfill(screen,x2-2,y-2,x2+l+2,y+h+2,35);
   rectfill(screen,x2,y,x2+l,y+h,c);
   textout_centre(screen,font,texte,x2+(l/2)+1,y+(h/2)-3,0);
   textout_centre(screen,font,texte,x2+(l/2),y+(h/2)-4,ct);
}

static UINT8 initial_palette[]={
0x00,0x00,0x00,
0x02,0x02,0x00,
0x01,0x01,0x02,
0x00,0x00,0x06,
0x00,0x00,0x0a,
0x00,0x00,0x13,
0x00,0x00,0x1b,
0x00,0x00,0x22,
0x00,0x00,0x2a,
0x00,0x00,0x2e,
0x00,0x00,0x31,
0x00,0x00,0x33,
0x00,0x00,0x37,
0x00,0x00,0x39,
0x00,0x00,0x3b,
0x00,0x00,0x3f,
0x09,0x09,0x03,
0x0d,0x0d,0x10,
0x0a,0x12,0x1d,
0x0a,0x25,0x25,
0x25,0x24,0x04,
0x1e,0x20,0x1e,
0x1d,0x24,0x24,
0x25,0x24,0x24,
0x13,0x23,0x2a,
0x0b,0x2d,0x2d,
0x2a,0x2a,0x29,
0x2b,0x2b,0x2e,
0x00,0x34,0x34,
0x00,0x3b,0x3b,
0x00,0x3d,0x3d,
0x00,0x3f,0x3f,
0x31,0x31,0x00,
0x37,0x37,0x00,
0x3b,0x3b,0x00,
0x3f,0x3f,0x00,
0x30,0x2b,0x1c,
0x2f,0x2d,0x2d,
0x31,0x2d,0x2d,
0x35,0x2d,0x2d,
0x2f,0x2f,0x2f,
0x31,0x2f,0x2f,
0x30,0x30,0x30,
0x2f,0x2f,0x35,
0x31,0x31,0x31,
0x32,0x32,0x34,
0x36,0x33,0x33,
0x3b,0x34,0x34,
0x34,0x34,0x3a,
0x37,0x37,0x3b,
0x39,0x39,0x39,
0x39,0x39,0x3d,
0x3b,0x37,0x37,
0x3b,0x39,0x39,
0x3b,0x3b,0x3b,
0x3b,0x3b,0x3d,
0x3b,0x3b,0x3f,
0x3d,0x37,0x37,
0x3d,0x39,0x39,
0x3d,0x3d,0x3d,
0x3d,0x3d,0x3f,
0x3f,0x37,0x37,
0x3f,0x3b,0x3b,
0x3f,0x3f,0x3f,
0x3f,0x00,0x00,
0x3f,0x20,0x00,
0x3f,0x3f,0x3f,

0x19,0x25,0x00, /* 67 */
0x25,0x19,0x00, /* 68 */
0x00,0x3e,0x00, /* 69 */

};

void I_Clear()
{
   int i;
   fade_out(12);
   rectfill(screen,0,0,639,479,63);
   blit(logo16, screen, 0, 0, logo_x, logo_y, logo16->w, logo16->h);
   text_mode(-1);
   textout_centre(screen, font, "BY LI JIH HWA AND THIERRY LESCOT", m, 100, 15);

   for (i=0; i<sizeof(initial_palette)/3; i++) {
     pal[i].r = initial_palette[i*3+0];
     pal[i].g = initial_palette[i*3+1];
     pal[i].b = initial_palette[i*3+2];
   }
   fade_in(pal, 12);
}

void I_NewMenu()
{
   ci = 0;
   pgi = 0;
   pgk = 0;
}

void I_SetItem(char *text_key, char *text, UINT8 key)
{
   sprintf(i_menu[ci], "%s", text);
   sprintf(i_menu_keystr[ci], "%s", text_key);
   i_menu_key[ci] = key;
   if (strlen(text)>pgi) pgi = strlen(text);
   if (strlen(text_key)>pgk) pgk = strlen(text_key);
   ci++;
}

void I_BuildMenu(int e)
{
   int i, h;
   pgi = pgi * 8 + 20;
   pgk = pgk * 8 + 20;
   h = 41;
   do {
      h--;
      i = ci * h;
   } while (i > 380-12);

   menu_y = 100 + ((380 - (ci * h)) / 2);
   for (i=0;i!=ci;i++) {
      if (!i) I_Rect(menu_y + h * i, pgi+20+pgk, h/2, i_menu[i], 64, 63);
      else I_Rect2(menu_y + h * i, pgk, pgi, h/2, i_menu_keystr[i], i_menu[i], 15, 63);
   }
}

int I_RunMenu(void)
{
   int choix, i;
   int k;
   choix = -2;
   do {
      while (!keypressed());
      if (keypressed) {
	 k = (readkey()>>8);
	 for (i=1;i!=ci;i++) if (i_menu_key[i] == k) choix = k;
      }
   } while (choix==-2);
   return choix;
}

void sub_menu_savegame(void)
{
   int i;
   char fn[256], game_desc[61], key[3];
   int choicx;
   
   do {
      I_Clear();
      I_NewMenu();
      I_SetItem("", "SELECT ONE SLOT",0);
      for (i=0; i<10; i++) {
         extern int num_cpus;
         extern char sav_path[80];
         
         sprintf(fn, "%s%s.sa%d", sav_path, shortname, (i+1)%10);
         if (num_cpus<=1) {
            FILE *f;
            if ((f=fopen(fn, "rb")) != NULL) {
               fread(game_desc, 60, 1, f);
               fclose(f);
            } else sprintf(game_desc, "%s", "FREE");
         } else {
            PACKFILE *pf; 
            if ((pf=pack_fopen(fn, F_READ_PACKED)) != NULL) {
               pack_fread(game_desc, 60, pf);
               pack_fclose(pf);
            } else sprintf(game_desc, "%s", "FREE");
         }
         sprintf(key, "%c", 48+i+((i==9)? -9:1));
         I_SetItem(key, game_desc, KEY_1 + i);
      }
      I_SetItem("ESC", "BACK TO MENU", KEY_ESC);
      I_BuildMenu(1);
      choicx = I_RunMenu();
      if ((choicx>=KEY_1)&&(choicx<=KEY_0)) {
         int index = choicx - KEY_1;
         strcpy(game_desc, i_menu[index+1]);
         if (I_GetString(60, "ENTER A DESCRIPTION", game_desc)) {
            sprintf(fn, "%s.sa%d", shortname, (index+1)%10);
            SaveGame(fn, game_desc);
         }
      }
      if (choicx==KEY_ESC) break;
   } while (1);
}

extern int trace_play_mode, current_tpl_slot;
void sub_menu_recordmovie(void)
{
   int i;
   char fn[256], game_desc[61], key[3];
   int choicx;

   if (trace_play_mode == 1) { // already in recording : stop recording
      save_tpl_data();
      trace_play_mode = 0;
      message_emul(-1, 2, "STOP RECORDING"); // -1 for deferred display
      return;
   }
  
   do {
      I_Clear();
      I_NewMenu();
      I_SetItem("", "SELECT ONE SLOT",0);
      for (i=0;i!=10;i++) {
         extern int num_cpus;
         extern char movie_path[80];
         
         sprintf(fn, "%s%s.mo%d", movie_path, shortname, (i+1)%10);
         {
            PACKFILE *pf; 
            if ((pf=pack_fopen(fn, F_READ_PACKED)) != NULL) {
               pack_fread(game_desc, 60, pf);
               pack_fclose(pf);
            } else sprintf(game_desc, "%s", "FREE");
         }
         sprintf(key, "%c", 48+i+((i==9)? -9:1));
         I_SetItem(key, game_desc, KEY_1 + i);
      }
      I_SetItem("ESC", "BACK TO MENU", KEY_ESC);
      I_BuildMenu(1);
      choicx = I_RunMenu();
      if ((choicx>=KEY_1)&&(choicx<=KEY_0)) {
         int index = choicx - KEY_1;
         strcpy(game_desc, i_menu[index+1]);
         if (I_GetString(60, "ENTER A DESCRIPTION", game_desc)) {
            extern UINT8 cur_trace_play_state[16];

            current_tpl_slot = (index+1)%10; // set current slot
  
            if (start_record_tpl(cur_trace_play_state, game_desc) == 0) {;
              trace_play_mode = 1;
              message_emul(-1, 2, "START RECORDING"); // -1 for deferred display
            }

            choice=KEY_ESC; // quick leave from main menu
            return;
         }
      }
      if (choicx==KEY_ESC) break;
   } while (1);
}

int sub_menu_playmovie() {
   int i, choicx;
   char fn[256], game_desc[61], key[3];
   FILE *f;
   
   if (trace_play_mode == 2) { // stop playing
     trace_play_mode = 0;
     message_emul(-1, 2, "STOP PLAYING"); // -1 for deferred display
     return;
   }
   
   while (1) {
      I_Clear();
      I_NewMenu();
      I_SetItem("", "SELECT MOVIE TO PLAY",0);
      for (i=0; i<10; i++) {
         extern int num_cpus;
         extern char movie_path[80];
         sprintf(fn, "%s%s.mo%d", movie_path, shortname, (i+1)%10);
         {
            PACKFILE *pf; 
            if ((pf=pack_fopen(fn, F_READ_PACKED)) != NULL) {
               pack_fread(game_desc, 60, pf);
               pack_fclose(pf);
            } else sprintf(game_desc, "%s", "FREE");
         }
         sprintf(key, "%c", 48+i+((i==9)? -9:1));
         I_SetItem(key, game_desc, KEY_1 + i);
      }
      I_SetItem("ESC", "BACK TO MENU", KEY_ESC);
      I_BuildMenu(1);
      choicx = I_RunMenu();
      if ((choicx>=KEY_1)&&(choicx<=KEY_0)) {
         extern UINT8 cur_trace_play_state[16];

         if (trace_play_mode == 1) { // already in recording
           save_tpl_data();
         }

         current_tpl_slot = (choicx-KEY_1+1)%10; // set current slot

         if (load_tpl_data() == 0) {
           trace_play_mode = 2;
           start_play_tpl(cur_trace_play_state);
           message_emul(-1, 2, "START PLAYING"); // -1 for deferred display
           choice=KEY_ESC; // quick leave from main menu
           return(0);
         }

      }
      if (choicx==KEY_ESC) return(1);
   }
}

void RoundFont(char *texte, int x, int y, int c1, int c2)
{
   int ix, iy;
   for (ix=-1;ix!=2;ix++) for (iy=-1;iy!=2;iy++)
     textout(screen,font,texte,x+ix,y+iy,c1);
   textout(screen,font,texte,x,y,c2);
}

void RoundFont_Centre(char *texte, int y, int c1, int c2)
{
   int ix, iy;
   for (ix=-1;ix!=2;ix++) for (iy=-1;iy!=2;iy++)
     textout_centre(screen,font,texte,320+ix,y+iy,c1);
   textout_centre(screen,font,texte,320,y,c2);
}

void dip_display(int n)
{
   rectfill(screen,328,188+15*n,640,202+15*n,63);
   if (n) {
      RoundFont(ds_values[(DS_MAX_VALUES*(n-1))+((dipswitch2&ds_mask[n-1])>>ds_shift[n-1])],330,190+15*n,67,69);
   } else {
      if (dipswitch1) RoundFont("FREE PLAY",330,190,67,69);
      else RoundFont("INSERT COINS",330,190,67,69);
   }
}

void dipswitch(void)
{
   int i, k, choix=0;
   UINT8 t1, t2;

   I_Clear();
   I_Rect(150,320,20,"DIP SWITCHES SETTINGS",64,35);
   I_Info("press UP and DOWN to select","press LEFT and RIGHT to change value","press RETURN to exit");
   for (i=0;i<=total_ds;i++) {
      if (i) RoundFont(ds_desc[i-1],310-text_length(font,ds_desc[i-1]),190+15*i,68,65);
      else RoundFont("COINS MODE",230,190,68,65);
      dip_display(i);
   }
   do {
      do {
	 rect(screen, 100, 187+15*choix, 540, 199+15*choix, 210+((read_timer()>>4)&0xF));
      } while (!keypressed());
      rect(screen,100,187+15*choix,540,199+15*choix,63);
      k = readkey()>>8;
      switch (k) {
       case KEY_UP: choix=((choix)? choix-1:total_ds); break;
       case KEY_DOWN: choix=((choix==total_ds)? 0:choix+1); break;
       case KEY_LEFT:
	 if (choix) {
	    t1 = ((dipswitch2&ds_mask[choix-1])>>ds_shift[choix-1])-1;
	    t2 = dipswitch2&(~ds_mask[choix-1]);
	    t1 = (t1<<ds_shift[choix-1])&ds_mask[choix-1];
	    dipswitch2 = t2|t1;
	 } else {
	    dipswitch1=~dipswitch1;
	 };
	 dip_display(choix);
	 break;
       case KEY_RIGHT:
	 if (choix) {
	    t1 = ((dipswitch2&ds_mask[choix-1])>>ds_shift[choix-1])+1;
	    t2 = dipswitch2&(~ds_mask[choix-1]);
	    t1 = (t1<<ds_shift[choix-1])&ds_mask[choix-1];
	    dipswitch2 = t2|t1;
	 } else {
	    dipswitch1=~dipswitch1;
	 };
	 dip_display(choix);
	 break;
      }
   } while (k!=KEY_ENTER && k!=KEY_ESC);
}

int sub_menu_loadgame() {
   int i, choicx;
   char fn[256], game_desc[61], key[3];
   FILE *f;
   
   while (1) {
      I_Clear();
      I_NewMenu();
      I_SetItem("", "SELECT GAME TO LOAD",0);
      for (i=0; i<10; i++) {
         extern int num_cpus;
         extern char sav_path[80];
         sprintf(fn, "%s%s.sa%d", sav_path, shortname, (i+1)%10);
         if (num_cpus<=1) {
            if ((f=fopen(fn, "rb")) != NULL) {
               fread(game_desc, 60, 1, f);
               fclose(f);
            } else sprintf(game_desc, "%s", "FREE");
         } else {
            PACKFILE *pf; 
            if ((pf=pack_fopen(fn, F_READ_PACKED)) != NULL) {
               pack_fread(game_desc, 60, pf);
               pack_fclose(pf);
            } else sprintf(game_desc, "%s", "FREE");
         }
         sprintf(key, "%c", 48+i+((i==9)? -9:1));
         I_SetItem(key, game_desc, KEY_1 + i);
      }
      I_SetItem("ESC", "BACK TO MENU", KEY_ESC);
      I_BuildMenu(1);
      choicx = I_RunMenu();
      if ((choicx>=KEY_1)&&(choicx<=KEY_0)) {
         sprintf(fn, "%s.sa%d", shortname, (choicx-KEY_1+1)%10);
         LoadGame(fn);
         choice=KEY_ESC; // quick leave from main menu
         return(0);
      }
      if (choicx==KEY_ESC) return(1);
   }
}

void Error(char *txt)
{
   I_Rect(230, text_length(font, txt)+20, 15, txt, 64, 63);
   clear_keybuf();
   while (!keypressed());
   clear_keybuf();
}

void redefine_keys(int is)
{
   int i, iv, ok;
   int k, b;
   char txt[256];
   extern UINT8 joystick_support;

   I_Clear();
   for (i=0; i<10; i++) {
      if (labelkey[i][0]) {
	 do {
	    ok = 1;
	    sprintf(txt, "PRESS KEY OR BUTTON FOR '%s'. (ESC TO PASS)", labelkey[i]);
	    rectfill(screen, 0, 220, 639, 280, 63);
	    RoundFont_Centre(txt, 260, 67, 69);
	    clear_keybuf();
	    k = b = 0;
	    do {
	       if (keypressed()) k = readkey()>>8;
    	       if (key[KEY_ESC]) { k=b=0; ok=1; break; }
	       if (key[KEY_ALT]) k = KEY_ALT;
	       if (key[KEY_LCONTROL]) k = KEY_LCONTROL;
	       if (key[KEY_RCONTROL]) k = KEY_RCONTROL;
	       if (key[KEY_LSHIFT]) k = KEY_LSHIFT;
	       if (key[KEY_RSHIFT]) k = KEY_RSHIFT;
	       if (joystick_support) {
	         int j;
                        UINT32 old_timer = read_timer();
	         while (read_timer() < old_timer + 2); // delay for reliably reading joystick data
	         if (read_joystick() == 0) {
	           for (j = 0; j<12; j++) {
  	             if (joy[0].button[j].b) { 
	               b = j + 1; 
	               while (1) {
                	  old_timer = read_timer();
	                 while (read_timer() < old_timer + 2); // delay for reliably reading joystick data
	                 if (read_joystick() == 0 && !joy[0].button[j].b) break;
	                 if (key[KEY_ESC]) break;
	               }
	               break;
	             }
	           }
	         }
	       }
	    } while (!k && !b);
	    if (i) {
	       for (iv=0;iv!=i;iv++) {
		  if (k && keydef[is+iv]==k) {
		     Error("ERROR: THIS KEY IS ALREADY USED !");
		     ok = 0;
		  } else if (b && joydef[is+iv]==b) {
		     Error("ERROR: THIS BUTTON IS ALREADY USED !");
		     ok = 0;
		  }
	       }
	    }
	 } while (!ok);
	 if (k) keydef[is+i] = k;
	 if (b) joydef[is+i] = b;
      }
   }
   clear_keybuf();
}

void sub_menu_keyboard()
{
   int i, choix;
   do {
      I_Clear();
      I_NewMenu();
      I_SetItem("", "CONTROLS CONFIGURATION",0);
      I_SetItem("F1", "DEFINE CONTROL PANEL KEYS", KEY_F1);
      I_SetItem("F2", "DEFINE PLAYER ONE KEYS", KEY_F2);
      I_SetItem("F3", "DEFINE PLAYER TWO KEYS", KEY_F3);
      I_SetItem("F4", "DEFINE PLAYER THREE KEYS", KEY_F4);
      I_SetItem("F5", "DEFINE EMULATOR KEYS", KEY_F5);
      I_SetItem("ESC", "BACK TO MAIN MENU", KEY_ESC);
//      I_SetItem("END","BACK TO EMULATION",KEY_END);
      I_BuildMenu(1);
      choix = I_RunMenu();
      switch (choix) {
       case KEY_F1:
         memset(labelkey, 0, sizeof(labelkey));
         for (i=0; i<8; i++) sprintf(labelkey[i],"%s",labelgen[i]);
         redefine_keys(0);
         break;
       case KEY_F2:
       case KEY_F3:
       case KEY_F4:
         memset(labelkey, 0, sizeof(labelkey));
         for (i=0; i<8; i++) sprintf(labelkey[i],"%s",labeljoy[i]);
         redefine_keys(10+(choix-KEY_F2)*10);
         break;
       case KEY_F5:
         memset(labelkey, 0, sizeof(labelkey));
         sprintf(labelkey[0],"%s","INTERFACE KEY");
         sprintf(labelkey[1],"%s","EXIT KEY");
         sprintf(labelkey[2],"%s","PAUSE KEY");
         sprintf(labelkey[3],"%s","SCREEN SHOT KEY");
         sprintf(labelkey[4],"%s","BACKGROUND ENABLE/DISABLE KEY");
         sprintf(labelkey[5],"%s","RECORD/STOP RECORDING MOVIE KEY");
         sprintf(labelkey[6],"%s","PLAY/STOP PLAYING MOVIE KEY");
         sprintf(labelkey[7],"%s","QUICKSAVE KEY");
         sprintf(labelkey[8],"%s","QUICKLOAD KEY");
         redefine_keys(40);
         break;
       case KEY_END:
         choice=KEY_END; return;
      }
   } while (choix!=KEY_ESC);
}

int MainMenu() {
   extern int trace_play_mode;
   do {
      I_Clear();
      I_NewMenu();
      I_SetItem("","MAIN MENU",0);
      I_SetItem("F1", "CONFIGURE DIP SWITCHES", KEY_F1);
      I_SetItem("F2", "CONFIGURE CONTROLS",KEY_F2);
      I_SetItem("F5", "SAVE GAME STATE", KEY_F5);
      I_SetItem("F6", "LOAD GAME STATE", KEY_F6);
      if (trace_play_mode != 1) I_SetItem("F9", "RECORD MOVIE", KEY_F9);
      else I_SetItem("F9", "STOP RECORDING MOVIE", KEY_F9);
      if (trace_play_mode != 2) I_SetItem("F11", "PLAY MOVIE", KEY_F11);
      else I_SetItem("F11", "STOP PLAYING MOVIE", KEY_F11);
      I_SetItem("F10", "RESET THE GAME", KEY_F10);
      I_SetItem("ESC","BACK TO EMULATION",KEY_ESC);
      I_SetItem("END","QUIT EMULATION",KEY_END);
      I_BuildMenu(0);
      choice=I_RunMenu();
      switch(choice) {
        case KEY_F1: dipswitch(); break;
        case KEY_F2: sub_menu_keyboard(); break;
        case KEY_F5: sub_menu_savegame(); break;
        case KEY_F6: sub_menu_loadgame(); break;
        case KEY_F9: sub_menu_recordmovie(); break;
        case KEY_F11: sub_menu_playmovie(); break;
        case KEY_F10: fastcpu_init2(); break;
        case KEY_END: return(1);
      }
   } while ((choice!=KEY_ESC) && (choice!=KEY_END));
   return(0);
}

void set_rgb(int i, int r, int g, int b)
{
   RGB c;
   c.r = r;
   c.g = g;
   c.b = b;
   set_color(i, (RGB *)&c);
}

void I_Init()
{
   logo16 = load_pcx("logo16.pcx", pal);
   if (!logo16) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      printf("Error, can't load logo16.pcx !\n");
      exit(-1);
   }
   logo_x = (640 - logo16->w) / 2;
   logo_y = 10;
   m = 320;
 
   set_rgb(63,63,63,63);
}

extern UINT8 menu_videomode;
void set_menuvideomode()
{
   int videomode[]={
GFX_TEXT,
GFX_AUTODETECT,
GFX_VGA,
GFX_MODEX,
GFX_VESA1,
GFX_VESA2B,	// 5: default
GFX_VESA2L,
GFX_VESA3,
GFX_VBEAF,
GFX_XTENDED,
};

   set_gfx_mode(videomode[menu_videomode], 640, 480, 0, 0);
}

int Interface(int d)
{
   int eval=0;
   extern UINT16 rx, ry;

   clear_keybuf();
   if (sampled_sound_support) set_audio_volume(0);

   get_palette(save_pal);
//   fade_out(30);
   rectfill(screen, 0, 0, rx-1, ry-1, 0);

   set_menuvideomode();
   
   I_Init();
   switch (d) {
     case 0: eval=MainMenu(); break;
     case 1: dipswitch(); break;
   }

   fade_out(10);
   rectfill(screen, 0, 0, 639, 479, 0);   // avoid gliches in mode switching

   Video(1);
   set_palette(save_pal);
   
   if (sampled_sound_support) set_audio_volume(64);
   
   return(eval);
}

void FichierTrouve(char *fichier, int attr, int p) {
   FILE *f;
   char L[256];
   int trouve, i;

   f = fopen(fichier, "r");
   trouve = 0;
   if (f) {
      while ((!feof(f))&&(!trouve)) {
	 fscanf(f, "%s", L);
	 if (L[0]=='.') {
	    LowerCase(L);
	    if (!strcmp(L, ".game")) trouve = 1;
	 }
      }
      if (trouve) {
	 fscanf(f, "%s", L);
	 for (i=0;i!=strlen(L);i++) if (L[i]=='_') L[i]=' ';
	 printf("%s\n", L);
      }
      fclose(f);
   }
}

void ListGCS() {
   printf("\nList of games\n\n");
   for_each_file("*.gcs",0,FichierTrouve,0);
   exit(0);
}

void CheckGCSName(char *s) {
   int p = 0, o = 0;
   while (s[p]) {
      if (s[p]=='.') o++;
      p++;
   }
   if (!o) {
      sprintf(s, "%s.gcs", s);
   }
}

