#include <stdio.h>
#include <allegro.h>
#include "host.h"

// JOYSTICK ///////////////////////////////////////////////////////
// INTERFACE:
//
// return 0 if succ
// int init_joystick(int joy_type)
//
// return 0 if succ
// int read_joystick()
// poll joystick device, data will be set by:
// joy[].stick[0].axis[0].pos : X
// joy[].stick[0].axis[0].d1 : left
// joy[].stick[0].axis[0].d2 : right
// joy[].stick[0].axis[1].pos : Y
// joy[].stick[0].axis[1].d1 : up
// joy[].stick[0].axis[1].d2 : down
// joy[].button[0~11].b
//

static int (*_read_joystick)();
static int poll_sidewinder()
{
   int i, b, mask;
   UINT32 *sw_raw_input;
   UINT32 *_SWStatus(); // defined in swdrv32.asm

   if ((sw_raw_input=_SWStatus()) == NULL) return -1;
//printf("sw_raw_input[0]=%08x\n", sw_raw_input[0]);
   for (i=0; i<4; i++) {
      joy[i].stick[0].axis[0].d1 = ((sw_raw_input[i] & 0x10) != 0);
      joy[i].stick[0].axis[0].d2 = ((sw_raw_input[i] & 0x08) != 0);
      joy[i].stick[0].axis[1].d1 = ((sw_raw_input[i] & 0x02) != 0);
      joy[i].stick[0].axis[1].d2 = ((sw_raw_input[i] & 0x04) != 0);

      for (b=0; b<2; b++) {
        if (joy[i].stick[0].axis[b].d1)
          joy[i].stick[0].axis[b].pos = -128;
        else if (joy[i].stick[0].axis[b].d2)
          joy[i].stick[0].axis[b].pos = 128;
        else
          joy[i].stick[0].axis[b].pos = 0;
      }

      mask = 0x20; 

      for (b=0; b<10; b++) {
        joy[i].button[b].b = ((sw_raw_input[i] & mask) != 0);
        mask <<= 1; 
      }
   }
   return 0;
}

// return 0 if succ
int init_joystick(int joy_type)
{
  int rc = -1;
  int type[16] = {
JOY_TYPE_NONE,
JOY_TYPE_STANDARD,
JOY_TYPE_2PADS,
JOY_TYPE_4BUTTON,
JOY_TYPE_6BUTTON,
JOY_TYPE_8BUTTON,
JOY_TYPE_FSPRO,
JOY_TYPE_WINGEX,
JOY_TYPE_SIDEWINDER,
JOY_TYPE_GAMEPAD_PRO,
JOY_TYPE_SNESPAD_LPT1,
JOY_TYPE_SNESPAD_LPT2,
JOY_TYPE_SNESPAD_LPT3,
};

  if (joy_type == -1) { // no drive
    memset(joy, 0, sizeof(joy));
    _read_joystick = NULL;
  } else if (type[joy_type] == JOY_TYPE_SIDEWINDER) {
    _read_joystick = poll_sidewinder;
    rc = 0;
  } else if (install_joystick(type[joy_type]) == 0) {
    _read_joystick = poll_joystick;
    rc = 0;
  } else {
    memset(joy, 0, sizeof(joy));
    _read_joystick = NULL;
  }
  return rc;
}

int read_joystick()
{
  if (_read_joystick != NULL) return (*_read_joystick)();
  else return -1;
}
