;	output generated by as2nasm (c) 1998 by Bartman/Abyss
;	source: MEM.S
	bits	32

;%define CATCH_WRITE     0x410e98
;%define CATCH_READ      0xffcd18

	section	.data

%ifdef	CATCH_WRITE
CATCH_WRITE_ADDR:       dd CATCH_WRITE
%endif
%ifdef	CATCH_READ
CATCH_READ_ADDR:	dd CATCH_READ
%endif

ERR_ROMWRT:	db 'ERROR: THE CPU TRIED TO WRITE INTO ROM',0,''
ERR_NOBNKWB:	db 'ERROR: B-WRITE ACCESS DENIED',0,''
ERR_NOBNKWW:	db 'ERROR: W-WRITE ACCESS DENIED',0,''
ERR_NOBNKWL:	db 'ERROR: L-WRITE ACCESS DENIED',0,''
ERR_NOBNKR:	db 'ERROR: READ ACCESS DENIED',0,''

NFO_MEMWPL:	db 'INFO: LONG WRITE',0,''
NFO_READIO:	db 'INFO: LECTURE I/O',0,''
NFO_WRITIO:	db 'INFO: WRITE I/O',0,''
NFO_SOUNDR:	db 'INFO: SOUND REQUEST I/O',0,''

NFO_CATCHW:	db 'CATCH WRITE:',0,''
NFO_CATCHR:	db 'CATCH READ:',0,''

	section	.text
	global	 _rom_readb
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_readb:	
	push	edx
	and	esi,0xffffff
	mov	edx,dword[_code]
	xor	esi,1
	mov	al,byte[edx+esi]
	pop	edx
	xor	esi,1
	ret

	global	 _rom_readw
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_readw:	
	push	edx
	and	esi,0xffffff
	mov	edx,dword[_code]
	mov	ax,word[edx+esi]
	pop	edx
	ret

	global	 _rom_readl
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_readl:	
	push	edx
	and	esi,0xffffff
	mov	edx,dword[_code]
	mov	eax,dword[edx+esi]
	pop	edx
	rol	eax,16
	ret

	global	 _rom_writeb
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_writeb:	
	push	edx

%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___rwb
        call    _catch_write
___rwb:	
%endif
	xor	esi,1
	mov	edx,dword[_code]
	mov	byte[edx+esi],al
	pop	edx
	xor	esi,1
	ret

	global	 _rom_writew
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_writew:	
	push	edx

%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___rww
        call    _catch_write
___rww:	
%endif
	mov	edx,dword[_code]
	mov	word[edx+esi],ax
	pop	edx
	ret

	global	 _rom_writel
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_rom_writel:	
	push	edx
	mov	edx,dword[_code]
	rol	eax,16
	mov	dword[edx+esi],eax
	rol	eax,16
	pop	edx
	ret

	global	 _mem_readb
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_readb:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_READ
        cmp     si,word[CATCH_READ_ADDR]
	jne	near ___rb
	and	bp,0xff
        cmp     bp,word[2+CATCH_READ_ADDR]
	jne	near ___rb
	call	_catch_read
___rb:	
%endif

	add	esi,dword[_s16_ptr+ebp*4]
	mov	al,byte[esi]
	pop	esi
	ret

	global	 _mem_readw
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_readw:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_READ
        cmp     si,word[CATCH_READ_ADDR]
	jne	near ___rw
	and	bp,0xff
        cmp     bp,word[2+CATCH_READ_ADDR]
	jne	near ___rw
	call	_catch_read
___rw:	
%endif

	add	esi,dword[_s16_ptr+ebp*4]
	mov	al,byte[1+esi]
	mov	ah,byte[esi]
	pop	esi
	ret

	global	 _mem_readl
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_readl:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_READ
        cmp     si,word[CATCH_READ_ADDR]
	jne	near ___rl
	and	bp,0xff
        cmp     bp,word[2+CATCH_READ_ADDR]
	jne	near ___rl
	call	_catch_read
___rl:	
%endif

	add	esi,dword[_s16_ptr+ebp*4]
	mov	eax,dword[esi]
	bswap	eax
	pop	esi
	ret

	global	 _mem_writeb
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_writeb:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___wb
	and	bp,0xff
        cmp     bp,word[2+CATCH_WRITE_ADDR]
	jne	near ___wb
	call	_catch_write
___wb:	
%endif

	add	esi,dword[_s16_ptr+ebp*4]
	mov	byte[esi],al
	pop	esi
	ret

	global	 _mem_writew
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_writew:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___ww
	and	bp,0xff
        cmp     bp,word[2+CATCH_WRITE_ADDR]
	jne	near ___ww
	call	_catch_write
___ww:	
%endif
	add	esi,dword[_s16_ptr+ebp*4]
	mov	byte[esi],ah
	mov	byte[1+esi],al
	pop	esi
	ret

	global	 _mem_writel
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_writel:	
	push	esi
	and	esi,0xFFFF

%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___wl
	and	bp,0xff
        cmp     bp,word[2+CATCH_WRITE_ADDR]
	jne	near ___wl
	call	_catch_write
___wl:	
%endif

	add	esi,dword[_s16_ptr+ebp*4]
	bswap	eax
	mov	dword[esi],eax
	bswap	eax
	pop	esi
	ret

	global	 _catch_write
_catch_write:	
	pushad
	mov	dword[_ASM_MESSAGE],NFO_CATCHW
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],eax
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
;              call    _cpudebug_registerdump
	popad
	ret

	global	 _catch_read
_catch_read:	
	pushad
	mov	dword[_ASM_MESSAGE],NFO_CATCHR
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],eax
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
	popad
	ret

	global	 _rom_write_illegal
_rom_write_illegal:	
	pushad
	mov	dword[_ASM_MESSAGE],ERR_ROMWRT
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],eax
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
;              call    _cpudebug_registerdump
	popad
	ret

	global	 _no_memory_bank_wb
_no_memory_bank_wb:	
	pushad
	mov	dword[_ASM_MESSAGE],ERR_NOBNKWB
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],0
	mov	byte[_ASM_VALUE],al
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
	popad
	ret
	global	 _no_memory_bank_ww
_no_memory_bank_ww:	
	pushad
	mov	dword[_ASM_MESSAGE],ERR_NOBNKWW
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],0
	mov	word[_ASM_VALUE],ax
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
	popad
	ret

	global	 _no_memory_bank_wl
_no_memory_bank_wl:	
	pushad
	mov	dword[_ASM_MESSAGE],ERR_NOBNKWL
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_VALUE],eax
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_3
	popad
	ret


	global	 _no_memory_bank_r
_no_memory_bank_r:	
	pushad
	mov	dword[_ASM_MESSAGE],ERR_NOBNKR
	mov	dword[_ASM_ADDRESS],esi
	mov	dword[_ASM_CPU_PC],ebx
	call	_ASM_MESSAGE_2

;	       call    _cpudebug_registerdump

	popad
	ret

	global	_io_noeffect
_io_noeffect:	
	mov	al,255
	ret

	global	 _mem_writeb_soundrequest
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_mem_writeb_soundrequest:	
%ifdef	CATCH_WRITE
        cmp     si,word[CATCH_WRITE_ADDR]
	jne	near ___wsb
	and	bp,0xff
        cmp     bp,word[2+CATCH_WRITE_ADDR]
	jne	near ___wsb
	call	_catch_write
___wsb:	
%endif
	cmp	byte[_sampled_sound_support],1
	jne	near _SR0
	cmp	si,0x0007
;        jne     near _SR0
        jne     near _mem_writeb

_PLAY_SOUND:	
	pushad
	push	eax
	call	_sound_request
	add	esp,4
	popad
_SR0:
	ret

; /////////Afterburner routines///////////////////////////////////
	global	 _math_readw
_math_readw:	
	push	esi
	and	esi,0xFFFFFF
	cmp	si,0x0008
	je	near _math_readw_do_div
	cmp	si,0x800e
	je	near _math_readw_do_div
	cmp	si,0x8006
	jne	near _math_readw_pass
;	do div ([8]=[0]/[4]) ([E]=[0]/[4])
_math_readw_do_div:	
	push	ebx
	push	ecx
	push	edx

	push	esi
	call	_math_readw_func
	add	esi,4

	pop	edx
	pop	ecx
	pop	ebx
	jmp	_math_readw_end

_math_readw_pass:	
	and	esi,0xffff
	add	esi,dword[_s16_ptr+ebp*4]
	mov	eax,dword[esi]
	ror	ax,8

_math_readw_end:	
	and	eax,0xffff
	pop	esi
	ret
	ret

	global	 _math_readl
_math_readl:	
	push	esi
	and	esi,0xFFFFFF
	cmp	si,0x0004
	jne	near _math_readl_pass
;	mul
	push	ebx
	push	ecx
	push	edx
	push	esi

	call	_math_readl_func

	add	esp,4
	pop	edx
	pop	ecx
	pop	ebx
	jmp	_math_readl_end

_math_readl_pass:	
	and	esi,0xffff
	add	esi,dword[_s16_ptr+ebp*4]
	mov	eax,dword[esi]
	bswap	eax
_math_readl_end:	
	pop	esi
	ret

	global	 _math_writel
_math_writel:	
	push	esi
	and	esi,0xFFFF
	cmp	esi,0x4000
	jb	near _math_writel_pass
	cmp	esi,0x8000
	jae	near _math_writel_pass
	and	esi,0x400f

_math_writel_pass:	
	add	esi,dword[_s16_ptr+ebp*4]
	bswap	eax
	mov	dword[esi],eax
	bswap	eax
	pop	esi
	ret

	global	 _math_writew
_math_writew:	
	push	esi
	and	esi,0xFFFF
	cmp	esi,0x4000
	jb	near _math_writew_pass
	cmp	esi,0x8000
	jae	near _math_writew_pass
	and	esi,0x400f

_math_writew_pass:	
	add	esi,dword[_s16_ptr+ebp*4]
	mov	byte[esi],ah
	mov	byte[1+esi],al
	pop	esi
	ret

	global	 _test_for_pentium_pro
	times	($$-$) & 3 nop    ; pad with NOPs to 4-byte boundary
	
_test_for_pentium_pro:	
	pushad
	mov	ecx,500000
        mov     esi,dword _ASM_ADDRESS

_test_for_pentium_pro_loop:	
        mov     dl,byte[esi]

	mov	eax,edx
	dec	ecx
	jnz	_test_for_pentium_pro_loop

	popad
	ret

;BARTMAN:these	extern definitions have been added manually, because NASM needs them
;	       and AS doesn't need them

	extern	_ASM_ADDRESS
	extern	_ASM_CPU_PC
	extern	_ASM_MESSAGE
	extern	_ASM_MESSAGE_2
	extern	_ASM_MESSAGE_3
	extern	_ASM_VALUE
	extern	_code
	extern	_math_readl_func
	extern	_math_readw_func
	extern	_s16_ptr
	extern	_sampled_sound_support
	extern	_sound_request
        extern  _cpudebug_registerdump
