/*
 * SYSTEM 16 ARCADE EMULATOR SOURCE CODE
 * 
 * Copyright 1996/97 Thierry Lescot
 */

#include <allegro.h>
#include "host.h"

//// SHOW TEXT MESSAGE  /////////////////////////////////////////////////
static int message_length;
static char show_message_text[80];
static int msg_x, msg_y;
static int time_countdown;
extern UINT16 rx, ry;
extern int sx, sy, total_x, total_y;

void DeleteMessage()
{
  if (msg_y != ry-8 || message_length > total_x) 
  rectfill(screen, msg_x, msg_y, msg_x+message_length, msg_y+7, 0);
  message_length = 0;
}

void update_message()
{
  if (message_length) {
    text_mode(-1); // -1 for transparent mode
    textout(screen, font, show_message_text, msg_x, msg_y, _white_color());
  }
}

/* type==-1 -> deferred display
   temps = seconds
*/
void message_emul(int type, int temps, char *text)
{
  if (type != -1 && message_length) DeleteMessage();
  strcpy(show_message_text, text);
  message_length = strlen(text)*8;
  time_countdown = temps*60;
  msg_x = total_x>=message_length ?sx : (sx-(message_length-total_x)/2>=0 ?sx-(message_length-total_x)/2 :0);
  msg_y = sy>=8 ?sy-8 : ry-8;
  if (type != -1) update_message();
}

void check_message()
{
  if (time_countdown > 0) {
    if (--time_countdown <= 0) {
      DeleteMessage();
    }
  }
}

//////////////////////////////////////////////////////////////////////////////
