; For assembly by NASM only
bits 32

; Theory of operation

; EDI=General purpose
; ESI=Program counter + base address
; EBP=mz80Base
; AX=AF
; BX=HL
; CX=BC
; DX=General purpose

; Using stack calling conventions
; Extended input/output instructions treat (C) as I/O address


		section	.data

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

		global	_mz80contextBegin
_mz80contextBegin:
		global	_z80pc
		global	_z80nmiAddr
		global	_z80intAddr

; DO NOT CHANGE THE ORDER OF AF, BC, DE, HL and THE PRIME REGISTERS!

_z80Base	dd	0	; Base address for Z80 stuff
_z80MemRead	dd	0	; Offset of memory read structure array
_z80MemWrite	dd	0	; Offset of memory write structure array
_z80IoRead	dd	0	; Base address for I/O reads list
_z80IoWrite	dd	0	; Base address for I/O write list
_z80clockticks	dd	0	; # Of clock tips that have elapsed
_z80inInterrupt	dd	0	; Non-zero if we're in an interrupt
_z80interruptMode dd	0	; Interrupt mode
_z80interruptState	dd	0	; What state is our interrupt in?
_z80halted	dd	0	; 0=Not halted, 1=Halted
_z80af		dw	0	; A Flag & Flags
_z80bc		dw	0	; BC
_z80de		dw	0	; DE
_z80hl		dw	0	; HL
_z80afprime	dw	0	; A Flag & Flags prime
_z80bcprime	dw	0	; BC prime
_z80deprime	dw	0	; DE prime
_z80hlprime	dw	0	; HL prime

; The order of the following registers can be changed without adverse
; effect. Keep the WORD and DWORDs on boundaries of two for faster access

_z80ix		dw	0	; IX
_z80iy		dw	0	; IY
_z80sp		dw	0	; Stack pointer
_z80pc		dw	0	; PC
_z80nmiAddr	dw	0	; Address to jump to for NMI
_z80intAddr	dw	0	; Address to jump to for INT
_z80i		db	0	; I register
_z80r		db	0	; R register

_mz80contextEnd:

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

dwElapsedTicks	dd	0	; # Of ticks elapsed
cyclesRemaining	dd	0	; # Of cycles remaining
_orgval	dw	0	; Scratch area
_orgval2	dw	0	; Scratch area
_baseFixup	dd	0	; Our base fixup for when we're out of time


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

z80regular:
		dd	RegInst00
		dd	RegInst01
		dd	RegInst02
		dd	RegInst03
		dd	RegInst04
		dd	RegInst05
		dd	RegInst06
		dd	RegInst07
		dd	RegInst08
		dd	RegInst09
		dd	RegInst0a
		dd	RegInst0b
		dd	RegInst0c
		dd	RegInst0d
		dd	RegInst0e
		dd	RegInst0f
		dd	RegInst10
		dd	RegInst11
		dd	RegInst12
		dd	RegInst13
		dd	RegInst14
		dd	RegInst15
		dd	RegInst16
		dd	RegInst17
		dd	RegInst18
		dd	RegInst19
		dd	RegInst1a
		dd	RegInst1b
		dd	RegInst1c
		dd	RegInst1d
		dd	RegInst1e
		dd	RegInst1f
		dd	RegInst20
		dd	RegInst21
		dd	RegInst22
		dd	RegInst23
		dd	RegInst24
		dd	RegInst25
		dd	RegInst26
		dd	RegInst27
		dd	RegInst28
		dd	RegInst29
		dd	RegInst2a
		dd	RegInst2b
		dd	RegInst2c
		dd	RegInst2d
		dd	RegInst2e
		dd	RegInst2f
		dd	RegInst30
		dd	RegInst31
		dd	RegInst32
		dd	RegInst33
		dd	RegInst34
		dd	RegInst35
		dd	RegInst36
		dd	RegInst37
		dd	RegInst38
		dd	RegInst39
		dd	RegInst3a
		dd	RegInst3b
		dd	RegInst3c
		dd	RegInst3d
		dd	RegInst3e
		dd	RegInst3f
		dd	RegInst40
		dd	RegInst41
		dd	RegInst42
		dd	RegInst43
		dd	RegInst44
		dd	RegInst45
		dd	RegInst46
		dd	RegInst47
		dd	RegInst48
		dd	RegInst49
		dd	RegInst4a
		dd	RegInst4b
		dd	RegInst4c
		dd	RegInst4d
		dd	RegInst4e
		dd	RegInst4f
		dd	RegInst50
		dd	RegInst51
		dd	RegInst52
		dd	RegInst53
		dd	RegInst54
		dd	RegInst55
		dd	RegInst56
		dd	RegInst57
		dd	RegInst58
		dd	RegInst59
		dd	RegInst5a
		dd	RegInst5b
		dd	RegInst5c
		dd	RegInst5d
		dd	RegInst5e
		dd	RegInst5f
		dd	RegInst60
		dd	RegInst61
		dd	RegInst62
		dd	RegInst63
		dd	RegInst64
		dd	RegInst65
		dd	RegInst66
		dd	RegInst67
		dd	RegInst68
		dd	RegInst69
		dd	RegInst6a
		dd	RegInst6b
		dd	RegInst6c
		dd	RegInst6d
		dd	RegInst6e
		dd	RegInst6f
		dd	RegInst70
		dd	RegInst71
		dd	RegInst72
		dd	RegInst73
		dd	RegInst74
		dd	RegInst75
		dd	RegInst76
		dd	RegInst77
		dd	RegInst78
		dd	RegInst79
		dd	RegInst7a
		dd	RegInst7b
		dd	RegInst7c
		dd	RegInst7d
		dd	RegInst7e
		dd	RegInst7f
		dd	RegInst80
		dd	RegInst81
		dd	RegInst82
		dd	RegInst83
		dd	RegInst84
		dd	RegInst85
		dd	RegInst86
		dd	RegInst87
		dd	RegInst88
		dd	RegInst89
		dd	RegInst8a
		dd	RegInst8b
		dd	RegInst8c
		dd	RegInst8d
		dd	RegInst8e
		dd	RegInst8f
		dd	RegInst90
		dd	RegInst91
		dd	RegInst92
		dd	RegInst93
		dd	RegInst94
		dd	RegInst95
		dd	RegInst96
		dd	RegInst97
		dd	RegInst98
		dd	RegInst99
		dd	RegInst9a
		dd	RegInst9b
		dd	RegInst9c
		dd	RegInst9d
		dd	RegInst9e
		dd	RegInst9f
		dd	RegInsta0
		dd	RegInsta1
		dd	RegInsta2
		dd	RegInsta3
		dd	RegInsta4
		dd	RegInsta5
		dd	RegInsta6
		dd	RegInsta7
		dd	RegInsta8
		dd	RegInsta9
		dd	RegInstaa
		dd	RegInstab
		dd	RegInstac
		dd	RegInstad
		dd	RegInstae
		dd	RegInstaf
		dd	RegInstb0
		dd	RegInstb1
		dd	RegInstb2
		dd	RegInstb3
		dd	RegInstb4
		dd	RegInstb5
		dd	RegInstb6
		dd	RegInstb7
		dd	RegInstb8
		dd	RegInstb9
		dd	RegInstba
		dd	RegInstbb
		dd	RegInstbc
		dd	RegInstbd
		dd	RegInstbe
		dd	RegInstbf
		dd	RegInstc0
		dd	RegInstc1
		dd	RegInstc2
		dd	RegInstc3
		dd	RegInstc4
		dd	RegInstc5
		dd	RegInstc6
		dd	RegInstc7
		dd	RegInstc8
		dd	RegInstc9
		dd	RegInstca
		dd	RegInstcb
		dd	RegInstcc
		dd	RegInstcd
		dd	RegInstce
		dd	RegInstcf
		dd	RegInstd0
		dd	RegInstd1
		dd	RegInstd2
		dd	RegInstd3
		dd	RegInstd4
		dd	RegInstd5
		dd	RegInstd6
		dd	RegInstd7
		dd	RegInstd8
		dd	RegInstd9
		dd	RegInstda
		dd	RegInstdb
		dd	RegInstdc
		dd	RegInstdd
		dd	RegInstde
		dd	RegInstdf
		dd	RegInste0
		dd	RegInste1
		dd	RegInste2
		dd	RegInste3
		dd	RegInste4
		dd	RegInste5
		dd	RegInste6
		dd	RegInste7
		dd	RegInste8
		dd	RegInste9
		dd	RegInstea
		dd	RegInsteb
		dd	RegInstec
		dd	RegInsted
		dd	RegInstee
		dd	RegInstef
		dd	RegInstf0
		dd	RegInstf1
		dd	RegInstf2
		dd	RegInstf3
		dd	RegInstf4
		dd	RegInstf5
		dd	RegInstf6
		dd	RegInstf7
		dd	RegInstf8
		dd	RegInstf9
		dd	RegInstfa
		dd	RegInstfb
		dd	RegInstfc
		dd	RegInstfd
		dd	RegInstfe
		dd	RegInstff

z80PrefixCB:
		dd	CBInst00
		dd	CBInst01
		dd	CBInst02
		dd	CBInst03
		dd	CBInst04
		dd	CBInst05
		dd	CBInst06
		dd	CBInst07
		dd	CBInst08
		dd	CBInst09
		dd	CBInst0a
		dd	CBInst0b
		dd	CBInst0c
		dd	CBInst0d
		dd	CBInst0e
		dd	CBInst0f
		dd	CBInst10
		dd	CBInst11
		dd	CBInst12
		dd	CBInst13
		dd	CBInst14
		dd	CBInst15
		dd	CBInst16
		dd	CBInst17
		dd	CBInst18
		dd	CBInst19
		dd	CBInst1a
		dd	CBInst1b
		dd	CBInst1c
		dd	CBInst1d
		dd	CBInst1e
		dd	CBInst1f
		dd	CBInst20
		dd	CBInst21
		dd	CBInst22
		dd	CBInst23
		dd	CBInst24
		dd	CBInst25
		dd	CBInst26
		dd	CBInst27
		dd	CBInst28
		dd	CBInst29
		dd	CBInst2a
		dd	CBInst2b
		dd	CBInst2c
		dd	CBInst2d
		dd	CBInst2e
		dd	CBInst2f
		dd	CBInst30
		dd	CBInst31
		dd	CBInst32
		dd	CBInst33
		dd	CBInst34
		dd	CBInst35
		dd	CBInst36
		dd	CBInst37
		dd	CBInst38
		dd	CBInst39
		dd	CBInst3a
		dd	CBInst3b
		dd	CBInst3c
		dd	CBInst3d
		dd	CBInst3e
		dd	CBInst3f
		dd	CBInst40
		dd	CBInst41
		dd	CBInst42
		dd	CBInst43
		dd	CBInst44
		dd	CBInst45
		dd	CBInst46
		dd	CBInst47
		dd	CBInst48
		dd	CBInst49
		dd	CBInst4a
		dd	CBInst4b
		dd	CBInst4c
		dd	CBInst4d
		dd	CBInst4e
		dd	CBInst4f
		dd	CBInst50
		dd	CBInst51
		dd	CBInst52
		dd	CBInst53
		dd	CBInst54
		dd	CBInst55
		dd	CBInst56
		dd	CBInst57
		dd	CBInst58
		dd	CBInst59
		dd	CBInst5a
		dd	CBInst5b
		dd	CBInst5c
		dd	CBInst5d
		dd	CBInst5e
		dd	CBInst5f
		dd	CBInst60
		dd	CBInst61
		dd	CBInst62
		dd	CBInst63
		dd	CBInst64
		dd	CBInst65
		dd	CBInst66
		dd	CBInst67
		dd	CBInst68
		dd	CBInst69
		dd	CBInst6a
		dd	CBInst6b
		dd	CBInst6c
		dd	CBInst6d
		dd	CBInst6e
		dd	CBInst6f
		dd	CBInst70
		dd	CBInst71
		dd	CBInst72
		dd	CBInst73
		dd	CBInst74
		dd	CBInst75
		dd	CBInst76
		dd	CBInst77
		dd	CBInst78
		dd	CBInst79
		dd	CBInst7a
		dd	CBInst7b
		dd	CBInst7c
		dd	CBInst7d
		dd	CBInst7e
		dd	CBInst7f
		dd	CBInst80
		dd	CBInst81
		dd	CBInst82
		dd	CBInst83
		dd	CBInst84
		dd	CBInst85
		dd	CBInst86
		dd	CBInst87
		dd	CBInst88
		dd	CBInst89
		dd	CBInst8a
		dd	CBInst8b
		dd	CBInst8c
		dd	CBInst8d
		dd	CBInst8e
		dd	CBInst8f
		dd	CBInst90
		dd	CBInst91
		dd	CBInst92
		dd	CBInst93
		dd	CBInst94
		dd	CBInst95
		dd	CBInst96
		dd	CBInst97
		dd	CBInst98
		dd	CBInst99
		dd	CBInst9a
		dd	CBInst9b
		dd	CBInst9c
		dd	CBInst9d
		dd	CBInst9e
		dd	CBInst9f
		dd	CBInsta0
		dd	CBInsta1
		dd	CBInsta2
		dd	CBInsta3
		dd	CBInsta4
		dd	CBInsta5
		dd	CBInsta6
		dd	CBInsta7
		dd	CBInsta8
		dd	CBInsta9
		dd	CBInstaa
		dd	CBInstab
		dd	CBInstac
		dd	CBInstad
		dd	CBInstae
		dd	CBInstaf
		dd	CBInstb0
		dd	CBInstb1
		dd	CBInstb2
		dd	CBInstb3
		dd	CBInstb4
		dd	CBInstb5
		dd	CBInstb6
		dd	CBInstb7
		dd	CBInstb8
		dd	CBInstb9
		dd	CBInstba
		dd	CBInstbb
		dd	CBInstbc
		dd	CBInstbd
		dd	CBInstbe
		dd	CBInstbf
		dd	CBInstc0
		dd	CBInstc1
		dd	CBInstc2
		dd	CBInstc3
		dd	CBInstc4
		dd	CBInstc5
		dd	CBInstc6
		dd	CBInstc7
		dd	CBInstc8
		dd	CBInstc9
		dd	CBInstca
		dd	CBInstcb
		dd	CBInstcc
		dd	CBInstcd
		dd	CBInstce
		dd	CBInstcf
		dd	CBInstd0
		dd	CBInstd1
		dd	CBInstd2
		dd	CBInstd3
		dd	CBInstd4
		dd	CBInstd5
		dd	CBInstd6
		dd	CBInstd7
		dd	CBInstd8
		dd	CBInstd9
		dd	CBInstda
		dd	CBInstdb
		dd	CBInstdc
		dd	CBInstdd
		dd	CBInstde
		dd	CBInstdf
		dd	CBInste0
		dd	CBInste1
		dd	CBInste2
		dd	CBInste3
		dd	CBInste4
		dd	CBInste5
		dd	CBInste6
		dd	CBInste7
		dd	CBInste8
		dd	CBInste9
		dd	CBInstea
		dd	CBInsteb
		dd	CBInstec
		dd	CBInsted
		dd	CBInstee
		dd	CBInstef
		dd	CBInstf0
		dd	CBInstf1
		dd	CBInstf2
		dd	CBInstf3
		dd	CBInstf4
		dd	CBInstf5
		dd	CBInstf6
		dd	CBInstf7
		dd	CBInstf8
		dd	CBInstf9
		dd	CBInstfa
		dd	CBInstfb
		dd	CBInstfc
		dd	CBInstfd
		dd	CBInstfe
		dd	CBInstff

z80PrefixED:
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst40
		dd	EDInst41
		dd	EDInst42
		dd	EDInst43
		dd	EDInst44
		dd	EDInst45
		dd	EDInst46
		dd	EDInst47
		dd	EDInst48
		dd	EDInst49
		dd	EDInst4a
		dd	EDInst4b
		dd	invalidInsWord
		dd	EDInst4d
		dd	invalidInsWord
		dd	EDInst4f
		dd	EDInst50
		dd	EDInst51
		dd	EDInst52
		dd	EDInst53
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst56
		dd	EDInst57
		dd	EDInst58
		dd	EDInst59
		dd	EDInst5a
		dd	EDInst5b
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst5e
		dd	EDInst5f
		dd	EDInst60
		dd	EDInst61
		dd	EDInst62
		dd	EDInst63
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst67
		dd	EDInst68
		dd	EDInst69
		dd	EDInst6a
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst6f
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst72
		dd	EDInst73
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInst78
		dd	EDInst79
		dd	EDInst7a
		dd	EDInst7b
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInsta0
		dd	EDInsta1
		dd	EDInsta2
		dd	EDInsta3
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInsta8
		dd	EDInsta9
		dd	EDInstaa
		dd	EDInstab
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInstb0
		dd	EDInstb1
		dd	EDInstb2
		dd	EDInstb3
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	EDInstb8
		dd	EDInstb9
		dd	EDInstba
		dd	EDInstbb
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord

z80PrefixDD:
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst09
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst19
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst21
		dd	DDInst22
		dd	DDInst23
		dd	DDInst24
		dd	DDInst25
		dd	DDInst26
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst29
		dd	DDInst2a
		dd	DDInst2b
		dd	DDInst2c
		dd	DDInst2d
		dd	DDInst2e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst34
		dd	DDInst35
		dd	DDInst36
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst39
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst44
		dd	DDInst45
		dd	DDInst46
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst4c
		dd	DDInst4d
		dd	DDInst4e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst54
		dd	DDInst55
		dd	DDInst56
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst5c
		dd	DDInst5d
		dd	DDInst5e
		dd	invalidInsWord
		dd	DDInst60
		dd	DDInst61
		dd	DDInst62
		dd	DDInst63
		dd	DDInst64
		dd	DDInst65
		dd	DDInst66
		dd	DDInst67
		dd	DDInst68
		dd	DDInst69
		dd	DDInst6a
		dd	DDInst6b
		dd	DDInst6c
		dd	DDInst6d
		dd	DDInst6e
		dd	DDInst6f
		dd	DDInst70
		dd	DDInst71
		dd	DDInst72
		dd	DDInst73
		dd	DDInst74
		dd	DDInst75
		dd	invalidInsWord
		dd	DDInst77
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst7c
		dd	DDInst7d
		dd	DDInst7e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst84
		dd	DDInst85
		dd	DDInst86
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst8c
		dd	DDInst8d
		dd	DDInst8e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst94
		dd	DDInst95
		dd	DDInst96
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInst9c
		dd	DDInst9d
		dd	DDInst9e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInsta4
		dd	DDInsta5
		dd	DDInsta6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInstac
		dd	DDInstad
		dd	DDInstae
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInstb4
		dd	DDInstb5
		dd	DDInstb6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInstbc
		dd	DDInstbd
		dd	DDInstbe
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInstcb
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInste1
		dd	invalidInsWord
		dd	DDInste3
		dd	invalidInsWord
		dd	DDInste5
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInste9
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDInstf9
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord

z80PrefixFD:
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst09
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst19
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst21
		dd	FDInst22
		dd	FDInst23
		dd	FDInst24
		dd	FDInst25
		dd	FDInst26
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst29
		dd	FDInst2a
		dd	FDInst2b
		dd	FDInst2c
		dd	FDInst2d
		dd	FDInst2e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst34
		dd	FDInst35
		dd	FDInst36
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst39
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst44
		dd	FDInst45
		dd	FDInst46
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst4c
		dd	FDInst4d
		dd	FDInst4e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst54
		dd	FDInst55
		dd	FDInst56
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst5c
		dd	FDInst5d
		dd	FDInst5e
		dd	invalidInsWord
		dd	FDInst60
		dd	FDInst61
		dd	FDInst62
		dd	FDInst63
		dd	FDInst64
		dd	FDInst65
		dd	FDInst66
		dd	FDInst67
		dd	FDInst68
		dd	FDInst69
		dd	FDInst6a
		dd	FDInst6b
		dd	FDInst6c
		dd	FDInst6d
		dd	FDInst6e
		dd	FDInst6f
		dd	FDInst70
		dd	FDInst71
		dd	FDInst72
		dd	FDInst73
		dd	FDInst74
		dd	FDInst75
		dd	invalidInsWord
		dd	FDInst77
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst7c
		dd	FDInst7d
		dd	FDInst7e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst84
		dd	FDInst85
		dd	FDInst86
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst8c
		dd	FDInst8d
		dd	FDInst8e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst94
		dd	FDInst95
		dd	FDInst96
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInst9c
		dd	FDInst9d
		dd	FDInst9e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInsta4
		dd	FDInsta5
		dd	FDInsta6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInstac
		dd	FDInstad
		dd	FDInstae
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInstb4
		dd	FDInstb5
		dd	FDInstb6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInstbc
		dd	FDInstbd
		dd	FDInstbe
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInstcb
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInste1
		dd	invalidInsWord
		dd	FDInste3
		dd	invalidInsWord
		dd	FDInste5
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInste9
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	FDInstf9
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
z80ddfdcbInstructions:
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst06
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst0e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst16
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst1e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst26
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst2e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst3e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst46
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst4e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst56
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst5e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst66
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst6e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst76
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst7e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst86
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst8e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst96
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInst9e
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInsta6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstae
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstb6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstbe
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstc6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstce
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstd6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstde
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInste6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstee
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstf6
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	invalidInsWord
		dd	DDFDCBInstfe
		dd	invalidInsWord

		section	.text

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst00:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst01:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	cx, [esi]	; Get our immediate value of BC
		add	esi, 2
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst02:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop0:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite0	; Yes - go write it!
		cmp	cx, [edi]	; Are we smaller?
		jb	nextAddr0	; Yes... go to the next addr
		cmp	cx, [edi+4]	; Are we smaller?
		jbe	callRoutine0	; If not, go call it!

nextAddr0:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop0

callRoutine0:
		mov	dx, cx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit0
memoryWrite0:
		mov	[ebp + ecx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit0:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst03:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		inc	cx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst04:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst05:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst06:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	ch, [esi]	; Get our immediate value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst07:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		rol	al, 1
		lahf
		and	ah, 0edh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst08:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		xchg	ah, al
		xchg	ax, [_z80afprime]
		xchg	ah, al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst09:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, ah
		and	dl, 0ech
		mov	[_orgval2], bx
		add	bx, cx
		lahf
		and	ah, 11h
		or	ah, dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0a:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop1:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead1
		cmp	cx, [edi]	; Are we smaller?
		jb		nextAddr1		; Yes, go to the next address
		cmp	cx, [edi+4]	; Are we bigger?
		jbe	callRoutine1

nextAddr1:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop1

callRoutine1:
		mov	dx, cx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit1

memoryRead1:
		mov	al, [ebp + ecx]	; Get our data

readExit1:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0b:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		dec	cx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	cl, [esi]	; Get our immediate value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst0f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		ror	al, 1
		lahf
		and	ah, 0edh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst10:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 8
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		dec	ch	; Decrement B
		jz	noJump	; Don't take the jump if it's done!
; Otherwise, take the jump
		add	[dwElapsedTicks], dword 5
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
noJump:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst11:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	di, [esi]	; Get our immediate value of DE
		mov	word [_z80de], di ; Store DE
		add	esi, 2
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst12:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	dx, [_z80de]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop2:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite2	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr2	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine2	; If not, go call it!

nextAddr2:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop2

callRoutine2:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit2
memoryWrite2:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit2:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst13:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		inc	word [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst14:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst15:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst16:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi]	; Get our immediate value
		mov	byte [_z80de + 1], dl	; Store our new value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst17:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		rcl	al, 1
		lahf
		and	ah, 0edh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst18:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst19:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, ah
		and	dl, 0ech
		mov	[_orgval2], bx
		add	bx, word [_z80de]
		lahf
		and	ah, 11h
		or	ah, dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1a:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dx, [_z80de]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop3:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead3
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr3		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine3

nextAddr3:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop3

callRoutine3:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit3

memoryRead3:
		mov	al, [ebp + edx]	; Get our data

readExit3:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1b:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		dec	word [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi]	; Get our immediate value
		mov	byte [_z80de], dl	; Store our new value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst1f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		rcr	al, 1
		lahf
		and	ah, 0edh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst20:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		sahf
		jnz	takeJump4
		jmp	short noJumpMan4
takeJump4:
		add	[dwElapsedTicks], dword 5
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
		xor	dh, dh
noJumpMan4:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst21:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	bx, [esi]	; Get our immediate value of HL
		add	esi, 2
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst22:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 16
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop5:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite5	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr5	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine5	; If not, go call it!

nextAddr5:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop5

callRoutine5:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit5
memoryWrite5:
		mov	[ebp + edx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit5:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop6:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite6	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr6	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine6	; If not, go call it!

nextAddr6:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop6

callRoutine6:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit6
memoryWrite6:
		mov	[ebp + edx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit6:
		xor	dh, dh	; Zero our upper byte
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst23:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		inc	bx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst24:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst25:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst26:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	bh, [esi]	; Get our immediate value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst27:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dh, ah
		and	dh, 02ah
		test	ah, 02h	; Were we doing a subtraction?
		jnz	handleNeg ; Nope!
		sahf
		daa
		lahf
		jmp	short endDaa
handleNeg:
		sahf
		das
		lahf
endDaa:
		and	ah, 0d5h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst28:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		sahf
		jz	takeJump7
		jmp	short noJumpMan7
takeJump7:
		add	[dwElapsedTicks], dword 5
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
		xor	dh, dh
noJumpMan7:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst29:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, ah
		and	dl, 0ech
		mov	[_orgval2], bx
		add	bx, bx
		lahf
		and	ah, 11h
		or	ah, dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2a:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 16
		mov	dx, [esi]	; Get address to load
		add	esi, 2	; Skip over it so we don't execute it
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop8:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead8
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr8		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine8

nextAddr8:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop8

callRoutine8:
		call	ReadMemoryByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit8

memoryRead8:
		mov	bl, [ebp + edx]	; Get our data

readExit8:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop9:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead9
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr9		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine9

nextAddr9:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop9

callRoutine9:
		call	ReadMemoryByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit9

memoryRead9:
		mov	bh, [ebp + edx]	; Get our data

readExit9:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2b:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		dec	bx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	bl, [esi]	; Get our immediate value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst2f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		not	al
		or	ah, 012h	; N And H are now on!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst30:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		sahf
		jnc	takeJump10
		jmp	short noJumpMan10
takeJump10:
		add	[dwElapsedTicks], dword 5
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
		xor	dh, dh
noJumpMan10:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst31:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	di, [esi]	; Get our immediate value of SP
		mov	word [_z80sp], di	; Store it!
		add	esi, 2
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst32:
		sub	dword [cyclesRemaining], byte 13
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 13
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop11:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite11	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr11	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine11	; If not, go call it!

nextAddr11:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop11

callRoutine11:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit11
memoryWrite11:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit11:
		xor	dh, dh	; Zero our upper byte
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst33:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		inc	word [_z80sp]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst34:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop12:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead12
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr12		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine12

nextAddr12:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop12

callRoutine12:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit12

memoryRead12:
		mov	dl, [ebp + ebx]	; Get our data

readExit12:
		sahf
		inc	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		and	ah, 0fdh	; Knock out N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop13:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite13	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr13	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine13	; If not, go call it!

nextAddr13:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop13

callRoutine13:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit13
memoryWrite13:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit13:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst35:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop14:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead14
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr14		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine14

nextAddr14:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop14

callRoutine14:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit14

memoryRead14:
		mov	dl, [ebp + ebx]	; Get our data

readExit14:
		sahf
		dec	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		or		ah, 02h	; Make it N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop15:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite15	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr15	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine15	; If not, go call it!

nextAddr15:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop15

callRoutine15:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit15
memoryWrite15:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit15:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst36:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	[_z80af], ax	; Store AF
		mov	al, [esi]	; And our data to write
		inc	esi	; Increment our program counter
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop16:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite16	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr16	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine16	; If not, go call it!

nextAddr16:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop16

callRoutine16:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit16
memoryWrite16:
		mov	[ebp + ebx], al	; Store our direct value
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit16:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst37:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		or	ah, 1
		and	ah,0edh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst38:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	dl, [esi] ; Get our relative offset
		inc	esi	; Next instruction, please!
		sahf
		jc	takeJump17
		jmp	short noJumpMan17
takeJump17:
		add	[dwElapsedTicks], dword 5
		xchg	ax, dx
		cbw
		xchg	ax, dx
		sub	esi, ebp
		add	si, dx
		add	esi, ebp
		xor	dh, dh
noJumpMan17:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst39:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, ah
		and	dl, 0ech
		mov	[_orgval2], bx
		add	bx, word [_z80sp]
		lahf
		and	ah, 11h
		or	ah, dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3a:
		sub	dword [cyclesRemaining], byte 13
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 13
		mov	dx, [esi]	; Get our address
		add	esi, 2		; Skip past the address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop18:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead18
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr18		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine18

nextAddr18:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop18

callRoutine18:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit18

memoryRead18:
		mov	al, [ebp + edx]	; Get our data

readExit18:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3b:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		dec	word [_z80sp]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		inc	al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		dec	al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative!
		xor	dh, dh	; Clear upper part of DX
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	al, [esi]	; Get our immediate value
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst3f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, ah
		and	dl, 01h
		shl	dl, 4
		xor	ah, 01h
		and	ah, 0edh
		or	ah, dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst40:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst41:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst42:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, byte [_z80de + 1]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst43:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, byte [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst44:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst45:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst46:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop19:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead19
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr19		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine19

nextAddr19:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop19

callRoutine19:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit19

memoryRead19:
		mov	ch, [ebp + ebx]	; Get our data

readExit19:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst47:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	ch, al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst48:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst49:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, byte [_z80de + 1]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, byte [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop20:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead20
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr20		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine20

nextAddr20:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop20

callRoutine20:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit20

memoryRead20:
		mov	cl, [ebp + ebx]	; Get our data

readExit20:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst4f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	cl, al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst50:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de + 1], ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst51:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de + 1], cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst52:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst53:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, byte [_z80de]
		mov	[_z80de + 1], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst54:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de + 1], bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst55:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de + 1], bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst56:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop21:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead21
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr21		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine21

nextAddr21:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop21

callRoutine21:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit21

memoryRead21:
		mov	dh, [ebp + ebx]	; Get our data

readExit21:
		mov	byte [_z80de + 1], dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst57:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de + 1], al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst58:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de], ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst59:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de], cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, byte [_z80de + 1]
		mov	[_z80de], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de], bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de], bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop22:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead22
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr22		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine22

nextAddr22:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop22

callRoutine22:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit22

memoryRead22:
		mov	dl, [ebp + ebx]	; Get our data

readExit22:
		mov	byte [_z80de], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst5f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	byte [_z80de], al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst60:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst61:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst62:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, byte [_z80de + 1]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst63:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, byte [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst64:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst65:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst66:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop23:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead23
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr23		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine23

nextAddr23:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop23

callRoutine23:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit23

memoryRead23:
		mov	bh, [ebp + ebx]	; Get our data

readExit23:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst67:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bh, al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst68:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst69:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, byte [_z80de + 1]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, byte [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop24:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead24
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr24		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine24

nextAddr24:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop24

callRoutine24:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit24

memoryRead24:
		mov	bl, [ebp + ebx]	; Get our data

readExit24:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst6f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	bl, al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst70:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop25:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite25	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr25	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine25	; If not, go call it!

nextAddr25:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop25

callRoutine25:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit25
memoryWrite25:
		mov	[ebp + ebx], ch
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit25:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst71:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop26:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite26	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr26	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine26	; If not, go call it!

nextAddr26:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop26

callRoutine26:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit26
memoryWrite26:
		mov	[ebp + ebx], cl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit26:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst72:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop27:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite27	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr27	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine27	; If not, go call it!

nextAddr27:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop27

callRoutine27:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit27
memoryWrite27:
		mov	edi, edx
		mov	dl, byte [_z80de + 1]
		mov	[ebp + ebx], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit27:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst73:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop28:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite28	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr28	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine28	; If not, go call it!

nextAddr28:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop28

callRoutine28:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit28
memoryWrite28:
		mov	edi, edx
		mov	dl, byte [_z80de]
		mov	[ebp + ebx], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit28:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst74:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop29:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite29	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr29	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine29	; If not, go call it!

nextAddr29:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop29

callRoutine29:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit29
memoryWrite29:
		mov	[ebp + ebx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit29:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst75:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop30:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite30	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr30	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine30	; If not, go call it!

nextAddr30:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop30

callRoutine30:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit30
memoryWrite30:
		mov	[ebp + ebx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit30:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst76:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dword [_z80halted], 1	; We've halted the chip!
		mov	edx, dword [cyclesRemaining] ; Get the time remaining
		add	[dwElapsedTicks], edx ; Fake like we did it
		jmp	noMoreExec
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst77:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop31:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite31	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr31	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine31	; If not, go call it!

nextAddr31:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop31

callRoutine31:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit31
memoryWrite31:
		mov	[ebp + ebx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit31:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst78:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, ch
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst79:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, cl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, byte [_z80de + 1]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, byte [_z80de]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, bh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	al, bl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop32:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead32
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr32		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine32

nextAddr32:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop32

callRoutine32:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit32

memoryRead32:
		mov	al, [ebp + ebx]	; Get our data

readExit32:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst7f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst80:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst81:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst82:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst83:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst84:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst85:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst86:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop33:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead33
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr33		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine33

nextAddr33:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop33

callRoutine33:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit33

memoryRead33:
		mov	dl, [ebp + ebx]	; Get our data

readExit33:
		sahf
		add	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst87:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		add	al, al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst88:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst89:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop34:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead34
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr34		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine34

nextAddr34:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop34

callRoutine34:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit34

memoryRead34:
		mov	dl, [ebp + ebx]	; Get our data

readExit34:
		sahf
		adc	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst8f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		adc	al, al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh ; No N!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst90:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst91:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst92:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst93:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst94:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst95:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst96:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop35:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead35
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr35		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine35

nextAddr35:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop35

callRoutine35:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit35

memoryRead35:
		mov	dl, [ebp + ebx]	; Get our data

readExit35:
		sahf
		sub	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst97:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sub	al, al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst98:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst99:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9a:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9b:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9c:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9d:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9e:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop36:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead36
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr36		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine36

nextAddr36:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop36

callRoutine36:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit36

memoryRead36:
		mov	dl, [ebp + ebx]	; Get our data

readExit36:
		sahf
		sbb	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInst9f:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		sbb	al, al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta0:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, ch
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta1:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, cl
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta2:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, byte [_z80de + 1]
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta3:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, byte [_z80de]
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta4:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, bh
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta5:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, bl
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop37:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead37
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr37		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine37

nextAddr37:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop37

callRoutine37:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit37

memoryRead37:
		mov	dl, [ebp + ebx]	; Get our data

readExit37:
		sahf
		and	al, dl
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta7:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		and	al, al
		lahf
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta8:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, ch
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsta9:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, cl
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstaa:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, byte [_z80de + 1]
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstab:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, byte [_z80de]
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstac:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, bh
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstad:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, bl
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstae:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop38:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead38
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr38		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine38

nextAddr38:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop38

callRoutine38:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit38

memoryRead38:
		mov	dl, [ebp + ebx]	; Get our data

readExit38:
		sahf
		xor	al, dl
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstaf:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		xor	al, al
		lahf
		and	ah, 0ech	; Only these flags matter!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb0:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, ch
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb1:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, cl
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb2:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, byte [_z80de + 1]
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb3:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, byte [_z80de]
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb4:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, bh
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb5:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, bl
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop39:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead39
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr39		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine39

nextAddr39:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop39

callRoutine39:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit39

memoryRead39:
		mov	dl, [ebp + ebx]	; Get our data

readExit39:
		sahf
		or	al, dl
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb7:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		or	al, al
		lahf
		and	ah, 0ech ; No H, N, or C
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb8:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, ch
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstb9:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, cl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstba:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, byte [_z80de + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstbb:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, byte [_z80de]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstbc:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, bh
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstbd:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, bl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstbe:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop40:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead40
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr40		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine40

nextAddr40:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop40

callRoutine40:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit40

memoryRead40:
		mov	dl, [ebp + ebx]	; Get our data

readExit40:
		sahf
		cmp	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstbf:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		sahf
		cmp	al, al
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set N for compare!
		xor	dh, dh	; Zero this...
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc0:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jnz	takeReturn41
		jmp	short retNotTaken41
takeReturn41:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken41:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc1:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop42:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead42
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr42		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine42

nextAddr42:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop42

callRoutine42:
		call	ReadMemoryByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit42

memoryRead42:
		mov	cl, [ebp + edx]	; Get our data

readExit42:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop43:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead43
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr43		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine43

nextAddr43:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop43

callRoutine43:
		call	ReadMemoryByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit43

memoryRead43:
		mov	ch, [ebp + edx]	; Get our data

readExit43:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc2:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jnz	takeJump44	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst44	 ; Go execute the next instruction
takeJump44:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst44:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc3:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	si, [esi]	; Get our new address
		and	esi, 0ffffh	; Only the lower 16 bits
		add	esi, ebp		; Our new address!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc4:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jnz	takeJump45	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken45	 ; Go execute the next instruction
takeJump45:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken45:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc5:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop46:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite46	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr46	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine46	; If not, go call it!

nextAddr46:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop46

callRoutine46:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit46
memoryWrite46:
		mov	[ebp + edx], cl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit46:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop47:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite47	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr47	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine47	; If not, go call it!

nextAddr47:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop47

callRoutine47:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit47
memoryWrite47:
		mov	[ebp + edx], ch
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit47:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		add	al, [esi]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; Knock out N!
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc7:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 000h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc8:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jz	takeReturn48
		jmp	short retNotTaken48
takeReturn48:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken48:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstc9:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstca:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jz	takeJump49	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst49	 ; Go execute the next instruction
takeJump49:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst49:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

;
; Handler for all CBxx instructions
;

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstcb:
		mov	[_baseFixup], dword 1
		mov	dl, [esi]
		inc	esi
		jmp	dword [z80PrefixCB+edx*4]




times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstcc:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jz	takeJump50	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken50	 ; Go execute the next instruction
takeJump50:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken50:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstcd:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstce:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		adc	al, [esi]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; Knock out N!
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstcf:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 008h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd0:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jnc	takeReturn51
		jmp	short retNotTaken51
takeReturn51:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken51:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd1:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop52:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead52
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr52		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine52

nextAddr52:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop52

callRoutine52:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit52

memoryRead52:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de], dl
		mov	dx, di
readExit52:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop53:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead53
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr53		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine53

nextAddr53:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop53

callRoutine53:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit53

memoryRead53:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de + 1], dl
		mov	dx, di
readExit53:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd2:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jnc	takeJump54	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst54	 ; Go execute the next instruction
takeJump54:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst54:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd3:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, [esi]	; Get our address to 'out' to
		inc	esi	; Next address
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop55:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit55	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr55	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine55	; If not, go call it!

nextAddr55:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop55

callRoutine55:
		call	WriteIOByte	; Go write the data!
WriteMacroExit55:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd4:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jnc	takeJump56	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken56	 ; Go execute the next instruction
takeJump56:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken56:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd5:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop57:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite57	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr57	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine57	; If not, go call it!

nextAddr57:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop57

callRoutine57:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit57
memoryWrite57:
		mov	edi, edx
		mov	dl, byte [_z80de]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit57:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop58:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite58	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr58	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine58	; If not, go call it!

nextAddr58:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop58

callRoutine58:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit58
memoryWrite58:
		mov	edi, edx
		mov	dl, byte [_z80de + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit58:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		sub	al, [esi]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Set negative!
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd7:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 010h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd8:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jc	takeReturn59
		jmp	short retNotTaken59
takeReturn59:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken59:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstd9:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	di, [_z80de]
		xchg	cx, [_z80bcprime]
		xchg	di, [_z80deprime]
		xchg	bx, [_z80hlprime]
		mov	[_z80de], di
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstda:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jc	takeJump60	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst60	 ; Go execute the next instruction
takeJump60:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst60:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstdb:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dl, [esi]	; Get our address to 'out' to
		inc	esi	; Next address
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop61:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead61
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr61		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine61

nextAddr61:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop61

callRoutine61:
		call	ReadIOByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit61

ioRead61:
		mov	al, 0ffh	; An unreferenced read
readExit61:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstdc:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jc	takeJump62	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken62	 ; Go execute the next instruction
takeJump62:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken62:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

;
; Handler for all DDxx instructions
;

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstdd:
		mov	[_baseFixup], dword 1
		mov	dl, [esi]
		inc	esi
		jmp	dword [z80PrefixDD+edx*4]




times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstde:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		sbb	al, [esi]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Set negative!
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstdf:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 018h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste0:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jpo	takeReturn63
		jmp	short retNotTaken63
takeReturn63:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken63:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste1:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop64:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead64
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr64		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine64

nextAddr64:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop64

callRoutine64:
		call	ReadMemoryByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit64

memoryRead64:
		mov	bl, [ebp + edx]	; Get our data

readExit64:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop65:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead65
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr65		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine65

nextAddr65:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop65

callRoutine65:
		call	ReadMemoryByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit65

memoryRead65:
		mov	bh, [ebp + edx]	; Get our data

readExit65:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste2:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jpo	takeJump66	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst66	 ; Go execute the next instruction
takeJump66:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst66:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste3:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 19
		mov	dx, word [_z80sp]
		xchg	bx, [ebp+edx]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste4:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jpo	takeJump67	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken67	 ; Go execute the next instruction
takeJump67:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken67:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste5:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop68:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite68	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr68	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine68	; If not, go call it!

nextAddr68:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop68

callRoutine68:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit68
memoryWrite68:
		mov	[ebp + edx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit68:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop69:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite69	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr69	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine69	; If not, go call it!

nextAddr69:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop69

callRoutine69:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit69
memoryWrite69:
		mov	[ebp + edx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit69:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		and	al, [esi]
		lahf
		and	ah, 0ech ; Only parity, half carry, sign, zero
		or	ah, 10h	; Half carry
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste7:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 020h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste8:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jpe	takeReturn70
		jmp	short retNotTaken70
takeReturn70:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken70:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInste9:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	si, bx
		and	esi, 0ffffh
		add	esi, ebp
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstea:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jpe	takeJump71	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst71	 ; Go execute the next instruction
takeJump71:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst71:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsteb:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		xchg	[_z80de], bx	; Exchange DE & HL
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstec:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jpe	takeJump72	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken72	 ; Go execute the next instruction
takeJump72:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken72:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

;
; Handler for all EDxx instructions
;

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInsted:
		mov	[_baseFixup], dword 1
		mov	dl, [esi]
		inc	esi
		jmp	dword [z80PrefixED+edx*4]




times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstee:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		xor	al, [esi]
		lahf
		and	ah, 0ech	; No H, N, or C
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstef:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 028h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf0:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		jns	takeReturn73
		jmp	short retNotTaken73
takeReturn73:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken73:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf1:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop74:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead74
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr74		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine74

nextAddr74:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop74

callRoutine74:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af + 1], al	; Save our new flags
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit74

memoryRead74:
		mov	ah, [ebp + edx]	; Get our data

readExit74:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop75:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead75
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr75		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine75

nextAddr75:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop75

callRoutine75:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit75

memoryRead75:
		mov	al, [ebp + edx]	; Get our data

readExit75:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf2:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jns	takeJump76	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst76	 ; Go execute the next instruction
takeJump76:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst76:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf3:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dword [_z80interruptState], 0	; Interrupts disabled now
		mov	dword [_z80inInterrupt], 0	; Not in an interrupt
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf4:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		jns	takeJump77	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken77	 ; Go execute the next instruction
takeJump77:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken77:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf5:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, ah	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop78:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite78	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr78	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine78	; If not, go call it!

nextAddr78:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop78

callRoutine78:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit78
memoryWrite78:
		mov	[ebp + edx], ah
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit78:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop79:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite79	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr79	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine79	; If not, go call it!

nextAddr79:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop79

callRoutine79:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit79
memoryWrite79:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit79:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf6:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		or	al, [esi]
		lahf
		and	ah, 0ech	; No H, N, or C
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf7:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 030h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf8:
		sub	dword [cyclesRemaining], byte 5
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 5
		sahf
		js	takeReturn80
		jmp	short retNotTaken80
takeReturn80:
		add	[dwElapsedTicks], dword 6
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh
retNotTaken80:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstf9:
		sub	dword [cyclesRemaining], byte 6
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 6
		mov	word [_z80sp], bx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstfa:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		js	takeJump81	; We're going to take a jump
		add	esi, 2		; Skip past the address
		jmp	short nextInst81	 ; Go execute the next instruction
takeJump81:
		add	dword [dwElapsedTicks], 7
		mov	si, [esi]	; Get our new offset
		and	esi, 0ffffh	; Only the lower WORD is valid
		add	esi, ebp		; Our new address!
nextInst81:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstfb:
		sub	dword [cyclesRemaining], byte 4
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 4
		mov	dword [_z80interruptState], 1	; Interrupts enabled now
		mov	dword [_z80inInterrupt], 0	; Not in an interrupt
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstfc:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 10
		sahf		; Restore our flags
		js	takeJump82	; We're going call in this case
		add	esi, 2		; Skip past the address
		jmp	short noCallTaken82	 ; Go execute the next instruction
takeJump82:
		add	[dwElapsedTicks], dword 7
		mov	dx, [esi]	; Get our call to address
		mov	[_z80pc], dx ; Store our new program counter
		add	esi, 2		; Skip to our new address to be pushed
		sub	esi, ebp		; Value to push onto the "stack"
		mov	dx, word [_z80sp] ; Get the current stack pointer
		sub	dx, 2		; Back up two bytes
		mov	[ebp+edx], si ; PUSH It!
		mov	word [_z80sp], dx	; Store our new stack pointer
		mov	si, [_z80pc] ; Get our new program counter
		add	esi, ebp		; Naturalize it!
		xor	dh, dh
noCallTaken82:
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

;
; Handler for all FDxx instructions
;

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstfd:
		mov	[_baseFixup], dword 1
		mov	dl, [esi]
		inc	esi
		jmp	dword [z80PrefixFD+edx*4]




times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstfe:
		sub	dword [cyclesRemaining], byte 7
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 7
		sahf
		cmp	al, [esi]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Set negative!
		inc	esi
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

RegInstff:
		sub	dword [cyclesRemaining], byte 11
		jc	near noMoreExec
		add	dword [dwElapsedTicks], byte 11
		mov	dx, word [_z80sp]	; Get our stack pointer
		sub	dx, 2		; Make room for the new value!
		mov	word [_z80sp], dx	; Store our new stack pointer
		sub	esi, ebp		; Get our real PC
		mov	[ebp+edx], si	; Our return address
		mov	si, 038h	; Our new call address
		add	esi, ebp	; Back to the base!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst00:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rol	ch, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	ch, ch
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst01:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rol	cl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	cl, cl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst02:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rol	dh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dh, dh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst03:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rol	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst04:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rol	bh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bh, bh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst05:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rol	bl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bl, bl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst06:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop83:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead83
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr83		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine83

nextAddr83:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop83

callRoutine83:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit83

memoryRead83:
		mov	dl, [ebp + ebx]	; Get our data

readExit83:
		sahf
		rol	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop84:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite84	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr84	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine84	; If not, go call it!

nextAddr84:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop84

callRoutine84:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit84
memoryWrite84:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit84:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst07:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rol	al, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	al, al
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst08:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		ror	ch, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	ch, ch
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst09:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		ror	cl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	cl, cl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		ror	dh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dh, dh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		ror	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		ror	bh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bh, bh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		ror	bl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bl, bl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop85:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead85
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr85		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine85

nextAddr85:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop85

callRoutine85:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit85

memoryRead85:
		mov	dl, [ebp + ebx]	; Get our data

readExit85:
		sahf
		ror	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop86:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite86	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr86	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine86	; If not, go call it!

nextAddr86:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop86

callRoutine86:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit86
memoryWrite86:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit86:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst0f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		ror	al, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	al, al
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst10:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcl	ch, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	ch, ch
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst11:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcl	cl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	cl, cl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst12:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rcl	dh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dh, dh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst13:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rcl	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst14:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcl	bh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bh, bh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst15:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcl	bl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bl, bl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst16:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop87:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead87
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr87		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine87

nextAddr87:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop87

callRoutine87:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit87

memoryRead87:
		mov	dl, [ebp + ebx]	; Get our data

readExit87:
		sahf
		rcl	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop88:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite88	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr88	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine88	; If not, go call it!

nextAddr88:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop88

callRoutine88:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit88
memoryWrite88:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit88:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst17:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcl	al, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	al, al
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst18:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcr	ch, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	ch, ch
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst19:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcr	cl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	cl, cl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rcr	dh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dh, dh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		rcr	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcr	bh, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bh, bh
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcr	bl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	bl, bl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop89:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead89
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr89		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine89

nextAddr89:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop89

callRoutine89:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit89

memoryRead89:
		mov	dl, [ebp + ebx]	; Get our data

readExit89:
		sahf
		rcr	dl, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	dl, dl
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop90:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite90	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr90	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine90	; If not, go call it!

nextAddr90:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop90

callRoutine90:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit90
memoryWrite90:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit90:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst1f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		rcr	al, 1
		lahf
		and	ah, 029h	; Clear H and N
		mov	byte [_z80af], ah
		or	al, al
		lahf
		and	ah, 0c4h	; Sign, zero, and parity
		or	ah, byte [_z80af]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst20:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	ch, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst21:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	cl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst22:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shl	dh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst23:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shl	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst24:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	bh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst25:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	bl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst26:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop91:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead91
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr91		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine91

nextAddr91:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop91

callRoutine91:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit91

memoryRead91:
		mov	dl, [ebp + ebx]	; Get our data

readExit91:
		sahf
		shl	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop92:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite92	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr92	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine92	; If not, go call it!

nextAddr92:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop92

callRoutine92:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit92
memoryWrite92:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit92:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst27:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	al, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst28:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sar	ch, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst29:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sar	cl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		sar	dh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		sar	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sar	bh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sar	bl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop93:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead93
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr93		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine93

nextAddr93:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop93

callRoutine93:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit93

memoryRead93:
		mov	dl, [ebp + ebx]	; Get our data

readExit93:
		sahf
		sar	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop94:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite94	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr94	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine94	; If not, go call it!

nextAddr94:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop94

callRoutine94:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit94
memoryWrite94:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit94:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst2f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sar	al, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst30:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	ch, 1
		lahf
		or	ch, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst31:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	cl, 1
		lahf
		or	cl, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst32:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shl	dh, 1
		lahf
		or	dh, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst33:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shl	dl, 1
		lahf
		or	dl, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst34:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	bh, 1
		lahf
		or	bh, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst35:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	bl, 1
		lahf
		or	bl, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst36:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop95:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead95
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr95		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine95

nextAddr95:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop95

callRoutine95:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit95

memoryRead95:
		mov	dl, [ebp + ebx]	; Get our data

readExit95:
		sahf
		shl	dl, 1
		lahf
		or	dl, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop96:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite96	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr96	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine96	; If not, go call it!

nextAddr96:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop96

callRoutine96:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit96
memoryWrite96:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit96:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst37:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shl	al, 1
		lahf
		or	al, 1	; Slide in a 1 bit (SLIA)
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst38:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shr	ch, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst39:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shr	cl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shr	dh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		sahf
		shr	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shr	bh, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shr	bl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop97:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead97
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr97		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine97

nextAddr97:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop97

callRoutine97:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit97

memoryRead97:
		mov	dl, [ebp + ebx]	; Get our data

readExit97:
		sahf
		shr	dl, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop98:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite98	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr98	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine98	; If not, go call it!

nextAddr98:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop98

callRoutine98:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit98
memoryWrite98:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit98:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst3f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		shr	al, 1
		lahf
		and	ah, 0edh	; Clear H and N
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst40:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst41:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst42:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst43:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst44:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst45:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst46:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop99:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead99
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr99		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine99

nextAddr99:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop99

callRoutine99:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit99

memoryRead99:
		mov	dl, [ebp + ebx]	; Get our data

readExit99:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst47:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 001h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst48:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst49:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4e:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop100:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead100
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr100		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine100

nextAddr100:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop100

callRoutine100:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit100

memoryRead100:
		mov	dl, [ebp + ebx]	; Get our data

readExit100:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst4f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 002h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst50:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst51:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst52:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst53:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst54:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst55:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst56:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop101:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead101
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr101		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine101

nextAddr101:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop101

callRoutine101:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit101

memoryRead101:
		mov	dl, [ebp + ebx]	; Get our data

readExit101:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst57:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 004h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst58:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst59:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5e:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop102:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead102
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr102		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine102

nextAddr102:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop102

callRoutine102:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit102

memoryRead102:
		mov	dl, [ebp + ebx]	; Get our data

readExit102:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst5f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 008h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst60:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst61:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst62:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst63:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst64:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst65:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst66:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop103:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead103
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr103		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine103

nextAddr103:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop103

callRoutine103:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit103

memoryRead103:
		mov	dl, [ebp + ebx]	; Get our data

readExit103:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst67:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 010h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst68:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst69:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6e:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop104:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead104
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr104		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine104

nextAddr104:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop104

callRoutine104:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit104

memoryRead104:
		mov	dl, [ebp + ebx]	; Get our data

readExit104:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst6f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 020h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst70:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst71:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst72:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst73:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst74:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst75:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst76:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop105:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead105
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr105		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine105

nextAddr105:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop105

callRoutine105:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit105

memoryRead105:
		mov	dl, [ebp + ebx]	; Get our data

readExit105:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst77:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 040h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst78:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test ch, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst79:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test cl, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de + 1], 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test byte [_z80de], 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bh, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test bl, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7e:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop106:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead106
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr106		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine106

nextAddr106:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop106

callRoutine106:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit106

memoryRead106:
		mov	dl, [ebp + ebx]	; Get our data

readExit106:
		mov	byte [_z80af], ah ; Store F
		sahf
		test	dl, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst7f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	byte [_z80af], ah ; Store F
		sahf
		test al, 080h	; Do a bitwise check
		lahf
		and	ah, 0c4h	; Only care about Z
		or	ah, 10h	; Set half carry to 1
		and	byte [_z80af], 029h		; Only zero/non-zero!
		or	ah, byte [_z80af]	; Put it in with the real flags
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst80:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0feh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst81:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0feh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst82:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0feh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst83:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0feh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst84:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0feh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst85:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0feh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst86:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop107:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead107
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr107		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine107

nextAddr107:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop107

callRoutine107:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit107

memoryRead107:
		mov	dl, [ebp + ebx]	; Get our data

readExit107:
		and dl, 0feh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop108:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite108	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr108	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine108	; If not, go call it!

nextAddr108:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop108

callRoutine108:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit108
memoryWrite108:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit108:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst87:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0feh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst88:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0fdh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst89:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0fdh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0fdh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0fdh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0fdh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0fdh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop109:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead109
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr109		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine109

nextAddr109:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop109

callRoutine109:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit109

memoryRead109:
		mov	dl, [ebp + ebx]	; Get our data

readExit109:
		and dl, 0fdh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop110:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite110	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr110	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine110	; If not, go call it!

nextAddr110:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop110

callRoutine110:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit110
memoryWrite110:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit110:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst8f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0fdh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst90:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0fbh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst91:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0fbh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst92:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0fbh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst93:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0fbh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst94:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0fbh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst95:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0fbh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst96:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop111:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead111
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr111		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine111

nextAddr111:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop111

callRoutine111:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit111

memoryRead111:
		mov	dl, [ebp + ebx]	; Get our data

readExit111:
		and dl, 0fbh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop112:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite112	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr112	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine112	; If not, go call it!

nextAddr112:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop112

callRoutine112:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit112
memoryWrite112:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit112:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst97:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0fbh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst98:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0f7h	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst99:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0f7h	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9a:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0f7h	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9b:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0f7h	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9c:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0f7h	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9d:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0f7h	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9e:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop113:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead113
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr113		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine113

nextAddr113:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop113

callRoutine113:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit113

memoryRead113:
		mov	dl, [ebp + ebx]	; Get our data

readExit113:
		and dl, 0f7h	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop114:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite114	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr114	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine114	; If not, go call it!

nextAddr114:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop114

callRoutine114:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit114
memoryWrite114:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit114:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInst9f:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0f7h	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0efh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0efh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0efh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0efh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0efh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0efh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop115:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead115
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr115		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine115

nextAddr115:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop115

callRoutine115:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit115

memoryRead115:
		mov	dl, [ebp + ebx]	; Get our data

readExit115:
		and dl, 0efh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop116:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite116	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr116	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine116	; If not, go call it!

nextAddr116:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop116

callRoutine116:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit116
memoryWrite116:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit116:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0efh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0dfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsta9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0dfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstaa:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0dfh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstab:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0dfh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstac:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0dfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstad:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0dfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstae:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop117:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead117
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr117		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine117

nextAddr117:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop117

callRoutine117:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit117

memoryRead117:
		mov	dl, [ebp + ebx]	; Get our data

readExit117:
		and dl, 0dfh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop118:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite118	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr118	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine118	; If not, go call it!

nextAddr118:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop118

callRoutine118:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit118
memoryWrite118:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit118:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstaf:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0dfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 0bfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 0bfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 0bfh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 0bfh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 0bfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 0bfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop119:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead119
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr119		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine119

nextAddr119:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop119

callRoutine119:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit119

memoryRead119:
		mov	dl, [ebp + ebx]	; Get our data

readExit119:
		and dl, 0bfh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop120:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite120	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr120	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine120	; If not, go call it!

nextAddr120:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop120

callRoutine120:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit120
memoryWrite120:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit120:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 0bfh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and ch, 07fh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstb9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and cl, 07fh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstba:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dh, 07fh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstbb:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		and dl, 07fh	; Reset a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstbc:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bh, 07fh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstbd:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and bl, 07fh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstbe:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop121:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead121
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr121		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine121

nextAddr121:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop121

callRoutine121:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit121

memoryRead121:
		mov	dl, [ebp + ebx]	; Get our data

readExit121:
		and dl, 07fh	; Reset a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop122:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite122	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr122	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine122	; If not, go call it!

nextAddr122:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop122

callRoutine122:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit122
memoryWrite122:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit122:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstbf:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		and al, 07fh	; Reset a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 001h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 001h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 001h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 001h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 001h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 001h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop123:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead123
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr123		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine123

nextAddr123:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop123

callRoutine123:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit123

memoryRead123:
		mov	dl, [ebp + ebx]	; Get our data

readExit123:
		or	dl, 001h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop124:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite124	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr124	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine124	; If not, go call it!

nextAddr124:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop124

callRoutine124:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit124
memoryWrite124:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit124:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 001h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 002h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstc9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 002h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstca:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 002h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstcb:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 002h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstcc:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 002h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstcd:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 002h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstce:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop125:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead125
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr125		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine125

nextAddr125:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop125

callRoutine125:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit125

memoryRead125:
		mov	dl, [ebp + ebx]	; Get our data

readExit125:
		or	dl, 002h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop126:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite126	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr126	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine126	; If not, go call it!

nextAddr126:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop126

callRoutine126:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit126
memoryWrite126:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit126:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstcf:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 002h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 004h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 004h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 004h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 004h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 004h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 004h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop127:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead127
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr127		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine127

nextAddr127:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop127

callRoutine127:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit127

memoryRead127:
		mov	dl, [ebp + ebx]	; Get our data

readExit127:
		or	dl, 004h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop128:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite128	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr128	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine128	; If not, go call it!

nextAddr128:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop128

callRoutine128:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit128
memoryWrite128:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit128:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 004h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 008h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstd9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 008h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstda:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 008h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstdb:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 008h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstdc:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 008h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstdd:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 008h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstde:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop129:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead129
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr129		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine129

nextAddr129:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop129

callRoutine129:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit129

memoryRead129:
		mov	dl, [ebp + ebx]	; Get our data

readExit129:
		or	dl, 008h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop130:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite130	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr130	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine130	; If not, go call it!

nextAddr130:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop130

callRoutine130:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit130
memoryWrite130:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit130:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstdf:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 008h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 010h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 010h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 010h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 010h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 010h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 010h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop131:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead131
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr131		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine131

nextAddr131:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop131

callRoutine131:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit131

memoryRead131:
		mov	dl, [ebp + ebx]	; Get our data

readExit131:
		or	dl, 010h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop132:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite132	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr132	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine132	; If not, go call it!

nextAddr132:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop132

callRoutine132:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit132
memoryWrite132:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit132:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 010h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 020h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInste9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 020h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstea:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 020h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsteb:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 020h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstec:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 020h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInsted:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 020h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstee:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop133:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead133
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr133		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine133

nextAddr133:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop133

callRoutine133:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit133

memoryRead133:
		mov	dl, [ebp + ebx]	; Get our data

readExit133:
		or	dl, 020h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop134:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite134	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr134	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine134	; If not, go call it!

nextAddr134:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop134

callRoutine134:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit134
memoryWrite134:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit134:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstef:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 020h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf0:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 040h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf1:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 040h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf2:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 040h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf3:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 040h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf4:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 040h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf5:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 040h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf6:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop135:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead135
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr135		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine135

nextAddr135:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop135

callRoutine135:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit135

memoryRead135:
		mov	dl, [ebp + ebx]	; Get our data

readExit135:
		or	dl, 040h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop136:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite136	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr136	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine136	; If not, go call it!

nextAddr136:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop136

callRoutine136:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit136
memoryWrite136:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit136:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf7:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 040h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf8:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	ch, 080h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstf9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	cl, 080h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstfa:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dh, 080h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstfb:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80de]	; Move DE into something half usable
		or	dl, 080h	; Set a bit
		mov	[_z80de], dx	; Once modified, put it back
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstfc:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bh, 080h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstfd:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	bl, 080h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstfe:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop137:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead137
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr137		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine137

nextAddr137:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop137

callRoutine137:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit137

memoryRead137:
		mov	dl, [ebp + ebx]	; Get our data

readExit137:
		or	dl, 080h	; Set a bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop138:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite138	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr138	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine138	; If not, go call it!

nextAddr138:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop138

callRoutine138:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit138
memoryWrite138:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit138:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

CBInstff:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		or	al, 080h	; Set a bit
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst40:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop139:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead139
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr139		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine139

nextAddr139:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop139

callRoutine139:
		call	ReadIOByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit139

ioRead139:
		mov	ch, 0ffh	; An unreferenced read
readExit139:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		or	ch, ch;
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst41:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop140:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit140	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr140	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine140	; If not, go call it!

nextAddr140:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop140

callRoutine140:
		call	WriteIOByte	; Go write the data!
WriteMacroExit140:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst42:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, cx	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		sbb	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		or	ah, 02h	; Negative!
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		mov	[_z80hl], bx
		xor	bx, [_orgval]
		xor	bx, [_orgval2]
		and	bh, 10h	; Half carry?
		or	ah, bh	; OR It in if so
		mov	bx, [_z80hl]
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst43:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop141:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite141	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr141	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine141	; If not, go call it!

nextAddr141:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop141

callRoutine141:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit141
memoryWrite141:
		mov	[ebp + edx], cl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit141:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop142:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite142	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr142	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine142	; If not, go call it!

nextAddr142:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop142

callRoutine142:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit142
memoryWrite142:
		mov	[ebp + edx], ch
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit142:
		xor	dh, dh	; Zero our upper word
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst44:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		sahf
		sub	dh, al
		lahf
		mov	al, dh
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst45:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst46:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dword [_z80interruptMode], 0 ; IM 0
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst47:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
           mov     [_z80i], al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst48:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop143:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead143
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr143		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine143

nextAddr143:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop143

callRoutine143:
		call	ReadIOByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit143

ioRead143:
		mov	cl, 0ffh	; An unreferenced read
readExit143:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		or	cl, cl;
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst49:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop144:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit144	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr144	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine144	; If not, go call it!

nextAddr144:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop144

callRoutine144:
		call	WriteIOByte	; Go write the data!
WriteMacroExit144:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst4a:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, cx	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		adc	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst4b:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get address to load
		add	esi, 2	; Skip over it so we don't execute it
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop145:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead145
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr145		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine145

nextAddr145:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop145

callRoutine145:
		call	ReadMemoryByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit145

memoryRead145:
		mov	cl, [ebp + edx]	; Get our data

readExit145:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop146:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead146
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr146		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine146

nextAddr146:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop146

callRoutine146:
		call	ReadMemoryByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit146

memoryRead146:
		mov	ch, [ebp + edx]	; Get our data

readExit146:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst4d:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	dx, word [_z80sp]	; Get our current stack pointer
		mov	si, [edx+ebp]	; Get our return address
		and	esi, 0ffffh		; Only within 64K!
		add	esi, ebp			; Add in our base address
		add	word [_z80sp], 02h	; Remove our two bytes from the stack
		mov	dword [_z80inInterrupt], 0
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst4f:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
           mov     [_z80r], al
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst50:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop147:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead147
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr147		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine147

nextAddr147:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop147

callRoutine147:
		call	ReadIOByte	; Standard read routine
		mov	byte [_z80de + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit147

ioRead147:
		mov	byte [_z80de + 1], 0ffh	; An unreferenced read
readExit147:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		mov	dl, byte [_z80de + 1]
		or	dl, dl
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst51:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop148:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit148	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr148	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine148	; If not, go call it!

nextAddr148:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop148

callRoutine148:
		call	WriteIOByte	; Go write the data!
WriteMacroExit148:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst52:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, word [_z80de]	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		sbb	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		or	ah, 02h	; Negative!
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		mov	[_z80hl], bx
		xor	bx, [_orgval]
		xor	bx, [_orgval2]
		and	bh, 10h	; Half carry?
		or	ah, bh	; OR It in if so
		mov	bx, [_z80hl]
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst53:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop149:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite149	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr149	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine149	; If not, go call it!

nextAddr149:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop149

callRoutine149:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit149
memoryWrite149:
		mov	edi, edx
		mov	dl, byte [_z80de]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit149:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop150:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite150	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr150	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine150	; If not, go call it!

nextAddr150:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop150

callRoutine150:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit150
memoryWrite150:
		mov	edi, edx
		mov	dl, byte [_z80de + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit150:
		xor	dh, dh	; Zero our upper word
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst56:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dword [_z80interruptMode], 1 ; Interrupt mode 1
		mov	word [_z80intAddr], 038h	; Interrupt mode 1 cmd!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst57:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
           mov     al, [_z80i]
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst58:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop151:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead151
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr151		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine151

nextAddr151:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop151

callRoutine151:
		call	ReadIOByte	; Standard read routine
		mov	byte [_z80de], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit151

ioRead151:
		mov	byte [_z80de], 0ffh	; An unreferenced read
readExit151:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		mov	dl, byte [_z80de]
		or	dl, dl
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst59:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop152:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit152	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr152	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine152	; If not, go call it!

nextAddr152:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop152

callRoutine152:
		call	WriteIOByte	; Go write the data!
WriteMacroExit152:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst5a:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, word [_z80de]	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		adc	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst5b:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get address to load
		add	esi, 2	; Skip over it so we don't execute it
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop153:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead153
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr153		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine153

nextAddr153:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop153

callRoutine153:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit153

memoryRead153:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de], dl
		mov	dx, di
readExit153:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop154:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead154
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr154		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine154

nextAddr154:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop154

callRoutine154:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit154

memoryRead154:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de + 1], dl
		mov	dx, di
readExit154:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst5e:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dword [_z80interruptMode], 2 ; IM 2
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst5f:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
           mov     al, [_z80r]
		and	ah, 029h	; No N, H, Z, or S!
		or	al,al	; Get appropriate flags
		o16 pushf
		pop	dx
		and	dl, 0c0h
		or	ah, dl	; OR In our S & Z flags
		mov	dl, byte [_z80inInterrupt]
		not	dl
		and	dl, 1
		shl	dl, 2
		or	ah, dl
		xor	dh, dh
		mov	dl, [_z80r]
		add	dl, bl
		inc	dl
		add	dl, ch
		xor	dl, al
		mov	[_z80r], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst60:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop155:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead155
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr155		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine155

nextAddr155:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop155

callRoutine155:
		call	ReadIOByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit155

ioRead155:
		mov	bh, 0ffh	; An unreferenced read
readExit155:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		or	bh, bh;
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst61:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop156:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit156	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr156	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine156	; If not, go call it!

nextAddr156:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop156

callRoutine156:
		call	WriteIOByte	; Go write the data!
WriteMacroExit156:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst62:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, bx	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		sbb	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		or	ah, 02h	; Negative!
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		mov	[_z80hl], bx
		xor	bx, [_orgval]
		xor	bx, [_orgval2]
		and	bh, 10h	; Half carry?
		or	ah, bh	; OR It in if so
		mov	bx, [_z80hl]
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst63:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop157:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite157	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr157	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine157	; If not, go call it!

nextAddr157:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop157

callRoutine157:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit157
memoryWrite157:
		mov	[ebp + edx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit157:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop158:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite158	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr158	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine158	; If not, go call it!

nextAddr158:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop158

callRoutine158:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit158
memoryWrite158:
		mov	[ebp + edx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit158:
		xor	dh, dh	; Zero our upper word
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst67:
		sub	dword [cyclesRemaining], byte 18
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 18
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop159:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead159
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr159		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine159

nextAddr159:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop159

callRoutine159:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit159

memoryRead159:
		mov	dl, [ebp + ebx]	; Get our data

readExit159:
		mov	dh, dl	; Put a copy in DH
		shr	dl, 4	; Upper nibble to lower nibble
		shl	ecx, 16	; Save this
		mov	cl, al
		shl	cl, 4
		or	dl, cl	; OR In what was in A
		and	al, 0f0h	; Knock out lower part
		and	dh, 0fh	; Only the lower nibble
		or	al, dh	; OR In our nibble
		shr	ecx, 16	; Restore this
		and	ah, 29h	; Retain carry & two undefined bits
		mov	dh, ah	; Store our flags away for later
		or	dl, dl	; Get our flags
		lahf
		and	ah,0c4h	; Only partiy, zero, and sign
		or	ah, dh	; OR In our old flags
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop160:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite160	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr160	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine160	; If not, go call it!

nextAddr160:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop160

callRoutine160:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit160
memoryWrite160:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit160:
		xor	dh, dh	; Zero out this for later
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst68:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop161:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead161
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr161		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine161

nextAddr161:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop161

callRoutine161:
		call	ReadIOByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit161

ioRead161:
		mov	bl, 0ffh	; An unreferenced read
readExit161:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		or	bl, bl;
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst69:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop162:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit162	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr162	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine162	; If not, go call it!

nextAddr162:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop162

callRoutine162:
		call	WriteIOByte	; Go write the data!
WriteMacroExit162:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst6a:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, bx	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		adc	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst6f:
		sub	dword [cyclesRemaining], byte 18
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 18
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop163:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead163
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr163		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine163

nextAddr163:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop163

callRoutine163:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit163

memoryRead163:
		mov	dl, [ebp + ebx]	; Get our data

readExit163:
		mov	dh, dl	; Put a copy in DH
		shr	dh, 4	; Get our upper nibble in position
		shl	dl, 4	; Get our lower nibble into the higher position
		shl	ecx, 16	; Save this for later
		mov	cl, al
		and	cl, 0fh
	; Only the lower nibble
		or	dl, cl	; OR In A->(HL) transfer
		and	al, 0f0h	; Only the upper 4 bits remain
		or	al, dh	; OR It in to our accumulator
		shr	ecx, 16	; Restore this
		and	ah, 29h	; Retain carry & two undefined bits
		mov	dh, ah	; Store our flags away for later
		or	dl, dl	; Get our flags
		lahf
		and	ah,0c4h	; Only partiy, zero, and sign
		or	ah, dh	; OR In our old flags
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop164:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite164	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr164	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine164	; If not, go call it!

nextAddr164:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop164

callRoutine164:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit164
memoryWrite164:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit164:
		xor	dh, dh	; Zero out this for later
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst72:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, word [_z80sp]	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		sbb	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		or	ah, 02h	; Negative!
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		mov	[_z80hl], bx
		xor	bx, [_orgval]
		xor	bx, [_orgval2]
		and	bh, 10h	; Half carry?
		or	ah, bh	; OR It in if so
		mov	bx, [_z80hl]
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst73:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get our address to write to
		add	esi, 2		; Next address, please...
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80sp]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop165:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite165	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr165	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine165	; If not, go call it!

nextAddr165:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop165

callRoutine165:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit165
memoryWrite165:
		mov	edi, edx
		mov	dl, byte [_z80sp]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit165:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80sp + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop166:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite166	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr166	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine166	; If not, go call it!

nextAddr166:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop166

callRoutine166:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit166
memoryWrite166:
		mov	edi, edx
		mov	dl, byte [_z80sp + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit166:
		xor	dh, dh	; Zero our upper word
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst78:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop167:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead167
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr167		; Yes, go to the next address
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine167

nextAddr167:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop167

callRoutine167:
		call	ReadIOByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit167

ioRead167:
		mov	al, 0ffh	; An unreferenced read
readExit167:
;
; Remember, this variant of the IN instruction modifies the flags
;

		sahf	; Restore our flags
		mov	dh, ah	; Save flags for later
		or	al, al;
		lahf
		and	dh, 029h	; Only keep carry and two unused flags
		and	ah, 0d4h
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst79:
		sub	dword [cyclesRemaining], byte 12
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 12
		mov	dl, cl	; Address in DX... (C)
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop168:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit168	; Yes - ignore it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr168	; Yes... go to the next addr
		cmp	dx, [edi+2]	; Are we bigger?
		jbe	callRoutine168	; If not, go call it!

nextAddr168:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop168

callRoutine168:
		call	WriteIOByte	; Go write the data!
WriteMacroExit168:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst7a:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dx, word [_z80sp]	; Get our original register
		mov	[_orgval], dx	; Store this for later half carry computation
		mov	[_orgval2], bx	; Store this, too
		sahf		; Restore our flags
		adc	bx, dx	; Do the operation!
		lahf		; Get our new flags
		and	ah, 0edh	; Knock out negative & half carry flags
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInst7b:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	; Get address to load
		add	esi, 2	; Skip over it so we don't execute it
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop169:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead169
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr169		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine169

nextAddr169:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop169

callRoutine169:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80sp], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit169

memoryRead169:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80sp], dl
		mov	dx, di
readExit169:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop170:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead170
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr170		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine170

nextAddr170:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop170

callRoutine170:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80sp + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit170

memoryRead170:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80sp + 1], dl
		mov	dx, di
readExit170:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta0:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	[_orgval], cx	; Store BC for later
		push	esi	; Save our PC for later
		push	ebp	; Save our base pointer for later
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop171:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead171
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr171		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine171

nextAddr171:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop171

callRoutine171:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit171

memoryRead171:
		mov	dl, [ebp + ebx]	; Get our data

readExit171:
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_z80de]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop172:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite172	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr172	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine172	; If not, go call it!

nextAddr172:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop172

callRoutine172:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit172
memoryWrite172:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit172:
		inc	bx	; Increment HL
		inc	word [_z80de]	; Increment DE
		and	ah, 0e9h ; Knock out H & N and P/V
		dec	cx	; Decrement BC
		jz	atZero173 ; We're done!
		or	ah, 04h	; Non-zero - we're still going!
atZero173:
		pop	ebp	; Restore our base pointer
		pop	esi	; Restore PC
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta1:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop174:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead174
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr174		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine174

nextAddr174:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop174

callRoutine174:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit174

memoryRead174:
		mov	dl, [ebp + ebx]	; Get our data

readExit174:
		mov	byte [_z80af], ah
		sahf
		cmp	al, dl	; Do our comparison
		lahf
		and	ah, 0fah	; No P/V or carry!
		dec	cx	; Dec BC
		jz	notBcZero175
		or	ah, 04h	; P/V set when BC not zero
notBcZero175:
		or	ah, 02h	; N Gets set when we do compares
		mov	dl, byte [_z80af]
		and	dl, 01h
		or	ah, dl	; Preserve carry!
		inc	bx	; Increment!
		xor	edx, edx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta2:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		push	cx	; Save BC
		xor	ch, ch ; Not 16 bit for this instruction
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop176:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead176
		cmp	cx, [edi]	; Are we smaller?
		jb		nextAddr176		; Yes, go to the next address
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine176

nextAddr176:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop176

callRoutine176:
		mov	dx, cx	; Get our address
		call	ReadIOByte	; Standard read routine
		mov	dl, al	; Put it in DL for later consumption
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit176

ioRead176:
		mov	dl, 0ffh	; An unreferenced read
readExit176:
		pop	cx	; Restore BC
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop177:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite177	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr177	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine177	; If not, go call it!

nextAddr177:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop177

callRoutine177:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit177
memoryWrite177:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit177:
		inc	bx	; Increment HL
		dec	ch	; Decrement B (of C)
		jnz	clearFlag175
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue175
clearFlag175:
		and	ah, 0bfh	; Clear the zero flag
continue175:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta3:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop179:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead179
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr179		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine179

nextAddr179:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop179

callRoutine179:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit179

memoryRead179:
		mov	dl, [ebp + ebx]	; Get our data

readExit179:
		push	cx	; Save BC
		xor	ch, ch	; No 16 bit for this instruction!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop180:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit180	; Yes - ignore it!
		cmp	cx, [edi]	; Are we smaller?
		jb	nextAddr180	; Yes... go to the next addr
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine180	; If not, go call it!

nextAddr180:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop180

callRoutine180:
		mov	dx, cx	; Get our address to target
		call	WriteIOByte	; Go write the data!
WriteMacroExit180:
		pop	cx	; Restore BC now that it has been "OUT"ed
		inc	bx	; Increment HL
		dec	ch	; Decrement B (of C)
		jnz	clearFlag178
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue178
clearFlag178:
		and	ah, 0bfh	; Clear the zero flag
continue178:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta8:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	[_orgval], cx	; Store BC for later
		push	esi	; Save our PC for later
		push	ebp	; Save our base pointer for later
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop181:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead181
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr181		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine181

nextAddr181:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop181

callRoutine181:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit181

memoryRead181:
		mov	dl, [ebp + ebx]	; Get our data

readExit181:
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_z80de]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop182:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite182	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr182	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine182	; If not, go call it!

nextAddr182:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop182

callRoutine182:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit182
memoryWrite182:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit182:
		dec	bx	; Decrement HL
		dec	word [_z80de]	; Decrement DE
		and	ah, 0e9h ; Knock out H & N and P/V
		dec	cx	; Decrement BC
		jz	atZero183 ; We're done!
		or	ah, 04h	; Non-zero - we're still going!
atZero183:
		pop	ebp	; Restore our base pointer
		pop	esi	; Restore PC
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInsta9:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop184:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead184
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr184		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine184

nextAddr184:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop184

callRoutine184:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit184

memoryRead184:
		mov	dl, [ebp + ebx]	; Get our data

readExit184:
		mov	byte [_z80af], ah
		sahf
		cmp	al, dl	; Do our comparison
		lahf
		and	ah, 0fah	; No P/V or carry!
		dec	cx	; Dec BC
		jz	notBcZero185
		or	ah, 04h	; P/V set when BC not zero
notBcZero185:
		or	ah, 02h	; N Gets set when we do compares
		mov	dl, byte [_z80af]
		and	dl, 01h
		or	ah, dl	; Preserve carry!
		dec	bx	; Decrement!
		xor	edx, edx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstaa:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		push	cx	; Save BC
		xor	ch, ch ; Not 16 bit for this instruction
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop186:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead186
		cmp	cx, [edi]	; Are we smaller?
		jb		nextAddr186		; Yes, go to the next address
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine186

nextAddr186:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop186

callRoutine186:
		mov	dx, cx	; Get our address
		call	ReadIOByte	; Standard read routine
		mov	dl, al	; Put it in DL for later consumption
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit186

ioRead186:
		mov	dl, 0ffh	; An unreferenced read
readExit186:
		pop	cx	; Restore BC
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop187:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite187	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr187	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine187	; If not, go call it!

nextAddr187:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop187

callRoutine187:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit187
memoryWrite187:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit187:
		dec	bx	; Decrement HL
		dec	ch	; Decrement B (of C)
		jnz	clearFlag185
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue185
clearFlag185:
		and	ah, 0bfh	; Clear the zero flag
continue185:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstab:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop189:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead189
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr189		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine189

nextAddr189:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop189

callRoutine189:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit189

memoryRead189:
		mov	dl, [ebp + ebx]	; Get our data

readExit189:
		push	cx	; Save BC
		xor	ch, ch	; No 16 bit for this instruction!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop190:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit190	; Yes - ignore it!
		cmp	cx, [edi]	; Are we smaller?
		jb	nextAddr190	; Yes... go to the next addr
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine190	; If not, go call it!

nextAddr190:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop190

callRoutine190:
		mov	dx, cx	; Get our address to target
		call	WriteIOByte	; Go write the data!
WriteMacroExit190:
		pop	cx	; Restore BC now that it has been "OUT"ed
		dec	bx	; Decrement HL
		dec	ch	; Decrement B (of C)
		jnz	clearFlag188
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue188
clearFlag188:
		and	ah, 0bfh	; Clear the zero flag
continue188:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb0:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
		mov	[_orgval], cx	; Store BC for later
		push	esi	; Save our PC for later
		push	ebp	; Save our base pointer for later
ldRepeat191:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop191:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead191
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr191		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine191

nextAddr191:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop191

callRoutine191:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit191

memoryRead191:
		mov	dl, [ebp + ebx]	; Get our data

readExit191:
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_z80de]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop192:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite192	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr192	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine192	; If not, go call it!

nextAddr192:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop192

callRoutine192:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit192
memoryWrite192:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit192:
		inc	bx	; Increment HL
		inc	word [_z80de]	; Increment DE
		dec	cx	; Decrement BC
		jz	noMore193
		jmp	ldRepeat191 ; Loop until we're done!
noMore193:
		and	ah, 0e9h	; No N, P/V, or H!
		shl	eax, 16	; Save this for later
		mov	ax, [_orgval] ; Get our original BC count
		mov	dx, 21	; 21 Clock cycles per iteration
		mul	dx		; Multiply it!
		mov	edx, eax	; Put our value in EDX
		and	edx, 0ffffh ; Only the lower part matters..
		add	[dwElapsedTicks], edx
		xor	dh, dh
		shr	eax, 16	; Restore this!
		pop	ebp	; Restore our base pointer
		pop	esi	; Restore PC
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb1:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
		mov	dword [_orgval], 0	; Zero our timing info
cpRepeat193:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop194:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead194
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr194		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine194

nextAddr194:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop194

callRoutine194:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit194

memoryRead194:
		mov	dl, [ebp + ebx]	; Get our data

readExit194:
		mov	byte [_z80af], ah
		sahf
		cmp	al, dl	; Do our comparison
		lahf
		and	ah, 0fah	; No P/V or carry!
		dec	cx	; Dec BC
		jz	notBcZero195
		or	ah, 04h	; P/V set when BC not zero
notBcZero195:
		or	ah, 02h	; N Gets set when we do compares
		mov	dl, byte [_z80af]
		and	dl, 01h
		or	ah, dl	; Preserve carry!
		inc	bx	; Increment!
		sahf
		jz	BCDone193
		add	dword [_orgval], 21	; 21 T-States when not done
		jmp	cpRepeat193
BCDone193:
		mov	edx, dword [_orgval]
		add	[dwElapsedTicks], edx
		xor	edx, edx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb2:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
loopIt195:
		push	cx	; Save BC
		xor	ch, ch ; Not 16 bit for this instruction
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop196:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead196
		cmp	cx, [edi]	; Are we smaller?
		jb		nextAddr196		; Yes, go to the next address
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine196

nextAddr196:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop196

callRoutine196:
		mov	dx, cx	; Get our address
		call	ReadIOByte	; Standard read routine
		mov	dl, al	; Put it in DL for later consumption
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit196

ioRead196:
		mov	dl, 0ffh	; An unreferenced read
readExit196:
		pop	cx	; Restore BC
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop197:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite197	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr197	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine197	; If not, go call it!

nextAddr197:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop197

callRoutine197:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit197
memoryWrite197:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit197:
		inc	bx	; Increment HL
		dec	ch	; Decrement B (of C)
		jnz	loopIt195
		jnz	clearFlag195
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue195
clearFlag195:
		and	ah, 0bfh	; Clear the zero flag
continue195:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb3:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
loopIt198:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop199:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead199
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr199		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine199

nextAddr199:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop199

callRoutine199:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit199

memoryRead199:
		mov	dl, [ebp + ebx]	; Get our data

readExit199:
		push	cx	; Save BC
		xor	ch, ch	; No 16 bit for this instruction!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop200:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit200	; Yes - ignore it!
		cmp	cx, [edi]	; Are we smaller?
		jb	nextAddr200	; Yes... go to the next addr
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine200	; If not, go call it!

nextAddr200:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop200

callRoutine200:
		mov	dx, cx	; Get our address to target
		call	WriteIOByte	; Go write the data!
WriteMacroExit200:
		pop	cx	; Restore BC now that it has been "OUT"ed
		inc	bx	; Increment HL
		dec	ch	; Decrement B (of C)
		jnz	loopIt198
		jnz	clearFlag198
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue198
clearFlag198:
		and	ah, 0bfh	; Clear the zero flag
continue198:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb8:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
		mov	[_orgval], cx	; Store BC for later
		push	esi	; Save our PC for later
		push	ebp	; Save our base pointer for later
ldRepeat201:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop201:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead201
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr201		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine201

nextAddr201:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop201

callRoutine201:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit201

memoryRead201:
		mov	dl, [ebp + ebx]	; Get our data

readExit201:
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_z80de]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop202:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite202	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr202	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine202	; If not, go call it!

nextAddr202:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop202

callRoutine202:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit202
memoryWrite202:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit202:
		dec	bx	; Decrement HL
		dec	word [_z80de]	; Decrement DE
		dec	cx	; Decrement BC
		jz	noMore203
		jmp	ldRepeat201 ; Loop until we're done!
noMore203:
		and	ah, 0e9h	; No N, P/V, or H!
		shl	eax, 16	; Save this for later
		mov	ax, [_orgval] ; Get our original BC count
		mov	dx, 21	; 21 Clock cycles per iteration
		mul	dx		; Multiply it!
		mov	edx, eax	; Put our value in EDX
		and	edx, 0ffffh ; Only the lower part matters..
		add	[dwElapsedTicks], edx
		xor	dh, dh
		shr	eax, 16	; Restore this!
		pop	ebp	; Restore our base pointer
		pop	esi	; Restore PC
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstb9:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
		mov	dword [_orgval], 0	; Zero our timing info
cpRepeat203:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop204:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead204
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr204		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine204

nextAddr204:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop204

callRoutine204:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit204

memoryRead204:
		mov	dl, [ebp + ebx]	; Get our data

readExit204:
		mov	byte [_z80af], ah
		sahf
		cmp	al, dl	; Do our comparison
		lahf
		and	ah, 0fah	; No P/V or carry!
		dec	cx	; Dec BC
		jz	notBcZero205
		or	ah, 04h	; P/V set when BC not zero
notBcZero205:
		or	ah, 02h	; N Gets set when we do compares
		mov	dl, byte [_z80af]
		and	dl, 01h
		or	ah, dl	; Preserve carry!
		dec	bx	; Decrement!
		sahf
		jz	BCDone203
		add	dword [_orgval], 21	; 21 T-States when not done
		jmp	cpRepeat203
BCDone203:
		mov	edx, dword [_orgval]
		add	[dwElapsedTicks], edx
		xor	edx, edx
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstba:
		sub	dword [cyclesRemaining], byte 21
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 21
loopIt205:
		push	cx	; Save BC
		xor	ch, ch ; Not 16 bit for this instruction
		mov	edi, [_z80IoRead]	; Point to the read array

checkLoop206:
		cmp	[edi], word 0ffffh ; End of the list?
		je		ioRead206
		cmp	cx, [edi]	; Are we smaller?
		jb		nextAddr206		; Yes, go to the next address
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine206

nextAddr206:
		add	edi, 0ch		; Next structure!
		jmp	short checkLoop206

callRoutine206:
		mov	dx, cx	; Get our address
		call	ReadIOByte	; Standard read routine
		mov	dl, al	; Put it in DL for later consumption
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit206

ioRead206:
		mov	dl, 0ffh	; An unreferenced read
readExit206:
		pop	cx	; Restore BC
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop207:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite207	; Yes - go write it!
		cmp	bx, [edi]	; Are we smaller?
		jb	nextAddr207	; Yes... go to the next addr
		cmp	bx, [edi+4]	; Are we smaller?
		jbe	callRoutine207	; If not, go call it!

nextAddr207:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop207

callRoutine207:
		mov	dx, bx	; Get our address to target
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit207
memoryWrite207:
		mov	[ebp + ebx], dl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit207:
		dec	bx	; Decrement HL
		dec	ch	; Decrement B (of C)
		jnz	loopIt205
		jnz	clearFlag205
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue205
clearFlag205:
		and	ah, 0bfh	; Clear the zero flag
continue205:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

EDInstbb:
		sub	dword [cyclesRemaining], byte 16
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 16
loopIt208:
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop209:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead209
		cmp	bx, [edi]	; Are we smaller?
		jb		nextAddr209		; Yes, go to the next address
		cmp	bx, [edi+4]	; Are we bigger?
		jbe	callRoutine209

nextAddr209:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop209

callRoutine209:
		mov	dx, bx	; Get our address
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit209

memoryRead209:
		mov	dl, [ebp + ebx]	; Get our data

readExit209:
		push	cx	; Save BC
		xor	ch, ch	; No 16 bit for this instruction!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	edi, [_z80IoWrite]	; Point to the I/O write array

checkLoop210:
		cmp	[edi], word 0ffffh ; End of our list?
		je	WriteMacroExit210	; Yes - ignore it!
		cmp	cx, [edi]	; Are we smaller?
		jb	nextAddr210	; Yes... go to the next addr
		cmp	cx, [edi+2]	; Are we bigger?
		jbe	callRoutine210	; If not, go call it!

nextAddr210:
		add	edi, 0ch		; Next structure, please
		jmp	short checkLoop210

callRoutine210:
		mov	dx, cx	; Get our address to target
		call	WriteIOByte	; Go write the data!
WriteMacroExit210:
		pop	cx	; Restore BC now that it has been "OUT"ed
		dec	bx	; Decrement HL
		dec	ch	; Decrement B (of C)
		jnz	loopIt208
		jnz	clearFlag208
		or	ah, 040h	; Set the Zero flag!
		jmp	short continue208
clearFlag208:
		and	ah, 0bfh	; Clear the zero flag
continue208:
		or	ah, 02h	; Set negative!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst09:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80ix]	; Get our value
		add	di, cx
		lahf
		mov	[_z80ix], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst19:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80ix]	; Get our value
		add	di, word [_z80de]
		lahf
		mov	[_z80ix], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst21:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	di, [esi]	; Get our word to load
		add	esi, 2	; Advance past the word
		mov	[_z80ix], di ; Store our new value
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst22:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	 ; Get our address to store
		add	esi, 2
		mov	[_orgval], dx
		mov	dl, [_z80ix]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop211:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite211	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr211	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine211	; If not, go call it!

nextAddr211:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop211

callRoutine211:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit211
memoryWrite211:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit211:
		inc	word [_orgval]
		mov	dl, [_z80ix + 1]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop212:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite212	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr212	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine212	; If not, go call it!

nextAddr212:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop212

callRoutine212:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit212
memoryWrite212:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit212:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst23:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		inc	word [_z80ix]	; Increment our mz80Index register
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst24:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		inc	byte [_z80ix + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst25:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		dec	byte [_z80ix + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst26:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, [esi]	; Get immediate byte to load
		inc	esi	; Next byte
		mov	byte [_z80ix + 1], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst29:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80ix]	; Get our value
		add	di, di
		lahf
		mov	[_z80ix], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst2a:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	 ; Get our address to store
		add	esi, 2
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop213:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead213
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr213		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine213

nextAddr213:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop213

callRoutine213:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit213

memoryRead213:
		mov	dl, [ebp + edx]	; Get our data

readExit213:
		mov	[_z80ix], dl
		inc	word [_orgval]
		mov	dx, [_orgval]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop214:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead214
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr214		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine214

nextAddr214:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop214

callRoutine214:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit214

memoryRead214:
		mov	dl, [ebp + edx]	; Get our data

readExit214:
		mov	[_z80ix + 1], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst2b:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		dec	word [_z80ix]	; Increment our mz80Index register
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst2c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		inc	byte [_z80ix]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst2d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		dec	byte [_z80ix]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst2e:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, [esi]	; Get immediate byte to load
		inc	esi	; Next byte
		mov	byte [_z80ix], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst34:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned215	; Nope!
		dec	dh			; Make it FFable
notSigned215:
		add	dx, [_z80ix]	; Our offset!
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop216:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead216
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr216		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine216

nextAddr216:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop216

callRoutine216:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit216

memoryRead216:
		mov	dl, [ebp + edx]	; Get our data

readExit216:
		sahf
		inc	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		and	ah, 0fdh	; Knock out N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop217:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite217	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr217	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine217	; If not, go call it!

nextAddr217:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop217

callRoutine217:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit217
memoryWrite217:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit217:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst35:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned218	; Nope!
		dec	dh			; Make it FFable
notSigned218:
		add	dx, [_z80ix]	; Our offset!
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop219:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead219
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr219		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine219

nextAddr219:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop219

callRoutine219:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit219

memoryRead219:
		mov	dl, [ebp + edx]	; Get our data

readExit219:
		sahf
		dec	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		or		ah, 02h	; Make it N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop220:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite220	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr220	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine220	; If not, go call it!

nextAddr220:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop220

callRoutine220:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit220
memoryWrite220:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit220:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst36:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dx, [esi]	; Get our address
		add	esi, 2	; Skip over our storage bytes
		mov	di, dx	; Store it here for later
		xor	dh, dh
		or	dl, dl
		jns	noNegate221
		dec	dh
noNegate221:
		add	dx, [_z80ix]	; Add in our index
		mov	[_orgval], dx	; Store our address to write to
		mov	dx, di
		xchg	dh, dl
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop221:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite221	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr221	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine221	; If not, go call it!

nextAddr221:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop221

callRoutine221:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit221
memoryWrite221:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit221:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst39:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80ix]	; Get our value
		add	di, word [_z80sp]
		lahf
		mov	[_z80ix], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst44:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	ch, byte [_z80ix + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst45:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	ch, byte [_z80ix + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst46:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned223	; Nope!
		dec	dh			; Make it FFable
notSigned223:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop224:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead224
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr224		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine224

nextAddr224:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop224

callRoutine224:
		call	ReadMemoryByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit224

memoryRead224:
		mov	ch, [ebp + edx]	; Get our data

readExit224:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst4c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	cl, byte [_z80ix + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst4d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	cl, byte [_z80ix + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst4e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned226	; Nope!
		dec	dh			; Make it FFable
notSigned226:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop227:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead227
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr227		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine227

nextAddr227:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop227

callRoutine227:
		call	ReadMemoryByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit227

memoryRead227:
		mov	cl, [ebp + edx]	; Get our data

readExit227:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst54:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dh, byte [_z80ix + 1]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst55:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dh, byte [_z80ix + 0]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst56:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned229	; Nope!
		dec	dh			; Make it FFable
notSigned229:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop230:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead230
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr230		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine230

nextAddr230:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop230

callRoutine230:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit230

memoryRead230:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de + 1], dl
		mov	dx, di
readExit230:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst5c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dl, byte [_z80ix + 1]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst5d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dl, byte [_z80ix + 0]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst5e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned232	; Nope!
		dec	dh			; Make it FFable
notSigned232:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop233:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead233
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr233		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine233

nextAddr233:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop233

callRoutine233:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit233

memoryRead233:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de], dl
		mov	dx, di
readExit233:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst60:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 1], ch
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst61:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 1], cl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst62:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80ix + 1], dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst63:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80ix + 1], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst64:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dh, byte [_z80ix + 1]
		mov   byte [_z80ix + 1], bh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst65:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dl, byte [_z80ix]
		mov   byte [_z80ix + 1], bl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst66:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned235	; Nope!
		dec	dh			; Make it FFable
notSigned235:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop236:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead236
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr236		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine236

nextAddr236:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop236

callRoutine236:
		call	ReadMemoryByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit236

memoryRead236:
		mov	bh, [ebp + edx]	; Get our data

readExit236:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst67:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 1], al
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst68:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 0], ch
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst69:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 0], cl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6a:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80ix + 0], dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6b:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80ix + 0], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dh, byte [_z80ix + 1]
		mov   byte [_z80ix + 0], bh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dl, byte [_z80ix]
		mov   byte [_z80ix + 0], bl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned238	; Nope!
		dec	dh			; Make it FFable
notSigned238:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop239:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead239
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr239		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine239

nextAddr239:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop239

callRoutine239:
		call	ReadMemoryByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit239

memoryRead239:
		mov	bl, [ebp + edx]	; Get our data

readExit239:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst6f:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80ix + 0], al
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst70:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned241	; Nope!
		dec	dh			; Make it FFable
notSigned241:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop242:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite242	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr242	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine242	; If not, go call it!

nextAddr242:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop242

callRoutine242:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit242
memoryWrite242:
		mov	[ebp + edx], ch
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit242:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst71:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned243	; Nope!
		dec	dh			; Make it FFable
notSigned243:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop244:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite244	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr244	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine244	; If not, go call it!

nextAddr244:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop244

callRoutine244:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit244
memoryWrite244:
		mov	[ebp + edx], cl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit244:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst72:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned245	; Nope!
		dec	dh			; Make it FFable
notSigned245:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop246:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite246	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr246	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine246	; If not, go call it!

nextAddr246:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop246

callRoutine246:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit246
memoryWrite246:
		mov	edi, edx
		mov	dl, byte [_z80de + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit246:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst73:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned247	; Nope!
		dec	dh			; Make it FFable
notSigned247:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop248:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite248	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr248	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine248	; If not, go call it!

nextAddr248:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop248

callRoutine248:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit248
memoryWrite248:
		mov	edi, edx
		mov	dl, byte [_z80de]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit248:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst74:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned249	; Nope!
		dec	dh			; Make it FFable
notSigned249:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop250:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite250	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr250	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine250	; If not, go call it!

nextAddr250:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop250

callRoutine250:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit250
memoryWrite250:
		mov	[ebp + edx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit250:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst75:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned251	; Nope!
		dec	dh			; Make it FFable
notSigned251:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop252:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite252	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr252	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine252	; If not, go call it!

nextAddr252:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop252

callRoutine252:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit252
memoryWrite252:
		mov	[ebp + edx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit252:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst77:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned253	; Nope!
		dec	dh			; Make it FFable
notSigned253:
		add	dx, [_z80ix]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop254:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite254	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr254	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine254	; If not, go call it!

nextAddr254:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop254

callRoutine254:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit254
memoryWrite254:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit254:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst7c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	al, byte [_z80ix + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst7d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	al, byte [_z80ix + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst7e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned255	; Nope!
		dec	dh			; Make it FFable
notSigned255:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop256:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead256
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr256		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine256

nextAddr256:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop256

callRoutine256:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit256

memoryRead256:
		mov	al, [ebp + edx]	; Get our data

readExit256:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst84:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		add	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst85:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		add	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst86:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned258	; Nope!
		dec	dh			; Make it FFable
notSigned258:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop259:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead259
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr259		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine259

nextAddr259:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop259

callRoutine259:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit259

memoryRead259:
		mov	dl, [ebp + edx]	; Get our data

readExit259:
		sahf
		add	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst8c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		adc	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst8d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		adc	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst8e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned260	; Nope!
		dec	dh			; Make it FFable
notSigned260:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop261:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead261
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr261		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine261

nextAddr261:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop261

callRoutine261:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit261

memoryRead261:
		mov	dl, [ebp + edx]	; Get our data

readExit261:
		sahf
		adc	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst94:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		sub	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst95:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		sub	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst96:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned262	; Nope!
		dec	dh			; Make it FFable
notSigned262:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop263:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead263
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr263		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine263

nextAddr263:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop263

callRoutine263:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit263

memoryRead263:
		mov	dl, [ebp + edx]	; Get our data

readExit263:
		sahf
		sub	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst9c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		sbb	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst9d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		sbb	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInst9e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned264	; Nope!
		dec	dh			; Make it FFable
notSigned264:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop265:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead265
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr265		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine265

nextAddr265:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop265

callRoutine265:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit265

memoryRead265:
		mov	dl, [ebp + edx]	; Get our data

readExit265:
		sahf
		sbb	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInsta4:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		and	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInsta5:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		and	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInsta6:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned266	; Nope!
		dec	dh			; Make it FFable
notSigned266:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop267:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead267
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr267		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine267

nextAddr267:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop267

callRoutine267:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit267

memoryRead267:
		mov	dl, [ebp + edx]	; Get our data

readExit267:
		sahf
		and	al, dl
		lahf
		and	ah,0fch	; Knock out N & C
		or	ah, 10h	; Set half carry
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstac:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		xor	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstad:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		xor	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstae:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned268	; Nope!
		dec	dh			; Make it FFable
notSigned268:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop269:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead269
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr269		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine269

nextAddr269:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop269

callRoutine269:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit269

memoryRead269:
		mov	dl, [ebp + edx]	; Get our data

readExit269:
		sahf
		xor	al, dl
		lahf
		and	ah, 0ech	; Knock out H, N, and C
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstb4:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		or	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech ; No H, N, or C
		and	ah, 0ech ; No H, N, or C
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstb5:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		or	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech ; No H, N, or C
		and	ah, 0ech ; No H, N, or C
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstb6:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned270	; Nope!
		dec	dh			; Make it FFable
notSigned270:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop271:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead271
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr271		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine271

nextAddr271:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop271

callRoutine271:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit271

memoryRead271:
		mov	dl, [ebp + edx]	; Get our data

readExit271:
		sahf
		or	al, dl
		lahf
		and	ah, 0ech	; Knock out H, N, and C
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstbc:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix + 1]
		sahf		; Store our flags in x86 flag reg
		cmp	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Negative gets set on a compare
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstbd:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80ix]
		sahf		; Store our flags in x86 flag reg
		cmp	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Negative gets set on a compare
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstbe:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned272	; Nope!
		dec	dh			; Make it FFable
notSigned272:
		add	dx, [_z80ix]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop273:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead273
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr273		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine273

nextAddr273:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop273

callRoutine273:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit273

memoryRead273:
		mov	dl, [ebp + edx]	; Get our data

readExit273:
		sahf
		cmp	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

DDInstcb:
		mov	[_baseFixup], dword 3
		mov	dx, [esi]	; Get our instruction (and offset)
		add	esi, 2	; Increment our PC
		mov	byte [_orgval], dl ; Store our value
		or	dl, dl
		js	notNeg274
		mov	byte [_orgval + 1], 00h;
 		jmp	short jumpHandler274
notNeg274:
		mov	byte [_orgval + 1], 0ffh;	It's negative
jumpHandler274:
		shl	ebx, 16	; Save BX away
		mov	bx, [_z80ix]
		add	[_orgval], bx
		shr	ebx, 16	; Restore BX
		mov	dl, dh	; Get our instruction
		xor	dh, dh	; Zero this
		jmp	dword [z80ddfdcbInstructions+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInste1:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop275:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead275
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr275		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine275

nextAddr275:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop275

callRoutine275:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80ix], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit275

memoryRead275:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80ix], dl
		mov	dx, di
readExit275:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop276:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead276
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr276		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine276

nextAddr276:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop276

callRoutine276:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80ix + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit276

memoryRead276:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80ix + 1], dl
		mov	dx, di
readExit276:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInste3:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, word [_z80sp]
		xor	edi, edi
		mov	di, [_z80ix]
		xchg	di, [ebp+edx]
		mov	[_z80ix], di
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInste5:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80ix]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop277:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite277	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr277	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine277	; If not, go call it!

nextAddr277:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop277

callRoutine277:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit277
memoryWrite277:
		mov	edi, edx
		mov	dl, byte [_z80ix]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit277:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80ix + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop278:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite278	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr278	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine278	; If not, go call it!

nextAddr278:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop278

callRoutine278:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit278
memoryWrite278:
		mov	edi, edx
		mov	dl, byte [_z80ix + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit278:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInste9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80ix]	; Get our value
		mov	esi, edx		; New PC!
		add	esi, ebp		; Add in our base
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDInstf9:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		mov	di, [_z80ix] ; Get our source register
		mov	word [_z80sp], di	; Store our new SP
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst06:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop279:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead279
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr279		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine279

nextAddr279:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop279

callRoutine279:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit279

memoryRead279:
		mov	dl, [ebp + edx]	; Get our data

readExit279:
		sahf		; Restore our flags
		rol	dl, 1
		lahf		; Get our flags back
		and	ah, 0edh	; Knock out H & N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop280:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite280	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr280	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine280	; If not, go call it!

nextAddr280:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop280

callRoutine280:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit280
memoryWrite280:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit280:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst0e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop281:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead281
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr281		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine281

nextAddr281:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop281

callRoutine281:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit281

memoryRead281:
		mov	dl, [ebp + edx]	; Get our data

readExit281:
		sahf		; Restore our flags
		ror	dl, 1
		lahf		; Get our flags back
		and	ah, 0edh	; Knock out H & N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop282:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite282	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr282	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine282	; If not, go call it!

nextAddr282:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop282

callRoutine282:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit282
memoryWrite282:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit282:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst16:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop283:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead283
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr283		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine283

nextAddr283:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop283

callRoutine283:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit283

memoryRead283:
		mov	dl, [ebp + edx]	; Get our data

readExit283:
		sahf		; Restore our flags
		rcl	dl, 1
		lahf		; Get our flags back
		and	ah, 0edh	; Knock out H & N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop284:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite284	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr284	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine284	; If not, go call it!

nextAddr284:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop284

callRoutine284:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit284
memoryWrite284:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit284:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst1e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop285:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead285
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr285		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine285

nextAddr285:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop285

callRoutine285:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit285

memoryRead285:
		mov	dl, [ebp + edx]	; Get our data

readExit285:
		sahf		; Restore our flags
		rcr	dl, 1
		lahf		; Get our flags back
		and	ah, 0edh	; Knock out H & N
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop286:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite286	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr286	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine286	; If not, go call it!

nextAddr286:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop286

callRoutine286:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit286
memoryWrite286:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit286:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst26:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop287:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead287
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr287		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine287

nextAddr287:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop287

callRoutine287:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit287

memoryRead287:
		mov	dl, [ebp + edx]	; Get our data

readExit287:
		sahf		; Restore our flags
		shl	dl, 1
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop288:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite288	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr288	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine288	; If not, go call it!

nextAddr288:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop288

callRoutine288:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit288
memoryWrite288:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit288:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst2e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop289:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead289
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr289		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine289

nextAddr289:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop289

callRoutine289:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit289

memoryRead289:
		mov	dl, [ebp + edx]	; Get our data

readExit289:
		sahf		; Restore our flags
		sar	dl, 1
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop290:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite290	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr290	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine290	; If not, go call it!

nextAddr290:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop290

callRoutine290:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit290
memoryWrite290:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit290:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst3e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop291:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead291
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr291		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine291

nextAddr291:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop291

callRoutine291:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit291

memoryRead291:
		mov	dl, [ebp + edx]	; Get our data

readExit291:
		sahf		; Restore our flags
		shr	dl, 1
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop292:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite292	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr292	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine292	; If not, go call it!

nextAddr292:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop292

callRoutine292:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit292
memoryWrite292:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit292:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst46:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop293:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead293
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr293		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine293

nextAddr293:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop293

callRoutine293:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit293

memoryRead293:
		mov	dl, [ebp + edx]	; Get our data

readExit293:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 001h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst4e:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop294:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead294
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr294		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine294

nextAddr294:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop294

callRoutine294:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit294

memoryRead294:
		mov	dl, [ebp + edx]	; Get our data

readExit294:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 002h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst56:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop295:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead295
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr295		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine295

nextAddr295:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop295

callRoutine295:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit295

memoryRead295:
		mov	dl, [ebp + edx]	; Get our data

readExit295:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 004h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst5e:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop296:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead296
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr296		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine296

nextAddr296:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop296

callRoutine296:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit296

memoryRead296:
		mov	dl, [ebp + edx]	; Get our data

readExit296:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 008h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst66:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop297:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead297
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr297		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine297

nextAddr297:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop297

callRoutine297:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit297

memoryRead297:
		mov	dl, [ebp + edx]	; Get our data

readExit297:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 010h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst6e:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop298:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead298
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr298		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine298

nextAddr298:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop298

callRoutine298:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit298

memoryRead298:
		mov	dl, [ebp + edx]	; Get our data

readExit298:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 020h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst76:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop299:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead299
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr299		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine299

nextAddr299:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop299

callRoutine299:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit299

memoryRead299:
		mov	dl, [ebp + edx]	; Get our data

readExit299:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 040h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst7e:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop300:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead300
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr300		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine300

nextAddr300:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop300

callRoutine300:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit300

memoryRead300:
		mov	dl, [ebp + edx]	; Get our data

readExit300:
		mov	dh, ah	; Store our original flags
		and	dh, 29h	; Keep our old flags
		sahf		; Restore our flags
		test	dl, 080h	; Is it set?
		lahf		; Get our flags back
		and	ah, 0ech	; No Half carry or negative!
		or	ah, 10h	; OR In our half carry
		and	ah, 0d4h ; New flags
		or	ah, dh	; OR In our old flags
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst86:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop301:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead301
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr301		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine301

nextAddr301:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop301

callRoutine301:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit301

memoryRead301:
		mov	dl, [ebp + edx]	; Get our data

readExit301:
		and	dl, 0feh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop302:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite302	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr302	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine302	; If not, go call it!

nextAddr302:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop302

callRoutine302:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit302
memoryWrite302:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit302:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst8e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop303:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead303
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr303		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine303

nextAddr303:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop303

callRoutine303:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit303

memoryRead303:
		mov	dl, [ebp + edx]	; Get our data

readExit303:
		and	dl, 0fdh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop304:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite304	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr304	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine304	; If not, go call it!

nextAddr304:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop304

callRoutine304:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit304
memoryWrite304:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit304:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst96:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop305:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead305
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr305		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine305

nextAddr305:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop305

callRoutine305:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit305

memoryRead305:
		mov	dl, [ebp + edx]	; Get our data

readExit305:
		and	dl, 0fbh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop306:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite306	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr306	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine306	; If not, go call it!

nextAddr306:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop306

callRoutine306:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit306
memoryWrite306:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit306:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInst9e:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop307:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead307
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr307		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine307

nextAddr307:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop307

callRoutine307:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit307

memoryRead307:
		mov	dl, [ebp + edx]	; Get our data

readExit307:
		and	dl, 0f7h	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop308:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite308	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr308	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine308	; If not, go call it!

nextAddr308:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop308

callRoutine308:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit308
memoryWrite308:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit308:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInsta6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop309:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead309
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr309		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine309

nextAddr309:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop309

callRoutine309:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit309

memoryRead309:
		mov	dl, [ebp + edx]	; Get our data

readExit309:
		and	dl, 0efh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop310:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite310	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr310	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine310	; If not, go call it!

nextAddr310:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop310

callRoutine310:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit310
memoryWrite310:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit310:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstae:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop311:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead311
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr311		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine311

nextAddr311:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop311

callRoutine311:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit311

memoryRead311:
		mov	dl, [ebp + edx]	; Get our data

readExit311:
		and	dl, 0dfh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop312:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite312	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr312	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine312	; If not, go call it!

nextAddr312:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop312

callRoutine312:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit312
memoryWrite312:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit312:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstb6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop313:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead313
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr313		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine313

nextAddr313:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop313

callRoutine313:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit313

memoryRead313:
		mov	dl, [ebp + edx]	; Get our data

readExit313:
		and	dl, 0bfh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop314:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite314	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr314	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine314	; If not, go call it!

nextAddr314:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop314

callRoutine314:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit314
memoryWrite314:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit314:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstbe:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop315:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead315
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr315		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine315

nextAddr315:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop315

callRoutine315:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit315

memoryRead315:
		mov	dl, [ebp + edx]	; Get our data

readExit315:
		and	dl, 07fh	; Reset the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop316:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite316	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr316	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine316	; If not, go call it!

nextAddr316:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop316

callRoutine316:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit316
memoryWrite316:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit316:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstc6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop317:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead317
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr317		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine317

nextAddr317:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop317

callRoutine317:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit317

memoryRead317:
		mov	dl, [ebp + edx]	; Get our data

readExit317:
		or	dl, 001h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop318:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite318	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr318	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine318	; If not, go call it!

nextAddr318:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop318

callRoutine318:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit318
memoryWrite318:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit318:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstce:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop319:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead319
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr319		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine319

nextAddr319:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop319

callRoutine319:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit319

memoryRead319:
		mov	dl, [ebp + edx]	; Get our data

readExit319:
		or	dl, 002h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop320:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite320	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr320	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine320	; If not, go call it!

nextAddr320:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop320

callRoutine320:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit320
memoryWrite320:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit320:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstd6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop321:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead321
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr321		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine321

nextAddr321:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop321

callRoutine321:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit321

memoryRead321:
		mov	dl, [ebp + edx]	; Get our data

readExit321:
		or	dl, 004h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop322:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite322	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr322	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine322	; If not, go call it!

nextAddr322:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop322

callRoutine322:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit322
memoryWrite322:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit322:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstde:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop323:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead323
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr323		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine323

nextAddr323:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop323

callRoutine323:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit323

memoryRead323:
		mov	dl, [ebp + edx]	; Get our data

readExit323:
		or	dl, 008h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop324:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite324	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr324	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine324	; If not, go call it!

nextAddr324:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop324

callRoutine324:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit324
memoryWrite324:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit324:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInste6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop325:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead325
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr325		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine325

nextAddr325:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop325

callRoutine325:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit325

memoryRead325:
		mov	dl, [ebp + edx]	; Get our data

readExit325:
		or	dl, 010h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop326:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite326	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr326	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine326	; If not, go call it!

nextAddr326:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop326

callRoutine326:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit326
memoryWrite326:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit326:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstee:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop327:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead327
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr327		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine327

nextAddr327:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop327

callRoutine327:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit327

memoryRead327:
		mov	dl, [ebp + edx]	; Get our data

readExit327:
		or	dl, 020h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop328:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite328	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr328	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine328	; If not, go call it!

nextAddr328:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop328

callRoutine328:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit328
memoryWrite328:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit328:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstf6:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop329:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead329
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr329		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine329

nextAddr329:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop329

callRoutine329:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit329

memoryRead329:
		mov	dl, [ebp + edx]	; Get our data

readExit329:
		or	dl, 040h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop330:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite330	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr330	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine330	; If not, go call it!

nextAddr330:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop330

callRoutine330:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit330
memoryWrite330:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit330:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

DDFDCBInstfe:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, [_orgval]	; Get our target address
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop331:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead331
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr331		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine331

nextAddr331:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop331

callRoutine331:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit331

memoryRead331:
		mov	dl, [ebp + edx]	; Get our data

readExit331:
		or	dl, 080h	; Set the bit
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop332:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite332	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr332	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine332	; If not, go call it!

nextAddr332:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop332

callRoutine332:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit332
memoryWrite332:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit332:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst09:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80iy]	; Get our value
		add	di, cx
		lahf
		mov	[_z80iy], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst19:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80iy]	; Get our value
		add	di, word [_z80de]
		lahf
		mov	[_z80iy], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst21:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	di, [esi]	; Get our word to load
		add	esi, 2	; Advance past the word
		mov	[_z80iy], di ; Store our new value
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst22:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	 ; Get our address to store
		add	esi, 2
		mov	[_orgval], dx
		mov	dl, [_z80iy]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop333:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite333	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr333	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine333	; If not, go call it!

nextAddr333:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop333

callRoutine333:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit333
memoryWrite333:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit333:
		inc	word [_orgval]
		mov	dl, [_z80iy + 1]
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop334:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite334	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr334	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine334	; If not, go call it!

nextAddr334:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop334

callRoutine334:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit334
memoryWrite334:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit334:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst23:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		inc	word [_z80iy]	; Increment our mz80Index register
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst24:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		inc	byte [_z80iy + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst25:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		dec	byte [_z80iy + 1]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst26:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, [esi]	; Get immediate byte to load
		inc	esi	; Next byte
		mov	byte [_z80iy + 1], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst29:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80iy]	; Get our value
		add	di, di
		lahf
		mov	[_z80iy], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst2a:
		sub	dword [cyclesRemaining], byte 20
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 20
		mov	dx, [esi]	 ; Get our address to store
		add	esi, 2
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop335:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead335
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr335		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine335

nextAddr335:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop335

callRoutine335:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit335

memoryRead335:
		mov	dl, [ebp + edx]	; Get our data

readExit335:
		mov	[_z80iy], dl
		inc	word [_orgval]
		mov	dx, [_orgval]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop336:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead336
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr336		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine336

nextAddr336:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop336

callRoutine336:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit336

memoryRead336:
		mov	dl, [ebp + edx]	; Get our data

readExit336:
		mov	[_z80iy + 1], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst2b:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		dec	word [_z80iy]	; Increment our mz80Index register
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst2c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		inc	byte [_z80iy]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst2d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		sahf
		dec	byte [_z80iy]
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh	; Knock out N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst2e:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, [esi]	; Get immediate byte to load
		inc	esi	; Next byte
		mov	byte [_z80iy], dl
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst34:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned337	; Nope!
		dec	dh			; Make it FFable
notSigned337:
		add	dx, [_z80iy]	; Our offset!
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop338:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead338
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr338		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine338

nextAddr338:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop338

callRoutine338:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit338

memoryRead338:
		mov	dl, [ebp + edx]	; Get our data

readExit338:
		sahf
		inc	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		and	ah, 0fdh	; Knock out N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop339:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite339	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr339	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine339	; If not, go call it!

nextAddr339:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop339

callRoutine339:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit339
memoryWrite339:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit339:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst35:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned340	; Nope!
		dec	dh			; Make it FFable
notSigned340:
		add	dx, [_z80iy]	; Our offset!
		mov	[_orgval], dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop341:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead341
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr341		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine341

nextAddr341:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop341

callRoutine341:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit341

memoryRead341:
		mov	dl, [ebp + edx]	; Get our data

readExit341:
		sahf
		dec	dl
		lahf
		shl	edx, 16
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		shr	edx, 16
		or		ah, 02h	; Make it N!
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop342:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite342	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr342	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine342	; If not, go call it!

nextAddr342:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop342

callRoutine342:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit342
memoryWrite342:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit342:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst36:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dx, [esi]	; Get our address
		add	esi, 2	; Skip over our storage bytes
		mov	di, dx	; Store it here for later
		xor	dh, dh
		or	dl, dl
		jns	noNegate343
		dec	dh
noNegate343:
		add	dx, [_z80iy]	; Add in our index
		mov	[_orgval], dx	; Store our address to write to
		mov	dx, di
		xchg	dh, dl
		mov	[_z80af], ax	; Store AF
		mov	al, dl	; And our data to write
		mov	dx, [_orgval]
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop343:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite343	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr343	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine343	; If not, go call it!

nextAddr343:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop343

callRoutine343:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit343
memoryWrite343:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit343:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst39:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		mov	dh, ah	; Save flags
		and	dh, 0ech	; Preserve the top three and bits 2 & 3
		mov	di, [_z80iy]	; Get our value
		add	di, word [_z80sp]
		lahf
		mov	[_z80iy], di	; Store our register back
		and	ah, 11h	; Just half carry and carry
		or	ah, dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst44:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	ch, byte [_z80iy + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst45:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	ch, byte [_z80iy + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst46:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned345	; Nope!
		dec	dh			; Make it FFable
notSigned345:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop346:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead346
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr346		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine346

nextAddr346:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop346

callRoutine346:
		call	ReadMemoryByte	; Standard read routine
		mov	ch, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit346

memoryRead346:
		mov	ch, [ebp + edx]	; Get our data

readExit346:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst4c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	cl, byte [_z80iy + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst4d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	cl, byte [_z80iy + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst4e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned348	; Nope!
		dec	dh			; Make it FFable
notSigned348:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop349:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead349
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr349		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine349

nextAddr349:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop349

callRoutine349:
		call	ReadMemoryByte	; Standard read routine
		mov	cl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit349

memoryRead349:
		mov	cl, [ebp + edx]	; Get our data

readExit349:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst54:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dh, byte [_z80iy + 1]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst55:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dh, byte [_z80iy + 0]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst56:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned351	; Nope!
		dec	dh			; Make it FFable
notSigned351:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop352:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead352
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr352		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine352

nextAddr352:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop352

callRoutine352:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit352

memoryRead352:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de + 1], dl
		mov	dx, di
readExit352:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst5c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dl, byte [_z80iy + 1]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst5d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dx, [_z80de]	; Get a usable copy of DE here
		mov	dl, byte [_z80iy + 0]
		mov	[_z80de], dx	; Put it back!
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst5e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned354	; Nope!
		dec	dh			; Make it FFable
notSigned354:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop355:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead355
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr355		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine355

nextAddr355:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop355

callRoutine355:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80de], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit355

memoryRead355:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80de], dl
		mov	dx, di
readExit355:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst60:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 1], ch
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst61:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 1], cl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst62:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80iy + 1], dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst63:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80iy + 1], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst64:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dh, byte [_z80iy + 1]
		mov   byte [_z80iy + 1], bh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst65:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dl, byte [_z80iy]
		mov   byte [_z80iy + 1], bl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst66:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned357	; Nope!
		dec	dh			; Make it FFable
notSigned357:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop358:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead358
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr358		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine358

nextAddr358:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop358

callRoutine358:
		call	ReadMemoryByte	; Standard read routine
		mov	bh, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit358

memoryRead358:
		mov	bh, [ebp + edx]	; Get our data

readExit358:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst67:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 1], al
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst68:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 0], ch
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst69:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 0], cl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6a:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80iy + 0], dh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6b:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dx, [_z80de]	; Get DE
		mov   byte [_z80iy + 0], dl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dh, byte [_z80iy + 1]
		mov   byte [_z80iy + 0], bh
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
	mov	dl, byte [_z80iy]
		mov   byte [_z80iy + 0], bl
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned360	; Nope!
		dec	dh			; Make it FFable
notSigned360:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop361:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead361
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr361		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine361

nextAddr361:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop361

callRoutine361:
		call	ReadMemoryByte	; Standard read routine
		mov	bl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit361

memoryRead361:
		mov	bl, [ebp + edx]	; Get our data

readExit361:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst6f:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov   byte [_z80iy + 0], al
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst70:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned363	; Nope!
		dec	dh			; Make it FFable
notSigned363:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, ch	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop364:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite364	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr364	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine364	; If not, go call it!

nextAddr364:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop364

callRoutine364:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit364
memoryWrite364:
		mov	[ebp + edx], ch
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit364:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst71:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned365	; Nope!
		dec	dh			; Make it FFable
notSigned365:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, cl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop366:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite366	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr366	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine366	; If not, go call it!

nextAddr366:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop366

callRoutine366:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit366
memoryWrite366:
		mov	[ebp + edx], cl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit366:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst72:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned367	; Nope!
		dec	dh			; Make it FFable
notSigned367:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop368:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite368	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr368	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine368	; If not, go call it!

nextAddr368:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop368

callRoutine368:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit368
memoryWrite368:
		mov	edi, edx
		mov	dl, byte [_z80de + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit368:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst73:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned369	; Nope!
		dec	dh			; Make it FFable
notSigned369:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80de]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop370:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite370	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr370	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine370	; If not, go call it!

nextAddr370:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop370

callRoutine370:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit370
memoryWrite370:
		mov	edi, edx
		mov	dl, byte [_z80de]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit370:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst74:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned371	; Nope!
		dec	dh			; Make it FFable
notSigned371:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, bh	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop372:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite372	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr372	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine372	; If not, go call it!

nextAddr372:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop372

callRoutine372:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit372
memoryWrite372:
		mov	[ebp + edx], bh
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit372:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst75:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned373	; Nope!
		dec	dh			; Make it FFable
notSigned373:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	al, bl	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop374:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite374	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr374	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine374	; If not, go call it!

nextAddr374:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop374

callRoutine374:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit374
memoryWrite374:
		mov	[ebp + edx], bl
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit374:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst77:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned375	; Nope!
		dec	dh			; Make it FFable
notSigned375:
		add	dx, [_z80iy]	; Our offset!
		mov	[_z80af], ax	; Store AF
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop376:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite376	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr376	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine376	; If not, go call it!

nextAddr376:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop376

callRoutine376:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit376
memoryWrite376:
		mov	[ebp + edx], al
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit376:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst7c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	al, byte [_z80iy + 1]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst7d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	al, byte [_z80iy + 0]
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst7e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned377	; Nope!
		dec	dh			; Make it FFable
notSigned377:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop378:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead378
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr378		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine378

nextAddr378:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop378

callRoutine378:
		call	ReadMemoryByte	; Standard read routine
		mov	[_z80af], al	; Save our new accumulator
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit378

memoryRead378:
		mov	al, [ebp + edx]	; Get our data

readExit378:
		xor	dh, dh	; Make sure we don't hose things
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst84:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		add	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst85:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		add	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst86:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned380	; Nope!
		dec	dh			; Make it FFable
notSigned380:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop381:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead381
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr381		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine381

nextAddr381:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop381

callRoutine381:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit381

memoryRead381:
		mov	dl, [ebp + edx]	; Get our data

readExit381:
		sahf
		add	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst8c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		adc	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst8d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		adc	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		and	ah, 0fdh ; No N!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst8e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned382	; Nope!
		dec	dh			; Make it FFable
notSigned382:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop383:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead383
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr383		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine383

nextAddr383:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop383

callRoutine383:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit383

memoryRead383:
		mov	dl, [ebp + edx]	; Get our data

readExit383:
		sahf
		adc	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		and	ah, 0fdh	; Knock out negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst94:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		sub	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst95:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		sub	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst96:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned384	; Nope!
		dec	dh			; Make it FFable
notSigned384:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop385:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead385
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr385		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine385

nextAddr385:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop385

callRoutine385:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit385

memoryRead385:
		mov	dl, [ebp + edx]	; Get our data

readExit385:
		sahf
		sub	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst9c:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		sbb	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst9d:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		sbb	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; N Gets set!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInst9e:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned386	; Nope!
		dec	dh			; Make it FFable
notSigned386:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop387:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead387
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr387		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine387

nextAddr387:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop387

callRoutine387:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit387

memoryRead387:
		mov	dl, [ebp + edx]	; Get our data

readExit387:
		sahf
		sbb	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInsta4:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		and	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInsta5:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		and	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		or	ah, 010h	; Half carry gets set
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInsta6:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned388	; Nope!
		dec	dh			; Make it FFable
notSigned388:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop389:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead389
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr389		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine389

nextAddr389:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop389

callRoutine389:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit389

memoryRead389:
		mov	dl, [ebp + edx]	; Get our data

readExit389:
		sahf
		and	al, dl
		lahf
		and	ah,0fch	; Knock out N & C
		or	ah, 10h	; Set half carry
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstac:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		xor	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstad:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		xor	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech	; Only these flags matter!
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstae:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned390	; Nope!
		dec	dh			; Make it FFable
notSigned390:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop391:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead391
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr391		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine391

nextAddr391:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop391

callRoutine391:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit391

memoryRead391:
		mov	dl, [ebp + edx]	; Get our data

readExit391:
		sahf
		xor	al, dl
		lahf
		and	ah, 0ech	; Knock out H, N, and C
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstb4:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		or	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech ; No H, N, or C
		and	ah, 0ech ; No H, N, or C
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstb5:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		or	al, dl
		lahf		; Get flags back into AH
		and	ah, 0ech ; No H, N, or C
		and	ah, 0ech ; No H, N, or C
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstb6:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned392	; Nope!
		dec	dh			; Make it FFable
notSigned392:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop393:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead393
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr393		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine393

nextAddr393:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop393

callRoutine393:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit393

memoryRead393:
		mov	dl, [ebp + edx]	; Get our data

readExit393:
		sahf
		or	al, dl
		lahf
		and	ah, 0ech	; Knock out H, N, and C
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstbc:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy + 1]
		sahf		; Store our flags in x86 flag reg
		cmp	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Negative gets set on a compare
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstbd:
		sub	dword [cyclesRemaining], byte 9
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 9
		mov	dl, byte [_z80iy]
		sahf		; Store our flags in x86 flag reg
		cmp	al, dl
		lahf		; Get flags back into AH
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		xor	dh, dh
		or	ah, 02h	; Negative gets set on a compare
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstbe:
		sub	dword [cyclesRemaining], byte 19
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 19
		mov	dl, [esi]	; Fetch our offset
		inc	esi		; Move past the offset
		or	dl, dl		; Is this bad boy signed?
		jns	notSigned394	; Nope!
		dec	dh			; Make it FFable
notSigned394:
		add	dx, [_z80iy]	; Our offset!
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop395:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead395
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr395		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine395

nextAddr395:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop395

callRoutine395:
		call	ReadMemoryByte	; Standard read routine
		mov	dl, al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit395

memoryRead395:
		mov	dl, [ebp + edx]	; Get our data

readExit395:
		sahf
		cmp	al, dl
		lahf
		o16	pushf
		and	ah, 0fbh	;	Knock out parity/overflow
		pop	dx
		and	dh, 08h ; Just the overflow
		shr	dh, 1	; Shift it into position
		or	ah, dh	; OR It in with the real flags
		xor	dh, dh
		or	ah, 02h	; Set negative
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]

FDInstcb:
		mov	[_baseFixup], dword 3
		mov	dx, [esi]	; Get our instruction (and offset)
		add	esi, 2	; Increment our PC
		mov	byte [_orgval], dl ; Store our value
		or	dl, dl
		js	notNeg396
		mov	byte [_orgval + 1], 00h;
 		jmp	short jumpHandler396
notNeg396:
		mov	byte [_orgval + 1], 0ffh;	It's negative
jumpHandler396:
		shl	ebx, 16	; Save BX away
		mov	bx, [_z80iy]
		add	[_orgval], bx
		shr	ebx, 16	; Restore BX
		mov	dl, dh	; Get our instruction
		xor	dh, dh	; Zero this
		jmp	dword [z80ddfdcbInstructions+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInste1:
		sub	dword [cyclesRemaining], byte 14
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 14
		mov	dx, [_z80sp]
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop397:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead397
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr397		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine397

nextAddr397:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop397

callRoutine397:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80iy], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit397

memoryRead397:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80iy], dl
		mov	dx, di
readExit397:
		inc	dx
		mov	edi, [_z80MemRead]	; Point to the read array

checkLoop398:
		cmp	[edi], word 0ffffh ; End of the list?
		je		memoryRead398
		cmp	dx, [edi]	; Are we smaller?
		jb		nextAddr398		; Yes, go to the next address
		cmp	dx, [edi+4]	; Are we bigger?
		jbe	callRoutine398

nextAddr398:
		add	edi, 10h		; Next structure!
		jmp	short checkLoop398

callRoutine398:
		call	ReadMemoryByte	; Standard read routine
		mov	byte [_z80iy + 1], al	; Put our returned value here
		mov	ax, [_z80af]	; Get our AF back
		jmp	short readExit398

memoryRead398:
		mov	di, dx
		mov	dl, [ebp + edx]
		mov	byte [_z80iy + 1], dl
		mov	dx, di
readExit398:
		add	word [_z80sp], 2
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInste3:
		sub	dword [cyclesRemaining], byte 23
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 23
		mov	dx, word [_z80sp]
		xor	edi, edi
		mov	di, [_z80iy]
		xchg	di, [ebp+edx]
		mov	[_z80iy], di
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInste5:
		sub	dword [cyclesRemaining], byte 15
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 15
		sub	word [_z80sp], 2
		mov	dx, [_z80sp]
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80iy]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop399:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite399	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr399	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine399	; If not, go call it!

nextAddr399:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop399

callRoutine399:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit399
memoryWrite399:
		mov	edi, edx
		mov	dl, byte [_z80iy]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit399:
		inc	dx
		mov	[_z80af], ax	; Store AF
		mov	al, byte [_z80iy + 1]	; And our data to write
		mov	edi, [_z80MemWrite]	; Point to the write array

checkLoop400:
		cmp	[edi], word 0ffffh ; End of our list?
		je	memoryWrite400	; Yes - go write it!
		cmp	dx, [edi]	; Are we smaller?
		jb	nextAddr400	; Yes... go to the next addr
		cmp	dx, [edi+4]	; Are we smaller?
		jbe	callRoutine400	; If not, go call it!

nextAddr400:
		add	edi, 10h		; Next structure, please
		jmp	short checkLoop400

callRoutine400:
		call	WriteMemoryByte	; Go write the data!
		jmp	short WriteMacroExit400
memoryWrite400:
		mov	edi, edx
		mov	dl, byte [_z80iy + 1]
		mov	[ebp + edi], dl
		mov	edx, edi
		mov	ax, [_z80af] ; Get our accumulator and flags
WriteMacroExit400:
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInste9:
		sub	dword [cyclesRemaining], byte 8
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 8
		mov	dx, [_z80iy]	; Get our value
		mov	esi, edx		; New PC!
		add	esi, ebp		; Add in our base
		xor	dh, dh
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

FDInstf9:
		sub	dword [cyclesRemaining], byte 10
		jc	near noMoreExec2
		add	dword [dwElapsedTicks], byte 10
		mov	di, [_z80iy] ; Get our source register
		mov	word [_z80sp], di	; Store our new SP
		mov	dl, [esi]	; Get our next instruction
		inc	esi		; Increment PC
		jmp	dword [z80regular+edx*4]


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

; This is a generic read memory byte handler when a foreign
; handler is to be called

; EDI=Handler address, EDX=Address
; On return, EDX & EDI are undisturbed and AL=Byte read

ReadMemoryByte:
		mov	[_z80af], ax	; Save AF
		mov	[_z80hl], bx	; Save HL
		mov	[_z80bc], cx	; Save BC
		sub	esi, ebp	; Our program counter
		mov	[_z80pc], si	; Save our program counter
		push	edi	; Save our structure address
		push	edx	; And our desired address
		call	dword [edi + 8]	; Go call our handler
		pop	edx	; Restore our address
		pop	edi	; Restore our handler's address
		xor	ebx, ebx	; Zero our future HL
		xor	ecx, ecx	; Zero our future BC
		xor	esi, esi	; Zero it!
		mov	si, [_z80pc]	; Get our program counter back
		mov	ebp, [_z80Base] ; Base pointer comes back
		add	esi, ebp	; Rebase it properly
		mov	bx, [_z80hl]	; Get HL back
		mov	cx, [_z80bc]	; Get BC back
		ret


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

; This is a generic read memory byte handler when a foreign
; handler is to be called.
; EDI=Handler address, AL=Byte to write, EDX=Address
; EDI and EDX Are undisturbed on exit

WriteMemoryByte:
		mov	[_z80hl], bx	; Save HL
		mov	[_z80bc], cx	; Save BX
		sub	esi, ebp	; Our program counter
		mov	[_z80pc], si	; Save our program counter
		push	edi	; Save our structure address
		push	eax	; Data to write
		push	edx	; And our desired address
		call	dword [edi + 8]	; Go call our handler
		pop	edx	; Restore our address
		pop	eax	; Restore our data written
		pop	edi	; Save our structure address
		xor	ebx, ebx	; Zero our future HL
		xor	ecx, ecx	; Zero our future BC
		mov	bx, [_z80hl]	; Get HL back
		mov	cx, [_z80bc]	; Get BC back
		mov	ax, [_z80af]	; Get AF back
		xor	esi, esi	; Zero it!
		mov	si, [_z80pc]	; Get our program counter back
		mov	ebp, [_z80Base] ; Base pointer comes back
		add	esi, ebp	; Rebase it properly
		ret


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

; This is a generic I/O read byte handler for when a foreign
; handler is to be called
; EDI=Handler address, EDX=I/O Address
; On return, EDX & EDI are undisturbed and AL=Byte read

ReadIOByte:
		mov	[_z80af], ax	; Save AF
		mov	[_z80hl], bx	; Save HL
		mov	[_z80bc], cx	; Save BC
		sub	esi, ebp	; Our program counter
		mov	[_z80pc], si	; Save our program counter
		push	edi	; Save our structure address
		push	edx	; And our desired I/O port
		call	dword [edi + 4]	; Go call our handler
		pop	edx	; Restore our address
		pop	edi	; Restore our handler's address
		xor	ebx, ebx	; Zero our future HL
		xor	ecx, ecx	; Zero our future BC
		xor	esi, esi	; Zero it!
		mov	si, [_z80pc]	; Get our program counter back
		mov	ebp, [_z80Base] ; Base pointer comes back
		add	esi, ebp	; Rebase it properly
		mov	bx, [_z80hl]	; Get HL back
		mov	cx, [_z80bc]	; Get BC back
		ret


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

; This is a generic write I/O byte handler when a foreign handler is to
; be called
; EDI=Handler address, AL=Byte to write, EDX=I/O Address
; EDI and EDX Are undisturbed on exit

WriteIOByte:
		mov	[_z80hl], bx	; Save HL
		mov	[_z80bc], cx	; Save BX
		sub	esi, ebp	; Our program counter
		mov	[_z80pc], si	; Save our program counter
		push	edi	; Save our structure address
		push	eax	; Data to write
		push	edx	; And our desired I/O address
		call	dword [edi + 4]	; Go call our handler
		pop	edx	; Restore our address
		pop	eax	; Restore our data written
		pop	edi	; Save our structure address
		xor	ebx, ebx	; Zero our future HL
		xor	ecx, ecx	; Zero our future BC
		mov	bx, [_z80hl]	; Get HL back
		mov	cx, [_z80bc]	; Get BC back
		mov	ax, [_z80af]	; Get AF back
		xor	esi, esi	; Zero it!
		mov	si, [_z80pc]	; Get our program counter back
		mov	ebp, [_z80Base] ; Base pointer comes back
		add	esi, ebp	; Rebase it properly
		ret

		global	_mz80GetContext
		global	mz80GetContext_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80GetContext_:
_mz80GetContext:
		mov	eax, [esp+4]	; Get our context address
		push	esi		; Save registers we use
		push	edi
		push	ecx
		mov     ecx, _mz80contextEnd - _mz80contextBegin
		mov	esi, _mz80contextBegin
		mov	edi, eax	; Source address in ESI
		rep	movsb		; Move it as fast as we can!
		pop	ecx
		pop	edi
		pop	esi
		ret			; No return code
		global	_mz80SetContext
		global	mz80SetContext_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80SetContext_:
_mz80SetContext:
		mov	eax, [esp+4]	; Get our context address
		push	esi		; Save registers we use
		push	edi
		push	ecx
		mov     ecx, _mz80contextEnd - _mz80contextBegin
		mov	edi, _mz80contextBegin
		mov	esi, eax	; Source address in ESI
		rep	movsb		; Move it as fast as we can!
		pop	ecx
		pop	edi
		pop	esi
		ret			; No return code
		global	_mz80GetContextSize
		global	mz80GetContextSize_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80GetContextSize_:
_mz80GetContextSize:
		mov     eax, _mz80contextEnd - _mz80contextBegin
		ret

		global	_mz80GetElapsedTicks
		global	mz80GetElapsedTicks_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80GetElapsedTicks_:
_mz80GetElapsedTicks:
		mov	eax, [esp+4]	; Get our context address
		or	eax, eax	; Should we clear it?
		jz	getTicks
		xor	eax, eax
		xchg	eax, [dwElapsedTicks]
		ret
getTicks:
		mov	eax, [dwElapsedTicks]
		ret
		global	_mz80ReleaseTimeslice
		global	mz80ReleaseTimeslice_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary


times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80ReleaseTimeslice_:
_mz80ReleaseTimeslice:
		mov	[cyclesRemaining], dword 1
		ret

		global	_mz80reset
		global	mz80reset_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80reset_:
_mz80reset:
		xor	eax, eax 	; Zero AX

		mov	dword [_z80halted], eax	; We're not halted anymore!
		mov	word [_z80af], ax	; Zero A & flags
		mov	word [_z80bc], ax	; Zero BC
		mov	word [_z80de],	ax	; Zero DE
		mov	word [_z80hl], ax	; Zero HL
		mov	word [_z80afprime], ax	; Zero AF Prime
		mov	word [_z80bcprime], ax	; Zero BC prime
		mov	word [_z80deprime], ax ; Zero DE prime
		mov	word [_z80hlprime], ax ; Zero HL prime
		mov	byte [_z80i], al	; Zero Interrupt register
		mov	byte [_z80r], al	; Zero refresh register
		mov	word [_z80ix], 0ffffh	; Default mz80Index register
		mov	word [_z80iy], 0ffffh	; Default mz80Index register
		mov	word [_z80pc], ax	; Zero program counter
		mov	word [_z80sp], ax	; And the stack pointer
		mov	dword [_z80inInterrupt], eax ; Not in interrupt
		mov	dword [_z80interruptMode], eax ; Clear our interrupt mode (0)
		mov	dword [_z80interruptState], eax ; Set the state to off
		mov	word [_z80intAddr], 38h ; Set default interrupt address
		mov	word [_z80nmiAddr], 66h ; Set default nmi addr

		ret

		global	_mz80int
		global	mz80int_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80int_:
_mz80int:
		mov	eax, [esp+4]	; Get our (potential) lower interrupt address
		mov	dword [_z80halted], 0	; We're not halted anymore!
;		cmp	dword [_z80interruptState], 0
;		je	alreadyInInt	; Interrupts are disabled

		inc	dword [_z80inInterrupt]	; Set our in-interrupt semaphore
		mov	dword [_z80halted], 0	; We're not halted!

		push	ebp
		push	edi
		push	edx
		mov	ebp, [_z80Base]

		mov	dx, [_z80pc]
		xor	edi, edi
		mov	di, word [_z80sp]
		sub	di, 2
		mov	word [_z80sp], di
		mov	[ebp+edi], dx
		cmp	dword [_z80interruptMode], 2 ; Are we lower than mode 2?
		jb		justModeTwo
		mov	ah, [_z80i]	; Get our high address here
		and	eax, 0ffffh ; Only the lower part
		mov	ax, [eax+ebp] ; Get our vector
		jmp	short setNewVector ; Go set it!
justModeTwo:
		mov	ax, word [_z80intAddr]
setNewVector:
		mov	[_z80pc], ax

		pop	edx
		pop	edi
		pop	ebp

		xor	eax, eax	; Indicate we took the interrupt
		jmp	short z80intExit

alreadyInInt:
		mov	eax, 1		; Indicate we didn't take it

z80intExit:
		ret
		global	_mz80nmi
		global	mz80nmi_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80nmi_:
_mz80nmi:
		mov	dword [_z80halted], 0	; We're not halted anymore!

		push	ebp
		push	edi
		mov	ebp, [_z80Base]

		mov	ax, [_z80pc]
		xor	edi, edi
		mov	di, word [_z80sp]
		sub	di, 2
		mov	word [_z80sp], di
		mov	[ebp+edi], ax
		mov	ax, [_z80nmiAddr]
		mov	[_z80pc], ax

		pop	edi
		pop	ebp

		xor	eax, eax	; Indicate we took the interrupt
		ret
		global	_mz80exec
		global	mz80exec_

times ($$-$) & 3 nop	; pad with NOPs to 4-byte boundary

mz80exec_:
_mz80exec:
		mov	eax, [esp+4]	; Get our execution cycle count
		push	ebx			; Save all registers we use
		push	ecx
		push	edx
		push	ebp
		push	esi
		push	edi

		mov	dword [cyclesRemaining], eax	; Store # of instructions to
						; execute
		mov	dword [dwElapsedTicks], 0
		cmp	dword [_z80halted], 0
		je	goCpu
		mov	eax, dword [cyclesRemaining]
		add	dword [dwElapsedTicks], eax
		mov	dword [cyclesRemaining], 0	; Nothing left!
		mov	eax, 80000000h	; Successful exection
		jmp	popReg
goCpu:
		cld				; Go forward!

		xor	eax, eax		; Zero EAX 'cause we use it!
		xor	ebx, ebx		; Zero EBX, too
		xor	ecx, ecx		; Zero ECX
		xor	edx, edx		; And EDX
		xor	edi, edi		; Zero EDI as well
		xor	esi, esi		; Zero our source address

		mov	ax, [_z80af]		; Accumulator & flags
		xchg	ah, al		; Swap these for later
		mov	bx, [_z80hl]		; Get our HL value
		mov	cx, [_z80bc]		; And our BC value
		mov	ebp, [_z80Base]		; Get the base address
		mov	si, [_z80pc]		; Get our program counter
		add	esi, ebp		; Add in our base address
		mov	dl, [esi]
		inc	esi
		jmp	dword [z80regular+edx*4]

; We get to invalidInsWord if it's a double byte invalid opcode

invalidInsWord:
		dec	esi

; We get to invalidInsByte if it's a single byte invalid opcode

invalidInsByte:
		xchg	ah, al		; Swap them back so they look good
		mov	[_z80af], ax		; Store A & flags
		dec	esi			; Back up one instruction...
		mov	edx, esi		; Get our address in EAX
		sub	edx, ebp		; And subtract our base for
						; an invalid instruction
		jmp	short emulateEnd

noMoreExec2:
		sub	esi, [_baseFixup]
noMoreExec:
		dec	esi
		xchg	ah, al		; Swap these for later
		mov	[_z80af], ax		; Store A & flags
		mov	edx, 80000000h		; Indicate successful exec
		jmp	short emulateEnd	; All finished!

; Now let's tuck away the virtual registers for next time

storeFlags:
		xchg	ah, al		; Swap these for later
		mov	[_z80af], ax		; Store A & flags
emulateEnd:
		mov	[_z80hl], bx		; Store HL
		mov	[_z80bc], cx		; Store BC
		sub	esi, [_z80Base]		; Knock off physical address
		mov	[_z80pc], si		; And store virtual address
		mov	eax, edx		; Result code return

popReg:
		pop	edi			; Restore registers
		pop	esi
		pop	ebp
		pop	edx
		pop	ecx
		pop	ebx

		ret

		end
