#include <allegro.h>
#include "host.h"

extern BITMAP *vscreen_sub;
extern UINT8 *sprites_base_data;
extern int obj_size;

int spr_w = 16, spr_h = 16, spr_pos = 0, spr_size;

void display_spr()
{
   int x = (vscreen_sub->w - spr_w) / 2;
   int y = (vscreen_sub->h - spr_h) / 2;
   int xi, yi;
   int p = spr_pos, c;
   for (yi=0;yi<spr_h;yi++) {
      for (xi=0;xi<spr_w;xi++) {
         c = sprites_base_data[p];
         if ((c!=0)&&(c!=15)) putpixel(vscreen_sub, x+xi, y+yi, c);
         p++;
      }
   }
   spr_size = spr_w * spr_h;
};

void ripper()
{
   int wx = vscreen_sub->w, wy = vscreen_sub->h;
   int cx = wx/2;
   int k;
   do {
      clear(vscreen_sub);
      textprintf_centre(vscreen_sub, font, cx, 0, _white_color(),
                        "System 16 GFX Ripper v1.0");
      display_spr();
      quick_blit();
      clear_keybuf();
      while(!keypressed());
      k = readkey() >> 8;
      switch(k) {
         case KEY_LEFT:
            spr_w++;
            break;
         case KEY_RIGHT:
            if (spr_w) spr_w--;
            break;
         case KEY_UP:
            if (spr_h) spr_h--;
            break;
         case KEY_DOWN:
            spr_h++;
            break;
         case KEY_PGDN:
            if ((spr_pos+spr_size)<obj_size) spr_pos+=spr_size;
            break;
         case KEY_PGUP:
            if (spr_pos>spr_size) spr_pos-=spr_size;
            break;
      }
   } while (k!=KEY_ESC);
   clear_keybuf();
}
