;Multi-SW Version 1.0
;(C) 1997, 1998 Robert William Grubbs, All Rights Reserved


        bits    32

        section .data
        global __sidewinders,__sidewinder_rawdump
%define gDumpLen        200
__sidewinder_rawdump:
gDump times 100h db 0   ;SW Status dump buffer (space for 256 bytes, uses gDumpLen)
bDump times 80h  db 0    ;buffer to hold button data (Modes A and B, all SW)
__sidewinders:
SW1 dd 0                ;SW #1's button status
SW2 dd 0                ;SW #2's button status
SW3 dd 0                ;SW #3's button status
SW4 dd 0                ;SW #4's button status
SWCount dd 1            ;Tell the driver how many sidewinders are present



        section .text
        global  __SWStatus

;This macro calculates parity for the buttons and compares it to the SW's
; parity bit.  If they don't match, the button data is discarded.
%macro ParityCheckSW 1
  mov ecx,ebx                    ;duplicate button status
;  and ch,7fh                     ;mask out parity bit from data
  xor cl,ch                      ;
;  setp cl                        ;calculate parity data (thanks Sardu!)
;  bt ebx,15                      ;
;  setc ch                        ;get the SW's parity bit
;  cmp cl,ch                      ;compare the calculated vs. SW parity
;  jne %%ParChkSW                   ;if not equal, don't update the button status
  jp %%ParChkSW
  mov [%1],ebx              ;update button status for SW #n
%%ParChkSW:                      ;done
%endmacro

;The main subroutine;  this is the important one;  bow down before it
;IN: None
;Out: SWx=buttons (bit 0=null 1=up 2=dn 3=rt 4=lt 5=A 6=B 7=C 8=X)
;                 (9=Y 10=Z 11=L 12=R 13=St 14=M 15=Parity)
;eax <-- &SW1 or 0 if failed
;No registers other than eax are destroyed

__SWStatus:
  push ecx
  push edx
  push esi
  push edi
  push ebp
  push ebx                    ;Preserve registers

  mov ecx,gDumpLen                 ;dump buffer fill size
  lea ebx,[gDump]        ;initial dump pointer
;  mov edx,0201h               ;joystick port
  mov edx,0200h ; Nao 990129: port 200 would not get conflict with Win95
  cli                         ;Disable interrupts (required to avoid jitter)
  GetSWDataLoop:              ;
  out dx,al                   ;trigger joystick port
  nop
  nop
  nop
  nop
  nop
  nop
  in al,dx                    ;read SW status byte
  mov [ebx],al                ;dump status byte
  inc ebx                     ;increment dump pointer
  loop GetSWDataLoop          ;get next status byte (quickly)
  sti                         ;Re-enable interrupts

  mov ecx,0                   ;tick count
  mov esi,1                   ;initialize output mask
  mov ebx,0                   ;initialize output
  mov edi,0                   ;initialize input pointer

  ;My current method of cycle detection is to look for 15 highs in a row on
  ; the strobe line.  Cycle ends is detected by 15 lows in a row.
  ;Mode A has 15 strobes in a cycle, Mode B has 5.
  ; Note that the 15 highs/lows for cycle detection may be too high for slow
  ; machines.  I havn't seen a problem yet, but it may exist...
  ;Multiple Sidewinder data complicates things.  Each additional SW tags
  ; another set of strobes to the cycle, 5 more in mode B, 15 more in mode A.
  ; Detecting extra SW gamepad data is fairly simple: count the number of
  ; strobes. If it is a multiple of 5, you're in mode B and can divide by 5
  ; to get the total number of gamepads.  If it's divisible by 15, use mode A.
  ; However, this method cannot distinguish between mode A for one SW and mode
  ; B for three SW.  In that case, the SWCount variable must be set correctly.

  FindCycle:
  mov al,[gDump+edi]          ;get next status byte
  inc edi                     ;increment input pointer
  cmp edi,gDumpLen                 ;test for end of status block
  je SWNoFind                 ;if it's the end, quit sub with error
  test al,00010000b           ;Check for nonzero bits
  jnz WMFCS1                  ;
  xor ecx,ecx                 ;if zero, reset tick count
  jmp FindCycle               ;can't be pre-cycle
  WMFCS1:                     ;Possibly pre-cycle
  inc ecx                     ;increment tick count
  cmp ecx,15                  ;test for sufficient ticks for cycle start
  jne FindCycle               ;if insufficient, get next status byte
                              ;Yippie! it found a (probable) cycle!

  mov ebp,0                   ;initialize bDump index (strobe count)

  FindStrobeLow:              ;Search for leading edge of data strobe
  mov al,[gDump+edi]          ;get next status byte
  inc edi                     ;increment input pointer
  cmp edi,gDumpLen                 ;test for end of status block
  je SWNoFind                 ;if it's the end, quit sub with error
  test al,00010000b           ;get "strobe" bit
  jnz SHORT FindStrobeLow     ;if it isn't zero, we're not there yet
  xor ecx,ecx                 ;initialize cycle end test count

  FindStrobeHigh:
  inc ecx                     ;increment zero count
  cmp ecx,0fh                 ;is it 15?
  je SWModeCheck              ;if so, goto mode check
  mov al,[gDump+edi]          ;get next status byte
  inc edi                     ;increment input pointer
  cmp edi,gDumpLen                 ;test for end of status block
  je SWNoFind                 ;if it's the end, quit sub with error
  test al,00010000b           ;get "strobe" bit
  jz FindStrobeHigh           ;if it is zero, we're not there yet
                              ;if not, we're there!  data bit is valid (probably)
  mov byte [bDump+ebp],al          ;preserve data for button decoding
  inc ebp                     ;increment strobe count/bDump index
  jmp FindStrobeLow           ;wait for the next button
                           
  SMWDone:
  pop ebx
  pop ebp
  pop edi
  pop esi                     ;I could combine these into one line,
  pop edx                     ; but then it wouldn't compile under GRASM
  pop ecx
;  clc                         ;indicate no error
  lea   eax,[SW1]
  ret                         ;return to calling procedure


  SWNoFind:
  ;error return.  Calling sub should re-dump status, or report "no sidewinder"
  pop ebx
  pop ebp
  pop edi
  pop esi
  pop edx
  pop ecx
;  stc                         ;indicate error
  mov   eax,0
  ret                         ;return to calling procedure

  SWModeCheck:                ;Check strobe count to identify mode and # of SW
  cmp ebp,60                  ;Is it Mode A with 4 Sidewinders?
  je near ModeA4
  cmp ebp,45                  ;Is it Mode A with 3 Sidewinders?
  je near ModeA3
  cmp ebp,30                  ;Is it Mode A with 2 Sidewinders?
  je near ModeA2
  cmp ebp,15                  ;Is it Mode A with 1 Sidewinder or B with 3?
  je near ModeA1
  cmp ebp,20                  ;Is it Mode B with 3 Sidewinders?
  je near ModeB4
  cmp ebp,10                  ;Is it Mode B with 2 Sidewinders?
  je near ModeB2
  cmp ebp,5                   ;Is it Mode B with 1 Sidewinders?
  jne near SWNoFind          ;Any other # of strobes is invalid data

  ModeB1:
  xor ebp,ebp
  call DoModeB
  ParityCheckSW SW1
  jmp SMWDone

  ModeA1:
  cmp dword [SWCount],3
  je near ModeB3
  xor ebp,ebp
  call DoModeA
  ParityCheckSW SW1
  jmp SMWDone

  ModeA2:
  xor ebp,ebp
  call DoModeA
  ParityCheckSW SW1
  mov ebp,15
  call DoModeA
  ParityCheckSW SW2
  jmp SMWDone

  ModeA3:
  xor ebp,ebp
  call DoModeA
  ParityCheckSW SW1
  mov ebp,15
  call DoModeA
  ParityCheckSW SW2
  mov ebp,30
  call DoModeA
  ParityCheckSW SW3
  jmp SMWDone

  ModeA4:
  xor ebp,ebp
  call DoModeA
  ParityCheckSW SW1
  mov ebp,15
  call DoModeA
  ParityCheckSW SW2
  mov ebp,30
  call DoModeA
  ParityCheckSW SW3
  mov ebp,45
  call DoModeA
  ParityCheckSW SW4
  jmp SMWDone

  ModeB2:
  xor ebp,ebp
  call DoModeB
  ParityCheckSW SW1
  mov ebp,5
  call DoModeB
  ParityCheckSW SW2
  jmp SMWDone

  ModeB3:
  xor ebp,ebp
  call DoModeB
  ParityCheckSW SW1
  mov ebp,5
  call DoModeB
  ParityCheckSW SW2
  mov ebp,10
  call DoModeB
  ParityCheckSW SW3
  jmp SMWDone

  ModeB4:
  xor ebp,ebp
  call DoModeB
  ParityCheckSW SW1
  mov ebp,5
  call DoModeB
  ParityCheckSW SW2
  mov ebp,10
  call DoModeB
  ParityCheckSW SW3
  mov ebp,15
  call DoModeB
  ParityCheckSW SW4
  jmp SMWDone



DoModeB:                ;Decode mode B buttons
  ;Handle mode B buttons
  xor ebx,ebx                 ;Initialize output
  test byte [bDump+ebp],00100000b      ;Check bit 5 of Cycle 0
  jnz NoUp                    ;if zero, up is not pressed
  or ebx,0000000000000010b     ;set Up bit in output
  NoUp:                       ;
  test byte [bDump+ebp],01000000b   ;continues the same for all buttons.
  jnz NoDn
  or ebx,0000000000000100b
  NoDn:
  test byte [bDump+ebp],10000000b
  jnz NoRt
  or ebx,0000000000001000b
  NoRt:
  test byte [bDump+ebp+1],00100000b
  jnz NoLt
  or ebx,0000000000010000b
  NoLt:
  test byte [bDump+ebp+1],01000000b
  jnz NoA
  or ebx,0000000000100000b
  NoA:
  test byte [bDump+ebp+1],10000000b
  jnz NoB
  or ebx,0000000001000000b
  NoB:
  test byte [bDump+ebp+2],00100000b
  jnz NoC
  or ebx,0000000010000000b
  NoC:
  test byte [bDump+ebp+2],01000000b
  jnz NoX
  or ebx,0000000100000000b
  NoX:
  test byte [bDump+ebp+2],10000000b
  jnz NoY
  or ebx,0000001000000000b
  NoY:
  test byte [bDump+ebp+3],00100000b
  jnz NoZ
  or ebx,0000010000000000b
  NoZ:
  test byte [bDump+ebp+3],01000000b
  jnz NoL
  or ebx,0000100000000000b
  NoL:
  test byte [bDump+ebp+3],10000000b
  jnz NoR
  or ebx,0001000000000000b
  NoR:
  test byte [bDump+ebp+4],00100000b
  jnz NoSt
  or ebx,0010000000000000b
  NoSt:
  test byte [bDump+ebp+4],01000000b
  jnz NoM
  or ebx,0100000000000000b
  NoM:
  test byte [bDump+ebp+4],10000000b
  jnz NoParity
  or ebx,1000000000000000b
  NoParity:
  ret


DoModeA:                ;Decode Mode A buttons
;        push    ebp
;        push    dword _test_str2
;        call    _printf
;        add     esp,8

  xor ebx,ebx                 ;Clear output
  mov eax,1                   ;set output bit
  shl eax,1                   ;set output bit position
  test byte [bDump+ebp+0],00100000b ;check for button press
  jnz NoAUp                    ;
  or ebx,eax                  ;If pressed, output the bit
  NoAUp:                      ;
  inc ebp                     ;increment bDump pointer
  shl eax,1                   ;continues on for all 15 buttons (inc. parity)
  test byte [bDump+ebp+0],00100000b
  jnz NoADn                    ;Yeah, I should have used a macro or something
  or ebx,eax                  ; for this repetitive stuff.  So sue me.
  NoADn:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoARt
  or ebx,eax
  NoARt:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoALt
  or ebx,eax
  NoALt:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAA
  or ebx,eax
  NoAA:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAB
  or ebx,eax
  NoAB:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAC
  or ebx,eax
  NoAC:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAX
  or ebx,eax
  NoAX:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAY
  or ebx,eax
  NoAY:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAZ
  or ebx,eax
  NoAZ:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAL
  or ebx,eax
  NoAL:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAR
  or ebx,eax
  NoAR:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoASt
  or ebx,eax
  NoASt:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAM
  or ebx,eax
  NoAM:
  inc ebp
  shl eax,1
  test byte [bDump+ebp+0],00100000b
  jnz NoAPar
  or ebx,eax
  NoAPar:
  inc ebp
  ret

;        extern _printf
;        extern _test_str1
;        extern _test_str2
