#include <stdio.h>
#include <stdlib.h>
#include <allegro.h>
#include "host.h"

volatile static UINT32 global_timer;

extern UINT8 rdtsc;
static unsigned long long last_rdtsc_counter; // 64 bit
static UINT32 cycles_per_frame;
static UINT32 remained_cycles;

#define RDTSC(llptr) ({ \
        __asm__ __volatile__ ( \
          " rdtsc " \
          : "=a" (llptr[0]), "=d" (llptr[1]) \
          : : "%eax","%edx" ); })


static void pc_int() {
    global_timer++;
}
END_OF_FUNCTION(pc_int);

int init_timer(int int_per_second)
{
//  printf("init timer for %d\n", int_per_second);
  if (!rdtsc) { // use ALLEGRO timer service
    install_timer();
    LOCK_VARIABLE(global_timer);
    LOCK_FUNCTION(pc_int);
    global_timer = 0;
    install_int_ex(pc_int, 1193181/int_per_second);
  } else { // use RDTSC
    UINT32 counts_per_second = 0;
    unsigned long long tune_counter;
    global_timer = 0;
    install_timer();
    LOCK_VARIABLE(global_timer);
    LOCK_FUNCTION(pc_int);
    global_timer = 0;
    install_int_ex(pc_int, 1193181/10); // 100ms
    while (global_timer == 0);
    RDTSC(((UINT32 *)&last_rdtsc_counter));
    while (global_timer <= 5);
    RDTSC(((UINT32 *)&tune_counter));
    counts_per_second = (UINT32)(tune_counter - last_rdtsc_counter)*2;
    remove_timer();     
 
    cycles_per_frame = counts_per_second/int_per_second;
//    printf("cpf=%d\n", cycles_per_frame);
  }
  return 0;
}

int quit_timer()
{
  if (!rdtsc) remove_timer();
  return 0;
}

int start_timer()
{
//  printf("start timer\n");
  global_timer = 0;
  if (rdtsc) {
    RDTSC(((UINT32*)&last_rdtsc_counter));
    remained_cycles = 0;
  }
  return 0;
}

UINT32 read_timer()
{
  if (rdtsc) {
    unsigned long long rdtsc_counter;
    UINT32 dif;
    RDTSC(((UINT32*)&rdtsc_counter));
    dif = rdtsc_counter - last_rdtsc_counter;
    dif += remained_cycles;
    if (dif >= cycles_per_frame) {
      last_rdtsc_counter = rdtsc_counter;
      remained_cycles = dif % cycles_per_frame;
      global_timer += dif/cycles_per_frame;
    }
  }
//printf("called: g=%d\n", global_timer);
  return global_timer;
}
