#include <stdio.h>
#include <allegro.h>
#include "host.h"
#include "main.h"
#include "eagle.h"

extern UINT8 SCANLINES, EAGLE, DOUBLELINES;
extern long total_render;
extern UINT8 game, sync;
extern int number_of_new_colors;
extern int sx, sy;
extern UINT16 rx;
extern UINT8 *s16_ptr[0x10000];
extern UINT32 reg_screen_active, reg_screen_active18, reg_screen_active_sega3d;
extern UINT8 *display_base;
extern BITMAP *vscreen, *vscreen_sub, *v_vscreen;
extern UINT8 vertical_display;
extern UINT8 pre_16_flag;
extern UINT8 check_performance;
extern unsigned performance_68k,performance_z80,performance_fm,performance_blit;

UINT32 show_datavalue=0;
static void show_data(UINT32 addr)
{
  char status[80];
  int x,y;

  addr&=0xffffff;
  text_mode(0);

//context_switch(0);

  for (y=0; y<8; y++,addr+=8) {
/*
    unsigned char z80_readb();
    addr&=0xfff8;
    sprintf(status, "[%04x]: %02x %02x %02x %02x %02x %02x %02x %02x",
                     addr,
                     z80_readb(addr+0),z80_readb(addr+1),z80_readb(addr+2),z80_readb(addr+3),
                     z80_readb(addr+4),z80_readb(addr+5),z80_readb(addr+6),z80_readb(addr+7));
*/


    sprintf(status,"[%04x]:  %04x  %04x  %04x  %04x",addr,
            0xffff&cpu_readw(addr), 0xffff&cpu_readw(addr+2),
            0xffff&cpu_readw(addr+4), 0xffff&cpu_readw(addr+6));


    x=(1024-8*strlen(status))/2;
    textout(vscreen, font, status, x, y*24+(400-24*7-8)/2, _white_color());
  }
  
//context_switch(1);
}

static UINT8 test_sys18_scr_active(void)
{
  UINT8 u;
  u = cpu_readb(reg_screen_active18);
  if ((u&0x2)==0) return 0;
  return 0x20;
}

static UINT8 test_sega3d_scr_active(void)
{
  UINT8 u;
  u = cpu_readb(reg_screen_active_sega3d);
  if ((u&0x10)==0) return 0x0;
  return 0x20;
}

#define RDTSC(llptr) ({ \
        __asm__ __volatile__ ( \
          " rdtsc " \
          : "=a" (llptr[0]), "=d" (llptr[1]) \
          : : "%eax","%edx" ); })

unsigned chk_tsc()
{
  static unsigned last_tsc[2];
  static unsigned tsc[2];
  last_tsc[0]=tsc[0]; last_tsc[1]=tsc[1];
  RDTSC(tsc);
//  printf("%08x %08x %d\n",tsc[1],tsc[0], tsc[0]-last_tsc[0]);
  if (tsc[1]!=last_tsc[1]) {
    return (tsc[0]+(0xffffffff-last_tsc[0]));
  }
  return (tsc[0]-last_tsc[0]);
}

static unsigned cycles_per_frame;
static int default_vsync_method=1;
void init_rdtsc()
{
  int i, valid_counts;
  unsigned total_cycles, average;
  #define MAX_TESTS 32
  unsigned cycles[MAX_TESTS];
  UINT8 start_again=0;

  default_vsync_method = 2;

again:
  cycles_per_frame = 7553550;
  video_sync(0);
  chk_tsc();
  // take the average of the time between 2 vsync's
  for (i=0; i<MAX_TESTS; i++) {
    video_sync(0);
    cycles[i] = chk_tsc();
  }
  
  #define NEEDED_SAMPLES 8
  #define MAX_DELTA 25000
  // take the average of continous cycles counts with delta<MAX_DELTA
  for (i=0; i<MAX_TESTS-NEEDED_SAMPLES; i++) {
    #define delta(a,b) ((a)>(b) ?((a)-(b)) :((b)-(a)))
    int j;
    for (j=1; j<NEEDED_SAMPLES; j++) {
      if (delta(cycles[i], cycles[i+j]) > MAX_DELTA) break;
    }
    if (j >= NEEDED_SAMPLES) { // found it!
//      printf("i=%d :", i); for (j=0; j<NEEDED_SAMPLES; j++) printf("%d ", cycles[i+j]); printf("\n");
      for (j=0, total_cycles=0; j<NEEDED_SAMPLES; j++) total_cycles += cycles[i+j];
      cycles_per_frame = total_cycles/NEEDED_SAMPLES;
      break;
    }
  }

//  printf("cycles_per_frame = %d\n", cycles_per_frame);

  if (cycles_per_frame < 7553550/8 && !start_again) {
    start_again = 1;
    default_vsync_method = 1;
    goto again;
  }

}

static int enter_times;
static unsigned remained_cycles;
void reset_video_sync()
{
  enter_times = 0;
  remained_cycles = 0;
}

int video_sync(int method)
{
  switch (method) {
  case 0:
     video_sync(default_vsync_method);
     return 0;

  case 1: // poll on VGA status register
     while ((inportb(0x3DA)&0x08)!=0);
     while ((inportb(0x3DA)&0x08)==0);
     return 0;

  case 2: // call ALLEGRO::vsync()
     vsync();
     return 0;
    
  case 3: // poll on pentium internal timer, use default vsync method to re-syncronize the counter every 512 times (once per 8.53sec)
    {
      if ((enter_times++ &0x1ff) == 0) { // re-syncronize timer
        video_sync(default_vsync_method);
        chk_tsc();
        remained_cycles = 0;
      } else {
        unsigned cycles;
        cycles = remained_cycles + chk_tsc(); 
        while (cycles < cycles_per_frame) cycles += chk_tsc();
        remained_cycles = cycles - cycles_per_frame;
      }
    }
    return 0;

  }
  return 0;

}

void blit_eagle_vert(void)
{
   int eagle_y;
   for (eagle_y=0; eagle_y<320-1; eagle_y++) {
      eagle((unsigned long *)(v_vscreen->line[eagle_y]),
            (unsigned long *)(v_vscreen->line[eagle_y+1]),
            224,
            screen->seg,
            (int)(screen->line[sy+eagle_y*2]+288),
            (int)(screen->line[sy+eagle_y*2+1]+288));
   }
}

void blit_eagle_hor(void)
{
   int eagle_y;
   for (eagle_y=0; eagle_y<224-1; eagle_y++) {
        eagle((unsigned long *)(vscreen->line[eagle_y+88]+352),
        (unsigned long *)(vscreen->line[eagle_y+89]+352),
        320,
        screen->seg,
        (int)screen->line[sy+eagle_y*2],
        (int)screen->line[sy+eagle_y*2+1]);
   }
}

void blit_vertical(void)
{
   if (sy>=0) blit(v_vscreen, screen, 0, 0, sx, sy, 224, 320);
   else blit(v_vscreen, screen, 0, -sy, sx, 0, 224, 320+sy);
}

void blit_horizontal(void)
{
   blit(vscreen, screen, (1024-320)/2, (400-224)/2, sx, sy, 320, 224);
}

void ScanlinesBlit320();
void ScanlinesBlit640();
void ScanlinesBlit640_2();
void ScanlinesBlit1024();
void ScanlinesBlit1280();
void VerticalScanlinesBlit1024();
void VerticalScanlinesBlit1280();

void (*blit_routine)();

void init_blit_routine(void)
{
   if (EAGLE) blit_routine = (vertical_display)? blit_eagle_vert:blit_eagle_hor;
   else if (SCANLINES) {
     if (!vertical_display) {
       blit_routine = (rx==320)? ScanlinesBlit320:(DOUBLELINES? ScanlinesBlit640_2:ScanlinesBlit640);
       if (SCANLINES==2) blit_routine = ScanlinesBlit1024;
       if (SCANLINES==3) blit_routine = ScanlinesBlit1280;
     } else {
       blit_routine = blit_vertical;
       if (SCANLINES==1) blit_routine = VerticalScanlinesBlit1024;
       if (SCANLINES>=2) blit_routine = VerticalScanlinesBlit1280;
     }
   }
   else blit_routine = (vertical_display)? blit_vertical:blit_horizontal;
}

extern UINT8 rdtsc;
void RenderScreen() {
   UINT8 u=0x20;

   init_palette_freelist();

   if (pre_16_flag) translate_pre16();

   if (reg_screen_active18) {
     u=test_sys18_scr_active();
   } else if (reg_screen_active_sega3d) {
     u=test_sega3d_scr_active();
   } else {
     if (reg_screen_active)
       u = (s16_ptr[reg_screen_active>>16][reg_screen_active&0xffff]);
     if (u&1){ // video off
       clear_framebuf();
       u=0;
     }
   }

   {
     static UINT8 freeze_counter=0;
     if (!(u&0x20)) freeze_counter=4;
     if (freeze_counter) {
       freeze_counter--;
       u=0;
     }
   }
   
   if (check_performance) chk_tsc();
   if (u&0x20) {
     asm_render_screen();
   }
   if (check_performance) {
     unsigned ticks = chk_tsc();
     char status[80];
     text_mode(0); // non-transparent mode
     sprintf(status, "%07d %07d %07d %07d %07d", ticks,performance_68k,performance_z80,performance_fm,performance_blit);
     textout(vscreen, font, status, (1024-320)/2, (400-224)/2, _white_color());
   }
 
   if (pre_16_flag) untranslate_pre16();
   if (show_datavalue!=0) show_data(show_datavalue);
   if (vertical_display) {
     rotate_screen();
   }

   if (sync) {
     extern int opcodeb2; extern int opcodeb;
     int cpu=0; extern int num_cpus;
     int opcodeb3=0;
     char nomore=0;

     if (rdtsc) video_sync(3);
     else video_sync(1);
/*
     context_switch(cpu++);
     while ((inportb(0x3DA)&0x08)==0) {
       if (!nomore) { cpu_dispatch(10); opcodeb3+=10; opcodeb2+=10; }
       if (opcodeb3>opcodeb) {
         if (cpu<num_cpus) {
           context_switch(cpu++); opcodeb3=0;
         } else nomore=1;
       }
     }
*/


   }
   
   if (number_of_new_colors) Update_Palette();
   if (check_performance) chk_tsc();
//   update_message();
   (*blit_routine)();
   update_message();
   if (check_performance) performance_blit = chk_tsc();
   total_render++;
}

void quick_blit()
{
   (*blit_routine)();
};
