/* Setting up the OpenGL screen
*/
#include "GliD3D.h"
#include "gl2ideal.h"

#ifndef CDS_FULLSCREEN
#define CDS_FULLSCREEN      0x00000004
#endif

/* This function is taken from Mark J. Kilgard's book */
static int isExtensionSupported(const char *extension)
{
	const GLubyte *extensions = NULL;
	const GLubyte *start;
	GLubyte *where, *terminator;

	/* Extension names should not have spaces. */
	where = (GLubyte *) strchr(extension, ' ');
	if (where || *extension == '\0')
		return 0;

	extensions = glGetString(GL_EXTENSIONS);

	/* It takes a bit of care to be fool-proof about parsing the
	OpenGL extensions string. Don't be fooled by sub-strings, etc. */
	start = extensions;
	for (;;) {
		where = (GLubyte *) strstr((const char *) start, extension);
		if (!where)
			break;
		terminator = where + strlen(extension);
		if (where == start || *(where - 1) == ' ')
			if (*terminator == ' ' || *terminator == '\0')
				return 1;
		start = terminator;
	}
	return 0;
}

void InitGLExt(void)
{
	if(!isExtensionSupported("GL_ARB_texture_env_add") &&
	   !isExtensionSupported("GL_EXT_texture_env_add"))
		g_gr_bUseTexEnvAdd = 0;

	if(!isExtensionSupported("GL_NV_texture_env_combine4")){
		g_gr_bUseTexEnvCombine4 = 0;
	}else{
	//	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_ADD);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB_EXT, GL_PRIMARY_COLOR_EXT);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_RGB_EXT, GL_SRC_COLOR);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB_EXT, GL_TEXTURE);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_RGB_EXT, GL_SRC_COLOR);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE2_RGB_EXT, GL_CONSTANT_EXT);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND2_RGB_EXT, GL_SRC_COLOR);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE3_RGB_NV, GL_TEXTURE);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND3_RGB_NV, GL_ONE_MINUS_SRC_COLOR);
	//	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_ADD);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA_EXT, GL_PRIMARY_COLOR_EXT);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND0_ALPHA_EXT, GL_SRC_ALPHA);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_ALPHA_EXT, GL_TEXTURE);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND1_ALPHA_EXT, GL_SRC_ALPHA);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE2_ALPHA_EXT, GL_ZERO);
		glTexEnvi(GL_TEXTURE_ENV, GL_OPERAND2_ALPHA_EXT, GL_SRC_ALPHA);
	}
	if(!isExtensionSupported("GL_ARB_texture_env_combine") &&
	   !isExtensionSupported("GL_EXT_texture_env_combine")){
		g_gr_bUseTexEnvCombine = 0;
	}else{
	//	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_RGB_EXT, GL_REPLACE);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_RGB_EXT, GL_PRIMARY_COLOR_EXT);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_RGB_EXT, GL_TEXTURE);
	//	glTexEnvi(GL_TEXTURE_ENV, GL_COMBINE_ALPHA_EXT, GL_MODULATE);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE0_ALPHA_EXT, GL_PRIMARY_COLOR_EXT);
		glTexEnvi(GL_TEXTURE_ENV, GL_SOURCE1_ALPHA_EXT, GL_TEXTURE);
	}
}


LONG WINAPI WindowProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch (uMsg)
	{
	case WM_CREATE:
		return 0;
	case WM_DESTROY:
	case WM_CLOSE:
	case WM_QUIT:
		PostQuitMessage (0);
		return 0;
	case WM_MOVE:
	case WM_SIZE:
		break;
	default:
		PostMessage (g_gr_hWndOld, uMsg, wParam, lParam);
		break;
	}
	return DefWindowProc (hWnd, uMsg, wParam, lParam);
}

#define MINDIFF 60

HWND
CreateOpenGLWindow (HWND Parent_hWnd, char *title, int x, int y, int width, int height,
	BYTE type, DWORD flags)
{
	int pf;
	int fullscreen = 0;
	HWND hWnd;
	WNDCLASS wc;
	PIXELFORMATDESCRIPTOR pfd;
	static HINSTANCE hInstance = 0;
	DEVMODE dm;

	dm.dmBitsPerPel = 16;	// set default for window-mode

	if (g_gr_bFullScreen)
	{
	// Change the display to correct resolution
		long	res;
		int		bestchoise = -1, i, mindiff = 10000, found16bit = 0;

		fullscreen = 1;
		dm.dmSize = sizeof (DEVMODE);

		for (i = 0; EnumDisplaySettings (NULL, i, &dm) != FALSE; i++)
		{
			if ((int)dm.dmPelsWidth == width && (int)dm.dmPelsHeight == height)
			{
			if (dm.dmBitsPerPel == 16)
			{
				if (dm.dmDisplayFrequency == 0 || dm.dmDisplayFrequency == 1)
				{
					bestchoise = i;
					break;
				}
				found16bit = 1;

				if (abs (dm.dmDisplayFrequency - MINDIFF) < mindiff)
				{
					mindiff = abs (dm.dmDisplayFrequency - MINDIFF);
					bestchoise = i;
				}
			}
			else if (!found16bit && dm.dmBitsPerPel >= 16)
			{
				if (abs (dm.dmDisplayFrequency - MINDIFF) < mindiff)
				{
					mindiff = abs (dm.dmDisplayFrequency - MINDIFF);
					bestchoise = i;
				}
			}
			if(mindiff == 0)
				break;
			}
		}

		EnumDisplaySettings (NULL, bestchoise, &dm);
//	 if ((res = ChangeDisplaySettings (&dm, 0)) != DISP_CHANGE_SUCCESSFUL)
		if ((res = ChangeDisplaySettings (&dm, CDS_FULLSCREEN)) != DISP_CHANGE_SUCCESSFUL)
		{
//			dm.dmBitsPerPel = 32;
//			if ((res = ChangeDisplaySettings (&dm, CDS_FULLSCREEN)) != DISP_CHANGE_SUCCESSF)
			{
				switch (res)
				{
				case DISP_CHANGE_RESTART:
					ERROROUT ("Display change error: DISP_CHANGE_RESTART");
					break;
				case DISP_CHANGE_BADFLAGS:
					ERROROUT ("Display change error: DISP_CHANGE_BADFLAGS");
					break;
				case DISP_CHANGE_BADMODE:
					ERROROUT ("Display change error: DISP_CHANGE_BADMODE");
					break;
				case DISP_CHANGE_FAILED:
					ERROROUT ("Display change error: DISP_CHANGE_FAILED");
					break;
				}
				fullscreen = 0;
			}
		}
	}
	/* only register the window class once - use hInstance as a flag. */
	if (!hInstance)
	{
		hInstance = GetModuleHandle (NULL);
		wc.style = CS_OWNDC;
		wc.lpfnWndProc = (WNDPROC) WindowProc;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = hInstance;
		wc.hIcon = LoadIcon (NULL, IDI_WINLOGO);
		wc.hCursor = LoadCursor (NULL, IDC_ARROW);
		wc.hbrBackground = NULL;
		wc.lpszMenuName = NULL;
		wc.lpszClassName = "OpenGL";

		if (!RegisterClass (&wc))
		{
			ERROROUT("RegisterClass() failed:  " "Cannot register window class.");
//			MessageBox (NULL, "RegisterClass() failed:  "
//			"Cannot register window class.", "Error", MB_OK);
			return NULL;
		}
	}

	if (fullscreen)
	{
		hWnd = CreateWindowEx (WS_EX_TOPMOST, "OpenGL", title, WS_POPUP |	// WS_OVERLAPPEDWINDOW |
			WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_DISABLED | WS_VISIBLE,
			x, y, width, height, NULL, NULL, hInstance, NULL);
		ShowCursor (FALSE);
	}
	else
	{
		hWnd = CreateWindowEx (WS_EX_TOPMOST, "OpenGL", title,
			WS_CHILD | WS_CLIPSIBLINGS | WS_DISABLED | WS_VISIBLE,
			x, y, width, height, Parent_hWnd, NULL, hInstance, NULL);
		// UltraHLE hack
		SetWindowPos(Parent_hWnd, NULL, 0, 0, width, height+77, SWP_NOMOVE|SWP_NOZORDER);
		RECT	r, rp;
		GetWindowRect(Parent_hWnd, &rp);
		GetClientRect(Parent_hWnd, &r);
		SetWindowPos(Parent_hWnd, NULL, 0, 0, width+(rp.right-rp.left)-(r.right-r.left),
					 height+(rp.bottom-rp.top)-(r.bottom-r.top)+20, SWP_NOMOVE|SWP_NOZORDER);
	}
	if (hWnd == NULL)
	{
		ERROROUT("CreateWindow() failed:  Cannot create a window.");
//		MessageBox (NULL, "CreateWindow() failed:  Cannot create a window.",
//			"Error", MB_OK);
		return NULL;
	}


	g_gr_hDC = GetDC (hWnd);

	/* there is no guarantee that the contents of the stack that become
		the pfd are zeroed, therefore _make sure_ to clear these bits. */

	memset (&pfd, 0, sizeof (pfd));
	pfd.nSize = sizeof (pfd);
	pfd.nVersion = 1;
	pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | flags;
	pfd.iPixelType = type;
//	pfd.cColorBits = 16;
//	pfd.cDepthBits = 32;
	pfd.cColorBits = dm.dmBitsPerPel;
	pfd.cDepthBits = 24;

	pf = ChoosePixelFormat (g_gr_hDC, &pfd);
	if (pf == 0) {
//		pfd.cColorBits = 16;
		pfd.cDepthBits = 32;
		pf = ChoosePixelFormat (g_gr_hDC, &pfd);
		if (pf == 0) {
			pfd.cDepthBits = 16;
			pf = ChoosePixelFormat (g_gr_hDC, &pfd);
			if (pf == 0) {
				ERROROUT("ChoosePixelFormat() failed:  Cannot find a suitable pixel format.");
//				MessageBox (NULL, "ChoosePixelFormat() failed:  "
//				"Cannot find a suitable pixel format.", "Error", MB_OK);
				return 0;
			}
		}
	}

	if (SetPixelFormat (g_gr_hDC, pf, &pfd) == FALSE)
	{
		ERROROUT("SetPixelFormat() failed:  Cannot set format specified.");
//		MessageBox (NULL, "SetPixelFormat() failed:  "
//			"Cannot set format specified.", "Error", MB_OK);
		return 0;
	}

	DescribePixelFormat (g_gr_hDC, pf, sizeof (PIXELFORMATDESCRIPTOR), &pfd);

	if(pfd.cDepthBits > 16)
		fPrecisionFix = 1.0f;	// Disable PrecisionFix
	else
		fPrecisionFix = 10.0f;

#ifdef DEBUGDLL
	char	mbuf[256];
	sprintf(mbuf, "color: %dx%dx%d(%d%d%d) depth:%d", dm.dmPelsWidth, dm.dmPelsHeight, dm.dmBitsPerPel, pfd.cRedBits, pfd.cGreenBits, pfd.cBlueBits, pfd.cDepthBits);
	ERROROUT(mbuf);
#endif	//DEBUGDLL

	ReleaseDC (hWnd, g_gr_hDC);

	return hWnd;
}
