/////////////////////////////////////////////////////////////////////////////
// GliD3D_texture.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "GliD3D.h"
#include "gl2ideal.h"
#include <stdlib.h>
/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

#define nTmu 0

inline void SetCurrentTexture(FxU32 StartAddress)
{
	if (StartAddress > GLID3D_TEXMAXADDRESS) {
		StartAddress = GLID3D_TEXMAXADDRESS;
	}
	current_texture=&g_gr_tmu[nTmu].texture[StartAddress];
}

/////////////////////////////////////////////////////////////////////////////

FX_ENTRY FxU32 FX_CALL
  grTexCalcMemRequired (
	GrLOD_t lodmin, GrLOD_t lodmax,
	GrAspectRatio_t aspect, GrTextureFormat_t fmt)
{
	TRACEFUNCTION ("grTexCalcMemRequired");

	return GLID3D_TEXCALCMEMREQUIRED;
}

FX_ENTRY FxU32 FX_CALL
  grTexTextureMemRequired (FxU32 evenOdd,
	GrTexInfo * info)
{
	TRACEFUNCTION ("grTexTextureMemRequired");

	return GLID3D_TEXTEXTUREMEMREQUIRED;
}

FX_ENTRY FxU32 FX_CALL
  grTexMinAddress (GrChipID_t tmu)
{
	TRACEFUNCTION ("grTexMinAddress");

	return GLID3D_TEXMINADDRESS;
}

FX_ENTRY FxU32 FX_CALL
  grTexMaxAddress (GrChipID_t tmu)
{
	TRACEFUNCTION ("grTexMaxAddress");

	return GLID3D_TEXMAXADDRESS-1;
}

FX_ENTRY void FX_CALL grTexNCCTable (GrChipID_t tmu, GrNCCTable_t table)
{
	TRACEFUNCTION ("grTexNCCTable");
}

FX_ENTRY void FX_CALL grTexSource (GrChipID_t tmu, FxU32 startAddress, FxU32 evenOdd,
	GrTexInfo * info)
{
	TRACEFUNCTION ("grTexSource");
	//INT nTmu = grsubGetTmuIndex(tmu);
	// semantically incorrect and/or buggy: only optimized for UltraHLE

	if(current_texture != &g_gr_tmu[nTmu].texture[startAddress]){
		FlushTriangleVertex();

		SetCurrentTexture(startAddress);
		glBindTexture (GL_TEXTURE_2D, current_texture->texId);
	}
}

FX_ENTRY void FX_CALL grTexClampMode (GrChipID_t tmu, GrTextureClampMode_t s_clampmode,
	GrTextureClampMode_t t_clampmode)
{
	TRACEFUNCTION ("grTexClampMode");

	if (current_texture->clampmode == (s_clampmode | (t_clampmode << 1)))
		return;
	current_texture->clampmode = (s_clampmode | (t_clampmode << 1));

	FlushTriangleVertex();

	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT - s_clampmode);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT - t_clampmode);
}

FX_ENTRY void FX_CALL grTexCombine (GrChipID_t tmu, GrCombineFunction_t rgb_function,
	GrCombineFactor_t rgb_factor, GrCombineFunction_t alpha_function,
	GrCombineFactor_t alpha_factor, FxBool rgb_invert, FxBool alpha_invert)
{
	TRACEFUNCTION ("grTexCombine");
}

FX_ENTRY void FX_CALL grTexCombineFunction (GrChipID_t tmu,
	GrTextureCombineFnc_t fnc)
{
	TRACEFUNCTION ("grTexCombineFunction");
}

FX_ENTRY void FX_CALL grTexDetailControl (GrChipID_t tmu, int lod_bias,
	FxU8 detail_scale,
	float detail_max
)
{
	TRACEFUNCTION ("grTexDetailControl");
}

FX_ENTRY void FX_CALL grTexFilterMode (GrChipID_t tmu, GrTextureFilterMode_t
	minfilter_mode, GrTextureFilterMode_t magfilter_mode)
{
	TRACEFUNCTION ("grTexFilterMode");

	if (current_texture->texture_filter_mode == (magfilter_mode | (minfilter_mode << 1)))
		return;
	current_texture->texture_filter_mode = (magfilter_mode | (minfilter_mode << 1));

	FlushTriangleVertex();

	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST + magfilter_mode);
	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST + minfilter_mode);
}

FX_ENTRY void FX_CALL grTexLodBiasValue (GrChipID_t tmu, float bias)
{
	TRACEFUNCTION ("grTexLodBiasValue");
}

FX_ENTRY void FX_CALL grTexDownloadMipMap (GrChipID_t tmu, FxU32 startAddress,
	FxU32 evenOdd, GrTexInfo * info)
{
	TRACEFUNCTION ("grTexDownloadMipMap");

	 grTexDownloadMipMapLevel (tmu, startAddress, info->smallLod, info->smallLod,
		info->aspectRatio, info->format, GR_MIPMAPLEVELMASK_BOTH, info->data);
}

FX_ENTRY void FX_CALL grTexDownloadMipMapLevel (GrChipID_t tmu, FxU32 startAddress,
	GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
	GrTextureFormat_t format, FxU32 evenOdd, void *data)
{
	TRACEFUNCTION ("grTexDownloadMipMapLevel");

	FlushTriangleVertex();

	static unsigned long tbuffer[256 * 256];
	void *tadr = tbuffer;

	SetCurrentTexture(startAddress);
	if (current_texture->texId == TEXID_INVALID)
	{
		//genereate a new texname
		glGenTextures (1, &current_texture->texId);
		glBindTexture (GL_TEXTURE_2D, current_texture->texId);
		glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
		current_texture->texture_filter_mode = (GR_TEXTUREFILTER_BILINEAR | (GR_TEXTUREFILTER_BILINEAR << 1));
		current_texture->clampmode = (GR_TEXTURECLAMP_WRAP | (GR_TEXTURECLAMP_WRAP << 1));
	}else{
		//create new texture object
		glBindTexture (GL_TEXTURE_2D, current_texture->texId);
	}

	int	aw, ah;
	grsubAspectToInt (aw, ah, aspectRatio);

	current_texture->aw = aw / 256.0;
	current_texture->ah = ah / 256.0;

	//Get size of lod
	const int	w = grsubLodToInt(thisLod) / ah;
	const int	h = grsubLodToInt(thisLod) / aw;
	const int	size = w*h;

	register unsigned char *dest;
	register const unsigned short *src;
	GLenum texture_iformat = GL_RGBA4;
	GLenum texture_format = GL_RGBA;
	GLenum texture_type = GL_UNSIGNED_BYTE;

	switch (format)
	{
		case GR_TEXFMT_INTENSITY_8:
		case GR_TEXFMT_ALPHA_INTENSITY_88:
		case GR_TEXFMT_AP_88:
		case GR_TEXFMT_ALPHA_INTENSITY_44:
		case GR_TEXFMT_P_8:
		case GR_TEXFMT_ALPHA_8:
		break;			// not implemented/

	case GR_TEXFMT_AYIQ_8422:
		 src = (unsigned short *)data;
		 dest = (unsigned char*)tbuffer;
		 while(src < (unsigned short*)data + size)
		 {
			int		y, i, q;
			 y = (((*src) >> 4) & 0x0f);
			 i = (((*src) >> 2) & 0x03);
			 q = ((*src) & 0x03);
			 *dest++ = (unsigned char)(y + 0.95 * i + 0.62 * q);
			 *dest++ = (unsigned char)(y - 0.28 * i - 0.64 * q);
			 *dest++ = (unsigned char)(y - 1.11 * i + 1.73 * q);
			 *dest++ = (((*src) >> 8) & 0xff);
			 src++;
		 }
		break;
	case GR_TEXFMT_YIQ_422:
	{
		register const unsigned char *src8 = (unsigned char *)data;
		dest = (unsigned char*)tbuffer;
		while(src8 < (unsigned char *)data + size)
		{
			int		y, i, q;
			y = (((*src8) >> 4) & 0x0f);
			i = (((*src8) >> 2) & 0x03);
			q = (((*src8) >> 0) & 0x03);
			*dest++ = (unsigned char)(y + 0.95 * i + 0.62 * q);
			*dest++ = (unsigned char)(y - 0.28 * i - 0.64 * q);
			*dest++ = (unsigned char)(y - 1.11 * i + 1.73 * q);
			*dest++ = 0;
			src8++;
		}
		break;
	}
	case GR_TEXFMT_RGB_332:			// Untested
	{
		register int x;
		for (x = 0; x < size; x++)
		{
			src = (unsigned short *)(data) + x;
			dest = (unsigned char *)tbuffer + x * 4;
			*(dest) = ((*src) & (0x007 << 5)) + (((*src >> 5) & 0x007) << 2) +
				(((*src >> 5) & 0x007) >> 1);
			*(dest + 1) = ((*src << 3) & (0x007 << 5)) + (((*src >> 2) &
				0x007) << 2) + (((*src >> 2) & 0x007) >> 1);
			*(dest + 2) = (((*src) & 0x003) << 6) + (((*src) & 0x003) << 4) +
				(((*src) & 0x003) << 4) + (((*src) & 0x003));
			*(dest + 3) = 0xff;
		}
		break;
	}
	case GR_TEXFMT_ARGB_8332:		// Untested
	{
		register int x;
		for (x = 0; x < size; x++)
		{
			src = (unsigned short *)(data) + x;
			dest = (unsigned char *)tbuffer + x * 4;
			*(dest) = ((*src) & (0x007 << 5)) + (((*src >> 5) & 0x007) << 2) +
			(((*src >> 5) & 0x007) >> 1);
			*(dest + 1) = ((*src << 3) & (0x007 << 5)) + (((*src >> 2) &
				0x007) << 2) +
			(((*src >> 2) & 0x007) >> 1);
			*(dest + 2) = (((*src) & 0x003) << 6) + (((*src) & 0x003) << 4) +
			(((*src) & 0x003) << 4) + (((*src) & 0x003));
			*(dest + 3) = (((*src) >> 8) & 0xff);
		}
		break;
	}
	 case GR_TEXFMT_RGB_565:
		src = (unsigned short *)data;
		dest = (unsigned char*)tbuffer;
		while(src < (unsigned short*)data + size)
		{
			*dest++ = (((*src >> 11) & 0x001f) << 3) + (((*src >> 11) & 0x001f) >> 2);
			*dest++ = (((*src >> 5) & 0x003f) << 2) + (((*src >> 5) & 0x003f) >> 4);
			*dest++ = (((*src >> 0) & 0x001f) << 3) + (((*src >> 0) & 0x001f) >> 2);
			*dest++ = 0xff;
			src++;
		}
		break;

	 case GR_TEXFMT_ARGB_1555:
	 {
#ifndef NO_BGRA_REV
#ifndef GL_UNSIGNED_SHORT_4_4_4_4_REV
#define GL_UNSIGNED_SHORT_4_4_4_4_REV	0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV	0x8366
#endif
		tadr = data;
		texture_type = GL_UNSIGNED_SHORT_1_5_5_5_REV;
		texture_iformat = GL_RGBA;
		texture_format = GL_BGRA_EXT;
#else
		src = (unsigned short *)data;
		register unsigned long *destw=(unsigned long *)tbuffer;
#if 1
		while(src < (unsigned short*)data + size)
		{
			*destw++ = ((*src & 0x7c00) >> 7)	// r
					|  ((*src & 0x03e0) << 6)	// g
					|  ((*src & 0x001f) << 19)	// b
//					|  ((*src & 0x8000) ? 0xff000000 : 0);	// a
					|  ((*src & 0x8000) << 16);	// a
			src++;
		}
#else
		while(src < (unsigned short*)data + size)
		{
			*destw++=((*src&0x7fff)<<1) | ((*src&0x8000) >>15);
			src++;
		}
		texture_type = GL_UNSIGNED_SHORT_5_5_5_1_EXT;
#endif
		texture_iformat = GL_RGB5_A1;
#endif
		break;
	}
	case GR_TEXFMT_ARGB_4444:
	{
#ifndef NO_BGRA_REV
		tadr = data;
		texture_type = GL_UNSIGNED_SHORT_4_4_4_4_REV;
		texture_iformat = GL_RGBA;
		texture_format = GL_BGRA_EXT;
#else
		src = (unsigned short *)data;
		register unsigned long *destw = (unsigned long *)tbuffer;
#if 1
		while(src < (unsigned short*)data + size)
		{
			*destw++=((*src&0xf000)<<16)
				 | ((*src&0x0f00)>>4)
				 | ((*src&0x00f0)<<8)
				 | ((*src&0x000f)<<20);
			src++;
		}

#else
		while(src < (unsigned short*)data + size)
		{
			*destw++=((*src&0x0fff)<<4) | ((*src&0xf000)>>12);
			src++;
		}
		texture_type = GL_UNSIGNED_SHORT_4_4_4_4_EXT;
#endif
#endif
		break;
	}
	}

	int tlod;

	switch (evenOdd)
	{
	case GR_MIPMAPLEVELMASK_BOTH:
	default:
		tlod = (thisLod - largeLod);
		break;
	case GR_MIPMAPLEVELMASK_EVEN:
		tlod = ((thisLod - largeLod) / 2) - 1;
		break;
	case GR_MIPMAPLEVELMASK_ODD:
		tlod = (thisLod - 1 - largeLod) / 2;
		break;
	}

	glTexImage2D (GL_TEXTURE_2D, tlod, texture_iformat, w, h, 0, texture_format,
		texture_type, (void*)tadr);
}

FX_ENTRY void FX_CALL grTexDownloadMipMapLevelPartial (GrChipID_t tmu, FxU32 startAddress,
	GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
	GrTextureFormat_t format, FxU32 evenOdd, void *data,
	int start,
	int end)
{
	TRACEFUNCTION ("grTexDownloadMipMapLevelPartial");
}

FX_ENTRY void FX_CALL ConvertAndDownloadRle (GrChipID_t tmu, FxU32 startAddress,
	GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
	GrTextureFormat_t format, FxU32 evenOdd, FxU8 * bm_data, long bm_h,
	FxU32 u0,
	FxU32 v0,
	FxU32 width,
	FxU32 height,
	FxU32 dest_width,
	FxU32 dest_height,
	FxU16 * tlut)
{
	TRACEFUNCTION ("ConvertAndDownloadRle");
}

FX_ENTRY void FX_CALL grCheckForRoom (FxI32 n)
{
	TRACEFUNCTION ("grCheckForRoom");
}

FX_ENTRY void FX_CALL grTexDownloadTable (GrChipID_t tmu, GrTexTable_t type, void *data)
{
	TRACEFUNCTION ("grTexDownloadTable");
}

FX_ENTRY void FX_CALL grTexDownloadTablePartial (GrChipID_t tmu,
	GrTexTable_t type, void *data,
	int start,
	int end)
{
	TRACEFUNCTION ("grTexDownloadTablePartial");
}

FX_ENTRY void FX_CALL grTexMipMapMode (GrChipID_t tmu, GrMipMapMode_t mode,
	FxBool lodBlend)
{
	TRACEFUNCTION ("grTexMipMapMode");
}

FX_ENTRY void FX_CALL grTexMultibase (GrChipID_t tmu, FxBool enable)
{
	TRACEFUNCTION ("grTexMultibase");
}

FX_ENTRY void FX_CALL grTexMultibaseAddress (GrChipID_t tmu,
	GrTexBaseRange_t range, FxU32 startAddress, FxU32 evenOdd, GrTexInfo * info)
{
	TRACEFUNCTION ("grTexMultibaseAddress");
}

/////////////////////////////////////////////////////////////////////////////
