#ifdef _MSC_VER
#define inline __forceinline
#endif

#define PRJ_PERSPECTIVE

#ifndef GL_EXT_texture_env_combine
#define GL_COMBINE_EXT			0x8570
#define GL_COMBINE_RGB_EXT		0x8571
#define GL_COMBINE_ALPHA_EXT	0x8572
#define GL_RGB_SCALE_EXT		0x8573
#define GL_ADD_SIGNED_EXT		0x8574
#define GL_INTERPOLATE_EXT		0x8575
#define GL_CONSTANT_EXT			0x8576
#define GL_PRIMARY_COLOR_EXT	0x8577
#define GL_PREVIOUS_EXT			0x8578
#define GL_SOURCE0_RGB_EXT		0x8580
#define GL_SOURCE1_RGB_EXT		0x8581
#define GL_SOURCE2_RGB_EXT		0x8582
#define GL_SOURCE0_ALPHA_EXT	0x8588
#define GL_SOURCE1_ALPHA_EXT	0x8589
#define GL_SOURCE2_ALPHA_EXT	0x858A
#define GL_OPERAND0_RGB_EXT		0x8590
#define GL_OPERAND1_RGB_EXT		0x8591
#define GL_OPERAND2_RGB_EXT		0x8592
#define GL_OPERAND0_ALPHA_EXT	0x8598
#define GL_OPERAND1_ALPHA_EXT	0x8599
#define GL_OPERAND2_ALPHA_EXT	0x859A
#endif	//GL_EXT_texture_env_combine

#ifndef GL_NV_texture_env_combine4
#define GL_COMBINE4_NV			0x8503
#define GL_SOURCE3_RGB_NV		0x8583
#define GL_SOURCE3_ALPHA_NV		0x858B
#define GL_OPERAND3_RGB_NV		0x8593
#define GL_OPERAND3_ALPHA_NV	0x859B
#endif	//GL_NV_texture_env_combine4

#define TEXID_INVALID	0xffffffff
#define static_color	ptlv[0].color

HWND
CreateOpenGLWindow (HWND Parent_hWnd, char *title, int x, int y, int width, int height,
    BYTE type, DWORD flags);

void InitBlendMap(void);
void InitDrawState(void);
void InitGLExt(void);

/////////////////////////////////////////////////////////////////////////////

inline void ColorConvFromGrVertex (GL2IDE_COLOR &color, const GrVertex * pv,
	GrCombineLocal_t _color = static_color_mode,
	GrCombineLocal_t _alpha = g_gr_state.alpha_combine_local,
	int	_fix = g_gr_fix1)
{
	if(_color == GR_COMBINE_LOCAL_ITERATED){
		if(_fix || pv->r < f256){
			color.rgb.r = pv->r * f_255;
			color.rgb.g = pv->g * f_255;
			color.rgb.b = pv->b * f_255;
		}else{	// fake wrapround to eliminate pinky-background bug
			color.rgb.b = color.rgb.g = color.rgb.r = 0.0f;
		}
		if(_alpha == GR_COMBINE_LOCAL_ITERATED){
			color.a = pv->a * f_255;
		}else{
			color.a = static_color.a;
		}
	}else{
		if(_alpha == GR_COMBINE_LOCAL_ITERATED){
			color.rgb = static_color.rgb;
			color.a = pv->a * f_255;
		}else{
			color = static_color;
		}
	}
}

inline void CoordConvFromGrVertex (CORD &cord, GL2IDE_TEXCORD &tcord, const GrVertex * pv,
	 BOOL _Texture2DOn = g_gr_Texture2DOn)
{
#ifdef PRJ_PERSPECTIVE
	cord.w = 1.0f / pv->oow;
	if(_Texture2DOn){	 // scale texture coordinates according to aspect ratio
		tcord.tv = tcord.tu = cord.w;
		tcord.tu *= pv->tmuvtx[0].sow * current_texture->ah;
		tcord.tv *= pv->tmuvtx[0].tow * current_texture->aw;
	}

	if (g_gr_bPrecisionFix) {
		if (cord.w < fPrecisionFix)
			cord.w = fPrecisionFix;
	}
//	cord.x = (pv->x - g_gr_nWidth/2) * cord.w;
//	cord.y = (pv->y - g_gr_nHeight/2) * cord.w;
	cord.x = pv->x * cord.w;
	cord.y = pv->y * cord.w;
	cord.z = -cord.w;
	cord.w = 1.0f;
#else
	cord.w = 1.0f / pv->oow;
	if(_Texture2DOn){	 // scale texture coordinates according to aspect ratio
		tcord.tv = tcord.tu = cord.w;
		tcord.tu *= pv->tmuvtx[0].sow * current_texture->ah;
		tcord.tv *= pv->tmuvtx[0].tow * current_texture->aw;
	}

	if (g_gr_bUseZInverse) {
		if (g_gr_bPrecisionFix) {
			if (cord.w < fPrecisionFix)
				cord.w = fPrecisionFix;
		}
		cord.z = 1.0f;
	}else{
		cord.z = -cord.w * cord.w;
	}
	cord.x = pv->x * cord.w;
	cord.y = pv->y * cord.w;
#endif // PRJ_PERSPECTIVE
}

inline void grsubSetVertexFromGrVertex (CORD &cord, GL2IDE_COLOR &color,
       GL2IDE_TEXCORD &tcord, const GrVertex * pv)
{
	CoordConvFromGrVertex(cord, tcord, pv);
	ColorConvFromGrVertex(color, pv);
}

/////////////////////////////////////////////////////////////////////////////

inline void EnableBlend(void)
{
	if(g_gr_BlendOn)
		return;
	g_gr_BlendOn = TRUE;
	glEnable(GL_BLEND);
}

inline void DisableBlend(void)
{
	if(!g_gr_BlendOn)
		return;
	g_gr_BlendOn = FALSE;
	glDisable(GL_BLEND);
}

inline void EnableAlphaTest(void)
{
	if(g_gr_AlphaTestOn)
		return;
	g_gr_AlphaTestOn = TRUE;
	glEnable(GL_ALPHA_TEST);
}

inline void DisableAlphaTest(void)
{
	if(!g_gr_AlphaTestOn)
		return;
	g_gr_AlphaTestOn = FALSE;
	glDisable(GL_ALPHA_TEST);
}

inline void EnableTexture2D(void)
{
	if(g_gr_Texture2DOn)
		return;
	g_gr_Texture2DOn = TRUE;
	glEnable(GL_TEXTURE_2D);
}

inline void DisableTexture2D(void)
{
	if(!g_gr_Texture2DOn)
		return;
	g_gr_Texture2DOn = FALSE;
	glDisable(GL_TEXTURE_2D);
}

inline void SetTexEnvColor(const GL2IDE_COLOR &col)
{
	if (texEnvColor.rgb.r == col.rgb.r && texEnvColor.rgb.g == col.rgb.g && 
		texEnvColor.rgb.b == col.rgb.b && texEnvColor.a == col.a)
		return;

	FlushTriangleVertex();
	texEnvColor = col;
	glTexEnvfv(GL_TEXTURE_ENV, GL_TEXTURE_ENV_COLOR, (float*)&col);
}


/////////////////////////////////////////////////////////////////////////////

inline void InitCombineSetup ()
{
	static_color_mode = g_gr_state.color_combine_local;
	static_color = g_gr_state.constant_color;
	noTexColor = 1;
	noTexAlpha = 1;
	combine_color_mode = 0;

	const GL2IDE_COLOR	white_col = {{1,1,1},1};
	texEnvColor.a = 0;
	SetTexEnvColor(white_col);	// set default color
}

inline void i_grAlphaCombine (GrCombineFunction_t function,
    GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
    FxBool invert)
{
	g_gr_state.alpha_combine_function = function;
	g_gr_state.alpha_combine_factor = factor;
	g_gr_state.alpha_combine_local = local;
	g_gr_state.alpha_combine_other = other;
//	g_gr_state.alpha_combine_invert = invert;

	noTexAlpha = (function == GR_COMBINE_FUNCTION_ZERO ||
		factor == GR_COMBINE_FACTOR_NONE ||
		(factor != GR_COMBINE_FACTOR_TEXTURE_RGB &&
		other != GR_COMBINE_OTHER_TEXTURE));

	if( function == GR_COMBINE_FUNCTION_SCALE_OTHER &&
	    other == GR_COMBINE_OTHER_TEXTURE)
	{
		if(local != GR_COMBINE_LOCAL_ITERATED){
			if (factor == GR_COMBINE_FACTOR_ONE)
				static_color.a = 1.0f;
			else if (factor == GR_COMBINE_FACTOR_ZERO)
				static_color.a = 0.0f;
			else
				static_color.a = g_gr_state.constant_color.a;
		}
	}else{
		if(local != GR_COMBINE_LOCAL_ITERATED)
			static_color.a = g_gr_state.constant_color.a;
	}
}

inline void i_grColorCombine (GrCombineFunction_t function,
    GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
    FxBool invert)
{
	g_gr_state.color_combine_function = function;
	g_gr_state.color_combine_factor = factor;
	g_gr_state.color_combine_local = local;
	g_gr_state.color_combine_other = other;
//	g_gr_state.color_combine_invert = invert;

	noTexColor = (function == GR_COMBINE_FUNCTION_ZERO ||
		factor == GR_COMBINE_FACTOR_NONE ||
		(factor != GR_COMBINE_FACTOR_TEXTURE_RGB &&
		other != GR_COMBINE_OTHER_TEXTURE));

	if( factor == GR_COMBINE_FACTOR_TEXTURE_RGB)
	{
		if(other == GR_COMBINE_OTHER_ITERATED){	// reverse blending
			if(g_gr_bUseTexEnvCombine4){
				g_gr_texenv = GL_COMBINE4_NV;
				combine_color_mode = 0;
				static_color_mode = GR_COMBINE_LOCAL_ITERATED;
			}else{
				g_gr_texenv = GL_BLEND;
				combine_color_mode = 2;
				static_color_mode = local;
			}
		}else{
			g_gr_texenv = GL_BLEND;
			combine_color_mode = 0;
			static_color_mode = local;
		}
		if(static_color_mode != GR_COMBINE_LOCAL_ITERATED)
			static_color.rgb = g_gr_state.constant_color.rgb;
	}else
	if( function == GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL &&
	    factor == GR_COMBINE_FACTOR_TEXTURE_ALPHA &&
	    other == GR_COMBINE_OTHER_TEXTURE)
	{
		g_gr_texenv = GL_DECAL;
		combine_color_mode = 0;
		static_color_mode = local;
		if(local != GR_COMBINE_LOCAL_ITERATED)
			static_color.rgb = g_gr_state.constant_color.rgb;
	}else
	if( function == GR_COMBINE_FUNCTION_LOCAL &&
	    factor == GR_COMBINE_FACTOR_ONE)
	{
		g_gr_texenv = GL_MODULATE;
		combine_color_mode = 1;
		static_color_mode = local;
		if(local != GR_COMBINE_LOCAL_ITERATED)
			static_color.rgb = g_gr_state.constant_color.rgb;
	}else
	if( function == GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL &&
	    factor == GR_COMBINE_FACTOR_ONE)
	{
		combine_color_mode = 0;
		if(g_gr_bUseTexEnvAdd){
			g_gr_texenv = GL_ADD;
			static_color_mode = local;
			if(local != GR_COMBINE_LOCAL_ITERATED)
				static_color.rgb = g_gr_state.constant_color.rgb;
		}else{
			g_gr_texenv = GL_MODULATE;
			static_color_mode = GR_COMBINE_LOCAL_CONSTANT;
			static_color.rgb.b = static_color.rgb.g = static_color.rgb.r = 1.0f;
		}
	}else
	{
		g_gr_texenv = GL_MODULATE;
		combine_color_mode = 0;
		if(factor == GR_COMBINE_FACTOR_ONE){
			static_color_mode = GR_COMBINE_LOCAL_CONSTANT;
			static_color.rgb.b = static_color.rgb.g = static_color.rgb.r = 1.0f;
		}else if(factor == GR_COMBINE_FACTOR_ZERO){
			static_color_mode = GR_COMBINE_LOCAL_CONSTANT;
			static_color.rgb.b = static_color.rgb.g = static_color.rgb.r = 0.0f;
		}else{
			static_color_mode = local;
			if(local != GR_COMBINE_LOCAL_ITERATED)
				static_color.rgb = g_gr_state.constant_color.rgb;
		}
	}
}


/////////////////////////////////////////////////////////////////////////////

