/////////////////////////////////////////////////////////////////////////////
// GliD3D.cpp : GliD3D - Glide to Direct3D
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

// Windows
//#pragma comment(lib, "WinMM.lib")
//#pragma comment(lib, "OLE32.lib")
//#pragma comment(lib, "IMM32.lib")
//#pragma comment(lib, "Version.lib")

/*
// DirectX
#pragma comment(lib, "DxGuid.lib")
#pragma comment(lib, "DDraw.lib")
#pragma comment(lib, "D3DRM.lib")
*/

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

HWND g_gr_hWnd;
HWND g_gr_hWndOld;
HDC g_gr_hDC;
HGLRC g_gr_glRC;

BOOL g_gr_bUseZInverse;
FLOAT g_gr_fZInverseDepth;

INT g_gr_nGlideWidth;
INT g_gr_nGlideHeight;
FLOAT g_gr_fGlideWidth;
FLOAT g_gr_fGlideHeight;
INT g_gr_nWidth;
INT g_gr_nHeight;
FLOAT g_gr_fWidth;
FLOAT g_gr_fHeight;
FLOAT g_gr_fHarfWidth;
FLOAT g_gr_fHarfHeight;
FLOAT g_gr_fWidthScale;
FLOAT g_gr_fHeightScale;
BOOL g_gr_bFullScreen;
BOOL g_gr_bForceMipMaps;
INT g_gr_n16BPP;
INT g_gr_n24BPP;
INT g_gr_bFogMode;
BOOL g_gr_bNoMultiTextTest;
BOOL g_gr_bMultiTextureAvailable;
BOOL g_gr_AlphaTestOn;
BOOL g_gr_BlendOn;
BOOL g_gr_Texture2DOn;
BOOL g_gr_bAlphaFix;
BOOL g_gr_bLeft;
FLOAT g_gr_fGamma;
BOOL g_gr_bScaleFix;
BOOL g_gr_bPrecisionFix;
BOOL g_gr_bStereo;
BOOL g_gr_bSoftwareEmulation;
INT g_gr_nReduceTexture;
BOOL g_gr_bNoGammaControl;
FLOAT g_gr_fGammaBase;
INT g_gr_nContrast;
GLID3D_RESOLUTIONINFO g_gr_aResolution[16];
BOOL g_gr_bUVFix;
BOOL g_gr_bWindowMode;
BOOL g_gr_bUseZForW;

BOOL g_gr_bCanTextureSystemMemory;
INT g_gr_nNumTextureFormats;

//GB3DTEXTUREFORMATINFO g_gr_texture_format[GLID3D_MAXTEXTUREFORMATS];
GLID3D_TEXFMT g_gr_texfmt[16];

INT g_gr_nColBuffers;
INT g_gr_nAuxBuffers;
GrBuffer_t g_gr_render_buffer;

BOOL g_gr_bOpenedWindow;
BOOL g_gr_bSplashed;
RECT g_gr_rcOld;

GLID3D_STATE g_gr_state;
GLID3D_TMU g_gr_tmu[GLID3D_NUM_TMU];
GLID3D_VERTEXLAYOUT g_gr_vertex_layout;

//BYTE                                  g_gr_fogtable[GR_FOG_TABLE_SIZE];
BYTE g_gr_fogtable[64];

GLID3D_LFBLOCKINFO g_gr_lfb_lock_info_front;
GLID3D_LFBLOCKINFO g_gr_lfb_lock_info_back;

// Debug

INT g_gr_nTrianglePerFrame;


// PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB          = NULL;
// PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB        = NULL;
/////////////////////////////////////////////////////////////////////////////
// Implements

BOOL
GliD3DGetProfileString (LPCSTR pszSection, LPCSTR pszKey, LPCSTR
    pszDefault, LPSTR pszDest, LPCSTR pszProfileName)
{
    GetPrivateProfileString (pszSection, pszKey, pszDefault, pszDest, 256, pszProfileName);
    return TRUE;
}

INT
GliD3DGetProfileInt (LPCSTR pszSection, LPCSTR pszKey, INT nDefault,
    LPCSTR pszProfileName)
{
    CHAR pszDefault[32];
    CHAR pszDest[32];
    INT nDest;
    BOOL bSucceeded;

    itoa (nDefault, pszDefault, 10);
    bSucceeded = GetPrivateProfileString (pszSection, pszKey, pszDefault,
		pszDest, 256, pszProfileName);
    nDest = atoi (pszDest);
    return nDest;
}

BOOL
GliD3DWriteProfileString (LPCSTR pszSection, LPCSTR pszKey, LPSTR pszSrc,
    LPCSTR pszProfileName)
{
    return WritePrivateProfileString (pszSection, pszKey, pszSrc, pszProfileName);
}

BOOL
GliD3DWriteProfileInt (LPCSTR pszSection, LPCSTR pszKey, INT nSrc,
    LPCSTR pszProfileName)
{
    CHAR pszSrc[32];

    itoa (nSrc, pszSrc, 10);
    return WritePrivateProfileString (pszSection, pszKey, pszSrc, pszProfileName);
}

/////////////////////////////////////////////////////////////////////////////
