/////////////////////////////////////////////////////////////////////////////
// GliD3D.h : GliD3D - Glide to Direct3D
/////////////////////////////////////////////////////////////////////////////
#ifndef __GLID3D_H__
#define __GLID3D_H__
/////////////////////////////////////////////////////////////////////////////
#include <stdio.h>

extern "C"
{				/////////////////////////////////////////////////////////////////////////////// Directive//#include <iostream.h>//#include <stdlib.h>//#include <conio.h>/////////////////////////////////////////////////////////////////////////////// Defines / Variables

#define CACHETRIANGLES
//#define USEVERTEXARRAY
//#define DEBUGDLL
#define OPTIMIZE_TEXTURE2D
#define GLID3D_FOG_OFF	0
#define GLID3D_FOG_MODE1 1
#define GLID3D_FOG_MODE2 2
#define GREXPORT __declspec(dllexport)
#define GLID3D_DEBUGDUMP					(TRUE)
#define GLID3D_TRACEALLFUNCTIONS			(FALSE)
#define GLID3D_MESSAGEBOXWARNING			(FALSE)
#define GLID3D_TRACEWARNING					(TRUE)
//#define TRACEFUNCTION(v)                                      DEBUG(if (GLID3D_TRACEALLFUNCTIONS) TRACE("GliD3D function : " v "\n"));
/*
#define ERROROUT(v)				{ \
								  		  ofstream fel2("error.txt",ios::out | ios::app, 0); \
											fel2 << v << endl; \
											fel2.close(); \
											} */
#define ERROROUT(v)
#ifdef DEBUGDLL
#define TRACEFUNCTION(v) (fputs(v, ErrorFile), fputc('\n', ErrorFile))
#else
#define TRACEFUNCTION(v)	//#define WARNING(v) MessageBox(NULL,v, NULL, MB_OK);
#endif
#define WARNING(v)		// If undefined this #define then speedup but will not scaling when different screen size mode//#define GLID3D_NOSCALINGFIX// If undefined this #define then speedup and don't show debug information
#define GLID3D_SHOWDEBUGINFO	// If undefined this #define then speedup but will inactivate stereo effect
#define GLID3D_NOSPECIALEFFECTS
#define GLID3D_CLASSNAME						"GL2IDE_CLASS"
#define GLID3D_TITLE							"GL2IDE"
#define GLID3D_PROFILENAME						"GL2IDE.INI"
#define GLID3DPROF_VIDEO_FOGMODE				"FogMode"
#define GLID3DPROF_VIDEO_MIPMAPS				"MipMaps"
#define GLID3DPROF_VIDEO_FULLSCREEN				"FullScreen"
#define GLID3DPROF_VIDEO_BLENDFIX				"BlendFix"
#define GLID3DPROF_VIDEO_PRECISIONFIX			"PrecisionFix"
#define GLID3DPROF_VIDEO_USEZINVERSE			"UseZInverse"
#define GLID3DPROF_VIDEO_ZDEPTHRANGE			"ZDepthRange"	//#define GLID3DPROF_SPLASH                                             "Splash"//#define GLID3DPROF_SPLASH_NOSPLASH                            "NoSplash"//#define GLID3DPROF_SPLASH_NOSOUND                             "NoSound"
#define GLID3D_TMU0						(0)
#define GLID3D_NUM_TMU					(1)
#define GLID3D_TEXCALCMEMREQUIRED		(1)
#define GLID3D_TEXTEXTUREMEMREQUIRED	(1)
#define GLID3D_TEXMINADDRESS			(0)
#define GLID3D_TEXMAXADDRESS			(8191)
#define GLID3D_MAXTEXTUREFORMATS		(32)
#define GLID3D_FOGMODE_EXP				(0xf0)
#define GLID3D_FOGMODE_EXP2				(0xf1)
#define GLID3D_FOGMODE_LINEAR			(0xf2)
#define GLID3D_FOGTABLE_MODE			(0)
#define GLID3D_FOGTABLE_VALIDATE		(1)
#define GLID3D_FOGTABLE_DENSITY			(3 + sizeof(float) * 0)
#define GLID3D_FOGTABLE_NEARZ			(5 + sizeof(float) * 1)
#define GLID3D_FOGTABLE_FARZ			(7 + sizeof(float) * 2)
#define GLID3D_FOGTABLE_VALIDATE_VALUE	('P')
#define DIV255(x) div255_lookuptable[x]

typedef struct t_cord {
	GLfloat x;
	GLfloat y;
	GLfloat z;
	GLfloat w;
}
CORD;

struct GL2IDE_COLOR
{
  GLfloat r, g, b, a;
};

struct GL2IDE_TEXCORD
{
  GLfloat tu, tv;
};

typedef struct t_vertex
{
   CORD cord;
   float tu, tv;
   int color;
}
VERTEX;

typedef struct t_vertex2
{
   CORD cord;
   GL2IDE_TEXCORD tcord;
   GL2IDE_COLOR color;
}
VERTEX2;

#ifdef USEVERTEXARRAY
typedef VOID (*vertexconv_func) (CORD &cord, GL2IDE_COLOR &color,
       GL2IDE_TEXCORD &texcord, const GrVertex * pv);
#else
typedef VOID (*vertexconv_func) (VERTEX2 & ptlv, const GrVertex * pv);
#endif

typedef struct tagGLID3D_TEXTURE
{

   GrTexInfo info;

   unsigned int texId;	//gltexturename, -1 if no texture associated with 

   BOOL bPal;
   INT nWidth;
   INT nHeight;

}
 *LPGLID3D_TEXTURE, GLID3D_TEXTURE;

typedef struct tagGLID3D_TEXFMT
{

   INT nFormat;

   INT nBits;
   BOOL bPalette;
   INT nR;
   INT nRShift;
   INT nG;
   INT nGShift;
   INT nB;
   INT nBShift;

}
 *LPGLID3D_TEXFMT, GLID3D_TEXFMT;

typedef struct tagGLID3D_TMU
{

   GrTextureFilterMode_t texture_minfilter_mode;
   GrTextureFilterMode_t texture_magfilter_mode;
   GrMipMapMode_t mipmap_mode;

   GrCombineFunction_t texture_combine_rgb_function;
   GrCombineFactor_t texture_combine_rgb_factor;
   GrCombineFunction_t texture_combine_alpha_function;
   GrCombineFactor_t texture_combine_alpha_factor;

   GLID3D_TEXTURE texture[GLID3D_TEXMAXADDRESS + 256];

   FxU32 texture_source_start_address;
   FxU32 texture_source_start_address_old;
   FxU32 texture_source_even_odd;
   GrTexInfo texture_source_info;

   GrTextureClampMode_t s_clampmode;
   GrTextureClampMode_t t_clampmode;

   float ah, aw;

}
 *LPGLID3D_TMU, GLID3D_TMU;

struct GL2IDE_TEXTURE
{
   GrTextureFilterMode_t texture_minfilter_mode;
   GrTextureFilterMode_t texture_magfilter_mode;
   GrMipMapMode_t mipmap_mode;

   GrTextureClampMode_t s_clampmode;
   GrTextureClampMode_t t_clampmode;
   GLint MinFilterMode, MagFilterMode, SClampWrap, TClampWrap;
};

typedef struct tagGLID3D_STATE
{

   // System
   GrColorFormat_t color_format;
   GrOriginLocation_t origin_location;
   GrBuffer_t render_buffer;
   GrCullMode_t cull_mode;
   GrDitherMode_t dither_mode;
   GrColor_t fog_color;
   GrFogMode_t fog_mode;
   DWORD fog_d3dcolor;

   // Clip window
   FxU32 clip_window_minx;
   FxU32 clip_window_miny;
   FxU32 clip_window_maxx;
   FxU32 clip_window_maxy;

   // Chromakey
   GrChromakeyMode_t chromakey_mode;
   GrColor_t chromakey_value;

   // Depth buffer
   GrDepthBufferMode_t depth_buffer_mode;
   FxBool depth_mask;
   GrCmpFnc_t depth_buffer_function;
   FxI16 depth_bias_level;

   // Color
   DWORD constant_color_value;
   DWORD constant_color_value_color;
   DWORD constant_color_value_alpha;
   GL2IDE_COLOR constant_color;
   GrCombineFunction_t color_combine_function;
   GrCombineFactor_t color_combine_factor;
   GrCombineLocal_t color_combine_local;
   GrCombineOther_t color_combine_other;
   FxBool color_combine_invert;
   FxBool color_mask_rgb;
   FxBool color_mask_a;

   // Alpha
   GrCombineFunction_t alpha_combine_function;
   GrCombineFactor_t alpha_combine_factor;
   GrCombineLocal_t alpha_combine_local;
   GrCombineOther_t alpha_combine_other;
   GrAlphaBlendFnc_t alpha_blend_function_rgb_sf;
   GrAlphaBlendFnc_t alpha_blend_function_rgb_df;
   GrAlphaBlendFnc_t alpha_blend_function_alpha_sf;
   GrAlphaBlendFnc_t alpha_blend_function_alpha_df;
   GrCmpFnc_t alpha_test_function;
   GrAlpha_t alpha_test_reference_value;

}
 *LPGLID3D_STATE, GLID3D_STATE;

typedef struct tagGLID3D_VERTEXLAYOUT
{
   INT nXY;
   INT nRGB;
   INT nZ;
   INT nA;
   INT nQ;
   INT nST0;
   INT nQ0;
   INT nST1;
   INT nQ1;
}
 *LPGLID3D_VERTEXLAYOUT, GLID3D_VERTEXLAYOUT;

typedef struct tagGLID3D_PIXELFORMAT
{
   BOOL bPalette;
   INT nBits;
   INT nRShifts;
   INT nRMax;
   INT nGShifts;
   INT nGMax;
   INT nBShifts;
   INT nBMax;
}
 *LPGLID3D_PIXELFORMAT, GLID3D_PIXELFORMAT;

typedef struct tagGLID3D_LFBLOCKINFO
{
   BOOL bLocked;
   GrLfbInfo_t info;
   INT nSize;
}
 *LPGLID3D_LFBLOCKINFO, GLID3D_LFBLOCKINFO;

typedef struct tagGLID3D_RESOLUTIONINFO
{
   INT nWidth;
   INT nHeight;
}
 *LPGLID3D_RESOLUTIONINFO, GLID3D_RESOLUTIONINFO;

extern BOOL g_gr_bNoMultiTextTest;
extern BOOL g_gr_bMultiTextureAvailable;

extern BOOL g_gr_bUseZInverse;
extern FLOAT g_gr_fZInverseDepth;

extern HDC g_gr_hDC;
extern HGLRC g_gr_glRC;
extern HWND g_gr_hWnd;
extern HWND g_gr_hWndOld;
extern INT g_gr_nGlideWidth;
extern INT g_gr_nGlideHeight;
extern FLOAT g_gr_fGlideWidth;
extern FLOAT g_gr_fGlideHeight;
extern INT g_gr_nWidth;
extern INT g_gr_nHeight;
extern FLOAT g_gr_fWidth;
extern FLOAT g_gr_fHeight;
extern FLOAT g_gr_fHarfWidth;
extern FLOAT g_gr_fHarfHeight;
extern FLOAT g_gr_fWidthScale;
extern FLOAT g_gr_fHeightScale;
extern BOOL g_gr_bFullScreen;
extern INT g_gr_n16BPP;
extern INT g_gr_n24BPP;
extern INT g_gr_bFogMode;
extern BOOL g_gr_AlphaTestOn;
extern BOOL g_gr_BlendOn;
extern BOOL g_gr_Texture2DOn;
extern BOOL g_gr_bPrecisionFix;
extern BOOL g_gr_bAlphaFix;
extern BOOL g_gr_bLeft;
extern FLOAT g_gr_fGamma;
extern BOOL g_gr_bScaleFix;
extern BOOL g_gr_bStereo;
extern BOOL g_gr_bSoftwareEmulation;
extern INT g_gr_nReduceTexture;
extern BOOL g_gr_bNoGammaControl;
extern FLOAT g_gr_fGammaBase;
extern INT g_gr_nContrast;
extern GLID3D_RESOLUTIONINFO g_gr_aResolution[16];
extern BOOL g_gr_bUVFix;
extern BOOL g_gr_bWindowMode;
extern BOOL g_gr_bUseZForW;
extern BOOL g_gr_bForceMipMaps;

extern BOOL g_gr_bCanTextureSystemMemory;
extern INT g_gr_nNumTextureFormats;

// extern GB3DTEXTUREFORMATINFO g_gr_texture_format[GLID3D_MAXTEXTUREFORMATS];
extern GLID3D_TEXFMT g_gr_texfmt[16];

extern INT g_gr_nColBuffers;
extern INT g_gr_nAuxBuffers;

extern BOOL g_gr_bOpenedWindow;
extern BOOL g_gr_bSplashed;
extern RECT g_gr_rcOld;

extern GLID3D_STATE g_gr_state;
extern GLID3D_TMU g_gr_tmu[GLID3D_NUM_TMU];
extern GLID3D_VERTEXLAYOUT g_gr_vertex_layout;

extern GL2IDE_TEXTURE *current_texture;

//extern BYTE                                           g_gr_fogtable[GR_FOG_TABLE_SIZE];
extern BYTE g_gr_fogtable[64];

extern GLID3D_LFBLOCKINFO g_gr_lfb_lock_info_front;
extern GLID3D_LFBLOCKINFO g_gr_lfb_lock_info_back;
extern GLenum g_gr_dfactor, g_gr_sfactor;

extern GLfloat div255_lookuptable[256];

// Debug

extern INT g_gr_nTrianglePerFrame;
extern vertexconv_func grsubSetVertexFromGrVertex;
extern GLuint disp_listnum, disp_listnum2;

// extern PFNGLACTIVETEXTUREARBPROC          glActiveTextureARB;
// extern PFNGLMULTITEXCOORD2FARBPROC        glMultiTexCoord2fARB;
#ifdef DEBUGDLL
extern FILE *ErrorFile;
void InitErrorFile(void);
void CloseErrorFile(void);
#endif

/////////////////////////////////////////////////////////////////////////////
// Prototypes

void grMegaCombineEverythingSetup (bool);
void InitLookupVertexFuncs (void);
void InitBlendMap(void);
void InitDiv255LookupTable(void);
void ChooseVertexFunc (void);
void SetCurrentTexture(FxU32 StartAddress);

// Glide functions
GREXPORT FX_ENTRY void FX_CALL grDrawLine (const GrVertex * v1, const
   GrVertex * v2);
GREXPORT FX_ENTRY void FX_CALL grDrawPlanarPolygon (int nverts, const int
   ilist[], const
   GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPlanarPolygonVertexList (int
   nverts, const
   GrVertex
   vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPoint (const GrVertex * pt);
GREXPORT FX_ENTRY void FX_CALL grDrawPolygon (int nverts, const int
   ilist[], const GrVertex
   vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawPolygonVertexList (int nverts, const
   GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grDrawTriangle (const GrVertex * a, const
   GrVertex * b, const
   GrVertex * c);

GREXPORT FX_ENTRY void FX_CALL grBufferClear (GrColor_t color, GrAlpha_t
   alpha, FxU16 depth);
GREXPORT FX_ENTRY int FX_CALL grBufferNumPending (void);
GREXPORT FX_ENTRY void FX_CALL grBufferSwap (int swap_interval);
GREXPORT FX_ENTRY void FX_CALL grRenderBuffer (GrBuffer_t buffer);

typedef void (*GrErrorCallbackFnc_t) (const char *string, FxBool fatal);
GREXPORT FX_ENTRY void FX_CALL grErrorSetCallback (GrErrorCallbackFnc_t fnc);

GREXPORT FX_ENTRY void FX_CALL grSstIdle (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstVideoLine (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstVRetraceOn (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstIsBusy (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstWinOpen (
   FxU32 hWnd,
   GrScreenResolution_t screen_resolution,
   GrScreenRefresh_t refresh_rate,
   GrColorFormat_t color_format,
   GrOriginLocation_t origin_location,
   int nColBuffers,
   int nAuxBuffers);
GREXPORT FX_ENTRY void FX_CALL grSstWinClose (void);
GREXPORT FX_ENTRY FxBool FX_CALL grSstControl (FxU32 code);
GREXPORT FX_ENTRY FxBool FX_CALL grSstQueryHardware (GrHwConfiguration * hwconfig);
GREXPORT FX_ENTRY FxBool FX_CALL grSstQueryBoards (GrHwConfiguration * hwconfig);
GREXPORT FX_ENTRY void FX_CALL grSstOrigin (GrOriginLocation_t origin);
GREXPORT FX_ENTRY void FX_CALL grSstSelect (int which_sst);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstScreenHeight (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstScreenWidth (void);
GREXPORT FX_ENTRY FxU32 FX_CALL grSstStatus (void);

GREXPORT FX_ENTRY void FX_CALL grSstPerfStats (GrSstPerfStats_t * pStats);
GREXPORT FX_ENTRY void FX_CALL grSstResetPerfStats (void);
GREXPORT FX_ENTRY void FX_CALL grResetTriStats ();
GREXPORT FX_ENTRY void FX_CALL grTriStats (FxU32 * trisProcessed, FxU32
   * trisDrawn);

GREXPORT FX_ENTRY void FX_CALL grAlphaBlendFunction (GrAlphaBlendFnc_t
   rgb_sf, GrAlphaBlendFnc_t rgb_df, GrAlphaBlendFnc_t alpha_sf,
   GrAlphaBlendFnc_t alpha_df);
GREXPORT FX_ENTRY void FX_CALL grAlphaCombine (GrCombineFunction_t
   function, GrCombineFactor_t factor, GrCombineLocal_t local,
   GrCombineOther_t other, FxBool invert);
GREXPORT FX_ENTRY void FX_CALL grAlphaControlsITRGBLighting (FxBool enable);
GREXPORT FX_ENTRY void FX_CALL grAlphaTestFunction (GrCmpFnc_t function);
GREXPORT FX_ENTRY void FX_CALL grAlphaTestReferenceValue (GrAlpha_t value);
GREXPORT FX_ENTRY void FX_CALL grChromakeyMode (GrChromakeyMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grChromakeyValue (GrColor_t value);
GREXPORT FX_ENTRY void FX_CALL grClipWindow (FxU32 minx, FxU32 miny, FxU32
   maxx, FxU32 maxy);
GREXPORT FX_ENTRY void FX_CALL grColorCombine (GrCombineFunction_t
   function, GrCombineFactor_t factor, GrCombineLocal_t local,
   GrCombineOther_t other, FxBool invert);
GREXPORT FX_ENTRY void FX_CALL grColorMask (FxBool rgb, FxBool a);
GREXPORT FX_ENTRY void FX_CALL grCullMode (GrCullMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grConstantColorValue (GrColor_t value);
GREXPORT FX_ENTRY void FX_CALL grConstantColorValue4 (float a, float r, float
   g, float b);
GREXPORT FX_ENTRY void FX_CALL grDepthBiasLevel (FxI16 level);
GREXPORT FX_ENTRY void FX_CALL grDepthBufferFunction (GrCmpFnc_t function);
GREXPORT FX_ENTRY void FX_CALL grDepthBufferMode (GrDepthBufferMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grDepthMask (FxBool mask);
GREXPORT FX_ENTRY void FX_CALL grDisableAllEffects (void);
GREXPORT FX_ENTRY void FX_CALL grDitherMode (GrDitherMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grFogColorValue (GrColor_t fogcolor);
GREXPORT FX_ENTRY void FX_CALL grFogMode (GrFogMode_t mode);
GREXPORT FX_ENTRY void FX_CALL grFogTable (const GrFog_t ft[GR_FOG_TABLE_SIZE]);
GREXPORT FX_ENTRY void FX_CALL grGammaCorrectionValue (float value);
GREXPORT FX_ENTRY void FX_CALL grSplash (float x, float y, float width, float
   height, FxU32 frame);

GREXPORT FX_ENTRY FxU32 FX_CALL
  grTexCalcMemRequired (
   GrLOD_t lodmin, GrLOD_t lodmax,
   GrAspectRatio_t aspect, GrTextureFormat_t fmt);
GREXPORT FX_ENTRY FxU32 FX_CALL
  grTexTextureMemRequired (FxU32 evenOdd,
   GrTexInfo * info);
GREXPORT FX_ENTRY FxU32 FX_CALL grTexMinAddress (GrChipID_t tmu);
GREXPORT FX_ENTRY FxU32 FX_CALL grTexMaxAddress (GrChipID_t tmu);
GREXPORT FX_ENTRY void FX_CALL grTexNCCTable (GrChipID_t tmu,
   GrNCCTable_t table);
GREXPORT FX_ENTRY void FX_CALL grTexSource (GrChipID_t tmu, FxU32 startAddress,
   FxU32 evenOdd, GrTexInfo * info);
GREXPORT FX_ENTRY void FX_CALL grTexClampMode (GrChipID_t tmu,
   GrTextureClampMode_t s_clampmode, GrTextureClampMode_t t_clampmode);
GREXPORT FX_ENTRY void FX_CALL grTexCombine (GrChipID_t tmu,
   GrCombineFunction_t rgb_function, GrCombineFactor_t rgb_factor,
   GrCombineFunction_t alpha_function, GrCombineFactor_t alpha_factor,
   FxBool rgb_invert, FxBool alpha_invert);
GREXPORT FX_ENTRY void FX_CALL grTexCombineFunction (GrChipID_t tmu,
   GrTextureCombineFnc_t fnc);
GREXPORT FX_ENTRY void FX_CALL grTexDetailControl (GrChipID_t tmu, int lod_bias,
   FxU8 detail_scale,
   float detail_max
);
GREXPORT FX_ENTRY void FX_CALL grTexFilterMode (GrChipID_t tmu,
   GrTextureFilterMode_t minfilter_mode, GrTextureFilterMode_t magfilter_mode);
GREXPORT FX_ENTRY void FX_CALL grTexLodBiasValue (GrChipID_t tmu, float bias);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMap (GrChipID_t tmu,
   FxU32 startAddress, FxU32 evenOdd, GrTexInfo * info);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMapLevel (GrChipID_t tmu,
   FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
   GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32
   evenOdd, void *data);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadMipMapLevelPartial
   (GrChipID_t tmu, FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
   GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32
   evenOdd, void *data,
   int start,
   int end);
GREXPORT FX_ENTRY void FX_CALL ConvertAndDownloadRle (GrChipID_t tmu,
   FxU32 startAddress, GrLOD_t thisLod, GrLOD_t largeLod,
   GrAspectRatio_t aspectRatio, GrTextureFormat_t format, FxU32 evenOdd,
   FxU8 * bm_data, long bm_h,
   FxU32 u0,
   FxU32 v0,
   FxU32 width,
   FxU32 height,
   FxU32 dest_width,
   FxU32 dest_height,
   FxU16 * tlut);
GREXPORT FX_ENTRY void FX_CALL grCheckForRoom (FxI32 n);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadTable (GrChipID_t tmu,
   GrTexTable_t type, void *data);
GREXPORT FX_ENTRY void FX_CALL grTexDownloadTablePartial (GrChipID_t tmu,
   GrTexTable_t type, void *data,
   int start,
   int end);
GREXPORT FX_ENTRY void FX_CALL grTexMipMapMode (GrChipID_t tmu,
   GrMipMapMode_t mode, FxBool lodBlend);
GREXPORT FX_ENTRY void FX_CALL grTexMultibase (GrChipID_t tmu, FxBool enable);
GREXPORT FX_ENTRY void FX_CALL grTexMultibaseAddress (GrChipID_t tmu,
   GrTexBaseRange_t range, FxU32 startAddress, FxU32 evenOdd, GrTexInfo
   * info);

GREXPORT FX_ENTRY GrMipMapId_t FX_CALL guTexAllocateMemory (GrChipID_t tmu,
   FxU8 odd_even_mask, int width, int height,
   GrTextureFormat_t fmt,
   GrMipMapMode_t mm_mode,
   GrLOD_t smallest_lod, GrLOD_t largest_lod,
   GrAspectRatio_t aspect,
   GrTextureClampMode_t s_clamp_mode,
   GrTextureClampMode_t t_clamp_mode,
   GrTextureFilterMode_t minfilter_mode,
   GrTextureFilterMode_t magfilter_mode,
   float lod_bias,
   FxBool trilinear
);

GREXPORT FX_ENTRY FxBool FX_CALL
  guTexChangeAttributes (
   GrMipMapId_t mmid,
   int width, int height,
   GrTextureFormat_t fmt,
   GrMipMapMode_t mm_mode,
   GrLOD_t smallest_lod, GrLOD_t largest_lod,
   GrAspectRatio_t aspect,
   GrTextureClampMode_t s_clamp_mode,
   GrTextureClampMode_t t_clamp_mode,
   GrTextureFilterMode_t minFilterMode,
   GrTextureFilterMode_t magFilterMode
);

GREXPORT FX_ENTRY void FX_CALL guTexCombineFunction (GrChipID_t tmu,
   GrTextureCombineFnc_t fnc);
GREXPORT FX_ENTRY GrMipMapId_t FX_CALL guTexGetCurrentMipMap (GrChipID_t tmu);
GREXPORT FX_ENTRY GrMipMapInfo *FX_CALL guTexGetMipMapInfo (GrMipMapId_t mmid);
GREXPORT FX_ENTRY FxU32 FX_CALL guTexMemQueryAvail (GrChipID_t tmu);
GREXPORT FX_ENTRY void FX_CALL guTexMemReset (void);
GREXPORT FX_ENTRY void FX_CALL guTexDownloadMipMap (GrMipMapId_t mmid, const void *src,
   const GuNccTable * table
);
GREXPORT FX_ENTRY void FX_CALL guTexDownloadMipMapLevel (GrMipMapId_t mmid,
   GrLOD_t lod, const void **src
);
GREXPORT FX_ENTRY void FX_CALL guTexSource (GrMipMapId_t id);

GREXPORT FX_ENTRY FxBool FX_CALL grLfbLock (GrLock_t type, GrBuffer_t
   buffer, GrLfbWriteMode_t writeMode, GrOriginLocation_t origin,
   FxBool pixelPipeline, GrLfbInfo_t * info);
GREXPORT FX_ENTRY FxBool FX_CALL grLfbUnlock (GrLock_t type, GrBuffer_t buffer);
GREXPORT FX_ENTRY void FX_CALL grLfbConstantAlpha (GrAlpha_t alpha);
GREXPORT FX_ENTRY void FX_CALL grLfbConstantDepth (FxU16 depth);
GREXPORT FX_ENTRY void FX_CALL grLfbWriteColorSwizzle (FxBool swizzleBytes,
   FxBool swapWords);
GREXPORT FX_ENTRY void FX_CALL grLfbWriteColorFormat (GrColorFormat_t colorFormat);
GREXPORT FX_ENTRY FxBool FX_CALL grLfbWriteRegion (GrBuffer_t dst_buffer,
   FxU32 dst_x, FxU32 dst_y, GrLfbSrcFmt_t src_format, FxU32 src_width,
   FxU32 src_height, FxI32 src_stride, void *src_data);
GREXPORT FX_ENTRY FxBool FX_CALL
  grLfbReadRegion (GrBuffer_t src_buffer,
   FxU32 src_x, FxU32 src_y,
   FxU32 src_width, FxU32 src_height,
   FxU32 dst_stride, void *dst_data);

GREXPORT FX_ENTRY void FX_CALL grAADrawLine (const GrVertex * v1, const
	GrVertex * v2);
GREXPORT FX_ENTRY void FX_CALL grAADrawPoint (const GrVertex * pt);
GREXPORT FX_ENTRY void FX_CALL grAADrawPolygon (const int nverts, const int
   ilist[], const GrVertex
   vlist[]);
GREXPORT FX_ENTRY void FX_CALL grAADrawPolygonVertexList (const int
   nverts, const
   GrVertex vlist[]);
GREXPORT FX_ENTRY void FX_CALL grAADrawTriangle (const GrVertex * a, const
   GrVertex * b, const
   GrVertex * c,
   FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
);

GREXPORT FX_ENTRY void FX_CALL grGlideInit (void);
GREXPORT FX_ENTRY void FX_CALL grGlideShutdown (void);
GREXPORT FX_ENTRY void FX_CALL grGlideGetVersion (char version[80]);
GREXPORT FX_ENTRY void FX_CALL grGlideGetState (GrState * state);
GREXPORT FX_ENTRY void FX_CALL grGlideSetState (const GrState * state);
GREXPORT FX_ENTRY void FX_CALL grGlideShamelessPlug (const FxBool on);
GREXPORT FX_ENTRY void FX_CALL grHints (GrHint_t hintType, FxU32 hintMask);

GREXPORT FX_ENTRY void FX_CALL guAADrawTriangleWithClip (const GrVertex
   * a, const GrVertex
   * b, const GrVertex * c);
GREXPORT FX_ENTRY void FX_CALL guDrawTriangleWithClip (const GrVertex * a,
   const GrVertex * b,
   const GrVertex * c
);
GREXPORT FX_ENTRY void FX_CALL guDrawPolygonVertexListWithClip (int
   nverts, const
   GrVertex
   vlist[]);
GREXPORT FX_ENTRY void FX_CALL guAlphaSource (GrAlphaSource_t mode);
GREXPORT FX_ENTRY void FX_CALL guColorCombineFunction
   (GrColorCombineFnc_t fnc);
GREXPORT FX_ENTRY int FX_CALL guEncodeRLE16 (void *dst,
   void *src,
   FxU32 width,
   FxU32 height);
GREXPORT FX_ENTRY FxU16 *FX_CALL guTexCreateColorMipMap (void);

GREXPORT FX_ENTRY float FX_CALL guFogTableIndexToW (int i);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateExp (GrFog_t
   fogtable[GR_FOG_TABLE_SIZE], float density);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateExp2 (GrFog_t
   fogtable[GR_FOG_TABLE_SIZE], float density);
GREXPORT FX_ENTRY void FX_CALL guFogGenerateLinear (GrFog_t
   fogtable[GR_FOG_TABLE_SIZE], float
   nearZ, float farZ);

GREXPORT FX_ENTRY FxU32 FX_CALL guEndianSwapWords (FxU32 value);
GREXPORT FX_ENTRY FxU16 FX_CALL guEndianSwapBytes (FxU16 value);

GREXPORT FX_ENTRY FxBool FX_CALL gu3dfGetInfo (const char *filename,
   Gu3dfInfo * info);
GREXPORT FX_ENTRY FxBool FX_CALL gu3dfLoad (const char *filename,
   Gu3dfInfo * data);


// Sub functions
inline DWORD grsubConvColor (GrColor_t color)
{ // Convert color format to ARGB
   switch (g_gr_state.color_format)
   {
   case GR_COLORFORMAT_RGBA:
       return (DWORD) (
       ((((DWORD) color) >> 8) & 0x00ffffff) |
       ((((DWORD) color) << 24) & 0xff000000));
       case GR_COLORFORMAT_ARGB:
       return (DWORD) color;
       case GR_COLORFORMAT_BGRA:
		return (DWORD) (
       ((((DWORD) color) << 8) & 0x00ff0000) |
       ((((DWORD) color) >> 8) & 0x0000ff00) |
       ((((DWORD) color) >> 24) & 0x000000ff) |
       ((((DWORD) color) << 24) & 0xff000000));
       case GR_COLORFORMAT_ABGR:
       return (DWORD) (
       ((((DWORD) color) << 16) & 0x00ff0000) |
       ((((DWORD) color)) & 0xff00ff00) |
       ((((DWORD) color) >> 16) & 0x000000ff));
   }
   return 0xffffffff;
}

inline COLORREF grsubConvColorRef (GrColor_t color)
{ // Convert color format to COLORREF (BGR)
   switch (g_gr_state.color_format)
   {
	case GR_COLORFORMAT_RGBA:
       return (COLORREF) (
       ((((DWORD) color) >> 24) & 0x000000ff) |
       ((((DWORD) color) >> 8) & 0x0000ff00) |
       ((((DWORD) color) << 8) & 0x00ff0000));
   case GR_COLORFORMAT_ARGB:
       return (COLORREF) (
       ((((DWORD) color) >> 16) & 0x000000ff) |
       ((((DWORD) color) << 16) & 0x00ff0000) |
       ((((DWORD) color)) & 0x0000ff00));
   case GR_COLORFORMAT_BGRA:
       return (COLORREF) ((((DWORD) color) >> 8) & 0x00ffffff);
   case GR_COLORFORMAT_ABGR:
       return (COLORREF) color & 0x00ffffff;
   }
   return 0xffffffff;
}

//VOID grsubPreRender ();
//VOID grsubPostRender ();
inline INT grsubGetTmuIndex (GrChipID_t tmu)
{
   return GLID3D_TMU0;;
}
//BOOL grsubCreateSurface(LPDIRECTDRAWSURFACE4* ppddsDevice, LPDIRECTDRAWSURFACE4* ppddsMemory, LPINT pnTexFormat, GrTexInfo* info);
BOOL gusub3dfGetInfo (LPCSTR filename, Gu3dfInfo * info, LPDWORD pdwDataOffset);

//VOID grsubGetSurfacePixelFormat(LPGLID3D_PIXELFORMAT ppixel, LPDIRECTDRAWSURFACE4 pddsurface);

inline INT grsubLodToInt (GrLOD_t lod)
{
   switch (lod)
   {
   case GR_LOD_1:
       return 1;
   case GR_LOD_2:
		return 2;
   case GR_LOD_4:
       return 4;
   case GR_LOD_8:
       return 8;
   case GR_LOD_16:
       return 16;
   case GR_LOD_32:
       return 32;
   case GR_LOD_64:
       return 64;
   case GR_LOD_128:
       return 128;
   case GR_LOD_256:
       return 256;
   }
   return 0;
}

inline GrLOD_t grsubIntToLod (INT nLod)
{
   switch (nLod)
   {
   case 1:
       return GR_LOD_1;
   case 2:
       return GR_LOD_2;
   case 4:
       return GR_LOD_4;
   case 8:
       return GR_LOD_8;
   case 16:
       return GR_LOD_16;
   case 32:
       return GR_LOD_32;
   case 64:
		return GR_LOD_64;
   case 128:
       return GR_LOD_128;
   case 256:
       return GR_LOD_256;
   }
   return 0;
}

inline VOID grsubAspectToInt (INT & pnAspectW, INT & pnAspectH,
   GrAspectRatio_t aspect_ratio)
{
   switch (aspect_ratio)
   {
   case GR_ASPECT_8x1:
       pnAspectW = 8;
       pnAspectH = 1;
       return;
	case GR_ASPECT_4x1:
       pnAspectW = 4;
       pnAspectH = 1;
       return;
   case GR_ASPECT_2x1:
       pnAspectW = 2;
       pnAspectH = 1;
       return;
   case GR_ASPECT_1x1:
       pnAspectW = 1;
       pnAspectH = 1;
       return;
   case GR_ASPECT_1x2:
       pnAspectW = 1;
       pnAspectH = 2;
       return;
   case GR_ASPECT_1x4:
       pnAspectW = 1;
		pnAspectH = 4;
       return;
   case GR_ASPECT_1x8:
       pnAspectW = 1;
       pnAspectH = 8;
       return;
   default:
       pnAspectW = 1;
       pnAspectH = 1;
       break;
   }
}

inline VOID grsubIntToAspect (GrAspectRatio_t & paspect_ratio, INT nAspectW,
   INT nAspectH)
{
   if (nAspectW == 1)
   {
		if (nAspectH == 1)
          paspect_ratio = GR_ASPECT_1x1;
       else if (nAspectH == 2)
            paspect_ratio = GR_ASPECT_1x2;
       else if (nAspectH == 4)
            paspect_ratio = GR_ASPECT_1x4;
       else if (nAspectH == 8)
            paspect_ratio = GR_ASPECT_1x8;
   }
   else
   {
       if (nAspectW == 2)
          paspect_ratio = GR_ASPECT_2x1;
       else if (nAspectW == 4)
            paspect_ratio = GR_ASPECT_4x1;
       else if (nAspectW == 8)
            paspect_ratio = GR_ASPECT_8x1;
   }
}

inline void EnableBlend(void)
{
   if (!g_gr_BlendOn)
   {
       glEnable(GL_BLEND);
       g_gr_BlendOn = TRUE;
   }
}

inline void DisableBlend(void)
{
   if (g_gr_BlendOn)
   {
      glDisable(GL_BLEND);
      g_gr_BlendOn = FALSE;
   }
}

inline void EnableAlphaTest(void)
{
   if (!g_gr_AlphaTestOn)
   {
       glEnable(GL_ALPHA_TEST);
       g_gr_AlphaTestOn = TRUE;
   }
}

inline void DisableAlphaTest(void)
{
   if (g_gr_AlphaTestOn)
   {
      glDisable(GL_ALPHA_TEST);
      g_gr_AlphaTestOn = FALSE;
   }
}

inline void EnableTexture2D(void)
{
   if (!g_gr_Texture2DOn)
   {
       glEnable(GL_TEXTURE_2D);
       g_gr_Texture2DOn = TRUE;
   }
}

inline void DisableTexture2D(void)
{
   if (g_gr_Texture2DOn)
   {
      glDisable(GL_TEXTURE_2D);
	   g_gr_Texture2DOn = FALSE;
   }
}

inline void AlphaFix(void)
{
    // Ugly way to fix the problem with the horses joints in Zelda 64
    if (g_gr_bAlphaFix)
    {
       if (g_gr_state.alpha_combine_other != GR_COMBINE_OTHER_TEXTURE &&
           g_gr_AlphaTestOn)
           DisableAlphaTest();
       else if (g_gr_AlphaTestOn)
           EnableAlphaTest();
    }
}


#ifdef CACHETRIANGLES

extern BOOL g_gr_DrawingTriangles;

#ifdef USEVERTEXARRAY
#define MAXVERTEX 300
extern GLsizei ArrayCount;
extern GL2IDE_TEXCORD TexCoordArray[MAXVERTEX];
extern GL2IDE_COLOR ColorArray[MAXVERTEX];
extern CORD CoordArray[MAXVERTEX];

inline void FlushTriangleVertex(void)
{
	if (g_gr_DrawingTriangles)
   {
   	g_gr_DrawingTriangles = FALSE;
       glTexCoordPointer (2, GL_FLOAT, 0, TexCoordArray);
       glVertexPointer( 4, GL_FLOAT, 0, CoordArray);
       glColorPointer( 4, GL_FLOAT, 0, ColorArray);
       glDrawArrays( GL_TRIANGLES, 0, ArrayCount);
   }
}

inline void AddTriangleVertex(const VERTEX2 *ptlv)
{
	if (!g_gr_DrawingTriangles)
   {
   	ArrayCount=0;
       g_gr_DrawingTriangles = TRUE;
   }
   TexCoordArray[ArrayCount] = ptlv[0].tcord;
   ColorArray[ArrayCount] = ptlv[0].color;
   CoordArray[ArrayCount++] = ptlv[0].cord;

   TexCoordArray[ArrayCount] = ptlv[1].tcord;
   ColorArray[ArrayCount] = ptlv[1].color;
   CoordArray[ArrayCount++] = ptlv[1].cord;

   TexCoordArray[ArrayCount] = ptlv[2].tcord;
   ColorArray[ArrayCount] = ptlv[2].color;
   CoordArray[ArrayCount++] = ptlv[2].cord;
   if (ArrayCount==MAXVERTEX)
       FlushTriangleVertex();
}
#else
inline void AddTriangleVertex(const VERTEX2 *ptlv)
{
	if (!g_gr_DrawingTriangles)
   {
   	glBegin(GL_TRIANGLES);
       g_gr_DrawingTriangles = TRUE;
   }
#ifdef OPTIMIZE_TEXTURE2D
   if (!g_gr_Texture2DOn)
   {
       glColor4fv ((const GLfloat*)&ptlv[0].color);
       glVertex4fv ((const GLfloat*)&ptlv[0].cord);

       glColor4fv ((const GLfloat*)&ptlv[1].color);
       glVertex4fv ((const GLfloat*)&ptlv[1].cord);

       glColor4fv ((const GLfloat*)&ptlv[2].color);
       glVertex4fv ((const GLfloat*)&ptlv[2].cord);
   } else
#endif
   {
     glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
     glColor4fv ((const GLfloat*)&ptlv[0].color);
     glVertex4fv ((const GLfloat*)&ptlv[0].cord);

     glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
     glColor4fv ((const GLfloat*)&ptlv[1].color);
     glVertex4fv ((const GLfloat*)&ptlv[1].cord);

     glTexCoord2fv ((const GLfloat *)&ptlv[2].tcord);
     glColor4fv ((const GLfloat*)&ptlv[2].color);
     glVertex4fv ((const GLfloat*)&ptlv[2].cord);
   }
}

inline void FlushTriangleVertex(void)
{
	if (g_gr_DrawingTriangles)
   {
   	glEnd();
       g_gr_DrawingTriangles = FALSE;
   }
}
#endif
#else
#define FlushTriangleVertex()
#endif

inline void SetAlphaTestFunction(GrCmpFnc_t function)
{
    switch (function)
    {
      case GR_CMP_NEVER:
       	glAlphaFunc (GL_NEVER, DIV255(g_gr_state.alpha_test_reference_value));
           EnableAlphaTest();
       	break;
      case GR_CMP_LESS:
       glAlphaFunc (GL_LESS, DIV255(g_gr_state.alpha_test_reference_value - 1));
       EnableAlphaTest();
       break;
      case GR_CMP_EQUAL:
       glAlphaFunc (GL_EQUAL, DIV255(g_gr_state.alpha_test_reference_value));
       EnableAlphaTest();
       //ERROROUT ("AlphaTestFunction: EQUAL");
       break;
      case GR_CMP_LEQUAL:
       glAlphaFunc (GL_LEQUAL, DIV255(g_gr_state.alpha_test_reference_value - 1));
       EnableAlphaTest();
       break;
      case GR_CMP_GREATER:
       glAlphaFunc (GL_GREATER, DIV255(g_gr_state.alpha_test_reference_value + 1));
       EnableAlphaTest();
       break;
      case GR_CMP_NOTEQUAL:
         glAlphaFunc (GL_NOTEQUAL, DIV255(g_gr_state.alpha_test_reference_value));
     //ERROROUT ("AlphaTestFunction: NOTEQUAL");
         EnableAlphaTest();
         break;
      case GR_CMP_GEQUAL:
         glAlphaFunc (GL_GEQUAL, DIV255(g_gr_state.alpha_test_reference_value + 1));
         EnableAlphaTest();
         break;
      case GR_CMP_ALWAYS:
         DisableAlphaTest();
         break;
    }
}

//inline VOID grsubSetTLVertexFromGrVertex(LPD3DTLVERTEX ptlv, const GrVertex* pv);


BOOL GliD3DGetProfileString (LPCSTR pszSection, LPCSTR pszKey, LPCSTR
	pszDefault, LPSTR pszDest, LPCSTR pszProfileName);
INT GliD3DGetProfileInt (LPCSTR pszSection, LPCSTR pszKey, INT nDefault,
	LPCSTR pszProfileName);
BOOL GliD3DWriteProfileString (LPCSTR pszSection, LPCSTR pszKey, LPSTR
	pszSrc, LPCSTR pszProfileName);
BOOL GliD3DWriteProfileInt (LPCSTR pszSection, LPCSTR pszKey, INT nSrc,
	LPCSTR pszProfileName);
}
/////////////////////////////////////////////////////////////////////////////
#endif
/////////////////////////////////////////////////////////////////////////////
