/////////////////////////////////////////////////////////////////////////////
// GliD3D_Config_SpecialEffect.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables
static WORD idx[4096];
static const GLfloat f128 = 128.0;
static const GLfloat f255 = 255.0;
static const GLfloat f256 = 256.0;
static const GLfloat f4096 = 4096.0;
static const GLfloat f65535 = 65535.0;
static const GLfloat f65536 = 65536.0;

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

#define nTmu 0

GLenum g_gr_dfactor, g_gr_sfactor;

int grCheckTextureOn (GrCombineFunction_t function, GrCombineFactor_t factor,
    GrCombineOther_t other)
{
    if (other == GR_COMBINE_OTHER_TEXTURE)
    {
	//return 1;
		switch (function)
		{
		  case GR_COMBINE_FUNCTION_SCALE_OTHER:
		  case GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL:
		  case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL:
		  case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL:
		  case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL_ALPHA:
			  return 1;
		  default:
			  return 0;
		}
	 }
	 else
		return 0;
}

class ColorIteratedAlphaIterated
{
public:
    ColorIteratedAlphaIterated (GL2IDE_COLOR & color, const GrVertex * pv)
    {
		color.r = pv->r / f255;
		color.b = pv->b / f255;
		color.g = pv->g / f255;
		color.a = pv->a / f255;
	 }
};

class ColorIteratedAlphaConstant
{
public:                     
	 ColorIteratedAlphaConstant (GL2IDE_COLOR & color, const GrVertex * pv)
	 {
		color.r = pv->r / f255;
		color.b = pv->b / f255;
		color.g = pv->g / f255;
		//color.a = (g_gr_state.constant_color_value_alpha >> 24) / f255;
       color.a = g_gr_state.constant_color.a;
    }
};

class ColorConstantAlphaIterated
{
public:
	 ColorConstantAlphaIterated (GL2IDE_COLOR & color, const GrVertex * pv)
	 {
		/*color.r = ((g_gr_state.constant_color_value_color & 0xff0000) >> 16) / f255;
		color.g = ((g_gr_state.constant_color_value_color & 0x00ff00) >> 8) / f255;
		color.b = ((g_gr_state.constant_color_value_color & 0x0000ff) >> 0) / f255;*/
	    color.r = g_gr_state.constant_color.r;
       color.g = g_gr_state.constant_color.g;
       color.b = g_gr_state.constant_color.b;
		color.a = pv->a / f255;
	 }
};

class ColorConstantAlphaConstant
{
public:
	 ColorConstantAlphaConstant (GL2IDE_COLOR & color, const GrVertex * pv)
	 {
		color = g_gr_state.constant_color;
       /*color.r = ((g_gr_state.constant_color_value_color & 0xff0000) >> 16) / f255;
		color.g = ((g_gr_state.constant_color_value_color & 0x00ff00) >> 8) / f255;
		color.b = ((g_gr_state.constant_color_value_color & 0x0000ff) >> 0) / f255;
		color.a = (g_gr_state.constant_color_value_alpha >> 24) / f255;*/
	 }
};

class NoColor
{
public:
	NoColor(GL2IDE_COLOR& , const GrVertex *)
   {
   }
};

class OriginUpperLeft
{
public:
	 OriginUpperLeft (CORD & cord, const GrVertex * pv)
	 {
		if (pv->y < f4096)
			cord.y = pv->y;
		else
			cord.y = pv->y - (FLOAT) (((DWORD) pv->y) & 0xfffff000);
	 }
};

class OriginLowerLeft
{
public:
	 OriginLowerLeft (CORD & cord, const GrVertex * pv)
	 {
		if (pv->y < f4096)
			cord.y = (FLOAT) g_gr_nHeight - pv->y;
		else
			cord.y = (FLOAT) g_gr_nHeight - (FLOAT) (((DWORD) pv->y) & 0xfffff000);
	 }
};

class TextureDisabled
{
public:
	TextureDisabled(VERTEX2 &, const GrVertex *)
   {
   }
};

class TextureEnabled
{
public:
   TextureEnabled(VERTEX2 &ptlv, const GrVertex *pv)
   {
		ptlv.tcord.tu = pv->tmuvtx[0].sow * ptlv.cord.w * g_gr_tmu[nTmu].ah;
   	ptlv.tcord.tv = pv->tmuvtx[0].tow * ptlv.cord.w * g_gr_tmu[nTmu].aw;
   }
};

enum CombineFunc_t
{
	 C_ITERATED,
	 C_CONSTANT,
	 C_NONE
};

/* template functions not used due to a bug in BC++ */
#ifdef USEVERTEXARRAY
template < class OriginFunc, class CombineFunc, class TexturePos >
class VertexConvClass
{
public:
	  static VOID VertexConv (CORD &cord, GL2IDE_COLOR &color,
       GL2IDE_TEXCORD &texcord, const GrVertex * pv);
};

template < class OriginFunc, class CombineFunc, class TexturePos >
  VOID VertexConvClass < OriginFunc, CombineFunc, TexturePos >::VertexConv
    (CORD &cord, GL2IDE_COLOR &color,
       GL2IDE_TEXCORD &tcord, const GrVertex * pv)
{
	 OriginFunc (cord, pv);
	 if (pv->x < f4096)
		cord.x = pv->x;
	 else
		cord.x = pv->x - (FLOAT) (((DWORD) pv->x) & 0xfffff000);
	 cord.w = 1.0 / pv->oow;
    	 // scale texture coordinates according to aspect ratio
    tcord.tu = pv->tmuvtx[0].sow * cord.w * g_gr_tmu[nTmu].ah;
    tcord.tv = pv->tmuvtx[0].tow * cord.w * g_gr_tmu[nTmu].aw;

	 if (g_gr_bUseZInverse)
	 {
		if (g_gr_bPrecisionFix)
		{
			if (cord.w < 10)
			cord.w = 10;

		}
		cord.z = 1.0f;
	 }
	 else
	 {
		cord.z = -cord.w * cord.w;
	 }

	 cord.x *= cord.w;
	 cord.y *= cord.w;
	 CombineFunc (color, pv);

	 // set color to (1,1,1) if using texture scaled with factor 1
	 // and (0,0,0) if using texture scaled with factor 0
    if ((g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER ||
        g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL)
        && g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
    {
       if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ONE)
       {
          color.r = 1;
          color.g = 1;
          color.b = 1;
       }
       else if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ZERO)
       {
          color.r = 0;
          color.g = 0;
          color.b = 0;
       }
    }
    if (g_gr_state.alpha_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER &&
        g_gr_state.alpha_combine_other == GR_COMBINE_OTHER_TEXTURE)
    {
       if (g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ONE)
           color.a = 1;
       else if (g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ZERO)
           color.a = 0;
    }
}
#else
template < class OriginFunc, class CombineFunc, class TexturePos >
class VertexConvClass
{
public:
	  static VOID VertexConv (VERTEX2 & ptlv, const GrVertex * pv);
};

template < class OriginFunc, class CombineFunc, class TexturePos >
  VOID VertexConvClass < OriginFunc, CombineFunc, TexturePos >::VertexConv (VERTEX2 &
	 ptlv, const GrVertex * pv)
{
	 OriginFunc (ptlv.cord, pv);
	 if (pv->x < f4096)
		ptlv.cord.x = pv->x;
	 else
		ptlv.cord.x = pv->x - (FLOAT) (((DWORD) pv->x) & 0xfffff000);
	 ptlv.cord.w = 1.0 / pv->oow;
    	 // scale texture coordinates according to aspect ratio
    TexturePos(ptlv, pv);
	 if (g_gr_bUseZInverse)
	 {
		if (g_gr_bPrecisionFix)
		{
			if (ptlv.cord.w < 10)
			ptlv.cord.w = 10;

		}
		ptlv.cord.z = 1.0f;
	 }
	 else
	 {
		ptlv.cord.z = -ptlv.cord.w * ptlv.cord.w;
       //ptlv.cord.z = pv->ooz / 65536.0f;
	 }

	 ptlv.cord.x *= ptlv.cord.w;
	 ptlv.cord.y *= ptlv.cord.w;

    CombineFunc (ptlv.color, pv);
    
    if (g_gr_Texture2DOn)
    {
      // set color to (1,1,1) if using texture scaled with factor 1
      // and (0,0,0) if using texture scaled with factor 0
      if ((g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER ||
          g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL)
          && g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
      {
         if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ONE)
         {
            ptlv.color.r = 1;
            ptlv.color.g = 1;
            ptlv.color.b = 1;
         }
         else if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ZERO)
         {
            ptlv.color.r = 0;
            ptlv.color.g = 0;
            ptlv.color.b = 0;
         }
      }
      if (g_gr_state.alpha_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER &&
          g_gr_state.alpha_combine_other == GR_COMBINE_OTHER_TEXTURE)
      {
         if (g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ONE)
             ptlv.color.a = 1;
         else if (g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ZERO)
             ptlv.color.a = 0;
      }
	}

	 //ptlv.tu = ((pv->tmuvtx[0].sow / pv->oow) + 0.2f) / 256.0;
	 //ptlv.tv = ((pv->tmuvtx[0].tow / pv->oow) + 0.2f) / 256.0;



/*      nTmu = grsubGetTmuIndex(tmu);


	 int ah, aw;

	 grsubAspectToInt (aw, ah, g_gr_tmu[nTmu].texture_source_info.aspectRatio);
	 ptlv.tcord.tu *= ah;
	 ptlv.tcord.tv *= aw;*/
}
#endif

static vertexconv_func lookup_vfunc[2][3][3][2];
vertexconv_func grsubSetVertexFromGrVertex;

void InitLookupVertexFuncs (void)
{
    lookup_vfunc[false][C_ITERATED][C_ITERATED][TRUE] =
   	VertexConvClass < OriginLowerLeft, ColorIteratedAlphaIterated, TextureEnabled >::VertexConv;
	 lookup_vfunc[false][C_ITERATED][C_CONSTANT][TRUE] =
	    VertexConvClass < OriginLowerLeft, ColorIteratedAlphaConstant, TextureEnabled >::VertexConv;
    lookup_vfunc[false][C_CONSTANT][C_ITERATED][TRUE] =
    	VertexConvClass < OriginLowerLeft, ColorConstantAlphaIterated, TextureEnabled >::VertexConv;
    lookup_vfunc[false][C_CONSTANT][C_CONSTANT][TRUE] =
	    VertexConvClass < OriginLowerLeft, ColorConstantAlphaConstant, TextureEnabled >::VertexConv;

    lookup_vfunc[true][C_ITERATED][C_ITERATED][TRUE] =
   	VertexConvClass < OriginUpperLeft, ColorIteratedAlphaIterated, TextureEnabled >::VertexConv;
    lookup_vfunc[true][C_ITERATED][C_CONSTANT][TRUE] =
	    VertexConvClass < OriginUpperLeft, ColorIteratedAlphaConstant, TextureEnabled >::VertexConv;
    lookup_vfunc[true][C_CONSTANT][C_ITERATED][TRUE] =
   	VertexConvClass < OriginUpperLeft, ColorConstantAlphaIterated, TextureEnabled >::VertexConv;
    lookup_vfunc[true][C_CONSTANT][C_CONSTANT][TRUE] =
   	VertexConvClass < OriginUpperLeft, ColorConstantAlphaConstant, TextureEnabled >::VertexConv;

    lookup_vfunc[false][C_ITERATED][C_ITERATED][FALSE] =
   	VertexConvClass < OriginLowerLeft, ColorIteratedAlphaIterated, TextureDisabled >::VertexConv;
	 lookup_vfunc[false][C_ITERATED][C_CONSTANT][FALSE] =
	    VertexConvClass < OriginLowerLeft, ColorIteratedAlphaConstant, TextureDisabled >::VertexConv;
    lookup_vfunc[false][C_CONSTANT][C_ITERATED][FALSE] =
    	VertexConvClass < OriginLowerLeft, ColorConstantAlphaIterated, TextureDisabled >::VertexConv;
    lookup_vfunc[false][C_CONSTANT][C_CONSTANT][FALSE] =
	    VertexConvClass < OriginLowerLeft, ColorConstantAlphaConstant, TextureDisabled >::VertexConv;

    lookup_vfunc[true][C_ITERATED][C_ITERATED][FALSE] =
   	VertexConvClass < OriginUpperLeft, ColorIteratedAlphaIterated, TextureDisabled >::VertexConv;
    lookup_vfunc[true][C_ITERATED][C_CONSTANT][FALSE] =
	    VertexConvClass < OriginUpperLeft, ColorIteratedAlphaConstant, TextureDisabled >::VertexConv;
    lookup_vfunc[true][C_CONSTANT][C_ITERATED][FALSE] =
   	VertexConvClass < OriginUpperLeft, ColorConstantAlphaIterated, TextureDisabled >::VertexConv;
    lookup_vfunc[true][C_CONSTANT][C_CONSTANT][FALSE] =
   	VertexConvClass < OriginUpperLeft, ColorConstantAlphaConstant, TextureDisabled >::VertexConv;

}

void ChooseVertexFunc (void)
{
    CombineFunc_t cfunc, alphafunc;

    switch (g_gr_state.color_combine_local)
    {
		 case GR_COMBINE_LOCAL_ITERATED:
			cfunc = C_ITERATED;
			break;
		 case GR_COMBINE_LOCAL_CONSTANT:
			if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_TEXTURE_RGB &&
				g_gr_state.color_combine_other == GR_COMBINE_OTHER_ITERATED)
				//&& g_gr_state.color_combine_function==GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL)
				cfunc = C_ITERATED;
			else
				cfunc = C_CONSTANT;
			break;
		 default:
			cfunc = C_NONE;
		break;
	 }
	 switch (g_gr_state.alpha_combine_local)
	 {
		 case GR_COMBINE_LOCAL_ITERATED:
			alphafunc = C_ITERATED;
			break;
		 case GR_COMBINE_LOCAL_CONSTANT:
			alphafunc = C_CONSTANT;
			break;
	 }

	 bool oul = (g_gr_state.origin_location == GR_ORIGIN_UPPER_LEFT);
	 grsubSetVertexFromGrVertex = lookup_vfunc[oul][cfunc][alphafunc][g_gr_Texture2DOn];
}

void grMegaCombineEverythingSetup (bool flag)
{
    FlushTriangleVertex();
    switch (g_gr_state.color_combine_function)
    {
    case GR_COMBINE_FUNCTION_LOCAL:
    case GR_COMBINE_FUNCTION_ZERO:
    case GR_COMBINE_FUNCTION_LOCAL_ALPHA:
       DisableTexture2D();
    break;
    case GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL:
    case GR_COMBINE_FUNCTION_SCALE_OTHER:
       if (g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
           EnableTexture2D();
       else
           DisableTexture2D();
       switch (g_gr_state.color_combine_factor)
       {
         case GR_COMBINE_FACTOR_NONE:
             DisableTexture2D();
             break;
         case GR_COMBINE_FACTOR_ONE:
         case GR_COMBINE_FACTOR_LOCAL:
             break;
         case GR_COMBINE_FACTOR_LOCAL_ALPHA:
             break;
         default:
             DisableTexture2D();
             break;
       }
       break;

    case GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL_ALPHA:
       if (g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
           EnableTexture2D();
       else
           DisableTexture2D();
       break;

    case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL:
    case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL:
    case GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL_ALPHA:
    case GR_COMBINE_FUNCTION_SCALE_MINUS_LOCAL_ADD_LOCAL:
       if (g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
           EnableTexture2D();
       else
           DisableTexture2D();
       break;
    case GR_COMBINE_FUNCTION_SCALE_MINUS_LOCAL_ADD_LOCAL_ALPHA:
       DisableTexture2D();
       break;
    }
    if (flag)
     grAlphaBlendFunction (g_gr_state.alpha_blend_function_rgb_sf,
         g_gr_state.alpha_blend_function_rgb_df,
         g_gr_state.alpha_blend_function_alpha_sf,
         g_gr_state.alpha_blend_function_alpha_df);
    ChooseVertexFunc ();
}

static GLenum src_blendmap[16], dst_blendmap[16];


GLfloat div255_lookuptable[256];

void InitDiv255LookupTable(void)
{
	for (int i=0; i<256; i++)
		div255_lookuptable[i]=i/255.0;
}

void InitBlendMap(void)
{
  src_blendmap[GR_BLEND_ZERO] = GL_ZERO;
  src_blendmap[GR_BLEND_ONE] = GL_ONE;
  src_blendmap[GR_BLEND_PREFOG_COLOR] = GL_DST_COLOR;	// ???
  src_blendmap[GR_BLEND_DST_COLOR] = GL_DST_COLOR;
  src_blendmap[GR_BLEND_ONE_MINUS_DST_COLOR] = GL_ONE_MINUS_DST_COLOR;
  src_blendmap[GR_BLEND_SRC_ALPHA] = GL_SRC_ALPHA;
  src_blendmap[GR_BLEND_ONE_MINUS_SRC_ALPHA] = GL_ONE_MINUS_SRC_ALPHA;
  src_blendmap[GR_BLEND_DST_ALPHA] = GL_DST_ALPHA;
  src_blendmap[GR_BLEND_ONE_MINUS_DST_ALPHA] = GL_ONE_MINUS_DST_ALPHA;

  dst_blendmap[GR_BLEND_ZERO] = GL_ZERO;
  dst_blendmap[GR_BLEND_ONE] = GL_ONE;
  dst_blendmap[GR_BLEND_PREFOG_COLOR] = GL_DST_COLOR;	// ???
  dst_blendmap[GR_BLEND_DST_COLOR] = GL_DST_COLOR;
  dst_blendmap[GR_BLEND_ONE_MINUS_DST_COLOR] = GL_ONE_MINUS_DST_COLOR;
  dst_blendmap[GR_BLEND_SRC_ALPHA] = GL_SRC_ALPHA;
  dst_blendmap[GR_BLEND_ONE_MINUS_SRC_ALPHA] = GL_ONE_MINUS_SRC_ALPHA;
  dst_blendmap[GR_BLEND_DST_ALPHA] = GL_DST_ALPHA;
  dst_blendmap[GR_BLEND_ONE_MINUS_DST_ALPHA] = GL_ONE_MINUS_DST_ALPHA;
}

FX_ENTRY void FX_CALL grAlphaBlendFunction (GrAlphaBlendFnc_t rgb_sf,
    GrAlphaBlendFnc_t rgb_df, GrAlphaBlendFnc_t alpha_sf, GrAlphaBlendFnc_t alpha_df)
{
	 GLenum dfactor, sfactor;

    TRACEFUNCTION ("grAlphaBlendFunction");

    FlushTriangleVertex();
    g_gr_state.alpha_blend_function_rgb_sf = rgb_sf;
    g_gr_state.alpha_blend_function_rgb_df = rgb_df;
    g_gr_state.alpha_blend_function_alpha_sf = alpha_sf;
    g_gr_state.alpha_blend_function_alpha_df = alpha_df;

	 //AlphaFix();

    if ((rgb_sf == GR_BLEND_ONE) && (rgb_df == GR_BLEND_ZERO))
       DisableBlend();
    else
    {
       if (g_gr_state.alpha_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER &&
           g_gr_state.alpha_combine_other == GR_COMBINE_OTHER_TEXTURE)
       {
             EnableTexture2D();
             ChooseVertexFunc();
       }
       EnableBlend();
       sfactor=src_blendmap[rgb_sf];
       dfactor=dst_blendmap[rgb_df];
       if (g_gr_sfactor==sfactor && g_gr_dfactor==dfactor)
       	return;

       glBlendFunc (sfactor, dfactor);
       g_gr_sfactor = sfactor;
       g_gr_dfactor = dfactor;
    }
}

FX_ENTRY void FX_CALL grAlphaCombine (GrCombineFunction_t function,
    GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
    FxBool invert)
{
    TRACEFUNCTION ("grAlphaCombine");

    g_gr_state.alpha_combine_function = function;
    g_gr_state.alpha_combine_factor = factor;
    g_gr_state.alpha_combine_local = local;
    g_gr_state.alpha_combine_other = other;

    grMegaCombineEverythingSetup (true);
}

FX_ENTRY void FX_CALL grAlphaControlsITRGBLighting (FxBool enable)
{
    TRACEFUNCTION ("grAlphaControlsITRGBLighting");
	 ERROROUT ("grAlphaControlsITRGBLighting");
}

FX_ENTRY void FX_CALL grAlphaTestFunction (GrCmpFnc_t function)
{
    TRACEFUNCTION ("grAlphaTestFunction");
    FlushTriangleVertex();
	 if (g_gr_state.alpha_test_function == function)
    	return;
    g_gr_state.alpha_test_function = function;
    SetAlphaTestFunction(function);
}

FX_ENTRY void FX_CALL grAlphaTestReferenceValue (GrAlpha_t value)
{
    //static char buf[256];
    TRACEFUNCTION ("grAlphaTestReferenceValue");

    if (g_gr_state.alpha_test_reference_value == value)
    	return;
    FlushTriangleVertex();
    g_gr_state.alpha_test_reference_value = value;
    SetAlphaTestFunction(g_gr_state.alpha_test_function);
}

FX_ENTRY void FX_CALL grChromakeyMode (GrChromakeyMode_t mode)
{
    TRACEFUNCTION ("grChromakeyMode");

    g_gr_state.chromakey_mode = mode;
}

FX_ENTRY void FX_CALL grChromakeyValue (GrColor_t value)
{
    TRACEFUNCTION ("grChromakeyValue");

	 DWORD cr = grsubConvColor (value);

    g_gr_state.chromakey_value = cr;
}

FX_ENTRY void FX_CALL grClipWindow (FxU32 minx, FxU32 miny, FxU32 maxx,
    FxU32 maxy)
{
    TRACEFUNCTION ("grClipWindow");
    /*FlushTriangleVertex();
    g_gr_state.clip_window_minx = minx;
    g_gr_state.clip_window_miny = miny;
    g_gr_state.clip_window_maxx = maxx;
    g_gr_state.clip_window_maxy = maxy;*/

}

FX_ENTRY void FX_CALL grColorCombine (GrCombineFunction_t function,
    GrCombineFactor_t factor, GrCombineLocal_t local, GrCombineOther_t other,
    FxBool invert)
{
    TRACEFUNCTION ("grColorCombine");

    g_gr_state.color_combine_function = function;
    g_gr_state.color_combine_factor = factor;
	 g_gr_state.color_combine_local = local;
    g_gr_state.color_combine_other = other;
	 g_gr_state.color_combine_invert = invert;

    /*if (g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL_ALPHA)
       ;
       else
       ;

       if (g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ONE) {
       } else {
       } */


    grMegaCombineEverythingSetup (false);

    //g_gr_tmu[0].texture_source_start_address_old = -1;
}

FX_ENTRY void FX_CALL grColorMask (FxBool rgb, FxBool a)
{
    TRACEFUNCTION ("grColorMask");
    if (g_gr_state.color_mask_rgb==rgb && g_gr_state.color_mask_a == a)
    	return;
    FlushTriangleVertex();
    g_gr_state.color_mask_rgb = rgb;
    g_gr_state.color_mask_a = a;
    glColorMask (rgb, rgb, rgb, a);
	 /*DWORD dwMask = 0;
       if (rgb == FXTRUE) dwMask |= 0x00ffffff;
       if (a == FXTRUE) dwMask |= 0xff000000; */

}

FX_ENTRY void FX_CALL grCullMode (GrCullMode_t mode)
{
    TRACEFUNCTION ("grCullMode");

    if (g_gr_state.cull_mode == mode)
    	return;
    g_gr_state.cull_mode = mode;
    FlushTriangleVertex();
    switch (mode)
    {
      case GR_CULL_DISABLE:
         glDisable (GL_CULL_FACE);
         break;
      case GR_CULL_NEGATIVE:
         glEnable (GL_CULL_FACE);
         glCullFace (GL_BACK);
         break;
      case GR_CULL_POSITIVE:
         glEnable (GL_CULL_FACE);
         glCullFace (GL_FRONT);
         break;
    }
}

FX_ENTRY void FX_CALL grConstantColorValue (GrColor_t value)
{
	 TRACEFUNCTION ("grConstantColorValue");

	 DWORD cr = grsubConvColor (value);

	 g_gr_state.constant_color_value = cr;
    g_gr_state.constant_color.r = DIV255((cr & 0xff0000) >> 16);
    g_gr_state.constant_color.g = DIV255((cr & 0x00ff00) >> 8);
    g_gr_state.constant_color.b = DIV255(cr & 0x0000ff);
    g_gr_state.constant_color.a = DIV255(cr >> 24);
/*	 g_gr_state.constant_color_value_color = cr & 0x00ffffff;
	 g_gr_state.constant_color_value_alpha = cr & 0xff000000;*/
}

FX_ENTRY void FX_CALL grConstantColorValue4 (float a, float r, float g, float b)
{
	 TRACEFUNCTION ("grConstantColorValue4");

	 DWORD value = (((DWORD) a & 0xff) << 24) |
	  (((DWORD) r & 0xff) << 16) |
	  (((DWORD) g & 0xff) << 8) |
	  (((DWORD) b & 0xff) << 0);
	 DWORD cr = grsubConvColor (value);

	 g_gr_state.constant_color_value = cr;
    g_gr_state.constant_color.r = r;
    g_gr_state.constant_color.g = g;
    g_gr_state.constant_color.b = b;
    g_gr_state.constant_color.a = a;

	 /*g_gr_state.constant_color_value_color = cr & 0x00ffffff;
	 g_gr_state.constant_color_value_alpha = cr & 0xff000000;*/
}

FX_ENTRY void FX_CALL grDepthBiasLevel (FxI16 level)
{
	 TRACEFUNCTION ("grDepthBiasLevel");
	 ERROROUT ("grDepthBiasLevel");
	 g_gr_state.depth_bias_level = level;
	 /*glPolygonOffset( 1.0f, level );
	 if (level != 0)
		glEnable( GL_POLYGON_OFFSET_FILL );
	 else
		glDisable( GL_POLYGON_OFFSET_FILL );*/
}

FX_ENTRY void FX_CALL grDepthBufferFunction (GrCmpFnc_t function)
{
	 TRACEFUNCTION ("grDepthBufferFunction");

    if (g_gr_state.depth_buffer_function == function)
    	return;
    FlushTriangleVertex();
	 g_gr_state.depth_buffer_function = function;
	 switch (function)
	 {
	 case GR_CMP_NEVER:
	   glDepthFunc (GL_NEVER);
  //              ERROROUT("DepthBufferFunction: NEVER");
	   break;
	 case GR_CMP_LESS:
	   glDepthFunc (GL_LESS);
  //              ERROROUT("DepthBufferFunction: LESS");
	  break;
	 case GR_CMP_EQUAL:
	   glDepthFunc (GL_EQUAL);
  //              ERROROUT("DepthBufferFunction: EQUAL");
	  break;
	 case GR_CMP_LEQUAL:
	   glDepthFunc (GL_LEQUAL);
  //              ERROROUT("DepthBufferFunction: LEQUAL");
	  break;
	 case GR_CMP_GREATER:
	   glDepthFunc (GL_GREATER);
  //              ERROROUT("DepthBufferFunction: GREATER");
	  break;
	 case GR_CMP_NOTEQUAL:
	   glDepthFunc (GL_NOTEQUAL);
  //              ERROROUT("DepthBufferFunction: NOTEQUAL");
	  break;
	 case GR_CMP_GEQUAL:
	   glDepthFunc (GL_GEQUAL);
  //              ERROROUT("DepthBufferFunction: GEQUAL");
	  break;
	 case GR_CMP_ALWAYS:
	   glDepthFunc (GL_ALWAYS);
  //              ERROROUT("DepthBufferFunction: ALWAYS");
	  break;
	 }
}

FX_ENTRY void FX_CALL grDepthBufferMode (GrDepthBufferMode_t mode)
{
    TRACEFUNCTION ("grDepthBufferMode");
//      ERROROUT("grDepthBufferMode");

	 if (g_gr_state.depth_buffer_mode == mode)
    	return;
    FlushTriangleVertex();

    g_gr_state.depth_buffer_mode = mode;

    switch (mode)
    {
    case GR_DEPTHBUFFER_DISABLE:
	  glDisable (GL_DEPTH_TEST);
	  break;
	 case GR_DEPTHBUFFER_ZBUFFER:
	  glEnable (GL_DEPTH_TEST);
	  break;
	 case GR_DEPTHBUFFER_WBUFFER:
	  glEnable (GL_DEPTH_TEST);
	  break;
	 default:
		ERROROUT ("COMPARE TO BIAS");
		break;
	 }
}

FX_ENTRY void FX_CALL grDepthMask (FxBool mask)
{
	 TRACEFUNCTION ("grDepthMask");
    if (g_gr_state.depth_mask == mask)
    	return;
    FlushTriangleVertex();
	 g_gr_state.depth_mask = mask;
    glDepthMask (mask);
}

FX_ENTRY void FX_CALL grDisableAllEffects (void)
{
	 TRACEFUNCTION ("grDisableAllEffects");
    FlushTriangleVertex();

	 grAlphaBlendFunction (GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ONE, GR_BLEND_ZERO);
	 grAlphaTestFunction (GR_CMP_ALWAYS);
	 grChromakeyMode (GR_CHROMAKEY_DISABLE);
	 grDepthBufferMode (GR_DEPTHBUFFER_DISABLE);
	 grFogMode (GR_FOG_DISABLE);
}

FX_ENTRY void FX_CALL grDitherMode (GrDitherMode_t mode)
{
	 TRACEFUNCTION ("grDitherMode");

	 g_gr_state.dither_mode = mode;
}

FX_ENTRY void FX_CALL grFogColorValue (GrColor_t fogcolor)
{
	 TRACEFUNCTION ("grFogColorValue");
	 if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;

    FlushTriangleVertex();

	 g_gr_state.fog_color = fogcolor;
	 DWORD cr = grsubConvColor (fogcolor);

	 g_gr_state.fog_d3dcolor = cr;
	 grFogMode (g_gr_state.fog_mode);

}

FX_ENTRY void FX_CALL grFogMode (GrFogMode_t mode)
{
	 TRACEFUNCTION ("grFogMode");

	 if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;
    FlushTriangleVertex();

    static GLfloat color[4];

    float *n, *f;

	 g_gr_state.fog_mode = mode;
	 color[0] = DIV255((g_gr_state.fog_d3dcolor >> 16) & 0xff);
	 color[1] = DIV255((g_gr_state.fog_d3dcolor >> 8) & 0xff);
	 color[2] = DIV255((g_gr_state.fog_d3dcolor) & 0xff);
	 color[3] = DIV255((g_gr_state.fog_d3dcolor >> 24) & 0xff);
	 if (mode == GR_FOG_DISABLE)
	 {
	  glDisable (GL_FOG);
	  return;
	 }

	 if (g_gr_state.fog_mode & GR_FOG_WITH_TABLE)
	 {
		INT nFogTableValidate = (INT) g_gr_fogtable[GLID3D_FOGTABLE_VALIDATE];

		if (nFogTableValidate == GLID3D_FOGTABLE_VALIDATE_VALUE)
		{
			INT nFogMode = (INT) g_gr_fogtable[GLID3D_FOGTABLE_MODE];

			switch (nFogMode)
			{
			  case GLID3D_FOGMODE_EXP:
			  {
				  glEnable (GL_FOG);
				  glFogi (GL_FOG_MODE, GL_EXP);
				  glFogf (GL_FOG_DENSITY, g_gr_fogtable[GLID3D_FOGTABLE_DENSITY]);
				  glFogfv (GL_FOG_COLOR, color);
				  break;
			  }
			  case GLID3D_FOGMODE_EXP2:
			  {
				  glEnable (GL_FOG);
				  glFogi (GL_FOG_MODE, GL_EXP2);
				  glFogf (GL_FOG_DENSITY, g_gr_fogtable[GLID3D_FOGTABLE_DENSITY]);
				  glFogfv (GL_FOG_COLOR, color);
				  break;
			  }
			  case GLID3D_FOGMODE_LINEAR:
			  {
				  n = (float *)&g_gr_fogtable[GLID3D_FOGTABLE_NEARZ];
				  f = (float *)&g_gr_fogtable[GLID3D_FOGTABLE_FARZ];
				  if (g_gr_bUseZInverse)
				  {
					if (g_gr_bFogMode == GLID3D_FOG_MODE1)
					{
						if (g_gr_bPrecisionFix)
						{
							  (*n) = 1.0 - 0.1 / (*n);
							  (*f) = 1.0 - 0.1 / (*f);
						}
						else
						{
							  (*n) = 1.0 - 1 / (*n);
							  (*f) = 1.0 - 1 / (*f);
						}
					}
					else
					{
						if (g_gr_bPrecisionFix)
						{
							  (*n) = (*n);
							  (*f) = (*f);
						}
						else
						{
							  (*n) = (*n);
							  (*f) = (*f);
						}
					}
				  }  else
				  {
					(*n) = (*n);
					(*f) = (*f);
				  }


				  glEnable (GL_FOG);
				  glFogi (GL_FOG_MODE, GL_LINEAR);
				  glFogf (GL_FOG_START, *n);
				  glFogf (GL_FOG_END, *f);
				  glFogfv (GL_FOG_COLOR, color);
				  break;
			  }
			}
		} else
		{
			// Invalid fogtable it was generated by non glide function
			glDisable (GL_FOG);
		}
	 }
//      else
//              glDisable(GL_FOG);
}

FX_ENTRY void FX_CALL grFogTable (const GrFog_t ft[GR_FOG_TABLE_SIZE])
{
	 TRACEFUNCTION ("grFogTable");

	 if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;
    FlushTriangleVertex();

	 CopyMemory (g_gr_fogtable, ft, sizeof (BYTE) * GR_FOG_TABLE_SIZE);

	 grFogMode (g_gr_state.fog_mode);
}

FX_ENTRY void FX_CALL grGammaCorrectionValue (float value)
{
	 TRACEFUNCTION ("grGammaCorrectionValue");
    FlushTriangleVertex();
	 if (g_gr_bNoGammaControl)
		return;

    value += g_gr_fGammaBase;
	 g_gr_fGamma = value;

    /*INT i;
       for (i = 0; i < 256; i++) {
		INT nRamp;
       if (value >= 0.0f) {
       nRamp = (INT)((FLOAT)i * (FLOAT)value * (FLOAT)0xffff / f255);
       nRamp += g_gr_nContrast;
       if (nRamp < 0) nRamp = 0;
		else if (nRamp > 0xffff) nRamp = 0xffff;
       } else {
       nRamp = 0;
       }
       } */

}

FX_ENTRY void FX_CALL grSplash (float x, float y, float width, float height,
    FxU32 frame)
{
    TRACEFUNCTION ("grSplash");

    if (frame == 0)
    {
		ERROROUT ("INSPLASH");
	 }
}

/////////////////////////////////////////////////////////////////////////////
