/////////////////////////////////////////////////////////////////////////////
// GliD3D_SST.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"
#include "OpenGLinit.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

const char *className = "Glide OpenGL";
const char *windowName = "Glide OpenGL Wrapper";
GLuint disp_listnum, disp_listnum2;
BOOL g_gr_DrawingTriangles;

FX_ENTRY void FX_CALL grSstIdle (void)
{
    TRACEFUNCTION ("grSstIdle");

}

FX_ENTRY FxU32 FX_CALL
  grSstVideoLine (void)
{
    TRACEFUNCTION ("grSstVideoLine");

    return 0;
}

FX_ENTRY FxBool FX_CALL
  grSstVRetraceOn (void)
{
    TRACEFUNCTION ("grSstVRetraceOn");

    return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grSstIsBusy (void)
{
    TRACEFUNCTION ("grSstIsBusy");

    return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grSstWinOpen (
    FxU32 hWnd,
    GrScreenResolution_t screen_resolution,
    GrScreenRefresh_t refresh_rate,
    GrColorFormat_t color_format,
    GrOriginLocation_t origin_location,
    int nColBuffers,
    int nAuxBuffers)
{
    TRACEFUNCTION ("grSstWinOpen");

    HRESULT hr;
    INT i, j;
    HDC hDC;
    WNDCLASS wndClass;
    char buf[267];

    ERROROUT ("grSstWinOpen");

    // Destroy old windows 

    wglMakeCurrent (NULL, NULL);

    wglDeleteContext (g_gr_glRC);

    ReleaseDC (g_gr_hWnd, g_gr_hDC);

    DestroyWindow (g_gr_hWnd);


    // Get some info from Profile
    CHAR pszProfileName[_MAX_PATH];
    CHAR pszSection[32];
    CHAR pszKey[32];
    CHAR pszString[256];
    CHAR pszDevice[256];
    INT nGammaBase;
    BOOL bNoVsync;
    INT nWidth, nHeight;
    BOOL bNoSplash;
    BOOL bNoSplashSound;

    lstrcpy (pszProfileName, "");
    GetSystemDirectory (pszProfileName, sizeof (pszProfileName));
    if (pszProfileName[lstrlen (pszProfileName) - 1] != '\\')
    	lstrcat (pszProfileName, "\\");
    lstrcat (pszProfileName, GLID3D_PROFILENAME);

    // Video info
    lstrcpy (pszSection, "Misc");

    g_gr_bUseZInverse = 1;
    lstrcpy (pszKey, GLID3DPROF_VIDEO_FOGMODE);
    g_gr_bFogMode = GliD3DGetProfileInt (pszSection, pszKey, 0, pszProfileName);

    lstrcpy (pszKey, GLID3DPROF_VIDEO_FULLSCREEN);
    g_gr_bFullScreen = GliD3DGetProfileInt (pszSection, pszKey, TRUE, pszProfileName);
    lstrcpy (pszKey, GLID3DPROF_VIDEO_BLENDFIX);
    g_gr_bAlphaFix = GliD3DGetProfileInt (pszSection, pszKey, TRUE, pszProfileName);
    lstrcpy (pszKey, GLID3DPROF_VIDEO_MIPMAPS);
    g_gr_bForceMipMaps = GliD3DGetProfileInt (pszSection, pszKey, FALSE, pszProfileName);
    lstrcpy (pszKey, GLID3DPROF_VIDEO_PRECISIONFIX);
    g_gr_bPrecisionFix = GliD3DGetProfileInt (pszSection, pszKey, FALSE, pszProfileName);
    lstrcpy (pszKey, GLID3DPROF_VIDEO_USEZINVERSE);
    g_gr_bUseZInverse = GliD3DGetProfileInt (pszSection, pszKey, TRUE, pszProfileName);
    g_gr_fZInverseDepth = 32000.0f;


    // Splash info
/*
	lstrcpy(pszSection, GLID3DPROF_SPLASH);

	lstrcpy(pszKey, GLID3DPROF_SPLASH_NOSPLASH);
	bNoSplash = GliD3DGetProfileInt(pszSection, pszKey, FALSE, pszProfileName);
	lstrcpy(pszKey, GLID3DPROF_SPLASH_NOSOUND);
	bNoSplashSound = GliD3DGetProfileInt(pszSection, pszKey, FALSE, pszProfileName);
*/

    // Initialize system variables

    // Initialize states
    g_gr_hWnd = NULL;
    g_gr_nWidth = 0;
    g_gr_nHeight = 0;
    g_gr_bLeft = TRUE;
    g_gr_nNumTextureFormats = 0;
    g_gr_nColBuffers = 0;
    g_gr_nAuxBuffers = 0;
    g_gr_bOpenedWindow = TRUE;
    g_gr_lfb_lock_info_front.bLocked = FALSE;
    g_gr_lfb_lock_info_back.bLocked = FALSE;

    // System
    g_gr_state.color_format = GR_COLORFORMAT_ABGR;
    g_gr_state.origin_location = GR_ORIGIN_UPPER_LEFT;
    g_gr_state.render_buffer = GR_BUFFER_BACKBUFFER;
    g_gr_state.cull_mode = GR_CULL_DISABLE;

    // Clip window
    g_gr_state.clip_window_minx = 0;
    g_gr_state.clip_window_miny = 0;
    g_gr_state.clip_window_maxx = 640;
    g_gr_state.clip_window_maxy = 480;

    // Chromakey
    g_gr_state.chromakey_mode = GR_CHROMAKEY_DISABLE;
    g_gr_state.chromakey_value = 0;

    // Depth buffer
    g_gr_state.depth_buffer_mode = GR_DEPTHBUFFER_DISABLE;
    g_gr_state.depth_mask = FXTRUE;
    g_gr_state.depth_buffer_function = GR_CMP_LEQUAL;
    g_gr_state.depth_bias_level = 0;

    // Color combine
    g_gr_state.constant_color_value = 0;
    g_gr_state.color_combine_function = GR_COMBINE_FUNCTION_LOCAL;
    g_gr_state.color_combine_factor = GR_COMBINE_FACTOR_NONE;
    g_gr_state.color_combine_local = GR_COMBINE_LOCAL_CONSTANT;
    g_gr_state.color_combine_other = GR_COMBINE_OTHER_NONE;

    // Alpha combine / function
    g_gr_state.alpha_combine_function = GR_COMBINE_FUNCTION_LOCAL;
    g_gr_state.alpha_combine_factor = GR_COMBINE_FACTOR_NONE;
    g_gr_state.alpha_combine_local = GR_COMBINE_LOCAL_CONSTANT;
    g_gr_state.alpha_combine_other = GR_COMBINE_OTHER_NONE;
    g_gr_state.alpha_blend_function_rgb_sf = GR_BLEND_ONE;
    g_gr_state.alpha_blend_function_rgb_df = GR_BLEND_ZERO;
    g_gr_state.alpha_blend_function_alpha_sf = GR_BLEND_ZERO;
    g_gr_state.alpha_blend_function_alpha_df = GR_BLEND_ZERO;

    // TMU

    for (i = 0; i < GLID3D_NUM_TMU; i++)
    {
       g_gr_tmu[i].texture_minfilter_mode = GR_TEXTUREFILTER_POINT_SAMPLED;
       g_gr_tmu[i].texture_magfilter_mode = GR_TEXTUREFILTER_POINT_SAMPLED;
       g_gr_tmu[i].mipmap_mode = GR_MIPMAP_DISABLE;

       g_gr_tmu[i].texture_combine_rgb_function = GR_COMBINE_FUNCTION_LOCAL;
       g_gr_tmu[i].texture_combine_rgb_factor = GR_COMBINE_FACTOR_NONE;
       g_gr_tmu[i].texture_combine_alpha_function = GR_COMBINE_FUNCTION_LOCAL;
       g_gr_tmu[i].texture_combine_alpha_factor = GR_COMBINE_FACTOR_NONE;

       g_gr_tmu[i].texture_source_start_address = 0;
       g_gr_tmu[i].texture_source_start_address_old = -1;
       g_gr_tmu[i].texture_source_even_odd = GR_MIPMAPLEVELMASK_EVEN;

       for (j = 0; j < GLID3D_TEXMAXADDRESS; j++)
       {
           g_gr_tmu[i].texture[j].texId = -1;
       }
    }


    // Setup video mode and 3d device
    if (hWnd)
    {
		g_gr_hWndOld = (HWND) hWnd;
    }
    else
    {
		g_gr_hWndOld = GetActiveWindow ();
    }


    switch (screen_resolution)
    {
    case GR_RESOLUTION_512x384:
       g_gr_nGlideWidth = 512;
       g_gr_nGlideHeight = 384;
       g_gr_nWidth = 512;
       g_gr_nHeight = 384;
       break;
    case GR_RESOLUTION_640x400:
       g_gr_nGlideWidth = 640;
       g_gr_nGlideHeight = 400;
       g_gr_nWidth = 640;
       g_gr_nHeight = 400;
       break;
    case GR_RESOLUTION_640x480:
       g_gr_nGlideWidth = 640;
       g_gr_nGlideHeight = 480;
       g_gr_nWidth = 640;
       g_gr_nHeight = 480;
       break;
    case GR_RESOLUTION_800x600:
       g_gr_nGlideWidth = 800;
       g_gr_nGlideHeight = 600;
       g_gr_nWidth = 800;
       g_gr_nHeight = 600;
       break;
    case GR_RESOLUTION_1024x768:
       g_gr_nGlideWidth = 1024;
       g_gr_nGlideHeight = 768;
       g_gr_nWidth = 1024;
       g_gr_nHeight = 768;
       break;
    }
    g_gr_fWidthScale = 1.0f;
    g_gr_fHeightScale = 1.0f;
    g_gr_state.color_format = color_format;
    g_gr_state.origin_location = origin_location;
    g_gr_nColBuffers = nColBuffers;
    g_gr_nAuxBuffers = nAuxBuffers;
    g_gr_state.clip_window_minx = 0;
    g_gr_state.clip_window_miny = 0;
    g_gr_state.clip_window_maxx = g_gr_nWidth;
    g_gr_state.clip_window_maxy = g_gr_nHeight;

    g_gr_fGlideWidth = (FLOAT) g_gr_nGlideWidth;
    g_gr_fGlideHeight = (FLOAT) g_gr_nGlideHeight;
    g_gr_fWidth = (FLOAT) g_gr_nWidth;
    g_gr_fHeight = (FLOAT) g_gr_nHeight;
    g_gr_fHarfWidth = (FLOAT) g_gr_nWidth / 2.0f;
    g_gr_fHarfHeight = (FLOAT) g_gr_nHeight / 2.0f;
    g_gr_sfactor = -1;
    g_gr_dfactor = -1;
    g_gr_DrawingTriangles = FALSE;
    
    InitDiv255LookupTable();
    InitBlendMap ();
    InitLookupVertexFuncs ();
    ChooseVertexFunc ();

    HWND hWnd_OldActive = GetActiveWindow ();

    g_gr_hWnd = CreateOpenGLWindow (g_gr_hWndOld, "GlideWrapper", 0, 0, g_gr_nWidth, g_gr_nHeight,
	    PFD_TYPE_RGBA, PFD_DOUBLEBUFFER);
    if (g_gr_hWnd == NULL)
		return FXFALSE;

    g_gr_hDC = GetDC (g_gr_hWnd);
    g_gr_glRC = wglCreateContext (g_gr_hDC);
    wglMakeCurrent (g_gr_hDC, g_gr_glRC);

    ShowWindow (g_gr_hWnd, SW_SHOW);
    UpdateWindow (g_gr_hWnd);

    BringWindowToTop (g_gr_hWnd);
    SetForegroundWindow (g_gr_hWndOld);
    SetActiveWindow (g_gr_hWndOld);
    //disp_listnum = glGenLists (1);
    //disp_listnum2 = glGenLists (1);
    glDisable (GL_FOG);
#ifdef USEVERTEXARRAY
	 glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_COLOR_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);
#endif
    //glEnable(GL_SCISSOR_TEST);
    glDisable(GL_BLEND);
    g_gr_BlendOn = FALSE;
    glDisable(GL_ALPHA_TEST);
    g_gr_AlphaTestOn = FALSE;
    glDisable(GL_TEXTURE_2D);
    g_gr_Texture2DOn = FALSE;
	 glPixelStorei(GL_UNPACK_ALIGNMENT, 4);								// Force 4-byte alignment
	 glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
	 glPixelStorei(GL_UNPACK_SKIP_ROWS, 0);
	 glPixelStorei(GL_UNPACK_SKIP_PIXELS, 0);

    glMatrixMode (GL_PROJECTION);
    glLoadIdentity ();
    glMatrixMode (GL_MODELVIEW);

    glLoadIdentity ();
    glViewport (0, 0, g_gr_nWidth, g_gr_nHeight);
    //glNewList(disp_listnum2, GL_COMPILE);
    glHint (GL_POLYGON_SMOOTH_HINT, GL_FASTEST);
    glHint (GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);
    glHint (GL_FOG_HINT, GL_NICEST);
    glHint (GL_LINE_SMOOTH_HINT, GL_FASTEST);
    glHint (GL_POINT_SMOOTH_HINT, GL_FASTEST);
	 if (g_gr_bFogMode == GLID3D_FOG_OFF)
    	glDisable(GL_FOG);    
    //glDisable (GL_DITHER);
//      glViewport(100,100, g_gr_nWidth-100, g_gr_nHeight-100);
//      if(g_gr_bPrecisionFix)
//              glOrtho(0,g_gr_nWidth,g_gr_nHeight, 0.0, -0.051,  0.0);
//      else
//              glOrtho(0,g_gr_nWidth,g_gr_nHeight, 0.0, -1.1,  0.0);
    if (g_gr_bUseZInverse)
    {
       if (g_gr_bPrecisionFix)
       {
           glOrtho (0, g_gr_nWidth, g_gr_nHeight, 0.0, -0.1f, 0.00);
       }
       else glOrtho (0, g_gr_nWidth, g_gr_nHeight, 0.0, -1.05f, 0.01);
    }
    else glOrtho (0, g_gr_nWidth, g_gr_nHeight, 0.0, 0.0f, -1.0f);

//      glDepthRange(0,100.0f);
    return FXTRUE;
}

FX_ENTRY void FX_CALL grSstWinClose (void)
{
    TRACEFUNCTION ("grSstWinClose");
    FlushTriangleVertex();
    INT i, j;

    for (i = 0; i < GLID3D_NUM_TMU; i++)
    {
       for (j = 0; j < GLID3D_TEXMAXADDRESS; j++)
       {
           glDeleteTextures (1, &g_gr_tmu[i].texture[j].texId);
       }
    }
    //glDeleteLists (disp_listnum, 1);
    //glDeleteLists (disp_listnum2, 1);

    wglMakeCurrent (NULL, NULL);
    wglDeleteContext (g_gr_glRC);
    ReleaseDC (g_gr_hWnd, g_gr_hDC);
    DestroyWindow (g_gr_hWnd);
    ChangeDisplaySettings (0, 0);

    WARNING ("grSstCloseWindow");

    return;
}

/* enable disable 3dfx view */
FX_ENTRY FxBool FX_CALL
  grSstControl (FxU32 code)
{
    TRACEFUNCTION ("grSstControl");

    return GR_CONTROL_ACTIVATE;
}

FX_ENTRY FxBool FX_CALL
  grSstQueryHardware (GrHwConfiguration * hwconfig)
{
    TRACEFUNCTION ("grSstQueryHardware");
    ERROROUT ("grSstQueryHardware");

    hwconfig->num_sst = 1;
    hwconfig->SSTs[0].type = GR_SSTTYPE_VOODOO;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.fbRam = 2;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.fbiRev = 2;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.nTexelfx = 1;
    hwconfig->SSTs[0].type = GR_SSTTYPE_VOODOO;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.sliDetect = FXFALSE;
    for (INT i = 0; i < GLIDE_NUM_TMU; i++)
    {
       hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRam = 2;
       hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRev = 1;
    }

    return FXTRUE;
}

FX_ENTRY FxBool FX_CALL
  grSstQueryBoards (GrHwConfiguration * hwconfig)
{
    TRACEFUNCTION ("grSstQueryBoards");
    ERROROUT ("grSstQueryBoards");

    hwconfig->num_sst = 1;
    hwconfig->SSTs[0].type = GR_SSTTYPE_VOODOO;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.fbRam = 2;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.fbiRev = 2;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.nTexelfx = 1;
    hwconfig->SSTs[0].sstBoard.VoodooConfig.sliDetect = FXFALSE;
    for (INT i = 0; i < GLIDE_NUM_TMU; i++)
    {
       hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRam = 2;
       hwconfig->SSTs[0].sstBoard.VoodooConfig.tmuConfig[i].tmuRev = 1;
    }

    return FXTRUE;
}

FX_ENTRY void FX_CALL grSstOrigin (GrOriginLocation_t origin)
{
    TRACEFUNCTION ("grSstOrigin");

    g_gr_state.origin_location = origin;
    ChooseVertexFunc ();
}

FX_ENTRY void FX_CALL grSstSelect (int which_sst)
{
    TRACEFUNCTION ("grSstSelect");

}

FX_ENTRY FxU32 FX_CALL
  grSstScreenHeight (void)
{
    TRACEFUNCTION ("grSstScreenHeight");

    return g_gr_nGlideHeight;
}

FX_ENTRY FxU32 FX_CALL
  grSstScreenWidth (void)
{
    TRACEFUNCTION ("grSstScreenWidth");

    return g_gr_nGlideWidth;
}

FX_ENTRY FxU32 FX_CALL
  grSstStatus (void)
{
    TRACEFUNCTION ("grSstStatus");

    return 1;
}
