/////////////////////////////////////////////////////////////////////////////
// GliD3D_texture.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"
/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/*typedef struct {
	DDPIXELFORMAT	ddpf;
	CHAR			pszName[256];
	INT				nBits;
	INT				nR;
	INT				nG;
	INT				nB;
	INT				nA;
	BOOL			bPalette;
} *LPGB3DCORETEXTUREFORMATINFO, GB3DCORETEXTUREFORMATINFO;

/////////////////////////////////////////////////////////////////////////////
// Prototypes

VOID GB3DCoreGetTextureFormatInfo(LPGB3DCORETEXTUREFORMATINFO pInfo, INT nIndex);*/

/////////////////////////////////////////////////////////////////////////////
// Implements

#define nTmu 0

inline void SetMipMapMode(INT tmu, GrMipMapMode_t mode)
{
  GLint MagFilterMode;
  if (g_gr_tmu[tmu].texture_magfilter_mode == GR_TEXTUREFILTER_BILINEAR)
  	 MagFilterMode = GL_LINEAR;
	 //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  else
    MagFilterMode = GL_NEAREST;
    //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
  if (MagFilterMode!=current_texture->MagFilterMode)
    glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, MagFilterMode);

  current_texture->MagFilterMode = MagFilterMode;
  if (g_gr_bForceMipMaps)
  {
     if (g_gr_tmu[tmu].texture_minfilter_mode == GR_TEXTUREFILTER_BILINEAR)
         glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
     else
         glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_LINEAR);
  }
  else
  {
  	  GLint MinFilterMode=GL_LINEAR;
     switch (mode)
     {
       case GR_MIPMAP_DISABLE:
           if (g_gr_tmu[tmu].texture_minfilter_mode == GR_TEXTUREFILTER_BILINEAR)
           	MinFilterMode = GL_LINEAR;
				//glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
           else
           	MinFilterMode = GL_NEAREST;
             //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
           break;
       case GR_MIPMAP_NEAREST:
           if (g_gr_tmu[tmu].texture_minfilter_mode == GR_TEXTUREFILTER_BILINEAR)
             MinFilterMode = GL_LINEAR_MIPMAP_NEAREST;
             //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST);
           else
             MinFilterMode = GL_NEAREST_MIPMAP_NEAREST;
             //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_NEAREST);
           break;

       case GR_MIPMAP_NEAREST_DITHER:
           if (g_gr_tmu[tmu].texture_minfilter_mode == GR_TEXTUREFILTER_BILINEAR)
             MinFilterMode = GL_LINEAR_MIPMAP_LINEAR;
             //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);
           else
             MinFilterMode = GL_NEAREST_MIPMAP_LINEAR;
             //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST_MIPMAP_LINEAR);
           break;
       default:
           break;
     }
     if (MinFilterMode!=current_texture->MinFilterMode)
	  	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, MinFilterMode);
     current_texture->MinFilterMode = MinFilterMode;
  }
}

FX_ENTRY FxU32 FX_CALL
  grTexCalcMemRequired (
    GrLOD_t lodmin, GrLOD_t lodmax,
    GrAspectRatio_t aspect, GrTextureFormat_t fmt)
{
    TRACEFUNCTION ("grTexCalcMemRequired");

    return GLID3D_TEXCALCMEMREQUIRED;
}

FX_ENTRY FxU32 FX_CALL
  grTexTextureMemRequired (FxU32 evenOdd,
    GrTexInfo * info)
{
    TRACEFUNCTION ("grTexTextureMemRequired");

    return GLID3D_TEXTEXTUREMEMREQUIRED;
}

FX_ENTRY FxU32 FX_CALL
  grTexMinAddress (GrChipID_t tmu)
{
    TRACEFUNCTION ("grTexMinAddress");

    return GLID3D_TEXMINADDRESS;
}

FX_ENTRY FxU32 FX_CALL
  grTexMaxAddress (GrChipID_t tmu)
{
    TRACEFUNCTION ("grTexMaxAddress");

    return GLID3D_TEXMAXADDRESS;
}

FX_ENTRY void FX_CALL grTexNCCTable (GrChipID_t tmu, GrNCCTable_t table)
{
    TRACEFUNCTION ("grTexNCCTable");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexSource (GrChipID_t tmu, FxU32 startAddress, FxU32 evenOdd,
    GrTexInfo * info)
{
    TRACEFUNCTION ("grTexSource");

    if (startAddress < 0 || startAddress >= GLID3D_TEXMAXADDRESS)
    {
		WARNING ("Wrong source");
		return;
    }

    //INT nTmu = grsubGetTmuIndex(tmu);
    // semantically incorrect and/or buggy: only optimized for UltraHLE

    FlushTriangleVertex();

    glBindTexture (GL_TEXTURE_2D, g_gr_tmu[nTmu].texture[startAddress].texId);

    SetCurrentTexture(startAddress);
    g_gr_tmu[nTmu].texture_source_start_address = startAddress;
    g_gr_tmu[nTmu].texture_source_even_odd = evenOdd;
    //g_gr_tmu[nTmu].texture_source_info = *info;
    int aw, ah;
    grsubAspectToInt (aw, ah, info->aspectRatio);
    g_gr_tmu[nTmu].aw=aw / 256.0;
    g_gr_tmu[nTmu].ah=ah / 256.0;
    AlphaFix();
    grTexClampMode (nTmu, g_gr_tmu[nTmu].s_clampmode, g_gr_tmu[nTmu].t_clampmode);
    grTexMipMapMode(nTmu, g_gr_tmu[nTmu].mipmap_mode, FALSE);
    //grMegaCombineEverythingSetup (true);
}

FX_ENTRY void FX_CALL grTexClampMode (GrChipID_t tmu, GrTextureClampMode_t s_clampmode,
    GrTextureClampMode_t t_clampmode)
{
    TRACEFUNCTION ("grTexClampMode");

    //INT nTmu = grsubGetTmuIndex(tmu);
    //


    g_gr_tmu[nTmu].s_clampmode = s_clampmode;
    g_gr_tmu[nTmu].t_clampmode = t_clampmode;

    if (current_texture->s_clampmode==s_clampmode &&
        current_texture->t_clampmode==t_clampmode)
    	return;

    FlushTriangleVertex();

    current_texture->s_clampmode = s_clampmode;
    current_texture->t_clampmode = t_clampmode;
    GLint SClampWrap;
    if (s_clampmode == GR_TEXTURECLAMP_WRAP)
    	SClampWrap = GL_REPEAT;
		//glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
    else
    	SClampWrap = GL_CLAMP;
		//glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    if (current_texture->SClampWrap!=SClampWrap)
    {
    	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, SClampWrap);
       current_texture->SClampWrap = SClampWrap;
    }
    GLint TClampWrap;
    if (t_clampmode == GR_TEXTURECLAMP_WRAP)
    	TClampWrap = GL_REPEAT;
		//glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
    else
    	TClampWrap = GL_CLAMP;
		//glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    if (current_texture->TClampWrap!=TClampWrap)
    {
    	glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, TClampWrap);
       current_texture->TClampWrap = TClampWrap;
    }

//      g_gr_pd3ddevice->SetTextureStageState(nTmu, D3DTSS_ADDRESSU, s_clampmode == GR_TEXTURECLAMP_WRAP ? D3DTADDRESS_WRAP : D3DTADDRESS_CLAMP);
//      g_gr_pd3ddevice->SetTextureStageState(nTmu, D3DTSS_ADDRESSV, t_clampmode == GR_TEXTURECLAMP_WRAP ? D3DTADDRESS_WRAP : D3DTADDRESS_CLAMP);
}

FX_ENTRY void FX_CALL grTexCombine (GrChipID_t tmu, GrCombineFunction_t rgb_function,
    GrCombineFactor_t rgb_factor, GrCombineFunction_t alpha_function,
    GrCombineFactor_t alpha_factor, FxBool rgb_invert, FxBool alpha_invert)
{
    TRACEFUNCTION ("grTexCombine");
    //INT nTmu = grsubGetTmuIndex(tmu);

    /*g_gr_tmu[nTmu].texture_combine_rgb_function = rgb_function;
    g_gr_tmu[nTmu].texture_combine_rgb_factor = rgb_factor;
    g_gr_tmu[nTmu].texture_combine_alpha_function = alpha_function;
    g_gr_tmu[nTmu].texture_combine_alpha_factor = alpha_factor;*/
}

FX_ENTRY void FX_CALL grTexCombineFunction (GrChipID_t tmu,
    GrTextureCombineFnc_t fnc)
{
    TRACEFUNCTION ("grTexCombineFunction");

    switch (fnc)
    {
    case GR_TEXTURECOMBINE_ZERO:
		break;
    case GR_TEXTURECOMBINE_DECAL:
		break;
    case GR_TEXTURECOMBINE_OTHER:
		break;
    case GR_TEXTURECOMBINE_ADD:
		break;
    case GR_TEXTURECOMBINE_MULTIPLY:
		break;
    case GR_TEXTURECOMBINE_SUBTRACT:
		break;
    case GR_TEXTURECOMBINE_DETAIL:
		break;
    case GR_TEXTURECOMBINE_DETAIL_OTHER:
		break;
    case GR_TEXTURECOMBINE_TRILINEAR_ODD:
		break;
    case GR_TEXTURECOMBINE_TRILINEAR_EVEN:
		break;
    case GR_TEXTURECOMBINE_ONE:
		break;
    }
}

FX_ENTRY void FX_CALL grTexDetailControl (GrChipID_t tmu, int lod_bias,
    FxU8 detail_scale,
    float detail_max
)
{
    TRACEFUNCTION ("grTexDetailControl");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexFilterMode (GrChipID_t tmu, GrTextureFilterMode_t
    minfilter_mode, GrTextureFilterMode_t magfilter_mode)
{
    TRACEFUNCTION ("grTexFilterMode");
    //INT nTmu = grsubGetTmuIndex(tmu);

    g_gr_tmu[nTmu].texture_minfilter_mode = minfilter_mode;
    g_gr_tmu[nTmu].texture_magfilter_mode = magfilter_mode;

    if (current_texture->texture_minfilter_mode==minfilter_mode &&
        current_texture->texture_magfilter_mode==magfilter_mode)
            return;
    FlushTriangleVertex();
    SetMipMapMode(nTmu, g_gr_tmu[nTmu].mipmap_mode);
    //grTexMipMapMode (tmu, g_gr_tmu[nTmu].mipmap_mode, FALSE);
    current_texture->texture_minfilter_mode = minfilter_mode;
    current_texture->texture_magfilter_mode = magfilter_mode;
}


FX_ENTRY void FX_CALL grTexLodBiasValue (GrChipID_t tmu, float bias)
{
    TRACEFUNCTION ("grTexLodBiasValue");

//      WARNING("Not supported yet");
}

#define GL2IDE_FORCE_MIPMAPS 0
FX_ENTRY void FX_CALL grTexDownloadMipMap (GrChipID_t tmu, FxU32 startAddress,
    FxU32 evenOdd, GrTexInfo * info)
{
	TRACEFUNCTION ("grTexDownloadMipMap");
   /* int aw, ah, w, h, size;
    register int i;
    register unsigned char *dataptr;

    grsubAspectToInt (aw, ah, info->aspectRatio);
    if (!g_gr_bForceMipMaps)
    {
       switch (info->format)
       {
         case GR_TEXFMT_ALPHA_INTENSITY_88:
             size = 2;
             break;
         case GR_TEXFMT_AP_88:
             size = 2;
             break;
         case GR_TEXFMT_ALPHA_INTENSITY_44:
         case GR_TEXFMT_INTENSITY_8:
         case GR_TEXFMT_P_8:
         case GR_TEXFMT_ALPHA_8:
         case GR_TEXFMT_YIQ_422:
         case GR_TEXFMT_RGB_332:
             size = 1;
             break;
         case GR_TEXFMT_AYIQ_8422:
         case GR_TEXFMT_ARGB_8332:
         case GR_TEXFMT_RGB_565:
         case GR_TEXFMT_ARGB_1555:
         case GR_TEXFMT_ARGB_4444:
             size = 2;
             break;

         default:
             size = 0;		//                      error << "cp format" << endl;
             break;
       }

       dataptr = (unsigned char *)info->data;
       //glNewList (disp_listnum, GL_COMPILE);
       switch (evenOdd)
       {
        case GR_MIPMAPLEVELMASK_BOTH:
           for (i = info->largeLod; i >= info->smallLod; i--)
           {
             w = grsubLodToInt (i) / ah;
             h = grsubLodToInt (i) / aw;
             grTexDownloadMipMapLevel (tmu, startAddress, i, info->largeLod,
                 info->aspectRatio, info->format,
                 evenOdd, dataptr);
             dataptr += w * h * size;
           }
           break;
       case GR_MIPMAPLEVELMASK_EVEN:
           for (i = info->largeLod; i >= info->smallLod; i--)
           {
             if ((i % 2) == 0)
             {
                 w = grsubLodToInt (i) / ah;
                 h = grsubLodToInt (i) / aw;
                 grTexDownloadMipMapLevel (tmu, startAddress, i, info->largeLod,
                   info->aspectRatio, info->format,
                   evenOdd, dataptr);
                 dataptr += w * h * size;
             }
           }
           break;
        case GR_MIPMAPLEVELMASK_ODD:
           for (i = info->largeLod; i >= info->smallLod; i--)
           {
             if ((i % 2) == 1)
             {
                 w = grsubLodToInt (i) / ah;
                 h = grsubLodToInt (i) / aw;
                 grTexDownloadMipMapLevel (tmu, startAddress, i, info->largeLod,
                   info->aspectRatio, info->format,
                   evenOdd, dataptr);
                 dataptr += w * h * size;
             }
           }
           break;
       default:
           //error
           break;
       }
       //glEndList ();
       //glCallList (disp_listnum);
    }
    else*/
	 grTexDownloadMipMapLevel (tmu, startAddress, info->smallLod, info->smallLod,
	    info->aspectRatio, info->format, evenOdd, info->data);
}

FX_ENTRY void FX_CALL grTexDownloadMipMapLevel (GrChipID_t tmu, FxU32 startAddress,
    GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
    GrTextureFormat_t format, FxU32 evenOdd, void *data)
{
    static unsigned char *tbuffer;
//      GLenum err;
//      char tmp[2024];


    TRACEFUNCTION ("grTexDownloadMipMapLevel");
//      ofstream error("error.txt",ios::out | ios::app, 0);

    //int nTmu = grsubGetTmuIndex(tmu);
    FlushTriangleVertex();
    LPGLID3D_TMU ptmu = &g_gr_tmu[nTmu];
    LPGLID3D_TEXTURE ptex = &ptmu->texture[startAddress];

    if (ptex->texId == -1)
    {
	    //genereate a new texname
		glGenTextures (1, &ptex->texId);
       SetCurrentTexture(startAddress);
	 	current_texture->s_clampmode = -1;
    	current_texture->t_clampmode = -1;
    	current_texture->texture_minfilter_mode = -1;
    	current_texture->texture_magfilter_mode = -1;
    	current_texture->mipmap_mode = g_gr_tmu[nTmu].mipmap_mode;
       current_texture->MinFilterMode = -1;
	    current_texture->MagFilterMode = -1;
       current_texture->SClampWrap = -1;
		current_texture->TClampWrap = -1;
    } else SetCurrentTexture(startAddress);

    if (tbuffer == NULL)
		tbuffer = (unsigned char *)malloc (256 * 256 * 4);
    //create new texture object
    glBindTexture (GL_TEXTURE_2D, ptex->texId);

    int w, h, aw, ah, y, i, q;
    grsubAspectToInt (aw, ah, aspectRatio);


    //Get size of lod
    w = grsubLodToInt (thisLod) / ah;
    h = grsubLodToInt (thisLod) / aw;

    const int size = w*h;
    register const unsigned short *src;
    register unsigned char *dest;
    register const unsigned char *src8;
    register int x;
    GLenum texture_format = GL_RGBA;
	 GLenum texture_type = GL_UNSIGNED_BYTE;
    void *texture_buf = tbuffer;
    
    switch (format)
    {
        case GR_TEXFMT_INTENSITY_8:
    //              error << "oimplemented format: Intensity 8" << endl;
         break;
        case GR_TEXFMT_ALPHA_INTENSITY_88:
    //              error << "oimplemented format: AI 8" << endl;
         break;
        case GR_TEXFMT_AP_88:
       // not implemented/
    //              error << "oimplemented format: AP 8" << endl;
          break;
        case GR_TEXFMT_ALPHA_INTENSITY_44:
        case GR_TEXFMT_P_8:

    //              error << "oimplemented format" << endl;


       break;
      case GR_TEXFMT_ALPHA_8:
    //              glTexImage2D(GL_TEXTURE_2D, tlod, GL_ALPHA, w, h, 0, GL_ALPHA, GL_UNSIGNED_BYTE, data);
    //              error << "ALPHA 8" << endl;
       break;

      case GR_TEXFMT_AYIQ_8422:
         src = (unsigned short *)data;
         dest = tbuffer;
         for (x = 0; x < size; x++)
         {
             //src = (unsigned short *)(data)+x; dest = (unsigned char*)tbuffer +x*4;
             y = (((*src) >> 4) & 0x0f);
             i = (((*src) >> 2) & 0x03);
             q = ((*src) & 0x03);
             *dest++ = y + 0.95 * i + 0.62 * q;
             *dest++ = y - 0.28 * i - 0.64 * q;
             *dest++ = y - 1.11 * i + 1.73 * q;
             *dest++ = (((*src) >> 8) & 0xff);
             src++;
         }
    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
    //                      error << "AYIQ_8422 " << w <<" " << h << endl;
       break;

      case GR_TEXFMT_YIQ_422:
       src8 = (unsigned char *)data;
       dest = tbuffer;
       for (x = 0; x < size; x++)
       {
           //src8 = (unsigned char *)(data)+x; dest = (unsigned char*)tbuffer +x*4;
           y = (((*src8) >> 4) & 0x0f);
           i = (((*src8) >> 2) & 0x03);
           q = (((*src8) >> 0) & 0x03);
           *dest++ = y + 0.95 * i + 0.62 * q;
           *dest++ = y - 0.28 * i - 0.64 * q;
           *dest++ = y - 1.11 * i + 1.73 * q;
           *dest++ = 0;
           src8++;
       }
    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
    //                      error << "YIQ_422 " << w <<" " << h << endl;
       break;

      case GR_TEXFMT_RGB_332:
       // Untested
       for (x = 0; x < size; x++)
       {
           src = (unsigned short *)(data) + x;
           dest = (unsigned char *)tbuffer + x * 4;
           *(dest) = ((*src) & (0x007 << 5)) + (((*src >> 5) & 0x007) << 2) +
           (((*src >> 5) & 0x007) >> 1);
           *(dest + 1) = ((*src << 3) & (0x007 << 5)) + (((*src >> 2) &
               0x007) << 2) + (((*src >> 2) & 0x007) >> 1);
           *(dest + 2) = (((*src) & 0x003) << 6) + (((*src) & 0x003) << 4) +
           (((*src) & 0x003) << 4) + (((*src) & 0x003));
           *(dest + 3) = 0xff;
       }

    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
       break;

        case GR_TEXFMT_ARGB_8332:
           // Untested
           for (x = 0; x < size; x++)
           {
               src = (unsigned short *)(data) + x;
               dest = (unsigned char *)tbuffer + x * 4;
               *(dest) = ((*src) & (0x007 << 5)) + (((*src >> 5) & 0x007) << 2) +
               (((*src >> 5) & 0x007) >> 1);
               *(dest + 1) = ((*src << 3) & (0x007 << 5)) + (((*src >> 2) &
                   0x007) << 2) +
               (((*src >> 2) & 0x007) >> 1);
               *(dest + 2) = (((*src) & 0x003) << 6) + (((*src) & 0x003) << 4) +
               (((*src) & 0x003) << 4) + (((*src) & 0x003));
               *(dest + 3) = (((*src) >> 8) & 0xff);
           }

    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
       break;

     case GR_TEXFMT_RGB_565:
       src = (unsigned short *)data;
       dest = tbuffer;
       for (x = 0; x < size; x++)
       {
           //src = (unsigned short *)(data)+x; dest = (unsigned char*)tbuffer +x*4;
           *dest++ = (((*src >> 11) & 0x001f) << 3) + (((*src >> 11) &
               0x001f) >> 2);
           *dest++ = (((*src >> 5) & 0x003f) << 2) + (((*src >> 5) &
               0x003f) >> 4);
           *dest++ = (((*src >> 0) & 0x001f) << 3) + (((*src >> 0) &
               0x001f) >> 2);
           *dest++ = 0xff;
           src++;
       }

    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
    //                      error << "RGB_565" << w <<" " << h << endl;
       break;

     case GR_TEXFMT_ARGB_1555:
     {
#if 1
       src = (unsigned short *)data;
       //dest = tbuffer;
       register unsigned long *destw=(unsigned long *)tbuffer;
       for (x = 0; x < size; x++)
       {
       	/**destw++ = ( ((*src >> 10) & 0x001f) << 3) |
                      ( ((*src >> 10) & 0x001c) >> 2) |
                      ( ((*src >>  5) & 0x001f) << 11) |
                      ( ((*src >>  5) & 0x001c) << 6) |
                      ( ((*src      ) & 0x001f) << 19) |
                      ( ((*src      ) & 0x001c) << 14) |
					   ((*src & 0x8000) ? 0xff000000 : 0);*/
           *destw++ = ((*src & 0x7c00) >> 7)   // r
                   |  ((*src & 0x03e0) << 6)   // g
                   |  ((*src & 0x001f) << 19) // b
                   |  ((*src & 0x8000) ? 0xff000000 : 0);             // a
           /*
           *destw++ = ((*src & 0x7c00) >> 7)  | ((*src & 0x7c00) >> 12)  // r
                   |  ((*src & 0x03e0) << 6)  | ((*src & 0x0380) << 1)  // g
                   |  ((*src & 0x001f) << 19) | ((*src & 0x001c) << 14)  // b
                   |  ((*src & 0x8000) ? 0xff000000 : 0);             // a*/
           /*if (*src & 0x8000)
           	*destw|=0xf8000000;
           destw++;*/
           //src = (unsigned short *)(data)+x; dest = (unsigned char*)tbuffer +x*4;
           /*
           *dest++  = (((*src >> 10) & 0x001f) << 3) | (((*src >> 10) &
               0x001f) >> 2);
           *dest++ = (((*src >> 5) & 0x001f) << 3) | (((*src >> 5) &
               0x001f) >> 2);
           *dest++ = ((*src & 0x001f) << 3) | ((*src & 0x001f) >> 2);
           *dest++ = ~ ((*src >> 15) & 0x0001);*/
           src++;
       }
    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
    //                      error << "RGB_555" << w <<" " << h << endl;
#else
       src = (unsigned short *)data;
       register unsigned short *destw = (unsigned short *)tbuffer;
       for (x = 0; x < size; x++)
       {
           *destw++=((*src&0x7fff)<<1) | ((*src&0x8000) ? 1 : 0);
           src++;
       }
       texture_type = GL_UNSIGNED_SHORT_5_5_5_1;
#endif
       break;
     }
     case GR_TEXFMT_ARGB_4444:
     {
#if 1
       src = (unsigned short *)data;
       //dest = tbuffer;
       register unsigned long *destw = (unsigned long *)tbuffer;
       for (x = 0; x < size; x++)
       {
           //src = (unsigned short *)(data)+x; dest = (unsigned char*)tbuffer +x*4;
            *destw++=((*src&0xf000)<<16)
             | ((*src&0x0f00)>>4)
             | ((*src&0x00f0)<<8)
             | ((*src&0x000f)<<20);
            /*
            *destw++=((*src&0xf000)<<16)|((*src&0xf000)<<12)
             | ((*src&0x0f00)>>4)|((*src&0x0f00)>>8)
             | ((*src&0x00f0)<<8)|((*src&0x00f0)<<4)
             | ((*src&0x000f)<<20)|((*src&0x000f)<<16);*/


           /**dest++ = (((*src >> 8) & 0x000f) << 4) | ((*src >> 8) & 0xf);
           *dest++ = (((*src >> 4) & 0x000f) << 4) | ((*src >> 4) & 0xf);
           *dest++ = ((*src & 0x000f) << 4) | (*src  & 0xf);
           *dest++ = (((*src >> 12) & 0x000f) << 4) | ((*src >> 12) & 0xf); //a*/
           src++;
       }

    //                      glTexImage2D(GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, tbuffer);
    //                      error << "RGB_4444" << w <<" " << h << endl;
#else
       src = (unsigned short *)data;
       register unsigned short *destw = (unsigned short *)tbuffer;
       for (x = 0; x < size; x++)
       {
           *destw++=((*src&0x0fff)<<4) | ((*src&0xf000)>>12);
           src++;
       }
       texture_type = GL_UNSIGNED_SHORT_4_4_4_4;
#endif
       break;
    }
    default:
    //                      error << "cp format" << endl;
       break;
    }
    int tlod;

    switch (evenOdd)
    {
    case GR_MIPMAPLEVELMASK_BOTH:
       tlod = (thisLod - largeLod);
       break;
    case GR_MIPMAPLEVELMASK_EVEN:
       tlod = ((thisLod - largeLod) / 2) - 1;
       break;
    case GR_MIPMAPLEVELMASK_ODD:
       tlod = (thisLod - 1 - largeLod) / 2;
       break;
    default:
       //error
       break;
    }
	 /*gluBuild2DMipmaps(GL_TEXTURE_2D, GL_RGBA, w, h, texture_format,
      texture_type, texture_buf);*/

    glTexImage2D (GL_TEXTURE_2D, tlod, GL_RGBA, w, h, 0, texture_format,
       texture_type, texture_buf);
    //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    //glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);

    /*SetMipMapMode(nTmu, g_gr_tmu[nTmu].mipmap_mode);
	 grTexClampMode (nTmu, g_gr_tmu[nTmu].s_clampmode, g_gr_tmu[nTmu].t_clampmode);*/

    ptex->info.smallLod = thisLod;
    ptex->info.largeLod = largeLod;
    ptex->info.aspectRatio = aspectRatio;
    ptex->info.format = format;
    ptex->info.data = data;
}

FX_ENTRY void FX_CALL grTexDownloadMipMapLevelPartial (GrChipID_t tmu, FxU32 startAddress,
    GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
    GrTextureFormat_t format, FxU32 evenOdd, void *data,
    int start,
    int end)
{
    TRACEFUNCTION ("grTexDownloadMipMapLevelPartial");

//      WARNING("Not supported yet");
}


FX_ENTRY void FX_CALL ConvertAndDownloadRle (GrChipID_t tmu, FxU32 startAddress,
    GrLOD_t thisLod, GrLOD_t largeLod, GrAspectRatio_t aspectRatio,
    GrTextureFormat_t format, FxU32 evenOdd, FxU8 * bm_data, long bm_h,
    FxU32 u0,
    FxU32 v0,
    FxU32 width,
    FxU32 height,
    FxU32 dest_width,
    FxU32 dest_height,
    FxU16 * tlut)
{
    TRACEFUNCTION ("ConvertAndDownloadRle");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grCheckForRoom (FxI32 n)
{
    TRACEFUNCTION ("grCheckForRoom");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexDownloadTable (GrChipID_t tmu, GrTexTable_t type, void *data)
{
    TRACEFUNCTION ("grTexDownloadTable");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexDownloadTablePartial (GrChipID_t tmu,
    GrTexTable_t type, void *data,
    int start,
    int end)
{
    TRACEFUNCTION ("grTexDownloadTablePartial");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexMipMapMode (GrChipID_t tmu, GrMipMapMode_t mode,
    FxBool lodBlend)
{
    TRACEFUNCTION ("grTexMipMapMode");

    //INT nTmu = grsubGetTmuIndex(tmu);
    //const INT nTmu = 0;
    g_gr_tmu[nTmu].mipmap_mode = mode;

    if (current_texture->mipmap_mode==mode)
    	return;

    current_texture->mipmap_mode = mode;
    SetMipMapMode(nTmu, mode);
}

FX_ENTRY void FX_CALL grTexMultibase (GrChipID_t tmu, FxBool enable)
{
    TRACEFUNCTION ("grTexMultibase");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grTexMultibaseAddress (GrChipID_t tmu,
    GrTexBaseRange_t range, FxU32 startAddress, FxU32 evenOdd, GrTexInfo * info)
{
    TRACEFUNCTION ("grTexMultibaseAddress");

//      WARNING("Not supported yet");
}

/////////////////////////////////////////////////////////////////////////////




