/////////////////////////////////////////////////////////////////////////////
// GliD3D_Antialiasing.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables
/*
#define GLID3D_ANTIALIAS_ENABLE \
	g_gr_pd3ddevice->SetRenderState(D3DRENDERSTATE_ANTIALIAS, D3DANTIALIAS_SORTINDEPENDENT); \
	g_gr_pd3ddevice->SetRenderState(D3DRENDERSTATE_EDGEANTIALIAS, TRUE);

#define GLID3D_ANTIALIAS_DISABLE \
	g_gr_pd3ddevice->SetRenderState(D3DRENDERSTATE_ANTIALIAS, D3DANTIALIAS_NONE); \
	g_gr_pd3ddevice->SetRenderState(D3DRENDERSTATE_EDGEANTIALIAS, FALSE);
*/
#define GLID3D_ANTIALIAS_ENABLE
#define GLID3D_ANTIALIAS_DISABLE

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY void FX_CALL grAADrawLine (const GrVertex * v1, const GrVertex * v2)
{
    TRACEFUNCTION ("grAADrawLine");

    GLID3D_ANTIALIAS_ENABLE
	grDrawLine (v1, v2);
    GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL grAADrawPoint (const GrVertex * pt)
{
    TRACEFUNCTION ("grAADrawPoint");

    GLID3D_ANTIALIAS_ENABLE
	grDrawPoint (pt);
    GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL grAADrawPolygon (const int nverts, const int ilist[], const
    GrVertex vlist[])
{
    TRACEFUNCTION ("grAADrawPolygon");

    GLID3D_ANTIALIAS_ENABLE
	grDrawPolygon (nverts, ilist, vlist);
    GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL grAADrawPolygonVertexList (const int nverts, const
    GrVertex vlist[])
{
    TRACEFUNCTION ("grAADrawPolygonVertexList");

    GLID3D_ANTIALIAS_ENABLE
	grDrawPolygonVertexList (nverts, vlist);
    GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL grAADrawTriangle (const GrVertex * a, const GrVertex
    * b, const GrVertex
    * c,
    FxBool ab_antialias, FxBool bc_antialias, FxBool ca_antialias
)
{
    TRACEFUNCTION ("grAADrawTriangle");

    GLID3D_ANTIALIAS_ENABLE
	grDrawTriangle (a, b, c);
    GLID3D_ANTIALIAS_DISABLE
}

/////////////////////////////////////////////////////////////////////////////
