/////////////////////////////////////////////////////////////////////////////
// GliD3D_Buffer.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables
static const GLfloat f255 = 255.0;

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY void FX_CALL grBufferClear (GrColor_t color, GrAlpha_t alpha, FxU16 depth)
{
    TRACEFUNCTION ("grBufferClear");

    FlushTriangleVertex();
    DWORD cr = grsubConvColor (color);

    glClearColor (DIV255((cr & 0xff0000) >> 16),
      DIV255((cr & 0xff00) >>  8),
      DIV255(cr & 0xff),
      DIV255((cr & 0xff000000) >> 24));

    switch (g_gr_state.depth_buffer_mode)
    {
    case GR_DEPTHBUFFER_DISABLE:
		glClear (GL_COLOR_BUFFER_BIT);
		// Clear back buffer.
		break;
    case GR_DEPTHBUFFER_WBUFFER:
		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		// Clear back buffer and W-buffer.
		break;
    case GR_DEPTHBUFFER_ZBUFFER:
		glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		// Clear back buffer and Z-buffer.
		break;
    }
}

FX_ENTRY int FX_CALL grBufferNumPending (void)
{
    TRACEFUNCTION ("grBufferNumPending");

    // First of all return 0.

    return 0;
}

FX_ENTRY void FX_CALL grBufferSwap (int swap_interval)
{
    TRACEFUNCTION ("grBufferSwap");
    FlushTriangleVertex();

    //glEndList();
    //glCallList(disp_listnum2);
    glFlush ();
    //glFinish ();
    SwapBuffers (g_gr_hDC);
    //glNewList(disp_listnum2, GL_COMPILE);
/*
	if((err=glGetError())!= GL_NO_ERROR) {
        char tmp[2024];
        GLenum err;
		ofstream error("error.txt",ios::out | ios::app, 0); 
		sprintf(tmp, "%s", (char*)gluErrorString(err));
		error << tmp << endl;
		error.close();
	}
*/
}

FX_ENTRY void FX_CALL grRenderBuffer (GrBuffer_t buffer)
{
    TRACEFUNCTION ("grRenderBuffer");
    //

	 if (g_gr_state.render_buffer == buffer)
    	return;
    FlushTriangleVertex();

    g_gr_state.render_buffer = buffer;
    switch (buffer)
    {
    case GR_BUFFER_FRONTBUFFER:
		glDrawBuffer (GL_FRONT);
    	break;
    case GR_BUFFER_BACKBUFFER:
		glDrawBuffer (GL_BACK);
		break;
    }
    //glFlush ();
}

/////////////////////////////////////////////////////////////////////////////
