/////////////////////////////////////////////////////////////////////////////
// GliD3D_Fog.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

#define GLID3D_FOGTABLE_DENSITY_DEPTH	(2.0f)

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY float FX_CALL guFogTableIndexToW (int i)
{
    TRACEFUNCTION ("guFogTableIndexToW");

    return (1.0f - (FLOAT) i / (FLOAT) GR_FOG_TABLE_SIZE) * 256.0f;
}

FX_ENTRY void FX_CALL guFogGenerateExp (GrFog_t * fogtable, float density)
{
    TRACEFUNCTION ("guFogGenerateExp");

    if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;
    density *= GLID3D_FOGTABLE_DENSITY_DEPTH;
    if (density > 1.0f)
		density = 1.0f;

    FLOAT *pfDensity = (FLOAT *) & fogtable[GLID3D_FOGTABLE_DENSITY];

    fogtable[GLID3D_FOGTABLE_MODE] = GLID3D_FOGMODE_EXP;
    fogtable[GLID3D_FOGTABLE_VALIDATE] = GLID3D_FOGTABLE_VALIDATE_VALUE;
    *pfDensity = density;
}

FX_ENTRY void FX_CALL guFogGenerateExp2 (GrFog_t * fogtable, float density)
{
    TRACEFUNCTION ("guFogGenerateExp2");

    if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;
    density *= GLID3D_FOGTABLE_DENSITY_DEPTH;
    if (density > 1.0f)
		density = 1.0f;

    FLOAT *pfDensity = (FLOAT *) & fogtable[GLID3D_FOGTABLE_DENSITY];

    fogtable[GLID3D_FOGTABLE_MODE] = GLID3D_FOGMODE_EXP2;
    fogtable[GLID3D_FOGTABLE_VALIDATE] = GLID3D_FOGTABLE_VALIDATE_VALUE;
    *pfDensity = density;
}

FX_ENTRY void FX_CALL guFogGenerateLinear (GrFog_t * fogtable, float nearZ, float farZ)
{
    TRACEFUNCTION ("guFogGenerateLinear");

    if (g_gr_bFogMode == GLID3D_FOG_OFF)
		return;
    float *pfNearZ = (float *)&fogtable[GLID3D_FOGTABLE_NEARZ];
    float *pfFarZ = (float *)&fogtable[GLID3D_FOGTABLE_FARZ];

    fogtable[GLID3D_FOGTABLE_MODE] = GLID3D_FOGMODE_LINEAR;
    fogtable[GLID3D_FOGTABLE_VALIDATE] = GLID3D_FOGTABLE_VALIDATE_VALUE;
    *pfNearZ = nearZ;
    *pfFarZ = farZ;
}

/////////////////////////////////////////////////////////////////////////////
