/////////////////////////////////////////////////////////////////////////////
// GliD3D_GlideManagement.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"
#include "OpenGLinit.h"
/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements





FX_ENTRY void FX_CALL grGlideInit (void)
{
    TRACEFUNCTION ("grGlideInit");

    ERROROUT ("grGlideInit");
    // Initialize system variables

    g_gr_hWndOld = NULL;
    g_gr_bOpenedWindow = FALSE;
    g_gr_bSplashed = FALSE;
    g_gr_nWidth = 0;
    g_gr_nHeight = 0;
    g_gr_bFullScreen = FALSE;

    g_gr_bNoMultiTextTest = 1;


    g_gr_bMultiTextureAvailable = 0;


    g_gr_nColBuffers = 0;
    g_gr_nAuxBuffers = 0;

    g_gr_nTrianglePerFrame = 0;

}

FX_ENTRY void FX_CALL grGlideShutdown (void)
{
    TRACEFUNCTION ("grGlideShutdown");

    if (g_gr_bOpenedWindow)
    {
		grSstWinClose ();
    }
}

FX_ENTRY void FX_CALL grGlideGetVersion (char version[80])
{
    TRACEFUNCTION ("grGlideGetVersion");
    ERROROUT ("grGlideGetVersion");

    lstrcpy (version, "2.46");
}

FX_ENTRY void FX_CALL grGlideGetState (GrState * state)
{
    TRACEFUNCTION ("grGlideGetState");

    CopyMemory (state, &g_gr_state, sizeof (GLID3D_STATE));
}

FX_ENTRY void FX_CALL grGlideSetState (const GrState * state)
{
    TRACEFUNCTION ("grGlideSetState");
    ERROROUT ("grGlideSetState");

    CopyMemory (&g_gr_state, state, sizeof (GLID3D_STATE));
    grMegaCombineEverythingSetup (true);
    /*grAlphaBlendFunction(g_gr_state.alpha_blend_function_rgb_sf,
       g_gr_state.alpha_blend_function_rgb_df,
       g_gr_state.alpha_blend_function_alpha_sf,
       g_gr_state.alpha_blend_function_alpha_df); */
    grClipWindow (g_gr_state.clip_window_minx,
		g_gr_state.clip_window_miny,
		g_gr_state.clip_window_maxx,
		g_gr_state.clip_window_maxy);
    grCullMode (g_gr_state.cull_mode);
    grFogMode (g_gr_state.fog_mode);
    grDepthBufferMode (g_gr_state.depth_buffer_mode);
    grDepthMask (g_gr_state.depth_mask);
    grAlphaTestFunction (g_gr_state.alpha_test_function);
    grAlphaTestReferenceValue (g_gr_state.alpha_test_reference_value);
    grDepthBufferFunction (g_gr_state.depth_buffer_function);
    grDepthBiasLevel (g_gr_state.depth_bias_level);
    grRenderBuffer (g_gr_state.render_buffer);

}

FX_ENTRY void FX_CALL grGlideShamelessPlug (const FxBool on)
{
    TRACEFUNCTION ("grGlideShamelessPlug");

//      WARNING("Not supported yet");
}

FX_ENTRY void FX_CALL grHints (GrHint_t hintType, FxU32 hintMask)
{
    TRACEFUNCTION ("grHints");

//      WARNING("Not supported yet");
}

/////////////////////////////////////////////////////////////////////////////
