/////////////////////////////////////////////////////////////////////////////
// GliD3D_HiLevelTexture.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY FxBool FX_CALL
  gu3dfGetInfo (const char *filename, Gu3dfInfo * info)
{
    TRACEFUNCTION ("gu3dfGetInfo");

    if (gusub3dfGetInfo (filename, info, NULL))
		return FXTRUE;

    return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  gu3dfLoad (const char *filename, Gu3dfInfo * data)
{
    TRACEFUNCTION ("gu3dfLoad");

    DWORD dwDataOffset = 0;

    if (!gusub3dfGetInfo (filename, data, &dwDataOffset))
	return FXFALSE;

    // Open file
    HANDLE hFile;
    DWORD dwLengthLo, dwLengthHi, dwBytesRead;
    INT nSize = 0;

    if ((hFile = CreateFile (filename, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL)) ==
		INVALID_HANDLE_VALUE)
    {
		return FXFALSE;
    }
    dwLengthLo = GetFileSize (hFile, &dwLengthHi);

    SetFilePointer (hFile, dwDataOffset, NULL, FILE_BEGIN);

    ReadFile (hFile, data->data, data->mem_required, &dwBytesRead, NULL);
    if (dwBytesRead != data->mem_required)
    {
     CloseHandle (hFile);
     return FXFALSE;
    }

    // Close file
    CloseHandle (hFile);

    return FXTRUE;
}

/////////////////////////////////////////////////////////////////////////////
