/////////////////////////////////////////////////////////////////////////////
// GliD3D_linearframebuffer.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY FxBool FX_CALL
  grLfbLock (GrLock_t type, GrBuffer_t buffer, GrLfbWriteMode_t writeMode,
    GrOriginLocation_t origin, FxBool pixelPipeline,
    GrLfbInfo_t * info)
{
    TRACEFUNCTION ("grLfbLock");
    if (writeMode == GR_LFBWRITEMODE_ANY)
		writeMode = GR_LFBWRITEMODE_565;

    if (buffer == GR_BUFFER_DEPTHBUFFER)
    {
		return FXFALSE;
    }
    if (writeMode != GR_LFBWRITEMODE_565)
    {
		return FXFALSE;
    }
    if (origin != GR_ORIGIN_UPPER_LEFT)
    {
		return FXFALSE;
    }

    switch (buffer)
    {
      case GR_BUFFER_FRONTBUFFER:
      {
         break;
      }
      case GR_BUFFER_BACKBUFFER:
      {

         break;
      }
    }

    return FXTRUE;
}

FX_ENTRY FxBool FX_CALL
  grLfbUnlock (GrLock_t type, GrBuffer_t buffer)
{
    TRACEFUNCTION ("grLfbUnlock");

    if (!g_gr_bOpenedWindow)
		return FALSE;

    switch (buffer)
    {
      case GR_BUFFER_FRONTBUFFER:
      {

         break;
      }
      case GR_BUFFER_BACKBUFFER:
      {
         break;
      }
    }

//      TRACE("GliD3D info : Unlocked the Lfb\n");

    return FXTRUE;
}

FX_ENTRY void FX_CALL grLfbConstantAlpha (GrAlpha_t alpha)
{
    TRACEFUNCTION ("grLfbConstantAlpha");

    WARNING ("LFB access not supported yet");
}

FX_ENTRY void FX_CALL grLfbConstantDepth (FxU16 depth)
{
    TRACEFUNCTION ("grLfbConstantDepth");

    WARNING ("LFB access not supported yet");
}

FX_ENTRY void FX_CALL grLfbWriteColorSwizzle (FxBool swizzleBytes, FxBool swapWords)
{
    TRACEFUNCTION ("grLfbWriteColorSwizzle");

    WARNING ("LFB access not supported yet");
}

FX_ENTRY void FX_CALL grLfbWriteColorFormat (GrColorFormat_t colorFormat)
{
    TRACEFUNCTION ("grLfbWriteColorFormat");

    WARNING ("LFB access not supported yet");
}

FX_ENTRY FxBool FX_CALL grLfbWriteRegion (GrBuffer_t dst_buffer, FxU32
    dst_x, FxU32 dst_y, GrLfbSrcFmt_t src_format, FxU32 src_width, FxU32 src_height,
    FxI32 src_stride, void *src_data)

{
    TRACEFUNCTION ("grLfbWriteRegion");

    WARNING ("LFB access not supported yet");
    return FXFALSE;
}

FX_ENTRY FxBool FX_CALL
  grLfbReadRegion (GrBuffer_t src_buffer,
    FxU32 src_x, FxU32 src_y,
    FxU32 src_width, FxU32 src_height,
    FxU32 dst_stride, void *dst_data)
{
    TRACEFUNCTION ("grLfbReadRegion");

    WARNING ("LFB access not supported yet");
    return FXFALSE;
}

/////////////////////////////////////////////////////////////////////////////
