/////////////////////////////////////////////////////////////////////////////
// GliD3D_Render.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

#define GLID3D_ANTIALIAS_ENABLE

#define GLID3D_ANTIALIAS_DISABLE



/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements
#ifdef USEVERTEXARRAY
GLsizei ArrayCount = 0;
GL2IDE_TEXCORD TexCoordArray[MAXVERTEX];
GL2IDE_COLOR ColorArray[MAXVERTEX];
CORD CoordArray[MAXVERTEX];
#endif

/*inline VOID
grsubSetVertexFromGrVertex(VERTEX2 &ptlv, const GrVertex* pv)
{
	if (pv->x < 4096)
		ptlv.cord.x = pv->x;
	else
		ptlv.cord.x = pv->x - (FLOAT)(((DWORD)pv->x) & 0xfffff000);

	if (g_gr_state.origin_location == GR_ORIGIN_UPPER_LEFT) {
		if (pv->y < 4096)
			ptlv.cord.y = pv->y;
		else
			ptlv.cord.y = pv->y - (FLOAT)(((DWORD)pv->y) & 0xfffff000);

	} else {
		if (pv->y < 4096)
			ptlv.cord.y = (FLOAT)g_gr_nHeight - pv->y;
		else
			ptlv.cord.y = (FLOAT)g_gr_nHeight - (FLOAT)(((DWORD)pv->y) & 0xfffff000);

	}
    ptlv.cord.w = 1.0/pv->oow;
	if(g_gr_bUseZInverse)
	{
		if(g_gr_bPrecisionFix)
		{
			if(ptlv.cord.w < 10)
				ptlv.cord.w = 10;

		}
		ptlv.cord.z = 1.0f;
	}
	else
	{
		ptlv.cord.z = -ptlv.cord.w*ptlv.cord.w;
	}

	ptlv.cord.x *= ptlv.cord.w;
	ptlv.cord.y *= ptlv.cord.w;

	switch (g_gr_state.color_combine_local) {
	 case GR_COMBINE_LOCAL_ITERATED:
        CombineLocalIterated(ptlv, pv);
		break;
	 case GR_COMBINE_LOCAL_CONSTANT:
        if ( //g_gr_state.color_combine_function==GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL &&
             g_gr_state.color_combine_factor==GR_COMBINE_FACTOR_TEXTURE_RGB &&
             g_gr_state.color_combine_other==GR_COMBINE_OTHER_ITERATED)
              CombineLocalIterated(ptlv, pv);
        else
		    CombineLocalConstant(ptlv, pv);
        break;
	}

	// set color to (1,1,1) if using texture scaled with factor 1
	// and (0,0,0) if using texture scaled with factor 0
 	if (g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER ||
		g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL )
	{
		if(g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE)
		{
			if(g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ONE)
            {
				ptlv.r = 1;
                ptlv.g = 1;
                ptlv.b = 1;
            } else if(g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_ZERO)
            {
				ptlv.r = 0;
                ptlv.g = 0;
                ptlv.b = 0;
            }
		}
	}

 	if(g_gr_state.alpha_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER &&
		g_gr_state.alpha_combine_other == GR_COMBINE_OTHER_TEXTURE)
	{
		if(g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ONE)
            ptlv.a = 1;
		else if(g_gr_state.alpha_combine_factor == GR_COMBINE_FACTOR_ZERO)
            ptlv.a = 0;
	}


	ptlv.tu = ((pv->tmuvtx[0].sow / pv->oow) + 0.2f) / 256.0;
	ptlv.tv = ((pv->tmuvtx[0].tow / pv->oow) + 0.2f) / 256.0;


    // scale texture coordinates according to aspect ratio
	INT nTmu;

//	nTmu = grsubGetTmuIndex(tmu);
	nTmu = 0;

    int ah, aw;
    grsubAspectToInt(&aw, &ah, g_gr_tmu[nTmu].texture_source_info.aspectRatio);
	ptlv.tu *= ah;
	ptlv.tv *= aw;

} */

FX_ENTRY void FX_CALL grDrawLine (const GrVertex * a, const GrVertex * b)
{
    VERTEX2 ptlv[2];

    TRACEFUNCTION ("grDrawLine");
#ifdef USEVERTEXARRAY
    grsubSetVertexFromGrVertex (ptlv[0].cord, ptlv[0].color, ptlv[0].tcord, a);
	 grsubSetVertexFromGrVertex (ptlv[1].cord, ptlv[1].color, ptlv[1].tcord, b);
#else
    grsubSetVertexFromGrVertex (ptlv[0], a);
	 grsubSetVertexFromGrVertex (ptlv[1], b);
#endif
    glBegin (GL_LINES);
    glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
    glColor4fv ((const GLfloat *)&ptlv[0].color);
    glVertex3fv ((const GLfloat *)&ptlv[0].cord);
    glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
    glColor4fv ((const GLfloat *)&ptlv[1].color);
    glVertex3fv ((const GLfloat *)&ptlv[1].cord);
    glEnd ();

}

FX_ENTRY void FX_CALL grDrawPlanarPolygon (int nverts, const int ilist[], const
    GrVertex vlist[])
{
    TRACEFUNCTION ("grDrawPlannarPolygon");
    ERROROUT ("grDrawPlannarPolygon");

    switch (g_gr_state.origin_location)
    {
    case GR_ORIGIN_UPPER_LEFT:
     {
         break;
     }
    case GR_ORIGIN_LOWER_LEFT:
     {
         break;
     }
    }

}

FX_ENTRY void FX_CALL grDrawPlanarPolygonVertexList (int nverts, const
    GrVertex vlist[])
{
    TRACEFUNCTION ("grPlanarPolygonVertexList");

    switch (g_gr_state.origin_location)
    {
    case GR_ORIGIN_UPPER_LEFT:
     {
         break;
     }
    case GR_ORIGIN_LOWER_LEFT:
     {
         break;
     }
	 }

}

FX_ENTRY void FX_CALL grDrawPoint (const GrVertex * pt)
{
    TRACEFUNCTION ("grDrawPoint");
    ERROROUT ("grDrawPoint");

    switch (g_gr_state.origin_location)
    {
    case GR_ORIGIN_UPPER_LEFT:
		break;
    case GR_ORIGIN_LOWER_LEFT:
		break;
    }
}

FX_ENTRY void FX_CALL grDrawPolygon (int nverts, const int ilist[], const
    GrVertex vlist[])
{
    TRACEFUNCTION ("grDrawPolygon");
    ERROROUT ("grDrawPolygon");

    switch (g_gr_state.origin_location)
    {
    case GR_ORIGIN_UPPER_LEFT:
     {
         break;
     }
    case GR_ORIGIN_LOWER_LEFT:
     {
         break;
     }
    }

}

// Untested
FX_ENTRY void FX_CALL grDrawPolygonVertexList (int nverts, const GrVertex
    vlist[])
{
    static VERTEX2 ptlv;
    register int i;

    TRACEFUNCTION ("grDrawPolygonVertexList");
    ERROROUT ("grDrawPolygonVertexList");

    glBegin (GL_POLYGON);
    if (g_gr_state.origin_location==GR_ORIGIN_UPPER_LEFT)
    {
       for (i = 0; i < nverts; i++)
       {
#ifdef USEVERTEXARRAY
             grsubSetVertexFromGrVertex (ptlv.cord, ptlv.color, ptlv.tcord, &vlist[i]);
#else
             grsubSetVertexFromGrVertex (ptlv, &vlist[i]);
#endif
             glTexCoord2fv ((const GLfloat *)&ptlv.tcord);
             glColor4fv ((const GLfloat *)&ptlv.color);
             glVertex4fv ((const GLfloat *)&ptlv.cord);
       }
    } else
    {
       for (i = nverts - 1; i >= 0; i--)
       {
#ifdef USEVERTEXARRAY
             grsubSetVertexFromGrVertex (ptlv.cord, ptlv.color, ptlv.tcord, &vlist[i]);
#else
             grsubSetVertexFromGrVertex (ptlv, &vlist[i]);
#endif
             glTexCoord2fv ((const GLfloat *)&ptlv.tcord);
             glColor4fv ((const GLfloat *)&ptlv.color);
             glVertex4fv ((const GLfloat *)&ptlv.cord);
       }
    }
    glEnd ();
}




#ifdef USEVERTEXARRAY
FX_ENTRY void FX_CALL grDrawTriangle (const GrVertex * a, const GrVertex *
	 b, const GrVertex * c)
{
	 TRACEFUNCTION ("grDrawTriangle");
    if (!g_gr_DrawingTriangles)
    {
   	ArrayCount=0;
       g_gr_DrawingTriangles = TRUE;
    }
    grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
      ColorArray[ArrayCount], TexCoordArray[ArrayCount], c);
    ArrayCount++;
    grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
      ColorArray[ArrayCount], TexCoordArray[ArrayCount], b);
    ArrayCount++;
    grsubSetVertexFromGrVertex(CoordArray[ArrayCount],
      ColorArray[ArrayCount], TexCoordArray[ArrayCount], a);
    ArrayCount++;
    if (ArrayCount==MAXVERTEX)
    	FlushTriangleVertex();
}

#else
static const GLfloat white_color[4] = {1,1,1,1};

FX_ENTRY void FX_CALL grDrawTriangle (const GrVertex * a, const GrVertex *
	 b, const GrVertex * c)
{
	 static VERTEX2 ptlv[3];
    bool TwoPass = g_gr_state.color_combine_function == GR_COMBINE_FUNCTION_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL &&
		g_gr_state.color_combine_factor == GR_COMBINE_FACTOR_TEXTURE_ALPHA &&
		g_gr_state.color_combine_local == GR_COMBINE_LOCAL_ITERATED &&
		g_gr_state.color_combine_other == GR_COMBINE_OTHER_TEXTURE;

	 TRACEFUNCTION ("grDrawTriangle");
	 if (TwoPass)
	 {
    	FlushTriangleVertex();
		BOOL OldTexture2DOn = g_gr_Texture2DOn;
       g_gr_Texture2DOn = true;
       ChooseVertexFunc();
		g_gr_Texture2DOn = OldTexture2DOn;
    }
    
	 if (g_gr_state.origin_location==GR_ORIGIN_UPPER_LEFT)
	 {
       grsubSetVertexFromGrVertex (ptlv[0], a);
       grsubSetVertexFromGrVertex (ptlv[1], b);
       grsubSetVertexFromGrVertex (ptlv[2], c);
	 } else
	 {
		grsubSetVertexFromGrVertex (ptlv[0], c);
		grsubSetVertexFromGrVertex (ptlv[1], b);
		grsubSetVertexFromGrVertex (ptlv[2], a);
	 }
    // Draw

    // 2 passes needed to acomplish this method
    if (TwoPass)
    {
       if (g_gr_Texture2DOn)
			glDisable (GL_TEXTURE_2D);
		glDepthMask (FALSE);

		glBegin (GL_TRIANGLES);
		glColor4fv ((const GLfloat*)&ptlv[0].color);
		glVertex4fv ((const GLfloat*)&ptlv[0].cord);

		glColor4fv ((const GLfloat*)&ptlv[1].color);
		glVertex4fv ((const GLfloat*)&ptlv[1].cord);

		glColor4fv ((const GLfloat*)&ptlv[2].color);
		glVertex4fv ((const GLfloat*)&ptlv[2].cord);

		glEnd ();

       glEnable (GL_TEXTURE_2D);
		glDepthMask (g_gr_state.depth_mask);
		BOOL glblendon = glIsEnabled (GL_BLEND);
       if (!glblendon)
			glEnable (GL_BLEND);

		glBegin (GL_TRIANGLES);
		glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
		glColor4fv ((const GLfloat*)&white_color);
		glVertex4fv ((const GLfloat*)&ptlv[0].cord);

		glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
		glVertex4fv ((const GLfloat*)&ptlv[1].cord);

		glTexCoord2fv ((const GLfloat *)&ptlv[2].tcord);
		glVertex4fv ((const GLfloat*)&ptlv[2].cord);
		glEnd ();

		if (!glblendon)
			glDisable (GL_BLEND);
		if (!g_gr_Texture2DOn)
		   glDisable(GL_TEXTURE_2D);
	}
	else
	{
#ifndef CACHETRIANGLES
   	glBegin (GL_TRIANGLES);
#ifdef OPTIMIZE_TEXTURE2D
       if (!g_gr_Texture2DOn)
       {
       	glColor4fv ((const GLfloat*)&ptlv[0].color);
       	glVertex4fv ((const GLfloat*)&ptlv[0].cord);

       	glColor4fv ((const GLfloat*)&ptlv[1].color);
       	glVertex4fv ((const GLfloat*)&ptlv[1].cord);

       	glColor4fv ((const GLfloat*)&ptlv[2].color);
       	glVertex4fv ((const GLfloat*)&ptlv[2].cord);
       } else
#endif
       {
         	glTexCoord2fv ((const GLfloat *)&ptlv[0].tcord);
           glColor4fv ((const GLfloat*)&ptlv[0].color);
           glVertex4fv ((const GLfloat*)&ptlv[0].cord);

           glTexCoord2fv ((const GLfloat *)&ptlv[1].tcord);
           glColor4fv ((const GLfloat*)&ptlv[1].color);
           glVertex4fv ((const GLfloat*)&ptlv[1].cord);

           glTexCoord2fv ((const GLfloat *)&ptlv[2].tcord);
           glColor4fv ((const GLfloat*)&ptlv[2].color);
           glVertex4fv ((const GLfloat*)&ptlv[2].cord);
		}
		glEnd ();
#else
		AddTriangleVertex(ptlv);
#endif
	}
}
#endif

FX_ENTRY void FX_CALL guAADrawTriangleWithClip (const GrVertex * a, const GrVertex
	 * b, const GrVertex * c)
{
	 TRACEFUNCTION ("guAADrawTriangleWithClip");

	 GLID3D_ANTIALIAS_ENABLE
	 guDrawTriangleWithClip (a, b, c);
	 GLID3D_ANTIALIAS_DISABLE
}

FX_ENTRY void FX_CALL guDrawTriangleWithClip (const GrVertex * a,
	 const GrVertex * b,
	 const GrVertex * c
)
{
	 grDrawTriangle (a, b, c);
}

FX_ENTRY void FX_CALL guDrawPolygonVertexListWithClip (int nverts, const
	 GrVertex vlist[])
{
	 TRACEFUNCTION ("guDrawPolygonVertexListWithClip");
	 ERROROUT ("guDrawPolygonVertexListWithClip");
	 grDrawPolygonVertexList (nverts, vlist);
}

/////////////////////////////////////////////////////////////////////////////


