/////////////////////////////////////////////////////////////////////////////
// GliD3D_Sub.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"
#include "GliD3D_Sub.h"

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

/////////////////////////////////////////////////////////////////////////////
// Implements

BOOL
gusub3dfGetInfo (LPCSTR filename, Gu3dfInfo * info, LPDWORD pdwDataOffset)
{
    CHAR pBuf[256];
    CHAR *pnt;


    // Open file
    HANDLE hFile;
    DWORD dwLengthLo, dwLengthHi, dwBytesRead;
    INT nSize = 0;

    if ((hFile = CreateFile (filename, GENERIC_READ, FILE_SHARE_READ, NULL,
		OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL)) == INVALID_HANDLE_VALUE)
    {
		return FALSE;
    }
    dwLengthLo = GetFileSize (hFile, &dwLengthHi);


    // Valivate Header strings
    ZeroMemory (pBuf, sizeof (pBuf));
    ReadFile (hFile, pBuf, 9, &dwBytesRead, NULL);
    pBuf[8] = '\x0';
    if (strnicmp (pBuf, "3df v", 5) != 0)
    {
       CloseHandle (hFile);
       return FALSE;
    }
    nSize += 9;


    // Read FORMAT
    pnt = pBuf;
    for (;;)
    {
       ReadFile (hFile, pnt, 1, &dwBytesRead, NULL);
       if (*pnt == '\x0a')
       {
           *pnt = '\x00';
           nSize++;
           break;
       }
       pnt++;
       nSize++;
    }

    GrTextureFormat_t format;

    if (stricmp (pBuf, "yiq") == 0)
    {
       // Not supported yet
       format = GR_TEXFMT_YIQ_422;
       //format = -1;
    }
    else if (stricmp (pBuf, "p8") == 0)
    {
       // Not supported yet
       format = GR_TEXFMT_P_8;
    }
    else if (stricmp (pBuf, "alpha8") == 0)
    {
       // Not supported yet
       //format = GR_TEXFMT_ALPHA_8;
       format = -1;
    }
    else if (stricmp (pBuf, "i8") == 0)
    {
       // Not supported yet
       //format = GR_TEXFMT_INTENSITY_8;
       format = -1;
    }
    else if (stricmp (pBuf, "ai44") == 0)
    {
		// Not supported yet
		//format = GR_TEXFMT_ALPHA_INTENSITY_44;
		format = -1;
    }
    else if (stricmp (pBuf, "rgb565") == 0)
    {
		// Not supported yet
		format = GR_TEXFMT_RGB_565;
    }
    else if (stricmp (pBuf, "argb8332") == 0)
    {
		// Not supported yet
		//format = GR_TEXFMT_ARGB_8332;
		format = -1;
    }
    else if (stricmp (pBuf, "argb1555") == 0)
    {
		// Not supported yet
		format = GR_TEXFMT_ARGB_1555;
    }
    else if (stricmp (pBuf, "argb4444") == 0)
    {
		// Not supported yet
		format = GR_TEXFMT_ARGB_4444;
    }
    else if (stricmp (pBuf, "ayiq8422") == 0)
    {
     // Not supported yet
     format = GR_TEXFMT_AYIQ_8422;
     //format = -1;
    }
    else if (stricmp (pBuf, "ai88") == 0)
    {
     // Not supported yet
     //format = GR_TEXFMT_ALPHA_INTENSITY_88;
     format = -1;
    }
    if (format == -1)
    {
		CloseHandle (hFile);
		return FALSE;
    }


    // Read LOD RANGE
    pnt = pBuf;
    for (;;)
    {
       ReadFile (hFile, pnt, 1, &dwBytesRead, NULL);
       if (*pnt == '\x0a')
       {
           *pnt = '\x00';
           nSize++;
           break;
       }
       pnt++;
       nSize++;
    }
    if (strnicmp (pBuf, "lod range:", 10) != 0)
    {
		CloseHandle (hFile);
		return FALSE;
    }

    INT nSmallLod, nLargeLod;
    GrLOD_t small_lod, large_lod;

    sscanf (pBuf + 10, "%d %d", &nSmallLod, &nLargeLod);

    small_lod = grsubIntToLod (nSmallLod);
    large_lod = grsubIntToLod (nLargeLod);


    // Read ASPECT RATIO
    pnt = pBuf;
    for (;;)
    {
       ReadFile (hFile, pnt, 1, &dwBytesRead, NULL);
       if (*pnt == '\x0a')
       {
           *pnt = '\x00';
           nSize++;
           break;
       }
       pnt++;
       nSize++;
    }
    if (strnicmp (pBuf, "aspect ratio:", 13) != 0)
    {
       CloseHandle (hFile);
       return FALSE;
    }

    INT nAspectW, nAspectH;
    GrAspectRatio_t aspect_ratio;

    sscanf (pBuf + 13, "%d %d", &nAspectW, &nAspectH);

    grsubIntToAspect (aspect_ratio, nAspectW, nAspectH);


    // Close file
    CloseHandle (hFile);

    // Set parameter
    info->header.width = nLargeLod * nAspectW;
    info->header.height = nLargeLod * nAspectH;
    info->header.small_lod = small_lod;
    info->header.large_lod = large_lod;
    info->header.aspect_ratio = aspect_ratio;
    info->header.format = format;
    info->mem_required = dwLengthLo - nSize;


    if (pdwDataOffset)
    {
		*pdwDataOffset = nSize;
    }

    return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
