/////////////////////////////////////////////////////////////////////////////
// GliD3D_UtilityTexture.cpp : No comment
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// Directive

#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"
#include <map>

/////////////////////////////////////////////////////////////////////////////
// Defines / Variables

/////////////////////////////////////////////////////////////////////////////
// Prototypes

#define nTmu 0
static GL2IDE_TEXTURE tlookup[GLID3D_TEXMAXADDRESS + 256];

GL2IDE_TEXTURE *current_texture = &tlookup[0];

void SetCurrentTexture(FxU32 StartAddress)
{
	current_texture=&tlookup[StartAddress];
   g_gr_tmu[nTmu].texture_source_start_address = StartAddress;
} 
/////////////////////////////////////////////////////////////////////////////
// Implements

FX_ENTRY GrMipMapId_t FX_CALL
  guTexAllocateMemory (
    GrChipID_t tmu,
    FxU8 odd_even_mask,
    int width, int height,
    GrTextureFormat_t fmt,
    GrMipMapMode_t mm_mode,
    GrLOD_t smallest_lod, GrLOD_t largest_lod,
    GrAspectRatio_t aspect,
    GrTextureClampMode_t s_clamp_mode,
    GrTextureClampMode_t t_clamp_mode,
    GrTextureFilterMode_t minfilter_mode,
    GrTextureFilterMode_t magfilter_mode,
    float lod_bias,
    FxBool trilinear
)
{
    TRACEFUNCTION ("guTexAllocateMemory");

    return 0;
}

FX_ENTRY FxBool FX_CALL
  guTexChangeAttributes (
    GrMipMapId_t mmid,
    int width, int height,
    GrTextureFormat_t fmt,
    GrMipMapMode_t mm_mode,
    GrLOD_t smallest_lod, GrLOD_t largest_lod,
    GrAspectRatio_t aspect,
    GrTextureClampMode_t s_clamp_mode,
    GrTextureClampMode_t t_clamp_mode,
    GrTextureFilterMode_t minFilterMode,
    GrTextureFilterMode_t magFilterMode
)
{
    TRACEFUNCTION ("guTexChangeAttributes");

    return FXTRUE;
}

FX_ENTRY void FX_CALL guTexCombineFunction (GrChipID_t tmu,
    GrTextureCombineFnc_t fnc)
{
    TRACEFUNCTION ("guTexCombineFunction");

    grTexCombineFunction (tmu, fnc);
}

FX_ENTRY GrMipMapId_t FX_CALL guTexGetCurrentMipMap (GrChipID_t tmu)
{
    TRACEFUNCTION ("guTexGetCurrentMipMap");

    return 0;
}

FX_ENTRY GrMipMapInfo *FX_CALL
  guTexGetMipMapInfo (GrMipMapId_t mmid)
{
    TRACEFUNCTION ("guTexGetMipMapInfo");

    return 0;
}

FX_ENTRY FxU32 FX_CALL
  guTexMemQueryAvail (GrChipID_t tmu)
{
    TRACEFUNCTION ("guTexMemQueryAvail");

    return 0;
}

FX_ENTRY void FX_CALL guTexMemReset (void)
{
    TRACEFUNCTION ("guTexMemReset");

}

FX_ENTRY void FX_CALL guTexDownloadMipMap (GrMipMapId_t mmid, const void *src,
    const GuNccTable * table
)
{
    TRACEFUNCTION ("guTexDownloadMipMap");

}

FX_ENTRY void FX_CALL guTexDownloadMipMapLevel (GrMipMapId_t mmid, GrLOD_t
    lod, const void **src
)
{
    TRACEFUNCTION ("guTexDownloadMipMapLevel");

}

FX_ENTRY void FX_CALL guTexSource (GrMipMapId_t id)
{
    TRACEFUNCTION ("guTexSource");

}

/////////////////////////////////////////////////////////////////////////////
