/* Setting up the OpenGL screen
*/
#include "StdHdr.h"
#pragma hdrstop
#include "GliD3D.h"


HPALETTE hPalette = 0;		/* custom palette (if needed) */
GLboolean animate = GL_TRUE;	/* animation flag */


/* 
Created in an attempt to emulate multiple texture units, saved for later use
BOOL GetGLProcs(){
    char *strExtensions;
	int ntu;
    strExtensions = (char*)glGetString(GL_EXTENSIONS);
    if (strstr(strExtensions, "GL_ARB_multitexture") == 0) {
		return FALSE; 
	}
	glGetIntegerv(GL_MAX_TEXTURES_UNITS_ARB, &ntu);
	if( ntu < 2)
		return FALSE;

    glActiveTextureARB         = (PFNGLACTIVETEXTUREARBPROC)wglGetProcAddress("glActiveTextureARB");
    glMultiTexCoord2fARB       = (PFNGLMULTITEXCOORD2FARBPROC)wglGetProcAddress("glMultiTexCoord2fARB");
	return TRUE;
}
*/
LONG WINAPI WindowProc (HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
      case WM_CREATE:
         return 0;
      case WM_DESTROY:
      case WM_CLOSE:
      case WM_QUIT:
         PostQuitMessage (0);
         return 0;
      case WM_MOVE:
      case WM_SIZE:
      	  break;
      default:
         PostMessage (g_gr_hWndOld, uMsg, wParam, lParam);
         break;
    }
    return DefWindowProc (hWnd, uMsg, wParam, lParam);
}

HWND
CreateOpenGLWindow (HWND Parent_hWnd, char *title, int x, int y, int width, int height,
    BYTE type, DWORD flags)
{
    int n, pf;
    int fullscreen = 0;
    HWND hWnd;
    char buf[1024];
    WNDCLASS wc;
    PIXELFORMATDESCRIPTOR pfd;
    static HINSTANCE hInstance = 0;


    if (g_gr_bFullScreen)
    {
	// Change the display to correct resolution
       DEVMODE dm;
       long res;
       int bestchoise = -1, i, mindiff = 10000, found16bit = 0;

       fullscreen = 1;
       dm.dmSize = sizeof (DEVMODE);

       for (i = 0; EnumDisplaySettings (NULL, i, &dm) != FALSE; i++)
       {
           if (dm.dmPelsWidth == width && dm.dmPelsHeight == height)
           {
             if (dm.dmBitsPerPel == 32 && found16bit == 0)
             {
                 if (abs (dm.dmDisplayFrequency - 65) < mindiff)
                 {
                   mindiff = abs (dm.dmDisplayFrequency - 65);
                   bestchoise = i;
                 }
             }
             else if (dm.dmBitsPerPel == 16)
             {
                 if (dm.dmDisplayFrequency == 0 || dm.dmDisplayFrequency == 1)
                 {
                   bestchoise = i;
                   break;
                 }
                 found16bit = 1;

                 if (abs (dm.dmDisplayFrequency - 65) < mindiff)
                 {
                   mindiff = abs (dm.dmDisplayFrequency - 65);
                   bestchoise = i;
                 }
             }
           }
       }

       EnumDisplaySettings (NULL, bestchoise, &dm);
       if ((res = ChangeDisplaySettings (&dm, 0)) != DISP_CHANGE_SUCCESSFUL)
       {
           dm.dmBitsPerPel = 32;
           if ((res = ChangeDisplaySettings (&dm, CDS_FULLSCREEN)) != DISP_CHANGE_SUCCESSFUL)
           {
                 switch (res)
                 {
                 case DISP_CHANGE_RESTART:
                     ERROROUT ("Display change error: DISP_CHANGE_RESTART");
                     break;
                 case DISP_CHANGE_BADFLAGS:
                     ERROROUT ("Display change error: DISP_CHANGE_BADFLAGS");
                     break;
                 case DISP_CHANGE_BADMODE:
                     ERROROUT ("Display change error: DISP_CHANGE_BADMODE");
                     break;
                 case DISP_CHANGE_FAILED:
                     ERROROUT ("Display change error: DISP_CHANGE_FAILED");
                     break;
                 }
             fullscreen = 0;
           }
       }
    }
    /* only register the window class once - use hInstance as a flag. */
    if (!hInstance)
    {
       hInstance = GetModuleHandle (NULL);
       wc.style = CS_OWNDC;
       wc.lpfnWndProc = (WNDPROC) WindowProc;
       wc.cbClsExtra = 0;
       wc.cbWndExtra = 0;
       wc.hInstance = hInstance;
       wc.hIcon = LoadIcon (NULL, IDI_WINLOGO);
       wc.hCursor = LoadCursor (NULL, IDC_ARROW);
       wc.hbrBackground = NULL;
       wc.lpszMenuName = NULL;
       wc.lpszClassName = "OpenGL";

       if (!RegisterClass (&wc))
       {
           MessageBox (NULL, "RegisterClass() failed:  "
           "Cannot register window class.", "Error", MB_OK);
           return NULL;
       }
    }

    if (fullscreen)
    {
       hWnd = CreateWindowEx (WS_EX_TOPMOST, "OpenGL", title, WS_POPUP |	// WS_OVERLAPPEDWINDOW |
           WS_CLIPSIBLINGS | WS_CLIPCHILDREN | WS_DISABLED,
           x, y, width, height, NULL, NULL, hInstance, NULL);
       ShowCursor (FALSE);
    }
    else
    {
       hWnd = CreateWindowEx (WS_EX_TOPMOST,  "OpenGL", title,
           WS_CHILD | WS_CLIPSIBLINGS | WS_DISABLED | WS_GROUP,
           x, y, width, height, Parent_hWnd, NULL, hInstance, NULL);
       // UltraHLE hack
       SetWindowPos(Parent_hWnd, NULL, -1, -1, width, height+77, SWP_NOMOVE | SWP_NOZORDER);
    }
    if (hWnd == NULL)
    {
       MessageBox (NULL, "CreateWindow() failed:  Cannot create a window.",
           "Error", MB_OK);
       return NULL;
    }


    g_gr_hDC = GetDC (hWnd);

    /* there is no guarantee that the contents of the stack that become
       the pfd are zeroed, therefore _make sure_ to clear these bits. */

    memset (&pfd, 0, sizeof (pfd));
    pfd.nSize = sizeof (pfd);
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | PFD_SUPPORT_OPENGL | flags;
    pfd.iPixelType = type;
    pfd.cColorBits = 16;
    pfd.cDepthBits = 32;


    pf = ChoosePixelFormat (g_gr_hDC, &pfd);
    if (pf == 0)
    {
       pfd.cColorBits = 32;
       pf = ChoosePixelFormat (g_gr_hDC, &pfd);
       if (pf == 0)
       {
           MessageBox (NULL, "ChoosePixelFormat() failed:  "
           "Cannot find a suitable pixel format.", "Error", MB_OK);
           return 0;
       }
    }

    if (SetPixelFormat (g_gr_hDC, pf, &pfd) == FALSE)
    {
       MessageBox (NULL, "SetPixelFormat() failed:  "
           "Cannot set format specified.", "Error", MB_OK);
		return 0;
    }

    DescribePixelFormat (g_gr_hDC, pf, sizeof (PIXELFORMATDESCRIPTOR), &pfd);

    ReleaseDC (hWnd, g_gr_hDC);

    return hWnd;
}
