#include "stdafx.h"

extern COLORCOMBINE colorCombine;
extern CONSTANTCOLOR constantColor;
extern TEXCOMBINE texCombine;
extern ALPHACOMBINE alphaCombine;
extern BLEND blend;
extern GLenum glFunc;
extern DEPTHINFO depthInfo;

extern int texWidth, texHeight;
extern FxU32 curStartAddress;
extern GrTexInfo curTexInfo;
extern GLbyte texMem[4 * 1024 * 1024];
extern int mode;

float ar, ag, ab, aa, aw, ax, ay, az, as, at;
float br, bg, bb, ba, bw, bx, by, bz, bs, bt;
float cr, cg, cb, ca, cw, cx, cy, cz, cs, ct;

void displayAlphaInfo(void)
{
   char string[256];
   char d[256];

   strcpy(string, "grAlphaCombine\n");
   strcat(string, itoa(alphaCombine.func, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(alphaCombine.factor, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(alphaCombine.local, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(alphaCombine.other, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(alphaCombine.invert, d, 10));

   MessageBox(NULL, string, "Notice", MB_APPLMODAL);
}

extern "C" __declspec(dllexport)
void grDrawTriangle(const GrVertex *a, const GrVertex *b, const GrVertex *c)
{
   /*static total = 0;
   static int modeCount[16] = {0, 0, 0, 0, 0, 
                               0, 0, 0, 0, 0, 
                               0, 0, 0, 0, 0, 0};
   modeCount[mode]++;
   total++;
   if(total == 1000000)
   {
      char string[256];
      char d[256];
      strcpy(string, "count\n");
      for(int i = 0; i < 16; i++)
      {
         strcat(string, itoa(modeCount[i], d, 10));
         strcat(string, "\n");
      }
      MessageBox(NULL, string, "Notice", MB_APPLMODAL);
   }*/

   static int lastMode = -2;

   ar = a->r / 255.0f;
   ag = a->g / 255.0f;
   ab = a->b / 255.0f;
   aa = a->a / 255.0f;
   aw = 1.0f / a->oow;
   ax = a->x * aw;
   ay = a->y * aw;
   az = ((*(unsigned long*)&aw >> 11) - (127 << 12)) / 65535.0f * aw;
   as = (a->tmuvtx[0].sow * aw) / texWidth;
   at = (a->tmuvtx[0].tow * aw) / texHeight;

   br = b->r / 255.0f;
   bg = b->g / 255.0f;
   bb = b->b / 255.0f;
   ba = a->a / 255.0f;
	bw = 1.0f / b->oow;
   bx = b->x * bw;
   by = b->y * bw;
   bz = ((*(unsigned long*)&bw >> 11) - (127 << 12)) / 65535.0f * bw;
   bs = (b->tmuvtx[0].sow * bw) / texWidth;
   bt = (b->tmuvtx[0].tow * bw) / texHeight;
	
   cr = c->r / 255.0f;
   cg = c->g / 255.0f;
   cb = c->b / 255.0f;
   ca = a->a / 255.0f;
   cw = 1.0f / c->oow;
   cx = c->x * cw;
   cy = c->y * cw;
   cz = ((*(unsigned long*)&cw >> 11) - (127 << 12)) / 65535.0f * cw;
   cs = (c->tmuvtx[0].sow * cw) / texWidth;
   ct = (c->tmuvtx[0].tow * cw) / texHeight;

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 3)
   {
      if(lastMode == mode)
      {
         glDisable(GL_ALPHA_TEST);//hack for zelda
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
         if(glFunc != GL_ALWAYS) glEnable(GL_ALPHA_TEST);//hack
      }
      else
      {
         glDisable(GL_ALPHA_TEST);//hack for zelda
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
         if(glFunc != GL_ALWAYS) glEnable(GL_ALPHA_TEST);//hack
      }
   } else
      
   if(mode == 10)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         glDisable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else

   

   if(mode == 1)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else
      
      
   if(mode == 0)
   {
      if(lastMode == mode)
      {
         glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
         glBegin(GL_TRIANGLES);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
      else
      {
         glEnable(GL_TEXTURE_2D);
         glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
         glBegin(GL_TRIANGLES);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
   } else
/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////

   if(mode == 2)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else
   
   if(mode == 4)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, constantColor.a);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

		      glColor4f(br, bg, bb, constantColor.a);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, constantColor.a);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
      else
      {
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, constantColor.a);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);

		      glColor4f(br, bg, bb, constantColor.a);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, constantColor.a);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
   } else

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////

   if(mode == 5)
   {
      if(lastMode == mode)
      {
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         //zelda press start
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         //zelda press start
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else

   if(mode == 6)
   {
      if(lastMode == mode)
      {
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         //zelda letters (entering name)
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         //zelda letters (entering name)
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else

   if(mode == 7)
   {
      if(lastMode == mode)
      {
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         glDisable(GL_TEXTURE_2D);
         ar = br = cr = constantColor.r;
         ag = bg = cg = constantColor.g;
         ab = bb = cb = constantColor.b;

         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else


/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 8)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         //zelda press start (not quite right)
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, aa);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, ba);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, ca);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else

   if(mode == 9)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         //zelda letters (entering name)
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
		      glColor4f(ar, ag, ab, 1.0f);
            glTexCoord2f(as, at);
		      glVertex4f(ax, ay, az, aw);
		      
		      glColor4f(br, bg, bb, 1.0f);
            glTexCoord2f(bs, bt);
		      glVertex4f(bx, by, bz, bw);

		      glColor4f(cr, cg, cb, 1.0f);
            glTexCoord2f(cs, ct);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   } else

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 11)
   {
      glDisable(GL_BLEND);
      glEnable(GL_TEXTURE_2D);
      glBegin(GL_TRIANGLES);
		   glColor4f(constantColor.r - ar, constantColor.g - ag, constantColor.g - ab, aa);
         glTexCoord2f(as, at);
		   glVertex4f(ax, ay, az, aw);
		   
		   glColor4f(constantColor.r - br, constantColor.g - bg, constantColor.g - bb, ba);
         glTexCoord2f(bs, bt);
		   glVertex4f(bx, by, bz, bw);

		   glColor4f(constantColor.r - cr, constantColor.g - cg, constantColor.g - cb, ca);
         glTexCoord2f(cs, ct);
		   glVertex4f(cx, cy, cz, cw);
	   glEnd();
      glDisable(GL_TEXTURE_2D);
      glEnable(GL_BLEND);
      glBlendFunc(GL_ONE, GL_ONE);
      glBegin(GL_TRIANGLES);
		   glColor4f(ar, ag, ab, aa);
		   glVertex4f(ax, ay, az, aw);
		   
		   glColor4f(br, bg, bb, ba);
		   glVertex4f(bx, by, bz, bw);

		   glColor4f(cr, cg, cb, ca);
		   glVertex4f(cx, cy, cz, cw);
	   glEnd();
      if(!blend.enabled) glDisable(GL_BLEND);
      glBlendFunc(blend.rgb_sf, blend.rgb_df);
   } else

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 12)
   {
      if(lastMode == mode)
      {
	      glColor4f(0.0f, 0.0f, 0.0f, 0.0f);
         glBegin(GL_TRIANGLES);
		      glVertex4f(ax, ay, az, aw);
		      glVertex4f(bx, by, bz, bw);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
      else
      {
         glDisable(GL_TEXTURE_2D);
	      glColor4f(0.0f, 0.0f, 0.0f, 0.0f);
         glBegin(GL_TRIANGLES);
		      glVertex4f(ax, ay, az, aw);
		      glVertex4f(bx, by, bz, bw);
		      glVertex4f(cx, cy, cz, cw);
         glEnd();
      }
   } else

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 13)
   {
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ZERO);
      glEnable(GL_TEXTURE_2D);
      glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
      glBegin(GL_TRIANGLES);
         glTexCoord2f(as, at);
		   glVertex4f(ax, ay, az, aw);

         glTexCoord2f(bs, bt);
		   glVertex4f(bx, by, bz, bw);

         glTexCoord2f(cs, ct);
		   glVertex4f(cx, cy, cz, cw);
      glEnd();
      glDisable(GL_TEXTURE_2D);
      if(!blend.enabled) glDisable(GL_BLEND);
      glBlendFunc(blend.rgb_sf, blend.rgb_df);
   } else

/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 14)
   {
      //mario's face
      glDisable(GL_TEXTURE_2D);
      glDisable(GL_BLEND);
      glBegin(GL_TRIANGLES);
		   glColor4f(ar, ag, ab, aa);
		   glVertex4f(ax, ay, az, aw);

		   glColor4f(br, bg, bb, ba);
		   glVertex4f(bx, by, bz, bw);

		   glColor4f(cr, cg, cb, ca);
		   glVertex4f(cx, cy, cz, cw);
      glEnd();
      glEnable(GL_TEXTURE_2D);
      glEnable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	   glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
      glBegin(GL_TRIANGLES);
         glTexCoord2f(as, at);
		   glVertex4f(ax, ay, az, aw);

         glTexCoord2f(bs, bt);
		   glVertex4f(bx, by, bz, bw);

         glTexCoord2f(cs, ct);
		   glVertex4f(cx, cy, cz, cw);
      glEnd();
      glDisable(GL_TEXTURE_2D);
      if(!blend.enabled) glDisable(GL_BLEND);
      glBlendFunc(blend.rgb_sf, blend.rgb_df);
   } else
 
/////////////////////////////////////
/////////////////////////////////////
/////////////////////////////////////
   if(mode == 15)
   {
      if(lastMode == mode)
      {
         glBegin(GL_TRIANGLES);
            glTexCoord2f(as, at);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
            glTexCoord2f(bs, bt);
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

            glTexCoord2f(cs, ct);
		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
      else
      {
         glEnable(GL_TEXTURE_2D);
         glBegin(GL_TRIANGLES);
            glTexCoord2f(as, at);
		      glColor4f(ar, ag, ab, aa);
		      glVertex4f(ax, ay, az, aw);
		      
            glTexCoord2f(bs, bt);
		      glColor4f(br, bg, bb, ba);
		      glVertex4f(bx, by, bz, bw);

            glTexCoord2f(cs, ct);
		      glColor4f(cr, cg, cb, ca);
		      glVertex4f(cx, cy, cz, cw);
	      glEnd();
      }
   }

   lastMode = mode;

   /*glBegin(GL_TRIANGLES);
		glColor3f(1.0f, 0.0f, 0.0f);
		glVertex4f(ax, ay, az, aw);

		glColor3f(0.0f, 1.0f, 0.0f);
		glVertex4f(bx, by, bz, bw);

		glColor3f(0.0f, 0.0f, 1.0f);
		glVertex4f(cx, cy, cz, cw);
   glEnd();

   char string[256];
   char d[256];
   strcpy(string, "grColorCombine\n");
   strcat(string, itoa(colorCombine.func, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(colorCombine.factor, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(colorCombine.local, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(colorCombine.other, d, 10));
   strcat(string, "\n");
   strcat(string, itoa(colorCombine.invert, d, 10));
   MessageBox(NULL, string, "Notice", MB_APPLMODAL);
   
   //MessageBox(NULL, "grDrawTriangle", "Notice", MB_APPLMODAL);*/
}