// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"



XGLLINK void XGLCALL grCullMode(uint32 mode) {
	vlog("Called grCullMode: mode=" << mode);
	int dwCull;

	_exebuffer->Flush();

	switch(mode) {
	case XGLCULL_NONE:
		dwCull = D3DCULL_NONE;
		break;
	case XGLCULL_CCW:
		dwCull = D3DCULL_CCW;
		break;
	case XGLCULL_CW:
		dwCull = D3DCULL_CW;
		break;
	default:
		dwCull = XGLCULL_NONE;
  }
  if(DX.D3DD->SetRenderState(D3DRENDERSTATE_CULLMODE, dwCull) != D3D_OK) log("  Error in grCullMode\n");

}




XGLLINK void XGLCALL grDepthBiasLevel(uint32 level) {
	vlog("Called grDepthBiasLevel: level=" << level);

//	_exebuffer->Flush();

//	log("  Error, unsupported function grDepthBiasLevel");

//	DX.D3DD->SetRenderState(D3DRENDERSTATE_ZBIAS, level);
}


XGLLINK void XGLCALL grDepthMask(uint32 mask) {
	vlog("Called grDepthMask: mask=" << mask);

	_exebuffer->Flush();

	if (mask) 
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, TRUE);
	else
		DX.D3DD->SetRenderState(D3DRENDERSTATE_ZWRITEENABLE, FALSE);
		
}

uint32 getTextureFormat(char *format) {
	if (strcmp(format, "yiq") == 0)			return XGLTEX_YIQ422;
	if (strcmp(format, "rgb565") == 0)		return XGLTEX_RGB565;
	if (strcmp(format, "a8") == 0)			return XGLTEX_A8;
	if (strcmp(format, "rgb332") == 0)		return XGLTEX_RGB332;
	if (strcmp(format, "p8") == 0)			return XGLTEX_P8;
	if (strcmp(format, "ayiq8422") == 0)	return XGLTEX_AYIQ8422;
	if (strcmp(format, "argb8332") == 0)	return XGLTEX_ARGB8332;
	if (strcmp(format, "argb4444") == 0)	return XGLTEX_ARGB4444;
	if (strcmp(format, "argb1555") == 0)	return XGLTEX_ARGB1555;
	if (strcmp(format, "ap88") == 0)		return XGLTEX_AP88;

	return 0;
}

uint32 getAspectRatio(uint32 w, uint32 h) {
	if (w == 1) {
		if (h == 1) return XGLASPECT_1x1;
		if (h == 2) return XGLASPECT_1x2;
		if (h == 4) return XGLASPECT_1x4;
		if (h == 8) return XGLASPECT_1x8;
	}
	if (w == 2) return XGLASPECT_2x1;
	if (w == 4) return XGLASPECT_4x1;
	if (w == 8) return XGLASPECT_8x1;

	return XGLASPECT_1x1;
}

uint32 getBytesPerPixel(uint32 fmt) {
	switch (fmt) {
	case XGLTEX_RGB332:		return 1;
	case XGLTEX_YIQ422:		return 1;
	case XGLTEX_A8:			return 1;
	case XGLTEX_L8:			return 1;
	case XGLTEX_AL44:		return 1;
	case XGLTEX_P8:			return 1;
	case XGLTEX_ARGB8332:	return 2;			// Same as GR_TEXFMT_16BIT
	case XGLTEX_AYIQ8422:	return 2;
	case XGLTEX_RGB565:		return 2;
	case XGLTEX_ARGB1555:	return 2;
	case XGLTEX_ARGB4444:	return 2;
	case XGLTEX_AL88:		return 2;
	case XGLTEX_AP88:		return 2;
	}

	return 2;
}

uint32 getLfbBytesPerPixel(uint32 fmt) {
	switch (fmt) {
	case XGLLFB_FMT_RGB565:				return 2;        
	case XGLLFB_FMT_RGB555:				return 2;
	case XGLLFB_FMT_ARGB1555:			return 2;
	case XGLLFB_FMT_RGB888:				return 3;
	case XGLLFB_FMT_ARGB8888:			return 4;
	case XGLLFB_FMT_RGB565_D16:			return 4;
	case XGLLFB_FMT_RGB555_D16:			return 4;
	case XGLLFB_FMT_ARGB1555_D16:		return 4;
	case XGLLFB_FMT_D16:				return 2;
	case XGLLFB_FMT_ANY:				return 2;
	default:							return 2;
	}
}