// Copyright (C) 1998-1999 Scott Cutler
// Please see the "readme.txt" file for license details

#include "include.h"


// Set all color combine modes to be undefined, so we can detect if
// a new mode is used that we haven't seen yet.
void clear_cc_lut() {
	int i, j, k, l;

	for (i=0; i<XGLCOMBINEFUNC_MAX; i++) {
		for (j=0; j<XGLCOMBINEFACTOR_MAX; j++) {
			for (k=0; k<XGLLOCAL_MAX; k++) {
				for (l=0; l<XGLOTHER_MAX; l++) {
					colorcombine_lut[i][j][k][l].set = 0;
				}
			}
		}
	}
}


// Fill the color combine lut with inputted values.  If any of the inputted 
// Glide constants are -1 (actually, less than zero), then fill all combinations
// of that factor in the lut with the info.
void fill_cc_lut(int32 func, int32 factor, int32 local, int32 other, D3DCOLOR (*getcolor)(const XGLVertex &), D3DTEXTUREOP colorop, uint32 colorarg1, uint32 colorarg2) {
	int i, j, k, l;
	int imax, jmax, kmax, lmax;
	int imin, jmin, kmin, lmin;


	if (func < 0) {
		imin = 0;
		imax = XGLCOMBINEFUNC_MAX;
	} else {
		imin = func;
		imax = func+1;
	}
	for (i=imin; i<imax; i++) {

		if (factor < 0) {
			jmin = 0;
			jmax = XGLCOMBINEFACTOR_MAX;
		} else {
			jmin = factor;
			jmax = factor+1;
		}
		for (j=jmin; j<jmax; j++) {

			if (local < 0) {
				kmin = 0;
				kmax = XGLLOCAL_MAX;
			} else {
				kmin = local;
				kmax = local+1;
			}
			for (k=kmin; k<kmax; k++) {

				if (other < 0) {
					lmin = 0;
					lmax = XGLOTHER_MAX;
				} else {
					lmin = other;
					lmax = other+1;
				}
				for (l=lmin; l<lmax; l++) {
					colorcombine_lut[i][j][k][l].set = 1;
					colorcombine_lut[i][j][k][l].getcolor = getcolor;
					colorcombine_lut[i][j][k][l].colorop = colorop;
					colorcombine_lut[i][j][k][l].colorarg1 = colorarg1;
					colorcombine_lut[i][j][k][l].colorarg2 = colorarg2;
				}
			}
		}
	}
}


void cc_lut_init() {
	clear_cc_lut();

	D3DTEXTUREOP arg;

	arg = (Settings.atifix) ? D3DTOP_SELECTARG1 : D3DTOP_SELECTARG2;
	fill_cc_lut(XGLCOMBINEFUNC_LOCAL, -1, XGLLOCAL_GOURAUD, -1, iterated, arg, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_LOCAL, -1, XGLLOCAL_CONSTANT, -1, constant, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ZERO, -1, -1, black, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_GOURAUD, iterated2, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterconst, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_GOURAUD, iterconst, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);

	// Unreal
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, constant, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);
//	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_TFACTOR);
//	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_CONSTANT, XGLOTHER_CONSTANT, constant2, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_GOURAUD, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_CONSTANT, constant, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
//	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER, XGLCOMBINEFACTOR_ONE, -1, XGLOTHER_CONSTANT, iterated, D3DTOP_SELECTARG1, D3DTA_TFACTOR, D3DTA_CURRENT);


	// Unreal - nope
//	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_LOCAL_ALPHA, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_LOCAL_ALPHA, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, constant, D3DTOP_BLENDDIFFUSEALPHA, D3DTA_TEXTURE, D3DTA_CURRENT);


	

	
	if (Settings.colorop_blendtexturealpha == 0) {
		arg = D3DTOP_SELECTARG1;
	} else if (Settings.colorop_blendtexturealpha == 1) {
		arg = D3DTOP_BLENDTEXTUREALPHA;
	} else if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_BLENDTEXTUREALPHA) {
		arg = D3DTOP_BLENDTEXTUREALPHA;
	} else {
		arg = D3DTOP_SELECTARG1;
	}
	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_ALPHA, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, arg, D3DTA_TEXTURE, D3DTA_CURRENT);


	if (Settings.colorop_add == 0) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else if (Settings.colorop_add == 1) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else {
		if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_ADD) {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
		} else {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_GOURAUD, XGLOTHER_CONSTANT, iterated, D3DTOP_SELECTARG2, D3DTA_TEXTURE, D3DTA_CURRENT);
		}
	}

	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_MINUS_LOCAL_ADD_LOCAL, XGLCOMBINEFACTOR_TEXTURE_RGB, XGLLOCAL_CONSTANT, XGLOTHER_GOURAUD, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);



	if (Settings.colorop_add == 0) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else if (Settings.colorop_add == 1) {
		fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
	} else {
		if (DX.D3DHD.dwTextureOpCaps & D3DTEXOPCAPS_ADD) {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_ADD, D3DTA_TEXTURE, D3DTA_CURRENT);
		} else {
			fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL, XGLCOMBINEFACTOR_ONE, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);
		}
	}


	fill_cc_lut(XGLCOMBINEFUNC_SCALE_OTHER_ADD_LOCAL_ALPHA, XGLCOMBINEFACTOR_LOCAL, XGLLOCAL_GOURAUD, XGLOTHER_TEXTURE, iterated, D3DTOP_MODULATE, D3DTA_TEXTURE, D3DTA_CURRENT);


	// Gods
	fill_cc_lut(XGLCOMBINEFUNC_BLEND_OTHER, XGLCOMBINEFACTOR_LOCAL_ALPHA, XGLLOCAL_CONSTANT, XGLOTHER_TEXTURE, iterated, D3DTOP_SELECTARG1, D3DTA_TEXTURE, D3DTA_CURRENT);


}
