#ifndef _DEFS_H_
#define _DEFS_H_

#define		MEMWRITE8		( -32 )
#define		MEMWRITE16		( -31 )
#define		MEMWRITE32		( -30 )
#define		MEMREAD8		( -29 )
#define		MEMREAD8U		( -28 )
#define		MEMREAD16		( -27 )
#define		MEMREAD16U		( -26 )
#define		MEMREAD32		( -25 )
#define		MEMWRITEL		( -24 )
#define		MEMWRITER		( -23 )
#define		MEMREADL		( -22 )
#define		MEMREADR		( -21 )

#define		HWWRITE8		( -20 )
#define		HWWRITE16		( -19 )
#define		HWWRITE32		( -18 )
#define		HWREAD8			( -17 )
#define		HWREAD16		( -16 )
#define		HWREAD32		( -15 )

#define		CPUDECODE		( -12 )
#define		TIMING			( -9 )

#define		DYNDIV			( -8 )
#define		DYNDIVU			( -7 )

#define		SYSCALL			( -4 )


#define		REG_LO			( -2 )
#define		REG_HI			( -1 )

#define		REG_ZERO		( 0x00 )
#define		REG_AT			( 0x01 )
#define		REG_V0			( 0x02 )
#define		REG_V1			( 0x03 )
#define		REG_A0			( 0x04 )
#define		REG_A1			( 0x05 )
#define		REG_A2			( 0x06 )
#define		REG_A3			( 0x07 )
#define		REG_T0			( 0x08 )
#define		REG_T1			( 0x09 )
#define		REG_T2			( 0x0a )
#define		REG_T3			( 0x0b )
#define		REG_T4			( 0x0c )
#define		REG_T5			( 0x0d )
#define		REG_T6			( 0x0e )
#define		REG_T7			( 0x0f )
#define		REG_S0			( 0x10 )
#define		REG_S1			( 0x11 )
#define		REG_S2			( 0x12 )
#define		REG_S3			( 0x13 )
#define		REG_S4			( 0x14 )
#define		REG_S5			( 0x15 )
#define		REG_S6			( 0x16 )
#define		REG_S7			( 0x17 )
#define		REG_T8			( 0x18 )
#define		REG_T9			( 0x19 )
#define		REG_GP			( 0x1c )
#define		REG_SP			( 0x1d )
#define		REG_FP			( 0x1e )
#define		REG_RA			( 0x1f )

//#define		___REG_A0		( 0x04 * 4 )
#define		___REG_RA       ( 0x1f * 4 )

typedef char				int8;
typedef short				int16;
typedef long				int32;
typedef long long			int64;
typedef unsigned char		uint8;
typedef unsigned short		uint16;
typedef unsigned long		uint32;
typedef unsigned long long	uint64;

#endif
