//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "dma.h"

#include "hardware.h"

#include <stdio.h>


static DMAHookFuncType DMAHookFunc[0x08];
static long DMAChannelData[ 0x04 * 0x08 ];

static long defDMAHookFunc(long) __attribute__((regparm(1)));
static long defDMAHookFunc(long dma_control)
{
	printf(":::defDMAFunction:::\n");
	return 0;
}

//static long filename = 0x41;
//
//static void DumpMemory()
//{
//	FILE *fout = fopen(&filename,"wb+");
//	printf("..%s..\n",&filename);
//	fwrite( Emulator -> BaseMemory + 0x10000 , 1 , 0x10000 , fout );
//	fclose(fout);
//	filename++;
//}

#define DMAWriteTemplate0(addr)												\
static void Write10 ## addr ## 0(unsigned long) __attribute__((regparm(1)));\
static void Write10 ## addr ## 0(unsigned long data)						\
{																			\
	printf("Write  %lx  @ [ %x ]\n", data, 0x1f8010 ## addr ## 0);			\
	fflush(0);																\
	DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) ] = data;					\
}

#define DMAWriteTemplate4(addr)												\
static void Write10 ## addr ## 4(unsigned long) __attribute__((regparm(1)));\
static void Write10 ## addr ## 4(unsigned long data)						\
{																			\
	printf("Write  %lx  @ [ %x ]\n", data, 0x1f8010 ## addr ## 4);			\
	fflush(0);																\
	DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) + 0x01 ] = data;			\
}

//Need to add something...
#define DMAWriteTemplate8(addr)												\
static void Write10 ## addr ## 8(unsigned long) __attribute__((regparm(1)));\
static void Write10 ## addr ## 8(unsigned long data)						\
{																			\
	printf("Write  %lx  @ [ %x ]\n", data, 0x1f8010 ## addr ## 8);			\
	fflush(0);																\
	DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) + 0x02 ] = data;			\
	if ( data & 0x01000000 )												\
	{																		\
		if((DMAHookFunc[ 0x0 ## addr - 0x08 ])(data))						\
		{																	\
			DMAChannelData[0x04*(0x0 ## addr - 0x08)+0x02] &= 0xfeffffff;	\
		}																	\
	}																		\
}

DMAWriteTemplate0(8)
DMAWriteTemplate4(8)
DMAWriteTemplate8(8)
DMAWriteTemplate0(9)
DMAWriteTemplate4(9)
DMAWriteTemplate8(9)
DMAWriteTemplate0(a)
DMAWriteTemplate4(a)
DMAWriteTemplate8(a)
DMAWriteTemplate0(b)
DMAWriteTemplate4(b)
DMAWriteTemplate8(b)
DMAWriteTemplate0(c)
DMAWriteTemplate4(c)
DMAWriteTemplate8(c)
DMAWriteTemplate0(d)
DMAWriteTemplate4(d)
DMAWriteTemplate8(d)
DMAWriteTemplate0(e)
DMAWriteTemplate4(e)
DMAWriteTemplate8(e)

#define DMAReadTemplate0(addr)												\
static unsigned long Read10 ## addr ## 0(void)								\
{																			\
	unsigned long value = DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) ];	\
	printf("Read  %lx  @ [ %x ]\n", value, 0x1f8010 ## addr ## 0);			\
	fflush(0);																\
	return value;															\
}

#define DMAReadTemplate4(addr)												\
static unsigned long Read10 ## addr ## 4(void)								\
{																			\
	unsigned long value = DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) + 1];	\
	printf("Read  %lx  @ [ %x ]\n", value, 0x1f8010 ## addr ## 4);			\
	fflush(0);																\
    return value;															\
}

#define DMAReadTemplate8(addr)												\
static unsigned long Read10 ## addr ## 8(void)								\
{																			\
	unsigned long value = DMAChannelData[ 0x04 * (0x0 ## addr - 0x08) + 2];	\
	printf("Read  %lx  @ [ %x ]\n", value, 0x1f8010 ## addr ## 8);			\
	fflush(0);																\
    return value;															\
}

DMAReadTemplate0(8)
DMAReadTemplate4(8)
DMAReadTemplate8(8)
DMAReadTemplate0(9)
DMAReadTemplate4(9)
DMAReadTemplate8(9)
DMAReadTemplate0(a)
DMAReadTemplate4(a)
DMAReadTemplate8(a)
DMAReadTemplate0(b)
DMAReadTemplate4(b)
DMAReadTemplate8(b)
DMAReadTemplate0(c)
DMAReadTemplate4(c)
DMAReadTemplate8(c)
DMAReadTemplate0(d)
DMAReadTemplate4(d)
DMAReadTemplate8(d)
DMAReadTemplate0(e)
DMAReadTemplate4(e)
DMAReadTemplate8(e)

static void Write10f0(long data)
{
}

static void Write10f4(long data)
{
}

static long Read10f0(void)
{
	return 0;
}

static long Read10f4(void)
{
	return 0;
}

static void UnSupported(void)
{
	printf("DMA UnSupport Port Access");//?
}

/******************************************************************************/

void *DMASetHook(DMAHookFuncType func, long addr)
{
	DMAHookFunc[ addr ] = func;
	return ( DMAChannelData + addr * 0x04 );
}

/******************************************************************************/

static void *DefChannelWrite[0x20] =
{
    Write1080,      Write1084,      Write1088,      UnSupported,
    Write1090,      Write1094,      Write1098,      UnSupported,
    Write10a0,      Write10a4,      Write10a8,      UnSupported,
    Write10b0,      Write10b4,      Write10b8,      UnSupported,
    Write10c0,      Write10c4,      Write10c8,      UnSupported,
    Write10d0,      Write10d4,      Write10d8,      UnSupported,
    Write10e0,      Write10e4,      Write10e8,      UnSupported,
    Write10f0,      Write10f4,      UnSupported,    UnSupported
};

static void *DefChannelRead[0x20] =
{
    Read1080,       Read1084,       Read1088,       UnSupported,
    Read1090,       Read1094,       Read1098,       UnSupported,
    Read10a0,       Read10a4,       Read10a8,       UnSupported,
    Read10b0,       Read10b4,       Read10b8,       UnSupported,
    Read10c0,       Read10c4,       Read10c8,       UnSupported,
    Read10d0,       Read10d4,       Read10d8,       UnSupported,
    Read10e0,       Read10e4,       Read10e8,       UnSupported,
    Read10f0,       Read10f4,       UnSupported,    UnSupported
};

//static void *LogChannelwrite[0x20];
//static void *LogChannelread[0x20];

/******************************************************************************/

long dmaOpen()
{
	long i;
	for( i = 0 ; i < 0x20 ; i++ )
	{
		cpuHookPortWord( DefChannelWrite[i] , DefChannelRead[i] , 0x00001080 + i*4 );
	}
	for( i = 0 ; i < 8 ; i++ )
	{
		DMAHookFunc[i] = defDMAHookFunc;
	}
	return 0;
}
