;;--Hooks
global cpuHookAddr
global cpuHookOpCode
;
;global cpumemory
;global branchmemory
;
global cpu_reset
global CPUDecode
global cpuExec
global CPUWriteData
global CPUClearData
;global CPUSetFuncEx
global cpuDynAddrGet
;Opcodes
global cpuDynOpcodeDiv
global cpuDynOpcodeDivU
;
%include "../include/defs.inc"
;
%assign		CPU_MEMORY_SIZE		0x00200000
;------------------------------------------------------------------------------;
section .text
;------------------------------------------------------------------------------;
;;----Hooks
;;--Addr
;Install User Function
align 4
;void cpuHookAddr(void *func, long addr)
cpuHookAddr:
	mov [ BasicHookFunc.faddr ], eax
	mov ecx, 0x08
	mov eax, BasicHookFunc
	call CPUWriteData
	ret
;;--OpCode
;Install User OpCode
align 4
;void cpuHookOpCode(void *func, long opcode)
cpuHookOpCode:
	mov		ecx, edx
	shr		ecx, 26
	test	ecx, ecx
	jz	.nOpcode
	mov		[ __Opcodes + ecx * 4 ], eax
	ret
.nOpcode:
;	test    edx, edx
;	jnz .nNop
;	mov     [ __Opcodes + edx * 4 ], eax
;	ret
;.nNop:
	mov     ecx, edx
	and		ecx, 0x3f
	mov		[ __Specials + ecx * 4 ], eax
	ret
;
align 4
;
cpuDynReturn:
	ret
;
align 4
;
cpuDynOpcodeDivU:
	div ecx
	mov [ byte ___REG_LO + esi ], eax
	mov [ byte ___REG_HI + esi ], edx
	ret
;
align 4
;
cpuDynOpcodeDiv:
	idiv ecx
	mov [ byte ___REG_LO + esi ], eax
	mov [ byte ___REG_HI + esi ], edx
	ret
;
align 4
;
cpuDynAddrGet:
	and eax, 0x001fffff
	lea eax, [ cpumemory + eax * 4 ]
	ret
;
align 4
;
cpuExec:
	and eax, 0x001fffff
	lea eax, [ cpumemory + eax * 4 ]
	call eax
	ret
;
align 4
;
decode_call_code:
	call [ byte CPUDECODE + esi ]
	nop
;
align 4
;
core_decode_call_code:
	call [ byte COREDECODE + esi ]
	nop
;
align 4
;
cpu_reset:
	push edi
		mov eax, [decode_call_code]
		mov edi, cpumemory
		mov ecx, CPU_MEMORY_SIZE
		rep stosd
	pop edi
	mov [next_free_branch], dword	branchmemory
;;;
	mov eax, cpuDynReturn
	mov edx, 0x00000090
	mov ecx, 0x00000001
	call CPUWriteData
;;;
	ret
;
align 4
;
CPUWriteData:
	push esi
	push edi
	mov esi,eax
	lea edi,[ cpumemory + edx * 4 ]
	rep movsd
	pop edi
	pop esi
	ret
;
align 4
;
CPUClearData:
	ret
;
align 4
;
CPUSetFuncEx:
	ret
;
;  DynaRec !!!
;
align 4
;
CPUDecode:
	sub dword [esp], 0x03
	mov eax, [esp]
	push ebp
	sub eax, cpumemory
	push ebx
	shr eax, 0x02
	push esi
	mov ebp, eax
;
.loop:
	mov edx, [ edi + ebp ]
;;;
	pusha
		popa
		pop esi
		push esi
		pusha
		push dword [ byte esi + ___REG_SP ]
		push ebp
		push edi
		push edx
		push dword cur_decode_message
extern _printf
		call _printf
		push dword 0
extern _fflush
		call _fflush
		add esp, 0x14
;
		add esp, 0x04
	popa
;;;
	mov eax, edx
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;
	lea		ebx, [ cpumemory + ebp * 4 ]
	add     ebp, ecx

.loop_copy:
    jecxz	.test_end_of_loop

    dec     ecx
	mov		edx, [ esi + ecx * 4 ]
    mov     [ ebx + ecx * 4 ], edx
	jmp		.loop_copy

.test_end_of_loop:
	test	eax, eax
	jz		.loop
;
	pop esi
	pop ebx
	pop ebp
	ret
;
align 4
;
__UnsupOp:
__Opcode_10:
__Opcode_12:
__Opcode_32:
__Opcode_3a:
	push edx
	push dword unsup_op_message
	call _printf
	add esp, 0x08
	jmp $
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_00:
	mov edx, eax
	test eax, eax
	jz .nop
	and edx, 0x3f								;--00--SPECIAL
	jmp [ __Specials + edx * 4 ]
.nop:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_01:
	mov edx, eax
	shr edx, 0x10
	and edx, 0x1f								;--01--BCOND
	jmp [ __BConds + edx * 4 ]
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_02:
	push edi
	shl eax, 2
	and eax, 0x001fffff
	lea eax, [ cpumemory + eax * 4 ]
	mov [COpcodeJ_j.t_addr], eax
	mov eax, [ next_free_branch ]
	mov [COpcodeJ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--02--J
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeJ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeJ_j.placeOpcode
	rep movsd
	mov esi,COpcodeJ_j
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ],dword 0x00000020
	rep movsd
	mov esi,COpcodeJ
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_03:
	push edi
	shl eax, 2
	and eax, 0x001fffff
	lea eax, [ cpumemory + eax * 4 ]
	mov [COpcodeJAL_j.t_addr], eax
	mov [COpcodeJAL.ra], ebp
	add [COpcodeJAL.ra], dword 0x08
	mov eax, [ next_free_branch ]
	mov [COpcodeJAL.b_addr], eax
;-->
	mov edx, [ edi + ebp + 4 ]
	mov eax,edx									;--03--JAL
	shr edx,26
	call [ __Opcodes + edx * 4 ]
;<--
	push esi
	push ecx
	mov edi,COpcodeJAL.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeJAL_j.placeOpcode
	rep movsd
	mov esi,COpcodeJAL_j
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ],dword 0x00000020
	rep movsd
	mov esi,COpcodeJAL
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_04:
	push edi
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx, [ cpumemory + ecx * 4 ]
	mov [COpcodeBEQ_b.t_addr], ecx
	mov [COpcodeBEQ.rs], dl
	mov [COpcodeBEQ.rt], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBEQ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--04--BEQ
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi, COpcodeBEQ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi, COpcodeBEQ_b.placeOpcode
	rep movsd
	mov esi, COpcodeBEQ_b
	mov edi, [ next_free_branch ]
	mov ecx, 0x08
	rep movsd
	add dword [ next_free_branch ], dword 0x00000020
	mov esi, COpcodeBEQ
	mov ecx, 0x08
	mov eax, 0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_05:
	push edi
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx, [ cpumemory + ecx * 4 ]
	mov [COpcodeBNE_b.t_addr], ecx
	mov [COpcodeBNE.rs], dl
	mov [COpcodeBNE.rt], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBNE.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx									;--05--BNE
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeBNE.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeBNE_b.placeOpcode
	rep movsd
	mov esi,COpcodeBNE_b
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ],dword 0x00000020
	rep movsd
	mov esi,COpcodeBNE
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_06:
	push edi
	movsx ecx, ax
	shr eax, 0x15-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx, [ cpumemory + ecx * 4 ]
	mov [COpcodeBLEZ_b.t_addr], ecx
	mov [COpcodeBLEZ.rs], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBLEZ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--06--BLEZ
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi, COpcodeBLEZ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi, COpcodeBLEZ_b.placeOpcode
	rep movsd
	mov esi, COpcodeBLEZ_b
	mov edi, [ next_free_branch ]
	mov ecx, 0x08
	add dword [ next_free_branch ], dword 0x00000020
	rep movsd
	mov esi, COpcodeBLEZ
	mov ecx, 0x08
	mov eax, 0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_07:
	push edi
	movsx ecx, ax
	shr eax, 0x15-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx,[ cpumemory + ecx * 4 ]
	mov [COpcodeBGTZ_b.t_addr], ecx
	mov [COpcodeBGTZ.rs], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBGTZ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--07--BGTZ
	shr edx,26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeBGTZ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeBGTZ_b.placeOpcode
	rep movsd
	mov esi,COpcodeBGTZ_b
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ],dword 0x00000020
	rep movsd
	mov esi,COpcodeBGTZ
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_08:
	mov edx, eax
	movsx ecx, ax
	shr edx,0x15-2
	and edx,0x1f<<2
	shr eax,0x10-2
	and eax,0x1f<<2								;--08--ADDI
	mov [COpcodeADDI.imm],ecx
	mov [COpcodeADDI.rs],dl
	mov [COpcodeADDI.rt],al
	mov esi,COpcodeADDI
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_09:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--09--ADDIU
	mov [COpcodeADDIU.imm], ecx
	mov [COpcodeADDIU.rs], dl
	mov [COpcodeADDIU.rt], al
	mov esi, COpcodeADDIU
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0a:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2							;--0A--SLTI
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeSLTI.imm], ecx
	mov [COpcodeSLTI.rs], dl
	mov [COpcodeSLTI.rt], al
	mov esi, COpcodeSLTI
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0b:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2							;--0B--SLTIU
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeSLTIU.imm], ecx
	mov [COpcodeSLTIU.rs], dl
	mov [COpcodeSLTIU.rt], al
	mov esi, COpcodeSLTIU
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0c:
	mov edx, eax
	movzx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2							;--0C--ANDI
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeANDI.imm], ecx
	mov [COpcodeANDI.rs], dl
	mov [COpcodeANDI.rt], al
	mov esi, COpcodeANDI
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0d:
	mov edx, eax
	movzx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2								;--0D--ORI
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeORI.imm], ecx
	mov [COpcodeORI.rs], dl
	mov [COpcodeORI.rt], al
	mov esi, COpcodeORI
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0e:
	mov edx, eax
	movzx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2								;--0E--XORI
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeXORI.imm], ecx
	mov [COpcodeXORI.rs], dl
	mov [COpcodeXORI.rt], al
	mov esi, COpcodeXORI
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_0f:
	mov edx, eax
	shl edx, 0x10
	shr eax, 0x10-2
	and eax, 0x1f<<2
	mov [COpcodeLUI.imm],edx					;--0F--LUI
	mov [COpcodeLUI.rt],al
	mov esi,COpcodeLUI
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_20:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--20--LB
	jz .lb_exit
	mov [COpcodeLB.imm], ecx
	mov [COpcodeLB.rs], dl
	mov [COpcodeLB.rt], al
	mov esi, COpcodeLB
	mov ecx, 0x04
	xor eax, eax
	ret
.lb_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_21:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--21--LH
	jz .lh_exit
	mov [COpcodeLH.imm], ecx
	mov [COpcodeLH.rs], dl
	mov [COpcodeLH.rt], al
	mov esi, COpcodeLH
	mov ecx, 0x04
	xor eax, eax
	ret
.lh_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_22:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--22--LWL
	jz .lwl_exit
	mov [COpcodeLWL.imm], ecx
	mov [COpcodeLWL.rs], dl
	mov [COpcodeLWL.rt], al
	mov esi, COpcodeLWL
	mov ecx, 0x04
	xor eax, eax
	ret
.lwl_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_23:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--23--LW
	jz .lw_exit
	mov [COpcodeLW.imm], ecx
	mov [COpcodeLW.rs], dl
	mov [COpcodeLW.rt], al
	mov esi, COpcodeLW
	mov ecx, 0x04
	xor eax, eax
	ret
.lw_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_24:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--24--LBU
	jz .lbu_exit
	mov [COpcodeLBU.imm], ecx
	mov [COpcodeLBU.rs], dl
	mov [COpcodeLBU.rt], al
	mov esi, COpcodeLBU
	mov ecx, 0x04
	xor eax, eax
	ret
.lbu_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_25:
	mov edx, eax
    movsx ecx, ax
    shr edx,0x15-2
    and edx,0x1f<<2
    shr eax,0x10-2
    and eax,0x1f<<2								;--25--LHU
    jz .lhu_exit
    mov [COpcodeLHU.imm],ecx
    mov [COpcodeLHU.rs],dl
    mov [COpcodeLHU.rt],al
    mov esi,COpcodeLHU
    mov ecx,0x04
    xor eax,eax
    ret
.lhu_exit:
    mov esi,COpcodeNOP
    mov ecx,0x04
    xor eax,eax
    ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_26:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--26--LWR
	jz .lwr_exit
	mov [COpcodeLWR.imm], ecx
	mov [COpcodeLWR.rs], dl
	mov [COpcodeLWR.rt], al
	mov esi, COpcodeLWR
	mov ecx, 0x04
	xor eax, eax
	ret
.lwr_exit:
	mov esi, COpcodeNOP
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_28:
	mov edx, eax
	movsx ecx, ax
	shr edx,0x15-2
	and edx,0x1f<<2
	shr eax,0x10-2
	and eax,0x1f<<2								;--28--SB
	mov [COpcodeSB.imm],ecx
	mov [COpcodeSB.rs],dl
	mov [COpcodeSB.rt],al
	mov esi,COpcodeSB
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_29:
	mov edx, eax
	movsx ecx, ax
	shr edx,0x15-2
	and edx,0x1f<<2
	shr eax,0x10-2
	and eax,0x1f<<2								;--29--SH
	mov [COpcodeSH.imm],ecx
	mov [COpcodeSH.rs],dl
	mov [COpcodeSH.rt],al
	mov esi,COpcodeSH
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_2a:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--2a--SWL
	mov [COpcodeSWL.imm], ecx
	mov [COpcodeSWL.rs], dl
	mov [COpcodeSWL.rt], al
	mov esi, COpcodeSWL
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_2b:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--2B--SW
	mov [COpcodeSW.imm], ecx
	mov [COpcodeSW.rs], dl
	mov [COpcodeSW.rt], al
	mov esi, COpcodeSW
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Opcode_2e:
	mov edx, eax
	movsx ecx, ax
	shr edx, 0x15-2
	and edx, 0x1f<<2
	shr eax, 0x10-2
	and eax, 0x1f<<2							;--2e--SWR
	mov [COpcodeSWR.imm], ecx
	mov [COpcodeSWR.rs], dl
	mov [COpcodeSWR.rt], al
	mov esi, COpcodeSWR
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__UnsupSp:
__Special_0d:
__Special_20:
__Special_22:
	push edx
	push dword unsup_sp_message
	call _printf
	add esp, 0x08
	jmp $
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_00:
	mov edx, eax
	mov ecx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	shr ecx, 0x06								;--00--SLL
	and ecx, 0x1f
	mov [COpcodeSLL.rt], al
	mov [COpcodeSLL.sa], cl
	mov [COpcodeSLL.rd], dl
	mov esi, COpcodeSLL
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_02:
	mov edx, eax
	mov ecx, eax
	shr eax, 0x10-2								;--02--SRL
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	shr ecx, 0x06
	and ecx, 0x1f
	mov [COpcodeSRL.rt], al
	mov [COpcodeSRL.sa], cl
	mov [COpcodeSRL.rd], dl
	mov esi, COpcodeSRL
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_03:
	mov edx, eax
	mov ecx, eax
	shr eax, 0x10-2								;--03--SRA
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	shr ecx, 0x06
	and ecx, 0x1f
	mov [COpcodeSRA.rt], al
	mov [COpcodeSRA.sa], cl
	mov [COpcodeSRA.rd], dl
	mov esi, COpcodeSRA
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_04:
	mov ecx, eax
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr edx, 0x0b-2								;--04--SLLV
	and edx, 0x1f<<2
	mov [COpcodeSLLV.rt], al
	mov [COpcodeSLLV.rs], cl
	mov [COpcodeSLLV.rd], dl
	mov esi, COpcodeSLLV
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_06:
	mov ecx, eax
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr edx, 0x0b-2								;--06--SRLV
	and edx, 0x1f<<2
	mov [COpcodeSRLV.rt], al
	mov [COpcodeSRLV.rs], cl
	mov [COpcodeSRLV.rd], dl
	mov esi, COpcodeSRLV
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_07:
	mov ecx, eax
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr edx, 0x0b-2								;--07--SRAV
	and edx, 0x1f<<2
	mov [COpcodeSRAV.rt], al
	mov [COpcodeSRAV.rs], cl
	mov [COpcodeSRAV.rd], dl
	mov esi, COpcodeSRAV
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_08:
	push edi
	shr eax, 0x15-2
	and eax, 0x1f<<2
	mov [COpcodeJR.rs], al
	mov eax, [ next_free_branch ]
	mov [COpcodeJR.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--08--JR
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeJR.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi, COpcodeJR_j.placeOpcode
	rep movsd
	mov esi, COpcodeJR_j
	mov edi, [ next_free_branch ]
	mov ecx, 0x08
	add dword [ next_free_branch ],dword 0x00000020
	rep movsd
	mov esi, COpcodeJR
	mov ecx, 0x08
	mov eax, 0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_09:
	push edi
	shr eax, 0x15-2
	and eax, 0x1f<<2
	mov [COpcodeJALR.rs],al
	mov [COpcodeJALR_j.ra],ebp
	add [COpcodeJALR_j.ra],dword 0x08
	mov eax, [ next_free_branch ]
	mov [COpcodeJALR.b_addr],eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--09--JALR
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeJALR.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeJALR_j.placeOpcode
	rep movsd
	mov esi,COpcodeJALR_j
	mov edi, [ next_free_branch ]
	mov ecx,0x0c
	add dword [ next_free_branch ], dword 0x00000030
	rep movsd
	mov esi,COpcodeJALR
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_0c:
	mov esi, COpcodeSYSCALL
	mov ecx, 0x04								;--0c--SYSCALL
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_10:
	shr eax, 0x0b-2
	and eax, 0x1f<<2
	mov [COpcodeMFHI.rd], al					;--10--MFHI
	mov esi, COpcodeMFHI
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_12:
	shr eax, 0x0b-2
	and eax, 0x1f<<2
	mov [COpcodeMFLO.rd], al					;--12--MFLO
	mov esi, COpcodeMFLO
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_18:
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x15-2								;--18--MULT
	and edx, 0x1f<<2
	mov [COpcodeMULT.rs], dl
	mov [COpcodeMULT.rt], al
	mov esi, COpcodeMULT
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_19:
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x15-2								;--19--MULTU
	and edx, 0x1f<<2
	mov [COpcodeMULTU.rs], dl
	mov [COpcodeMULTU.rt], al
	mov esi, COpcodeMULTU
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_1a:
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x15-2								;--1A--DIV
	and edx, 0x1f<<2
	mov [COpcodeDIV.rs], dl
	mov [COpcodeDIV.rt], al
	mov esi, COpcodeDIV
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_1b:
	mov edx, eax
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x15-2								;--1B--DIVU
	and edx, 0x1f<<2
	mov [COpcodeDIVU.rs], dl
	mov [COpcodeDIVU.rt], al
	mov esi, COpcodeDIVU
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_21:
	mov edx, eax
	mov ecx, eax
	shr ecx,0x15-2
	and ecx,0x1f<<2
	shr eax,0x10-2								;--21--ADDU
	and eax,0x1f<<2
	shr edx,0x0b-2
	and edx,0x1f<<2
	mov [COpcodeADDU.rs],cl
	mov [COpcodeADDU.rt],al
	mov [COpcodeADDU.rd],dl
	mov esi,COpcodeADDU
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_23:
	mov edx, eax
	mov ecx, eax
	shr ecx,0x15-2
	and ecx,0x1f<<2
	shr eax,0x10-2								;--23--SUBU
	and eax,0x1f<<2
	shr edx,0x0b-2
	and edx,0x1f<<2
	mov [COpcodeSUBU.rs],cl
	mov [COpcodeSUBU.rt],al
	mov [COpcodeSUBU.rd],dl
	mov esi,COpcodeSUBU
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_24:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr eax, 0x10-2								;--24--AND
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeAND.rs], cl
	mov [COpcodeAND.rt], al
	mov [COpcodeAND.rd], dl
	mov esi, COpcodeAND
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_25:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr eax, 0x10-2								;--25--OR
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeOR.rs], cl
	mov [COpcodeOR.rt], al
	mov [COpcodeOR.rd], dl
	mov esi, COpcodeOR
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_26:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr eax, 0x10-2								;--26--XOR
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeXOR.rs], cl
	mov [COpcodeXOR.rt], al
	mov [COpcodeXOR.rd], dl
	mov esi, COpcodeXOR
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_27:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2
	shr eax, 0x10-2								;--27--NOR
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeNOR.rs], cl
	mov [COpcodeNOR.rt], al
	mov [COpcodeNOR.rd], dl
	mov esi, COpcodeNOR
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_2a:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2							;--2A--SLT
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeSLT.rs], cl
	mov [COpcodeSLT.rt], al
	mov [COpcodeSLT.rd], dl
	mov esi, COpcodeSLT
	mov ecx, 0x04
	xor eax, eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__Special_2b:
	mov edx, eax
	mov ecx, eax
	shr ecx, 0x15-2
	and ecx, 0x1f<<2							;--2B--SLTU
	shr eax, 0x10-2
	and eax, 0x1f<<2
	shr edx, 0x0b-2
	and edx, 0x1f<<2
	mov [COpcodeSLTU.rs],cl
	mov [COpcodeSLTU.rt],al
	mov [COpcodeSLTU.rd],dl
	mov esi,COpcodeSLTU
	mov ecx,0x04
	xor eax,eax
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__UnsupBc:
__BCond_11:
	push edx
	push dword unsup_bc_message
	call _printf
	add esp, 0x08
	jmp $
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__BCond_00:
	push edi
	movsx ecx, ax
	shr eax, 0x15-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx, [ cpumemory + ecx * 4 ]
	mov [COpcodeBLTZ_b.t_addr], ecx
	mov [COpcodeBLTZ.rs], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBLTZ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--00--BLTZ
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeBLTZ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeBLTZ_b.placeOpcode
	rep movsd
	mov esi,COpcodeBLTZ_b
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ], dword 0x00000020
	rep movsd
	mov esi, COpcodeBLTZ
	mov ecx, 0x08
	mov eax, 0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
align 4 ;----------------------------------------------------------------------;
;------------------------------------------------------------------------------;
__BCond_01:
	push edi
	movsx ecx, ax
	shr eax, 0x15-2
	and eax, 0x1f<<2
	shl ecx, 2
	add ecx, ebp
	add ecx, 0x04
	lea ecx, [ cpumemory + ecx * 4 ]
	mov [COpcodeBGEZ_b.t_addr], ecx
	mov [COpcodeBGEZ.rs], al
	mov eax, [ next_free_branch ]
	mov [COpcodeBGEZ.b_addr], eax
;--->
	mov edx, [ edi + ebp + 4 ]
	mov eax, edx								;--01--BGEZ
	shr edx, 26
	call [ __Opcodes + edx * 4 ]
;<---
	push esi
	push ecx
	mov edi,COpcodeBGEZ.placeOpcode
	rep movsd
	pop ecx
	pop esi
	mov edi,COpcodeBGEZ_b.placeOpcode
	rep movsd
	mov esi,COpcodeBGEZ_b
	mov edi, [ next_free_branch ]
	mov ecx,0x08
	add dword [ next_free_branch ] ,dword 0x00000020
	rep movsd
	mov esi,COpcodeBGEZ
	mov ecx,0x08
	mov eax,0x01
	pop edi
	ret
;------------------------------------------------------------------------------;
section .data ;--------------S-E-C-T-I-O-N-------------------------------------;
;------------------------------------------------------------------------------;
;----- hook func --------------------------------------------------------------;
BasicHookFunc	db	0xb8
.faddr			db	0x00,0x00,0x00,0x00,0xff,0xd0,0x8b,0x46
.ra				db	___REG_RA,0x25,0xff,0xff,0x1f,0x00
				db	0x8d,0x04,0x85
				dd	cpumemory
				db	0xff,0xe0,0x00,0x00,0x00
				db	0x00,0x00,0x00,0x00,0x00
;----- Op = 00 ------------------------------------------------------;
COpcodeNOP		db	0xeb,0x0e,0x90,0x90,0x90,0x90,0x90,0x90
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 02 -New-Interface-Main-----------------------------------;
COpcodeJ		db	0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 02 -New-Interface-Jump-----------------------------------;
COpcodeJ_j
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 03 -New-Interface-Main-----------------------------------;
COpcodeJAL		db	0xc7,0x46,___REG_RA
.ra				db	0x00,0x00,0x00,0x00,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 03 -New-Interface-Jump-----------------------------------;
COpcodeJAL_j
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 04 -New-Interface-Main-----------------------------------;
COpcodeBEQ		db	0x8b,0x46
.rs				db	0x00,0x3b,0x46
.rt				db	0x00,0x75,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 04 -New-Interface-Branch---------------------------------;
COpcodeBEQ_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 05 -New-Interface-Main-----------------------------------;
COpcodeBNE		db	0x8b,0x46
.rs				db	0x00,0x3b,0x46
.rt				db	0x00,0x74,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 05 -New-Interface-Branch---------------------------------;
COpcodeBNE_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 06 -New-Interface-Main-----------------------------------;
COpcodeBLEZ		db	0x8b,0x46
.rs				db	0x00,0x83,0xf8
				db	0x00,0x7f,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 06 -New-Interface-Branch---------------------------------;
COpcodeBLEZ_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 07 -New-Interface-Main-----------------------------------;
COpcodeBGTZ		db	0x8b,0x46
.rs				db	0x00,0x83,0xf8
				db	0x00,0x7e,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Op = 07 -New-Interface-Branch---------------------------------;
COpcodeBGTZ_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 08 ------------------------------------------------------;Checked
COpcodeADDI		db	0x8b,0x46
.rs				db	0x00,0x05
.imm			db	0x00,0x00,0x00,0x00,0x89,0x46
.rt				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;Opt?
;----- Op = 09 ------------------------------------------------------;
COpcodeADDIU	db	0x8b,0x46
.rs				db	0x00,0x05
.imm			db	0x00,0x00,0x00,0x00,0x89,0x46
.rt				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 0a ------------------------------------------------------;
COpcodeSLTI		db	0x33,0xd2,0x8b,0x46
.rs				db	0x00,0x3d
.imm			db	0x00,0x00,0x00,0x00,0x7d,0x01,0x42,0x89,0x56
.rt				db	0x00
;--------------------------------------------------------------------;
;----- Op = 0b ------------------------------------------------------;
COpcodeSLTIU	db	0x33,0xd2,0x8b,0x46
.rs				db	0x00,0x3d
.imm			db	0x00,0x00,0x00,0x00,0x73,0x01,0x42,0x89,0x56
.rt				db	0x00
;--------------------------------------------------------------------;
;----- Op = 0c ------------------------------------------------------;
COpcodeANDI		db	0x8b,0x46
.rs				db	0x00,0x25
.imm			db	0x00,0x00,0x00,0x00,0x89,0x46
.rt				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 0d ------------------------------------------------------;
COpcodeORI		db	0x8b,0x46
.rs				db	0x00,0x0d
.imm			db	0x00,0x00,0x00,0x00,0x89,0x46
.rt				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 0e ------------------------------------------------------;
COpcodeXORI		db	0x8b,0x46
.rs				db	0x00,0x35
.imm			db	0x00,0x00,0x00,0x00,0x89,0x46
.rt				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 0f ------------------------------------------------------;
COpcodeLUI		db	0xc7,0x46
.rt				db	0x00
.imm			db	0x00,0x00,0x00,0x00,0xeb,0x07
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 20 ------------------------------------------------------;
COpcodeLB		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0xff,0x56
.func			db	MEMREAD8,0x89,0x46
.rt				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 21 ------------------------------------------------------;
COpcodeLH		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0xff,0x56
.func			db	MEMREAD16,0x89,0x46
.rt				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 22 ------------------------------------------------------;
COpcodeLWL		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0x8d,0x56
.rt				db	0x00,0xff,0x56
.func			db	MEMREADL,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 23 ------------------------------------------------------;
COpcodeLW		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0xff,0x56
.func			db	MEMREAD32,0x89,0x46
.rt				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 24 ------------------------------------------------------;
COpcodeLBU		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0xff,0x56
.func			db	MEMREAD8U,0x89,0x46
.rt				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 25 ------------------------------------------------------;
COpcodeLHU		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0xff,0x56
.func			db	MEMREAD16U,0x89,0x46
.rt				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 26 ------------------------------------------------------;
COpcodeLWR		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0x8d,0x56
.rt				db	0x00,0xff,0x56
.func			db	MEMREADR,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 28 ------------------------------------------------------;
COpcodeSB		db	0xba
.imm			db	0x00,0x00,0x00,0x00,0x8b,0x46
.rt				db	0x00,0x03,0x56
.rs				db	0x00,0xff,0x56
.func			db	MEMWRITE8,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 29 ------------------------------------------------------;
COpcodeSH		db	0xba
.imm			db	0x00,0x00,0x00,0x00,0x8b,0x46
.rt				db	0x00,0x03,0x56
.rs				db	0x00,0xff,0x56
.func			db	MEMWRITE16,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 2a ------------------------------------------------------;
COpcodeSWL		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0x8d,0x56
.rt				db	0x00,0xff,0x56
.func			db	MEMWRITEL,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 2b ------------------------------------------------------;
COpcodeSW		db	0xba
.imm			db	0x00,0x00,0x00,0x00,0x8b,0x46
.rt				db	0x00,0x03,0x56
.rs				db	0x00,0xff,0x56
.func			db	MEMWRITE32,0x90,0x90
;--------------------------------------------------------------------;
;----- Op = 2e ------------------------------------------------------;
COpcodeSWR		db	0xb8
.imm			db	0x00,0x00,0x00,0x00,0x03,0x46
.rs				db	0x00,0x8d,0x56
.rt				db	0x00,0xff,0x56
.func			db	MEMWRITER,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 00 ------------------------------------------------------;
COpcodeSLL		db	0x8b,0x46
.rt				db	0x00,0xc1,0xe0
.sa				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 02 ------------------------------------------------------;
COpcodeSRL		db	0x8b,0x46
.rt				db	0x00,0xc1,0xe8
.sa				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 03 ------------------------------------------------------;
COpcodeSRA		db	0x8b,0x46
.rt				db	0x00,0xc1,0xf8
.sa				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 04 ------------------------------------------------------;
COpcodeSLLV		db	0x8b,0x46
.rt				db	0x00,0x8b,0x4e
.rs				db	0x00,0xd3,0xe0,0x89,0x46
.rd				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 06 ------------------------------------------------------;
COpcodeSRLV		db	0x8b,0x46
.rt				db	0x00,0x8b,0x4e
.rs				db	0x00,0xd3,0xe8,0x89,0x46
.rd				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 07 ------------------------------------------------------;
COpcodeSRAV		db	0x8b,0x46
.rt				db	0x00,0x8b,0x4e
.rs				db	0x00,0xd3,0xf8,0x89,0x46
.rd				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 08 -New-Interface-Main-----------------------------------;
COpcodeJR		db	0x8b,0x46
.rs				db	0x00,0x25,0xff,0xff,0x1f,0x00,0x50,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Sp = 08 -New-Interface-Jump-----------------------------------;
COpcodeJR_j
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0x58,0x8d,0x04,0x85
				dd	cpumemory
				db	0xff,0xe0,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 09 -New-Interface-Main-----------------------------------;
COpcodeJALR		db	0x8b,0x46
.rs				db	0x00,0x25,0xff,0xff,0x1f,0x00,0x50,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Sp = 09 -New-Interface-Jump-----------------------------------;
COpcodeJALR_j	db	0xc7,0x46,___REG_RA
.ra				db	0x00,0x00,0x00,0x00,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0x58,0x8d,0x04,0x85
				dd	cpumemory
				db	0xff,0xe0,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 0c ------------------------------------------------------;
COpcodeSYSCALL	db	0x8b,0x4e,___REG_A0,0xff,0x56
				db	SYSCALL,0xeb,0x08
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 10 ------------------------------------------------------;
COpcodeMFHI		db	0x8b,0x46,___REG_HI,0x89,0x46
.rd				db	0x00,0xeb,0x08
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 12 ------------------------------------------------------;
COpcodeMFLO		db	0x8b,0x46,___REG_LO,0x89,0x46
.rd				db	0x00,0xeb,0x08
				db	0x90,0x90,0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 18 ------------------------------------------------------;
COpcodeMULT		db	0x8b,0x46
.rs				db	0x00,0xf7,0x6e
.rt				db	0x00,0x89,0x46,___REG_LO
				db	0x89,0x56,___REG_HI,0xeb,0x02,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 19 ------------------------------------------------------;
COpcodeMULTU	db	0x8b,0x46
.rs				db	0x00,0xf7,0x66
.rt				db	0x00,0x89,0x46,___REG_LO
				db	0x89,0x56,___REG_HI,0xeb,0x02,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 1a ------------------------------------------------------;//???
COpcodeDIV		db	0x8b,0x4e
.rt				db	0x00,0x85,0xc9,0x74,0x09,0x8b,0x46
.rs				db	0x00,0x99,0xff,0x56
				db	DYNDIV,0x90,0x90
;--------------------------------------------------------------------;//???
;----- Sp = 1b ------------------------------------------------------;
COpcodeDIVU		db	0x8b,0x4e
.rt				db	0x00,0x85,0xc9,0x74,0x09,0x8b,0x46
.rs				db	0x00,0x33,0xd2,0xff,0x56
				db	DYNDIVU,0x90
;--------------------------------------------------------------------;
;----- Sp = 21 ------------------------------------------------------;
COpcodeADDU		db	0x8b,0x46
.rs				db	0x00,0x03,0x46
.rt				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 23 ------------------------------------------------------;
COpcodeSUBU		db	0x8b,0x46
.rs				db	0x00,0x2b,0x46
.rt				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 24 ------------------------------------------------------;
COpcodeAND		db	0x8b,0x46
.rs				db	0x00,0x23,0x46
.rt				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 25 ------------------------------------------------------;
COpcodeOR		db	0x8b,0x46
.rs				db	0x00,0x0b,0x46
.rt				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 26 ------------------------------------------------------;
COpcodeXOR		db	0x8b,0x46
.rs				db	0x00,0x33,0x46
.rt				db	0x00,0x89,0x46
.rd				db	0x00,0xeb,0x05,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 27 ------------------------------------------------------;
COpcodeNOR		db	0x8b,0x46
.rs				db	0x00,0x0b,0x46
.rt				db	0x00,0xf7,0xd0,0x89,0x46
.rd				db	0x00,0xeb,0x03,0x90,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 2a ------------------------------------------------------;
COpcodeSLT		db	0x33,0xd2,0x8b,0x46
.rs				db	0x00,0x3b,0x46,
.rt				db	0x00,0x7d,0x01,0x42,0x89,0x56
.rd				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Sp = 2b ------------------------------------------------------;
COpcodeSLTU		db	0x33,0xd2,0x8b,0x46
.rs				db	0x00,0x3b,0x46,
.rt				db	0x00,0x73,0x01,0x42,0x89,0x56
.rd				db	0x00,0x90,0x90
;--------------------------------------------------------------------;
;----- Bc = 00 -New-Interface-Main-----------------------------------;Checked
COpcodeBLTZ		db	0x8b,0x46
.rs				db	0x00,0x83,0xf8
				db	0x00,0x7d,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;Opt?
;----- Bc = 00 -New-Interface-Branch---------------------------------;Checked
COpcodeBLTZ_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;Opt?
;----- Bc = 01 -New-Interface-Main-----------------------------------;
COpcodeBGEZ		db	0x8b,0x46
.rs				db	0x00,0x83,0xf8
				db	0x00,0x7c,0x08,0xb8
.b_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0,0x90
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
;--------------------------------------------------------------------;
;----- Bc = 01 -New-Interface-Branch---------------------------------;
COpcodeBGEZ_b
.placeOpcode	dd	0xffffffff,0xffffffff,0xffffffff,0xffffffff
				db	0xff,0x56
.do_timing		db	TIMING,0xb8
.t_addr			db	0x00,0x00,0x00,0x00,0xff,0xe0
				db	0x90,0x90,0x90,0x90,0x90,0x90
;--------------------------------------------------------------------;
__Opcodes:
	dd	__Opcode_00,__Opcode_01,__Opcode_02,__Opcode_03
	dd	__Opcode_04,__Opcode_05,__Opcode_06,__Opcode_07
	dd  __Opcode_08,__Opcode_09,__Opcode_0a,__Opcode_0b
	dd  __Opcode_0c,__Opcode_0d,__Opcode_0e,__Opcode_0f
	dd  __Opcode_10,__UnsupOp  ,__Opcode_12,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__UnsupOp  ,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__UnsupOp  ,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__UnsupOp  ,__UnsupOp
	dd  __Opcode_20,__Opcode_21,__Opcode_22,__Opcode_23
	dd  __Opcode_24,__Opcode_25,__Opcode_26,__UnsupOp
	dd  __Opcode_28,__Opcode_29,__Opcode_2a,__Opcode_2b
	dd  __UnsupOp  ,__UnsupOp  ,__Opcode_2e,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__Opcode_32,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__UnsupOp  ,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__Opcode_3a,__UnsupOp
	dd  __UnsupOp  ,__UnsupOp  ,__UnsupOp  ,__UnsupOp
__Specials:
	dd	__Special_00,__UnsupSp   ,__Special_02,__Special_03
	dd	__Special_04,__UnsupSp   ,__Special_06,__Special_07
	dd	__Special_08,__Special_09,__UnsupSp   ,__UnsupSp
	dd	__Special_0c,__Special_0d,__UnsupSp   ,__UnsupSp
	dd	__Special_10,__UnsupSp   ,__Special_12,__UnsupSp
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__Special_18,__Special_19,__Special_1a,__Special_1b
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__Special_20,__Special_21,__Special_22,__Special_23
	dd	__Special_24,__Special_25,__Special_26,__Special_27
	dd	__UnsupSp   ,__UnsupSp   ,__Special_2a,__Special_2b
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
	dd	__UnsupSp   ,__UnsupSp   ,__UnsupSp   ,__UnsupSp
__BConds:
	dd	__BCond_00,__BCond_01,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__BCond_11,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
	dd	__UnsupBc ,__UnsupBc ,__UnsupBc ,__UnsupBc
;
decode_message		db	"Decode Block at [ %x ]",10,0
cur_decode_message	db	"Current Opcode == [ %x ] at ( %x + %x ) sp == [ %x ]",10,0
unsup_op_message	db	"Unsupported Opcode [ %x ]",10,0
unsup_sp_message	db	"Unsupported Special Opcode [ %x ]",10,0
unsup_bc_message	db	"Unsupported Branch Opcode [ %x ]",10,0
;------------------------------------------------------------------------------;
section .bss ;---------------S-E-C-T-I-O-N-------------------------------------;
;------------------------------------------------------------------------------;
cpumemory			resd	CPU_MEMORY_SIZE
branchmemory		resd	CPU_MEMORY_SIZE / 2
next_free_branch	resd	1