//----------------------------------------------------------------------------//
// RbPSe - Sony Play Station Emulator                                         //
// Copyright (C) notes:                                                       //
//   Code: RomikB, 2002-2003                                                  //
//        <romikb@mail.ru>                                                    //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License          //
// along with this program; if not, write to the Free Software                //
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.//
//----------------------------------------------------------------------------//
#include "jmp.h"

#include "bios.h"

#include "defs.h"

#include <stdio.h>
/******************************************************************************/
register long *psxregs		__asm__("esi");
register char *psxmemory	__asm__("edi");
/******************************************************************************/
void hlelongjmp( hlejmp_buf env, int val )
{
	register int retaddr __asm__("edx");
	__asm__("movl	%0,	%%eax \n\t"
			"movl	%1,	%%edx \n\t"
			"movl   %2, %%ebx \n\t"
			"movl   %3, %%esi \n\t"
			"movl   %4, %%edi \n\t"
			"movl   %5, %%ebp \n\t"
			"movl   %6, %%esp"
			::
			"m"( val ),
			"m"( env[ HLEJB_EIP ] ),
			"m"( env[ HLEJB_EBX ] ),
			"m"( env[ HLEJB_ESI ] ),
			"m"( env[ HLEJB_EDI ] ),
			"m"( env[ HLEJB_EBP ] ),
			"m"( env[ HLEJB_ESP ] )
			:
			"eax",
			"edx"
			);
	goto *retaddr;
}
/******************************************************************************/
int hlesetjmp( hlejmp_buf env)
{
	__asm__("movl	%%ebx,	%0 \n\t"
			"movl	%%esi,	%1 \n\t"
			"movl	%%edi,	%2 \n\t"
			"movl	%%ebp,	%3 \n\t"
			"movl	%%esp,	%4 \n\t"
			"movl	0(%%esp),	%%ecx \n\t"
			"movl	%%ecx,	%5"
            ::
            "m"( env[ HLEJB_EBX ] ),
			"m"( env[ HLEJB_ESI ] ),
			"m"( env[ HLEJB_EDI ] ),
			"m"( env[ HLEJB_EBP ] ),
			"m"( env[ HLEJB_ESP ] ),
			"m"( env[ HLEJB_EIP ] )
            :
            "ecx"
            );
	return 0;
}
/******************************************************************************/
//void psxsetjmp(void)
//{
//	printf("[ psx ] setjmp( %lx )\n", psxregs[ REG_A0 ] );
//	psxregs[ REG_V0 ] = hlesetjmp( psxmemory + ( psxregs[ REG_A0 ] & 0x001fffff ) );
//}
/******************************************************************************/

long	jmpOpen()
{
//	cpuHookBIOSA0( psxsetjmp, 0x13 );
	return 0;
}
